/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.ByteIndexable;
import de.caff.generics.CharIndexable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongIndexable;
import de.caff.generics.ShortIndexable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Function;

class IndexableHelper {
    private IndexableHelper() {
    }

    @NotNull
    static <T> Indexable.Base<T> frozenFromList(final @NotNull List<T> list) {
        return new Indexable.Base<T>(){

            @NotNull
            Indexable.Base<T> getOuter() {
                return this;
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public T get(int n) {
                return list.get(n);
            }

            @Override
            @NotNull
            public Collection<T> asCollection() {
                return Collections.unmodifiableCollection(list);
            }

            @Override
            @NotNull
            public List<T> asList() {
                return Collections.unmodifiableList(list);
            }

            @Override
            @NotNull
            public Indexable<T> subSet(final int n, final int n2) {
                if (n < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n);
                }
                if (n2 > this.size()) {
                    throw new IndexOutOfBoundsException("toIndex = " + n2);
                }
                if (n > n2) {
                    throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
                }
                final int n3 = n2 - n;
                return n3 == 0 ? Indexable.emptyIndexable() : new Indexable.Base<T>(){

                    @Override
                    public int size() {
                        return n3;
                    }

                    @Override
                    public T get(int n4) {
                        if (n4 < 0 || n4 >= n3) {
                            throw new IndexOutOfBoundsException("No such element: " + n4);
                        }
                        return list.get(n4 + n);
                    }

                    @Override
                    @NotNull
                    public Indexable<T> subSet(int n4, int n22) {
                        if (n4 < 0) {
                            throw new IndexOutOfBoundsException("fromIndex = " + n4);
                        }
                        if (n22 > n3) {
                            throw new IndexOutOfBoundsException("toIndex = " + n22);
                        }
                        if (n4 > n22) {
                            throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n22 + ")");
                        }
                        return this.getOuter().subSet(n + n4, n + n22);
                    }

                    @Override
                    @NotNull
                    public Indexable<T> frozen() {
                        return this;
                    }

                    @Override
                    @NotNull
                    public Spliterator<T> spliterator() {
                        return this.frozenSpliterator();
                    }

                    @Override
                    @NotNull
                    public Spliterator<T> frozenSpliterator() {
                        return new Indexable.IndexableSpliterator(this.getOuter(), n, n2, true);
                    }
                };
            }

            @Override
            @NotNull
            public Indexable<T> frozen() {
                return this;
            }

            @Override
            @NotNull
            public Spliterator<T> spliterator() {
                return this.frozenSpliterator();
            }

            @Override
            @NotNull
            public Spliterator<T> frozenSpliterator() {
                return new Indexable.IndexableSpliterator(this, 0, this.size(), true);
            }
        };
    }

    @NotNull
    static <T> Indexable.Base<T> frozenFromList(final @NotNull List<T> list, final @NotNull Function<? super T, ? extends T> function) {
        return new Indexable.Base<T>(){

            @NotNull
            Indexable.Base<T> getOuter() {
                return this;
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public T get(int n) {
                return function.apply(list.get(n));
            }

            @Override
            @NotNull
            public Collection<T> asCollection() {
                return this.view(function).asCollection();
            }

            @Override
            @NotNull
            public List<T> asList() {
                return this.view(function).asList();
            }

            @Override
            @NotNull
            public Indexable<T> subSet(final int n, final int n2) {
                if (n < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n);
                }
                if (n2 > this.size()) {
                    throw new IndexOutOfBoundsException("toIndex = " + n2);
                }
                if (n > n2) {
                    throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
                }
                final int n3 = n2 - n;
                return n3 == 0 ? Indexable.emptyIndexable() : new Indexable.Base<T>(){

                    @Override
                    public int size() {
                        return n3;
                    }

                    @Override
                    public T get(int n4) {
                        if (n4 < 0 || n4 >= n3) {
                            throw new IndexOutOfBoundsException("No such element: " + n4);
                        }
                        return function.apply(list.get(n4 + n));
                    }

                    @Override
                    @NotNull
                    public Indexable<T> subSet(int n4, int n22) {
                        if (n4 < 0) {
                            throw new IndexOutOfBoundsException("fromIndex = " + n4);
                        }
                        if (n22 > n3) {
                            throw new IndexOutOfBoundsException("toIndex = " + n22);
                        }
                        if (n4 > n22) {
                            throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n22 + ")");
                        }
                        return this.getOuter().subSet(n + n4, n + n22);
                    }

                    @Override
                    @NotNull
                    public Spliterator<T> spliterator() {
                        return this.frozenSpliterator();
                    }

                    @Override
                    @NotNull
                    public Spliterator<T> frozenSpliterator() {
                        return new Indexable.IndexableSpliterator(this.getOuter(), n, n2, true);
                    }
                };
            }

            @Override
            @NotNull
            public Indexable<T> frozen() {
                return this;
            }

            @Override
            @NotNull
            public Spliterator<T> spliterator() {
                return this.frozenSpliterator();
            }

            @Override
            @NotNull
            public Spliterator<T> frozenSpliterator() {
                return new Indexable.IndexableSpliterator(this, 0, this.size(), true);
            }
        };
    }

    @NotNull
    static <T> Indexable.Base<T> frozenFromArray(final @NotNull T[] TArray) {
        final int n = TArray.length;
        if (n == 0) {
            return Indexable.emptyIndexable();
        }
        return new Indexable.Base<T>(){

            @NotNull
            Indexable.Base<T> getOuter() {
                return this;
            }

            @Override
            public T get(int n2) {
                return TArray[n2];
            }

            @Override
            public int size() {
                return n;
            }

            @Override
            @NotNull
            public Indexable<T> frozen() {
                return this;
            }

            @Override
            @NotNull
            public Indexable<T> subSet(final int n4, final int n2) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n2 > this.size()) {
                    throw new IndexOutOfBoundsException("toIndex = " + n2);
                }
                if (n4 > n2) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n2 + ")");
                }
                final int n3 = n2 - n4;
                return n3 == 0 ? Indexable.emptyIndexable() : new Indexable.Base<T>(){

                    @Override
                    public int size() {
                        return n3;
                    }

                    @Override
                    public T get(int n) {
                        if (n < 0 || n >= n3) {
                            throw new IndexOutOfBoundsException("No such element: " + n);
                        }
                        return TArray[n + n4];
                    }

                    @Override
                    @NotNull
                    public Indexable<T> subSet(int n, int n22) {
                        if (n < 0) {
                            throw new IndexOutOfBoundsException("fromIndex = " + n);
                        }
                        if (n22 > n3) {
                            throw new IndexOutOfBoundsException("toIndex = " + n22);
                        }
                        if (n > n22) {
                            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n22 + ")");
                        }
                        return this.getOuter().subSet(n4 + n, n4 + n22);
                    }

                    @Override
                    @NotNull
                    public Indexable<T> frozen() {
                        return this;
                    }

                    @Override
                    @NotNull
                    public Spliterator<T> spliterator() {
                        return this.frozenSpliterator();
                    }

                    @Override
                    @NotNull
                    public Spliterator<T> frozenSpliterator() {
                        return new Indexable.IndexableSpliterator(this.getOuter(), n4, n2, true);
                    }
                };
            }
        };
    }

    @NotNull
    static DoubleIndexable.Base frozenFromArray(final @NotNull double[] dArray) {
        final int n = dArray.length;
        if (n == 0) {
            return DoubleIndexable.EMPTY;
        }
        return new DoubleIndexable.Base(){

            @Override
            public double get(int n2) {
                return dArray[n2];
            }

            @Override
            public int size() {
                return n;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public DoubleIndexable.Base subSet(int n3, int n2) {
                if (n3 == 0 && n2 == n) {
                    return this;
                }
                return IndexableHelper.frozenFromArray(dArray, n3, n2 - n3);
            }

            @Override
            @NotNull
            public DoubleIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    static DoubleIndexable.Base frozenFromArray(final @NotNull double[] dArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start=" + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("length=" + n2);
        }
        if (n + n2 > dArray.length) {
            throw new IndexOutOfBoundsException("end=" + (n + n2));
        }
        if (n2 == 0) {
            return DoubleIndexable.EMPTY;
        }
        return new DoubleIndexable.Base(){

            @Override
            public double get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("index=%d for double[%d]", n3, n2));
                }
                return dArray[n + n3];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public DoubleIndexable frozen() {
                return this;
            }

            @Override
            @NotNull
            public DoubleIndexable.Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return IndexableHelper.frozenFromArray(dArray, n + n3, n22 - n3);
            }
        };
    }

    @NotNull
    static FloatIndexable.Base frozenFromArray(final @NotNull float[] fArray) {
        final int n = fArray.length;
        if (n == 0) {
            return FloatIndexable.EMPTY;
        }
        return new FloatIndexable.Base(){

            @Override
            public float get(int n2) {
                return fArray[n2];
            }

            @Override
            public int size() {
                return n;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public FloatIndexable.Base subSet(int n3, int n2) {
                if (n3 == 0 && n2 == n) {
                    return this;
                }
                return IndexableHelper.frozenFromArray(fArray, n3, n2 - n3);
            }

            @Override
            @NotNull
            public FloatIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    static FloatIndexable.Base frozenFromArray(final @NotNull float[] fArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start=" + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("length=" + n2);
        }
        if (n + n2 > fArray.length) {
            throw new IndexOutOfBoundsException("end=" + (n + n2));
        }
        if (n2 == 0) {
            return FloatIndexable.EMPTY;
        }
        return new FloatIndexable.Base(){

            @Override
            public float get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("index=%d for float[%d]", n3, n2));
                }
                return fArray[n + n3];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public FloatIndexable frozen() {
                return this;
            }

            @Override
            @NotNull
            public FloatIndexable.Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return IndexableHelper.frozenFromArray(fArray, n + n3, n22 - n3);
            }
        };
    }

    @NotNull
    static LongIndexable.Base frozenFromArray(final @NotNull long[] lArray) {
        final int n = lArray.length;
        if (n == 0) {
            return LongIndexable.EMPTY;
        }
        return new LongIndexable.Base(){

            @Override
            public long get(int n2) {
                return lArray[n2];
            }

            @Override
            public int size() {
                return n;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public LongIndexable.Base subSet(int n3, int n2) {
                if (n3 == 0 && n2 == n) {
                    return this;
                }
                return IndexableHelper.frozenFromArray(lArray, n3, n2 - n3);
            }

            @Override
            @NotNull
            public LongIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    static LongIndexable.Base frozenFromArray(final @NotNull long[] lArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start=" + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("length=" + n2);
        }
        if (n + n2 > lArray.length) {
            throw new IndexOutOfBoundsException("end=" + (n + n2));
        }
        if (n2 == 0) {
            return LongIndexable.EMPTY;
        }
        return new LongIndexable.Base(){

            @Override
            public long get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("index=%d for long[%d]", n3, n2));
                }
                return lArray[n + n3];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public LongIndexable frozen() {
                return this;
            }

            @Override
            @NotNull
            public LongIndexable.Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return IndexableHelper.frozenFromArray(lArray, n + n3, n22 - n3);
            }
        };
    }

    @NotNull
    static IntIndexable.Base frozenFromArray(final @NotNull int[] nArray) {
        final int n = nArray.length;
        if (n == 0) {
            return IntIndexable.EMPTY;
        }
        return new IntIndexable.Base(){

            @Override
            public int get(int n2) {
                return nArray[n2];
            }

            @Override
            public int size() {
                return n;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public IntIndexable.Base subSet(int n3, int n2) {
                if (n3 == 0 && n2 == n) {
                    return this;
                }
                return IndexableHelper.frozenFromArray(nArray, n3, n2 - n3);
            }

            @Override
            @NotNull
            public IntIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    static IntIndexable.Base frozenFromArray(final @NotNull int[] nArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start=" + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("length=" + n2);
        }
        if (n + n2 > nArray.length) {
            throw new IndexOutOfBoundsException("end=" + (n + n2));
        }
        if (n2 == 0) {
            return IntIndexable.EMPTY;
        }
        return new IntIndexable.Base(){

            @Override
            public int get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("index=%d for int[%d]", n3, n2));
                }
                return nArray[n + n3];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public IntIndexable frozen() {
                return this;
            }

            @Override
            @NotNull
            public IntIndexable.Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return IndexableHelper.frozenFromArray(nArray, n + n3, n22 - n3);
            }
        };
    }

    @NotNull
    static ShortIndexable.Base frozenFromArray(final @NotNull short[] sArray) {
        final int n = sArray.length;
        if (n == 0) {
            return ShortIndexable.EMPTY;
        }
        return new ShortIndexable.Base(){

            @Override
            public short get(int n2) {
                return sArray[n2];
            }

            @Override
            public int size() {
                return n;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public ShortIndexable.Base subSet(int n3, int n2) {
                if (n3 == 0 && n2 == n) {
                    return this;
                }
                return IndexableHelper.frozenFromArray(sArray, n3, n2 - n3);
            }

            @Override
            @NotNull
            public ShortIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    static ShortIndexable.Base frozenFromArray(final @NotNull short[] sArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start=" + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("length=" + n2);
        }
        if (n + n2 > sArray.length) {
            throw new IndexOutOfBoundsException("end=" + (n + n2));
        }
        if (n2 == 0) {
            return ShortIndexable.EMPTY;
        }
        return new ShortIndexable.Base(){

            @Override
            public short get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("index=%d for short[%d]", n3, n2));
                }
                return sArray[n + n3];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public ShortIndexable frozen() {
                return this;
            }

            @Override
            @NotNull
            public ShortIndexable.Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return IndexableHelper.frozenFromArray(sArray, n + n3, n22 - n3);
            }
        };
    }

    @NotNull
    static ByteIndexable.Base frozenFromArray(final @NotNull byte[] byArray) {
        final int n = byArray.length;
        if (n == 0) {
            return ByteIndexable.EMPTY;
        }
        return new ByteIndexable.Base(){

            @Override
            public byte get(int n2) {
                return byArray[n2];
            }

            @Override
            public int size() {
                return n;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public ByteIndexable.Base subSet(int n3, int n2) {
                if (n3 == 0 && n2 == n) {
                    return this;
                }
                return IndexableHelper.frozenFromArray(byArray, n3, n2 - n3);
            }

            @Override
            @NotNull
            public ByteIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    static ByteIndexable.Base frozenFromArray(final @NotNull byte[] byArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start=" + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("length=" + n2);
        }
        if (n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("end=" + (n + n2));
        }
        if (n2 == 0) {
            return ByteIndexable.EMPTY;
        }
        return new ByteIndexable.Base(){

            @Override
            public byte get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("index=%d for byte[%d]", n3, n2));
                }
                return byArray[n + n3];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public ByteIndexable frozen() {
                return this;
            }

            @Override
            @NotNull
            public ByteIndexable.Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return IndexableHelper.frozenFromArray(byArray, n + n3, n22 - n3);
            }
        };
    }

    @NotNull
    static CharIndexable.Base frozenFromArray(final @NotNull char[] cArray) {
        final int n = cArray.length;
        if (n == 0) {
            return CharIndexable.EMPTY;
        }
        return new CharIndexable.Base(){

            @Override
            public char get(int n2) {
                return cArray[n2];
            }

            @Override
            public int size() {
                return n;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public CharIndexable.Base subSet(int n3, int n2) {
                if (n3 == 0 && n2 == n) {
                    return this;
                }
                return IndexableHelper.frozenFromArray(cArray, n3, n2 - n3);
            }

            @Override
            @NotNull
            public CharIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    static CharIndexable.Base frozenFromArray(final @NotNull char[] cArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start=" + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("length=" + n2);
        }
        if (n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException("end=" + (n + n2));
        }
        if (n2 == 0) {
            return CharIndexable.EMPTY;
        }
        return new CharIndexable.Base(){

            @Override
            public char get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("index=%d for char[%d]", n3, n2));
                }
                return cArray[n + n3];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public CharIndexable frozen() {
                return this;
            }

            @Override
            @NotNull
            public CharIndexable.Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return IndexableHelper.frozenFromArray(cArray, n + n3, n22 - n3);
            }
        };
    }

    @NotNull
    static BooleanIndexable.Base frozenFromArray(final @NotNull boolean[] blArray) {
        final int n = blArray.length;
        if (n == 0) {
            return BooleanIndexable.EMPTY;
        }
        return new BooleanIndexable.Base(){

            @Override
            public boolean get(int n2) {
                return blArray[n2];
            }

            @Override
            public int size() {
                return n;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public BooleanIndexable.Base subSet(int n3, int n2) {
                if (n3 == 0 && n2 == n) {
                    return this;
                }
                return IndexableHelper.frozenFromArray(blArray, n3, n2 - n3);
            }

            @Override
            @NotNull
            public BooleanIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    static BooleanIndexable.Base frozenFromArray(final @NotNull boolean[] blArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start=" + n);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("length=" + n2);
        }
        if (n + n2 > blArray.length) {
            throw new IndexOutOfBoundsException("end=" + (n + n2));
        }
        if (n2 == 0) {
            return BooleanIndexable.EMPTY;
        }
        return new BooleanIndexable.Base(){

            @Override
            public boolean get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("index=%d for boolean[%d]", n3, n2));
                }
                return blArray[n + n3];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public BooleanIndexable frozen() {
                return this;
            }

            @Override
            @NotNull
            public BooleanIndexable.Base subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > n2) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return IndexableHelper.frozenFromArray(blArray, n + n3, n22 - n3);
            }
        };
    }
}

