/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.ByteIndexable;
import de.caff.generics.CharIndexable;
import de.caff.generics.Countable;
import de.caff.generics.Dict;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.FloatIndexable;
import de.caff.generics.IndexableHelper;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongIndexable;
import de.caff.generics.Matcher;
import de.caff.generics.MutableIndexable;
import de.caff.generics.Order;
import de.caff.generics.Pythonesque;
import de.caff.generics.ShortIndexable;
import de.caff.generics.Sizeable;
import de.caff.generics.Types;
import de.caff.generics.function.FragileFunction0;
import de.caff.generics.function.FragileFunction1;
import de.caff.generics.function.FragilePredicate1;
import de.caff.generics.function.FragileProcedure1;
import de.caff.generics.function.FragileProcedure2;
import de.caff.generics.function.Ordering;
import de.caff.generics.function.ToByteFunction;
import de.caff.generics.function.ToCharFunction;
import de.caff.generics.function.ToFloatFunction;
import de.caff.generics.function.ToShortFunction;
import de.caff.generics.range.Range;
import de.caff.generics.tuple.ITuple2;
import de.caff.generics.tuple.ITuple3;
import de.caff.generics.tuple.ITuple4;
import de.caff.generics.tuple.ITuple5;
import de.caff.generics.tuple.ITuple6;
import de.caff.generics.tuple.ITuple7;
import de.caff.generics.tuple.ITuple8;
import de.caff.generics.tuple.ITuple9;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;

public interface Indexable<T>
extends Countable<T> {
    public static final String EMPTY_INDEXABLE_STRING = "[]";
    @NotNull
    public static final Indexable<?> EMPTY = new Base<Object>(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Object get(int n) {
            throw new IndexOutOfBoundsException("Empty indexable has no elements!");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public Indexable<Object> frozen() {
            return this;
        }

        @Override
        @NotNull
        public Indexable<Object> sorted(@NotNull Comparator<? super Object> comparator) {
            return super.sorted(comparator);
        }

        @Override
        public boolean isSorted(@NotNull Comparator<? super Object> comparator) {
            return true;
        }

        @Override
        public boolean isStrictlySorted(@NotNull Comparator<? super Object> comparator) {
            return true;
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return Empty.OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public Indexable<Object> reverse() {
            return this;
        }

        @Override
        @NotNull
        public Indexable<Object> rotated(int n) {
            return this;
        }

        @Override
        @NotNull
        public Iterator<Object> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public ListIterator<Object> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        public void addAllTo(@NotNull Collection<? super Object> collection) {
        }

        @Override
        @NotNull
        public String toString() {
            return Indexable.EMPTY_INDEXABLE_STRING;
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Indexable && ((Indexable)object).isEmpty();
        }

        @Override
        public void forEach(Consumer<? super Object> consumer) {
        }

        @Override
        public <E extends Exception> void forEachFragile(@NotNull FragileProcedure1<E, ? super Object> fragileProcedure1) throws E {
        }

        @Override
        public <V> V foldLeft(V v, @NotNull BiFunction<? super V, ? super Object, ? extends V> biFunction) {
            return v;
        }

        @Override
        @NotNull
        public Collection<Object> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Object> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public <E> Indexable<E> view(@NotNull Function<? super Object, ? extends E> function) {
            return Indexable.emptyIndexable();
        }

        @Override
        @NotNull
        public <R, E extends Exception> Indexable<R> viewFragile(@NotNull FragileFunction1<? extends R, E, ? super Object> fragileFunction1) {
            return Indexable.emptyIndexable();
        }

        @Override
        @NotNull
        public <E> Indexable<E> indexedView(@NotNull BiFunction<? super Integer, ? super Object, ? extends E> biFunction) {
            return Indexable.emptyIndexable();
        }

        @Override
        @NotNull
        public Indexable<Object> frozen(@NotNull Function<? super Object, ?> function, boolean bl) {
            return Indexable.emptyIndexable();
        }

        @Override
        public int addToArray(@NotNull Object[] objectArray, int n, int n2, int n3) {
            return n;
        }

        @Override
        public int addToArray(@NotNull Object[] objectArray, int n) {
            return n;
        }

        @Override
        public void addToCollection(@NotNull Collection<? super Object> collection) {
        }

        @Override
        public void forEachEntry(@NotNull BiConsumer<Integer, ? super Object> biConsumer) {
        }

        @Override
        public <E extends Exception> void forEachEntryFragile(@NotNull FragileProcedure2<E, Integer, ? super Object> fragileProcedure2) throws E {
        }

        @Override
        public int findFirst(Object object) {
            return -1;
        }

        @Override
        public boolean containsEq(Object object) {
            return false;
        }

        @Override
        public boolean containsRef(Object object) {
            return false;
        }

        @Override
        public boolean hasAny(@NotNull Predicate<? super Object> predicate) {
            return false;
        }

        @Override
        @Nullable
        public Object getAny(@NotNull Predicate<? super Object> predicate) {
            return null;
        }

        @Override
        public boolean hasAll(@NotNull Predicate<? super Object> predicate) {
            return true;
        }

        @Override
        public Object first() {
            throw new NoSuchElementException("No first element in empty Indexable!");
        }

        @Override
        @Nullable
        public Object firstOrNull() {
            return null;
        }

        @Override
        @NotNull
        public Optional<Object> optFirst() {
            return Optional.empty();
        }

        @Override
        public Object last() {
            throw new NoSuchElementException("No last element in empty Indexable!");
        }

        @Override
        public Object lastOrNull() {
            return null;
        }

        @Override
        @NotNull
        public Optional<Object> optLast() {
            return Optional.empty();
        }

        @Override
        public <U> int findFirst(U u, @NotNull Matcher<? super U, ? super Object> matcher) {
            return -1;
        }

        @Override
        public int findFirst(@NotNull Predicate<? super Object> predicate) {
            return -1;
        }

        @Override
        public int findLast(Object object) {
            return -1;
        }

        @Override
        public <U> int findLast(U u, @NotNull Matcher<? super U, ? super Object> matcher) {
            return -1;
        }

        @Override
        public int findLast(@NotNull Predicate<? super Object> predicate) {
            return -1;
        }

        @Override
        @NotNull
        public Indexable<Object> findAll(@NotNull Predicate<? super Object> predicate) {
            return Indexable.emptyIndexable();
        }

        @Override
        @NotNull
        public Dict<Integer, Object> viewAsDict() {
            return Dict.empty();
        }

        @Override
        @NotNull
        public DoubleIndexable viewAsDoubleIndexable(@NotNull ToDoubleFunction<? super Object> toDoubleFunction) {
            return DoubleIndexable.EMPTY;
        }

        @Override
        @NotNull
        public FloatIndexable viewAsFloatIndexable(@NotNull ToFloatFunction<? super Object> toFloatFunction) {
            return FloatIndexable.EMPTY;
        }

        @Override
        @NotNull
        public LongIndexable viewAsLongIndexable(@NotNull ToLongFunction<? super Object> toLongFunction) {
            return LongIndexable.EMPTY;
        }

        @Override
        @NotNull
        public IntIndexable viewAsIntIndexable(@NotNull ToIntFunction<? super Object> toIntFunction) {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public ShortIndexable viewAsShortIndexable(@NotNull ToShortFunction<? super Object> toShortFunction) {
            return ShortIndexable.EMPTY;
        }

        @Override
        @NotNull
        public CharIndexable viewAsCharIndexable(@NotNull ToCharFunction<? super Object> toCharFunction) {
            return CharIndexable.EMPTY;
        }

        @Override
        @NotNull
        public ByteIndexable viewAsByteIndexable(@NotNull ToByteFunction<? super Object> toByteFunction) {
            return ByteIndexable.EMPTY;
        }

        @Override
        @NotNull
        public BooleanIndexable viewAsBooleanIndexable(@NotNull Predicate<? super Object> predicate) {
            return BooleanIndexable.EMPTY;
        }

        @Override
        @NotNull
        public Object[] toArray(@NotNull Class<Object> clazz) {
            return Empty.OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public Iterable<Object> filtered(@NotNull Predicate<? super Object> predicate) {
            return this;
        }

        @Override
        @NotNull
        public Countable<Object> filterToCountable(@NotNull Predicate<? super Object> predicate) {
            return this;
        }

        @Override
        @NotNull
        public Indexable<Object> filteredToIndexable(@NotNull Predicate<? super Object> predicate) {
            return this;
        }

        @Override
        @NotNull
        public <K> Dict<K, Indexable<Object>> groupingBy(@NotNull Function<? super Object, ? extends K> function) {
            return Dict.empty();
        }

        @Override
        @NotNull
        public <K, V> Dict<K, Indexable<V>> groupingBy(@NotNull Function<? super Object, ? extends K> function, @NotNull Function<? super Object, ? extends V> function2) {
            return Dict.empty();
        }

        @Override
        @NotNull
        public <K> Dict<K, Object> mappingBy(boolean bl, @NotNull Function<? super Object, ? extends K> function) {
            return Dict.empty();
        }

        @Override
        @NotNull
        public <K, V> Dict<K, V> mappingBy(boolean bl, @NotNull Function<? super Object, ? extends K> function, @NotNull Function<? super Object, ? extends V> function2) {
            return Dict.empty();
        }

        @Override
        @NotNull
        public Spliterator<Object> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @Override
        @NotNull
        public Stream<Object> stream() {
            return Stream.empty();
        }

        @Override
        @NotNull
        public Stream<Object> parellelStream() {
            return Stream.empty();
        }
    };

    public T get(int var1);

    public static void checkIndex(int n, int n2) {
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException(String.format("%s is not in range [0,%d[!", n, n2));
        }
    }

    default public T gyt(int n) {
        return this.get(Pythonesque.mapX(n, this));
    }

    default public T getMod(int n) {
        int n2 = this.size();
        if (n2 == 0) {
            throw new IndexOutOfBoundsException("No element for empty indexable!");
        }
        return this.gyt(n % n2);
    }

    @NotNull
    default public Indexable<T> reverse() {
        return new Base<T>(){

            @Override
            public int size() {
                return Indexable.this.size();
            }

            @Override
            public T get(int n) {
                return Indexable.this.get(Indexable.this.size() - n - 1);
            }

            @Override
            @NotNull
            public Indexable<T> reverse() {
                return Indexable.this;
            }
        };
    }

    @Override
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    default public Iterator<T> iterator() {
        return this.listIterator();
    }

    @NotNull
    default public Iterator<T> iterator(int n, int n2) {
        return this.subSet(n, n2).iterator();
    }

    @NotNull
    default public ListIterator<T> listIterator() {
        return new ListIterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < Indexable.this.size();
            }

            @Override
            public T next() {
                if (this.index >= Indexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return Indexable.this.get(this.index++);
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public T previous() {
                if (this.index == 0) {
                    throw new NoSuchElementException("index: -1");
                }
                return Indexable.this.get(--this.index);
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(T t) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(T t) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    default public T first() {
        return this.get(0);
    }

    @Override
    default public T last() {
        return this.gyt(-1);
    }

    @NotNull
    default public Indexable<T> subSet(final int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return n3 == 0 ? Indexable.emptyIndexable() : new Base<T>(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public T get(int n2) {
                Indexable.checkIndex(n2, n3);
                return Indexable.this.get(n2 + n);
            }

            @Override
            @NotNull
            public Indexable<T> subSet(int n4, int n2) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n2 > n3) {
                    throw new IndexOutOfBoundsException("toIndex = " + n2);
                }
                if (n4 > n2) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n2 + ")");
                }
                return Indexable.this.subSet(n + n4, n + n2);
            }
        };
    }

    @NotNull
    default public Indexable<T> sybSet(int n, int n2) {
        return this.subSet(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @NotNull
    default public Indexable<T> tailSet(int n) {
        return this.subSet(Pythonesque.mapX(n, this), this.size());
    }

    @NotNull
    default public Indexable<T> headSet(int n) {
        return this.subSet(0, Pythonesque.mapX(n, this));
    }

    @NotNull
    default public Dict<Integer, T> viewAsDict() {
        return new Dict.Base<Integer, T>(){

            @Override
            @Nullable
            public T get(Integer n) {
                if (n == null || n < 0 || n >= this.size()) {
                    return null;
                }
                return Indexable.this.get(n);
            }

            @Override
            public int size() {
                return Indexable.this.size();
            }

            @Override
            public boolean isEmpty() {
                return Indexable.this.isEmpty();
            }

            @Override
            @NotNull
            public Countable<T> values() {
                return Indexable.this;
            }

            @Override
            @NotNull
            public Countable<Integer> keys() {
                return Indexable.viewByIndex(this.size(), n -> n);
            }

            @Override
            public boolean hasKey(Integer n) {
                return n != null && n >= 0 && n < this.size();
            }

            @Override
            @NotNull
            public Countable<Dict.Entry<Integer, T>> entries() {
                return Indexable.viewByIndex(this.size(), n -> Dict.Entry.view(n, Indexable.this.get(n)));
            }
        };
    }

    @Override
    @NotNull
    default public Collection<T> asCollection() {
        return new AbstractCollection<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return Indexable.this.iterator();
            }

            @Override
            public int size() {
                return Indexable.this.size();
            }
        };
    }

    @NotNull
    default public List<T> asList() {
        return new ListView(this);
    }

    @NotNull
    default public Iterable<Integer> indexes() {
        return Range.indexes(this.size());
    }

    @NotNull
    default public IntIndexable intIndexes() {
        return IntIndexable.rangeFromSize(this.size());
    }

    @Override
    @NotNull
    default public <E> Indexable<E> view(final @NotNull Function<? super T, ? extends E> function) {
        return new Base<E>(){

            @Override
            public int size() {
                return Indexable.this.size();
            }

            @Override
            public E get(int n) {
                return function.apply(Indexable.this.get(n));
            }
        };
    }

    @Override
    @NotNull
    default public <R, E extends Exception> Indexable<R> viewFragile(@NotNull FragileFunction1<? extends R, E, ? super T> fragileFunction1) {
        return this.view(fragileFunction1.nonFragile());
    }

    @NotNull
    default public <E> Indexable<E> indexedView(final @NotNull BiFunction<? super Integer, ? super T, ? extends E> biFunction) {
        return new Base<E>(){

            @Override
            public E get(int n) {
                return biFunction.apply(n, Indexable.this.get(n));
            }

            @Override
            public int size() {
                return Indexable.this.size();
            }
        };
    }

    default public int addToArray(@NotNull T[] TArray, int n, int n2, int n3) {
        for (T t : this.subSet(n2, n2 + n3)) {
            TArray[n++] = t;
        }
        return n;
    }

    @Override
    default public int addToArray(@NotNull T[] TArray, int n) {
        return this.addToArray(TArray, n, 0, this.size());
    }

    @Deprecated
    default public void addToCollection(@NotNull Collection<? super T> collection) {
        this.forEach(collection::add);
    }

    default public void forEachEntry(@NotNull BiConsumer<Integer, ? super T> biConsumer) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            biConsumer.accept(i, (Integer)this.get(i));
        }
    }

    default public <E extends Exception> void forEachEntryFragile(@NotNull FragileProcedure2<E, Integer, ? super T> fragileProcedure2) throws E {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            fragileProcedure2.apply(i, this.get(i));
        }
    }

    @Override
    @NotNull
    default public Spliterator<T> spliterator() {
        return new IndexableSpliterator(this);
    }

    @NotNull
    default public Spliterator<T> frozenSpliterator() {
        Indexable indexable = this.frozen();
        return new IndexableSpliterator(indexable, 0, indexable.size(), true);
    }

    default public boolean isOrdered(@NotNull Ordering<? super T> ordering) {
        if (this.size() < 2) {
            return true;
        }
        T t = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            T t2 = this.get(i);
            if (ordering.check(t2, t) == Order.Descending) {
                return false;
            }
            t = t2;
        }
        return true;
    }

    default public boolean isStrictlyOrdered(@NotNull Ordering<? super T> ordering) {
        if (this.size() < 2) {
            return true;
        }
        T t = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            T t2 = this.get(i);
            if (ordering.check(t2, t) != Order.Ascending) {
                return false;
            }
            t = t2;
        }
        return true;
    }

    default public int binarySearch(T t, @NotNull Ordering<? super T> ordering) {
        int n = 0;
        int n2 = this.size() - 1;
        block4: while (n <= n2) {
            int n3 = n + n2 >>> 1;
            T t2 = this.get(n3);
            switch (ordering.check(t2, t)) {
                case Ascending: {
                    n = n3 + 1;
                    continue block4;
                }
                case Descending: {
                    n2 = n3 - 1;
                    continue block4;
                }
            }
            return n3;
        }
        return -(n + 1);
    }

    @NotNull
    default public MutableIndexable<T> ordered(@NotNull Ordering<? super T> ordering) {
        MutableIndexable mutableIndexable = MutableIndexable.fromIndexable(this);
        mutableIndexable.order(ordering);
        return mutableIndexable;
    }

    @Override
    @NotNull
    default public Base<T> asBase() {
        return new Base<T>(){

            @Override
            public int size() {
                return Indexable.this.size();
            }

            @Override
            public T get(int n) {
                return Indexable.this.get(n);
            }

            @Override
            @NotNull
            public Indexable<T> reverse() {
                return Indexable.this.reverse();
            }

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return Indexable.this.iterator();
            }

            @Override
            @NotNull
            public ListIterator<T> listIterator() {
                return Indexable.this.listIterator();
            }

            @Override
            @NotNull
            public Indexable<T> subSet(int n, int n2) {
                return Indexable.this.subSet(n, n2);
            }
        };
    }

    default public int findFirst(T t) {
        return this.findNext(t, 0);
    }

    default public int findNext(T t, int n) {
        return this.findNext(t, Objects::deepEquals, n);
    }

    default public <U> int findFirst(U u, @NotNull Matcher<? super U, ? super T> matcher) {
        return this.findNext(u, matcher, 0);
    }

    default public <U> int findNext(U u, @NotNull Matcher<? super U, ? super T> matcher, int n) {
        return this.findNext((Predicate<? super T>)matcher.foldLeft(u), n);
    }

    default public int findFirst(@NotNull Predicate<? super T> predicate) {
        return this.findNext(predicate, 0);
    }

    default public <X extends Exception> int findFirstX(@NotNull FragilePredicate1<X, ? super T> fragilePredicate1) throws X {
        return this.findNextX(fragilePredicate1, 0);
    }

    default public int findNext(@NotNull Predicate<? super T> predicate, int n) {
        int n2 = this.size();
        if (n < 0 && (n += n2) < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n - n2, n2));
        }
        while (n < n2) {
            if (predicate.test(this.get(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    default public <X extends Exception> int findNextX(@NotNull FragilePredicate1<X, ? super T> fragilePredicate1, int n) throws X {
        int n2 = this.size();
        if (n < 0 && (n += n2) < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n - n2, n2));
        }
        while (n < n2) {
            if (fragilePredicate1.test(this.get(n))) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Nullable
    default public T firstMatch(@NotNull Predicate<? super T> predicate) {
        return Types.findFirst(this, predicate);
    }

    @Nullable
    default public <X extends Exception> T firstMatchX(@NotNull FragilePredicate1<X, ? super T> fragilePredicate1) throws X {
        for (T t : this) {
            if (!fragilePredicate1.test(t)) continue;
            return t;
        }
        return null;
    }

    @Nullable
    default public <R> R firstMatch(@NotNull Predicate<? super T> predicate, @NotNull Function<? super T, ? extends R> function) {
        T t = this.firstMatch(predicate);
        return t != null ? (R)function.apply((T)t) : null;
    }

    default public int findLast(T t) {
        return this.findPrevious(t, -1);
    }

    default public int findPrevious(T t, int n) {
        return this.findPrevious(t, Objects::deepEquals, n);
    }

    default public <U> int findLast(U u, @NotNull Matcher<? super U, ? super T> matcher) {
        return this.findPrevious(u, matcher, -1);
    }

    default public <U> int findPrevious(U u, @NotNull Matcher<? super U, ? super T> matcher, int n) {
        return this.findPrevious((Predicate<? super T>)matcher.foldLeft(u), n);
    }

    default public int findLast(@NotNull Predicate<? super T> predicate) {
        return this.findPrevious(predicate, -1);
    }

    default public int findPrevious(@NotNull Predicate<? super T> predicate, int n) {
        int n2 = this.size();
        if (n < 0 && (n += n2) < -1) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n - n2, n2));
        }
        while (n >= 0) {
            if (predicate.test(this.get(n))) {
                return n;
            }
            --n;
        }
        return -1;
    }

    @NotNull
    default public Indexable<T> findAll(@NotNull Predicate<? super T> predicate) {
        return IndexableHelper.frozenFromList(Types.filter(this, predicate));
    }

    @NotNull
    default public <X extends Exception> Indexable<T> findAllX(@NotNull FragilePredicate1<X, ? super T> fragilePredicate1) throws X {
        ArrayList<T> arrayList = new ArrayList<T>();
        for (T t : this) {
            if (!fragilePredicate1.test(t)) continue;
            arrayList.add(t);
        }
        return IndexableHelper.frozenFromList(arrayList);
    }

    @NotNull
    default public Indexable<T> withInsertedItemAt(int n, final T t) {
        final int n2 = n;
        final int n3 = this.size() + 1;
        if (n2 == 0) {
            return new Base<T>(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public T get(int n) {
                    return n == 0 ? t : Indexable.this.get(n - 1);
                }
            };
        }
        if (n2 == n3 - 1) {
            return new Base<T>(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public T get(int n) {
                    return n == n3 - 1 ? t : Indexable.this.get(n);
                }
            };
        }
        return new Base<T>(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public T get(int n) {
                if (n == n2) {
                    return t;
                }
                return Indexable.this.get(n < n2 ? n : n - 1);
            }
        };
    }

    @Override
    @NotNull
    default public Indexable<T> withAppendedItem(T t) {
        return this.withInsertedItemAt(this.size(), t);
    }

    @Override
    @NotNull
    default public Indexable<T> withPrependedItem(T t) {
        return this.withInsertedItemAt(0, t);
    }

    @NotNull
    default public Indexable<T> withExchangedItemAt(int n, final T t) {
        final int n2 = Pythonesque.mapX(n, this);
        return new Base<T>(){

            @Override
            public T get(int n) {
                return n == n2 ? t : Indexable.this.get(n);
            }

            @Override
            public int size() {
                return Indexable.this.size();
            }
        };
    }

    @NotNull
    default public Indexable<T> withRemovedItemAt(int n) {
        final int n2 = Pythonesque.mapX(n, this);
        if (n2 == 0) {
            return this.tailSet(1);
        }
        final int n3 = this.size() - 1;
        if (n2 == n3) {
            return this.headSet(-1);
        }
        return new Base<T>(){

            @Override
            public T get(int n) {
                return n < n2 ? Indexable.this.get(n) : Indexable.this.get(n + 1);
            }

            @Override
            public int size() {
                return n3;
            }
        };
    }

    @NotNull
    default public Indexable<T> withSwappedItemsAt(int n, int n2) {
        int n3;
        final int n4 = Pythonesque.mapX(n, this);
        if (n4 == (n3 = Pythonesque.mapX(n2, this))) {
            return this;
        }
        return new Base<T>(){

            @Override
            public T get(int n) {
                if (n == n4) {
                    return Indexable.this.get(n3);
                }
                if (n == n3) {
                    return Indexable.this.get(n4);
                }
                return Indexable.this.get(n);
            }

            @Override
            public int size() {
                return Indexable.this.size();
            }
        };
    }

    @NotNull
    default public Indexable<T> rotated(int n) {
        if (this.isEmpty()) {
            return this;
        }
        if ((n %= this.size()) == 0) {
            return this;
        }
        if (n < 0) {
            n += this.size();
        }
        final int n2 = n;
        return new Base<T>(){

            @Override
            public T get(int n) {
                return Indexable.this.get((n + n2) % this.size());
            }

            @Override
            public int size() {
                return Indexable.this.size();
            }

            @Override
            @NotNull
            public Indexable<T> rotated(int n) {
                return Indexable.this.rotated(n2 + n);
            }
        };
    }

    @NotNull
    default public DoubleIndexable viewAsDoubleIndexable(@NotNull ToDoubleFunction<? super T> toDoubleFunction) {
        return DoubleIndexable.viewIndexable(this, toDoubleFunction);
    }

    @NotNull
    default public FloatIndexable viewAsFloatIndexable(@NotNull ToFloatFunction<? super T> toFloatFunction) {
        return FloatIndexable.viewIndexable(this, toFloatFunction);
    }

    @NotNull
    default public LongIndexable viewAsLongIndexable(@NotNull ToLongFunction<? super T> toLongFunction) {
        return LongIndexable.viewIndexable(this, toLongFunction);
    }

    @NotNull
    default public IntIndexable viewAsIntIndexable(@NotNull ToIntFunction<? super T> toIntFunction) {
        return IntIndexable.viewIndexable(this, toIntFunction);
    }

    @NotNull
    default public ShortIndexable viewAsShortIndexable(@NotNull ToShortFunction<? super T> toShortFunction) {
        return ShortIndexable.viewIndexable(this, toShortFunction);
    }

    @NotNull
    default public CharIndexable viewAsCharIndexable(@NotNull ToCharFunction<? super T> toCharFunction) {
        return CharIndexable.viewIndexable(this, toCharFunction);
    }

    @NotNull
    default public ByteIndexable viewAsByteIndexable(@NotNull ToByteFunction<? super T> toByteFunction) {
        return ByteIndexable.viewIndexable(this, toByteFunction);
    }

    @NotNull
    default public BooleanIndexable viewAsBooleanIndexable(@NotNull Predicate<? super T> predicate) {
        return BooleanIndexable.viewIndexable(this, predicate);
    }

    @Deprecated
    @NotNull
    public static <E> Indexable<E> fromList(@NotNull List<? extends E> list) {
        return Indexable.viewList(list);
    }

    @NotNull
    public static <E> Indexable<E> viewList(final @NotNull List<? extends E> list) {
        return new Base<E>(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public E get(int n) {
                return list.get(n);
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }

            @Override
            @NotNull
            public Iterator<E> iterator() {
                final Iterator iterator = list.iterator();
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public E next() {
                        return iterator.next();
                    }
                };
            }

            @Override
            @NotNull
            public ListIterator<E> listIterator() {
                final ListIterator listIterator = list.listIterator();
                return new ListIterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return listIterator.hasNext();
                    }

                    @Override
                    public E next() {
                        return listIterator.next();
                    }

                    @Override
                    public boolean hasPrevious() {
                        return listIterator.hasPrevious();
                    }

                    @Override
                    public E previous() {
                        return listIterator.previous();
                    }

                    @Override
                    public int nextIndex() {
                        return listIterator.nextIndex();
                    }

                    @Override
                    public int previousIndex() {
                        return listIterator.previousIndex();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }

                    @Override
                    public void set(E e) {
                        throw new UnsupportedOperationException("set");
                    }

                    @Override
                    public void add(E e) {
                        throw new UnsupportedOperationException("add");
                    }
                };
            }

            @Override
            @NotNull
            public Indexable<E> subSet(int n, int n2) {
                return Indexable.viewList(list.subList(n, n2));
            }

            @Override
            @NotNull
            public Collection<E> asCollection() {
                return Collections.unmodifiableCollection(list);
            }

            @Override
            @NotNull
            public List<E> asList() {
                return Collections.unmodifiableList(list);
            }
        };
    }

    @NotNull
    public static <E> Indexable<E> viewListN(@Nullable List<? extends E> list) {
        return list == null ? Indexable.emptyIndexable() : Indexable.viewList(list);
    }

    @NotNull
    public static <E, V> Indexable<E> viewList(final @NotNull List<V> list, final @NotNull Function<? super V, ? extends E> function) {
        return new Base<E>(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public E get(int n) {
                return function.apply(list.get(n));
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }

            @Override
            @NotNull
            public Iterator<E> iterator() {
                final Iterator iterator = list.iterator();
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public E next() {
                        return function.apply(iterator.next());
                    }
                };
            }

            @Override
            @NotNull
            public ListIterator<E> listIterator() {
                final ListIterator listIterator = list.listIterator();
                return new ListIterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return listIterator.hasNext();
                    }

                    @Override
                    public E next() {
                        return function.apply(listIterator.next());
                    }

                    @Override
                    public boolean hasPrevious() {
                        return listIterator.hasPrevious();
                    }

                    @Override
                    public E previous() {
                        return function.apply(listIterator.previous());
                    }

                    @Override
                    public int nextIndex() {
                        return listIterator.nextIndex();
                    }

                    @Override
                    public int previousIndex() {
                        return listIterator.previousIndex();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }

                    @Override
                    public void set(E e) {
                        throw new UnsupportedOperationException("set");
                    }

                    @Override
                    public void add(E e) {
                        throw new UnsupportedOperationException("add");
                    }
                };
            }

            @Override
            @NotNull
            public Indexable<E> subSet(int n, int n2) {
                return Indexable.viewList(list.subList(n, n2), function);
            }
        };
    }

    @NotNull
    public static <E, V> Indexable<E> viewListN(@Nullable List<V> list, @NotNull Function<? super V, ? extends E> function) {
        return list == null ? Indexable.emptyIndexable() : Indexable.viewList(list, function);
    }

    @SafeVarargs
    @Deprecated
    @NotNull
    public static <E> Indexable<E> fromArray(E ... EArray) {
        return Indexable.viewArray(EArray);
    }

    @SafeVarargs
    @NotNull
    public static <E> Indexable<E> viewArray(final E ... EArray) {
        return EArray.length == 0 ? Indexable.emptyIndexable() : new Base<E>(){

            @Override
            public int size() {
                return EArray.length;
            }

            @Override
            public E get(int n) {
                return EArray[n];
            }

            @Override
            @NotNull
            public Indexable<E> subSet(int n, int n2) {
                return Indexable.viewArray(EArray, n, n2 - n);
            }
        };
    }

    @NotNull
    public static <E> Indexable<E> viewArray(final @NotNull E[] EArray, final int n, final int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("start has to be non-negative, but is " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("len has to be non-negative, but is " + n2);
        }
        if (n + n2 > EArray.length) {
            throw new IndexOutOfBoundsException(String.format("end will be outside array: %d + %d > %d", n, n2, EArray.length));
        }
        if (n2 == 0) {
            return Indexable.emptyIndexable();
        }
        if (n == 0 && n2 == EArray.length) {
            return Indexable.viewArray(EArray);
        }
        return new Base<E>(){

            @Override
            public E get(int n3) {
                return EArray[n + n3];
            }

            @Override
            public int size() {
                return n2;
            }

            @Override
            @NotNull
            public Indexable<E> subSet(int n3, int n22) {
                if (n3 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n3);
                }
                if (n22 > this.size()) {
                    throw new IndexOutOfBoundsException("toIndex = " + n22);
                }
                if (n3 > n22) {
                    throw new IllegalArgumentException("fromIndex(" + n3 + ") > toIndex(" + n22 + ")");
                }
                return Indexable.viewArray(EArray, n3 + n, n22 - n3);
            }
        };
    }

    @NotNull
    public static <E> Indexable<E> fromCollection(@NotNull Collection<? extends E> collection) {
        return Indexable.fromIterable(collection, collection.size());
    }

    @NotNull
    public static <E, V> Indexable<E> fromCollection(@NotNull Collection<V> collection, @NotNull Function<? super V, ? extends E> function) {
        return Indexable.fromIterable(collection, collection.size(), function);
    }

    @NotNull
    public static <E> Indexable<E> fromCountable(@NotNull Countable<? extends E> countable) {
        return Indexable.fromIterable(countable, countable.size());
    }

    @NotNull
    public static <E, V> Indexable<E> fromCountable(@NotNull Countable<V> countable, @NotNull Function<? super V, ? extends E> function) {
        return Indexable.fromIterable(countable, countable.size(), function);
    }

    @NotNull
    public static <E> Indexable<E> fromIterable(@NotNull Iterable<? extends E> iterable) {
        if (iterable instanceof Sizeable) {
            if (iterable instanceof Indexable) {
                return Indexable.downCast(((Indexable)iterable).frozen());
            }
            return Indexable.fromIterable(iterable, ((Sizeable)((Object)iterable)).size(), object -> object);
        }
        if (iterable instanceof Collection) {
            return Indexable.fromCollection((Collection)iterable);
        }
        return Indexable.fromIterable(iterable, -1, object -> object);
    }

    @NotNull
    public static <E> Indexable<E> fromIterator(@NotNull Iterator<? extends E> iterator) {
        ArrayList arrayList = new ArrayList();
        iterator.forEachRemaining(arrayList::add);
        arrayList.trimToSize();
        return Indexable.viewList(arrayList);
    }

    @NotNull
    public static <E, V> Indexable<E> fromIterable(@NotNull Iterable<V> iterable, @NotNull Function<? super V, ? extends E> function) {
        return Indexable.fromIterable(iterable, -1, function);
    }

    @NotNull
    public static <E> Indexable<E> fromIterable(@NotNull Iterable<? extends E> iterable, int n) {
        return Indexable.fromIterable(iterable, n, object -> object);
    }

    @NotNull
    public static <E, V> Indexable<E> fromIterable(@NotNull Iterable<V> iterable, int n, @NotNull Function<? super V, ? extends E> function) {
        ArrayList arrayList = Types.map(new ArrayList(n > 0 ? n : 8), iterable, function);
        arrayList.trimToSize();
        return IndexableHelper.frozenFromList(arrayList);
    }

    @NotNull
    public static <E> Indexable<E> fromEnumeration(@NotNull Enumeration<? extends E> enumeration, int n) {
        return Indexable.fromEnumeration(enumeration, n, object -> object);
    }

    @NotNull
    public static <E, V> Indexable<E> fromEnumeration(@NotNull Enumeration<V> enumeration, int n, @NotNull Function<? super V, ? extends E> function) {
        ArrayList arrayList = Types.map(new ArrayList(n > 0 ? n : 8), enumeration, function);
        arrayList.trimToSize();
        return IndexableHelper.frozenFromList(arrayList);
    }

    @NotNull
    public static <E> Indexable<E> downCast(@NotNull Indexable<? extends E> indexable) {
        return indexable;
    }

    @NotNull
    public static <E> Indexable<E> singleton(final E e) {
        return new Base<E>(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public E get(int n) {
                if (n != 0) {
                    throw new IndexOutOfBoundsException("index is " + n + " for size 1!");
                }
                return e;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public Indexable<E> frozen() {
                return this;
            }

            @Override
            @NotNull
            public Indexable<E> reverse() {
                return this;
            }

            @Override
            @NotNull
            public Indexable<E> rotated(int n) {
                return this;
            }

            @Override
            @NotNull
            public Collection<E> asCollection() {
                return Collections.singletonList(e);
            }

            @Override
            @NotNull
            public List<E> asList() {
                return Collections.singletonList(e);
            }

            @Override
            @NotNull
            public Iterable<Integer> indexes() {
                return IntIndexable.SINGLE_0;
            }

            @Override
            @NotNull
            public IntIndexable intIndexes() {
                return IntIndexable.SINGLE_0;
            }

            @Override
            @NotNull
            public Indexable<E> sorted(@NotNull Comparator<? super E> comparator) {
                return Indexable.singleton(e);
            }

            @Override
            public boolean isSorted(@NotNull Comparator<? super E> comparator) {
                return true;
            }

            @Override
            public boolean isStrictlySorted(@NotNull Comparator<? super E> comparator) {
                return true;
            }

            @Override
            public E first() {
                return e;
            }

            @Override
            @Nullable
            public E firstOrNull() {
                return e;
            }

            @Override
            @NotNull
            public Optional<E> optFirst() {
                return Optional.of(e);
            }

            @Override
            public E last() {
                return e;
            }

            @Override
            public E lastOrNull() {
                return e;
            }

            @Override
            @NotNull
            public Optional<E> optLast() {
                return Optional.of(e);
            }

            @Override
            @NotNull
            public <K> Dict<K, Indexable<E>> groupingBy(@NotNull Function<? super E, ? extends K> function) {
                return Dict.singleton(function.apply(e), Indexable.singleton(e));
            }

            @Override
            @NotNull
            public <K, V> Dict<K, Indexable<V>> groupingBy(@NotNull Function<? super E, ? extends K> function, @NotNull Function<? super E, ? extends V> function2) {
                return Dict.singleton(function.apply(e), Indexable.singleton(function2.apply(e)));
            }

            @Override
            @NotNull
            public <K> Dict<K, E> mappingBy(boolean bl, @NotNull Function<? super E, ? extends K> function) {
                return Dict.singleton(function.apply(e), e);
            }

            @Override
            @NotNull
            public <K, V> Dict<K, V> mappingBy(boolean bl, @NotNull Function<? super E, ? extends K> function, @NotNull Function<? super E, ? extends V> function2) {
                return Dict.singleton(function.apply(e), function2.apply(e));
            }
        };
    }

    @NotNull
    public static <E> Indexable<E> optional(@Nullable E e) {
        return e != null ? Indexable.singleton(e) : Indexable.emptyIndexable();
    }

    @NotNull
    public static <E> Indexable<E> fromOptional(@NotNull Optional<E> optional) {
        return optional.map(Indexable::singleton).orElseGet(Indexable::emptyIndexable);
    }

    @SafeVarargs
    @NotNull
    public static <E, V> Indexable<E> mapArray(final @NotNull Function<? super V, ? extends E> function, final V ... VArray) {
        return new Base<E>(){

            @Override
            public int size() {
                return VArray.length;
            }

            @Override
            public E get(int n) {
                return function.apply(VArray[n]);
            }
        };
    }

    @NotNull
    public static <V> Indexable<V> view(@NotNull Indexable<? extends V> indexable) {
        return indexable;
    }

    @NotNull
    public static <V> Indexable<V> init(int n, @NotNull Supplier<? extends V> supplier) {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = supplier.get();
        }
        return IndexableHelper.frozenFromArray(objectArray);
    }

    @NotNull
    public static <E, X extends Exception> Indexable<E> initFragile(int n, @NotNull FragileFunction0<E, X> fragileFunction0) throws X {
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = fragileFunction0.apply();
        }
        return IndexableHelper.frozenFromArray(objectArray);
    }

    @NotNull
    public static <V> Indexable<V> viewByIndex(final int n, final @NotNull IntFunction<? extends V> intFunction) {
        if (n == 0) {
            return Indexable.emptyIndexable();
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base<V>(){

            @Override
            public V get(int n2) {
                Indexable.checkIndex(n2, n);
                return intFunction.apply(n2);
            }

            @Override
            public int size() {
                return n;
            }
        };
    }

    @NotNull
    public static <V> Indexable<V> initByIndex(int n, @NotNull IntFunction<? extends V> intFunction) {
        Indexable<V> indexable = Indexable.viewByIndex(n, intFunction);
        return indexable.frozen();
    }

    @NotNull
    public static <E> Base<E> emptyIndexable() {
        return (Base)EMPTY;
    }

    @SafeVarargs
    @NotNull
    public static <E> Indexable<E> combine(final Indexable<? extends E> ... indexableArray) {
        if (indexableArray.length == 0) {
            return Indexable.emptyIndexable();
        }
        return new Base<E>(){

            @Override
            public E get(int n) {
                if (n < 0) {
                    throw new IndexOutOfBoundsException("Non-positive: " + n);
                }
                int n2 = n;
                for (Indexable indexable : indexableArray) {
                    if (n2 < indexable.size()) {
                        return indexable.get(n2);
                    }
                    n2 -= indexable.size();
                }
                throw new IndexOutOfBoundsException(String.format("Index %d too large for size %d", n, this.size()));
            }

            @Override
            public int size() {
                int n = 0;
                for (Indexable indexable : indexableArray) {
                    if ((n += indexable.size()) >= 0) continue;
                    throw new RuntimeException("Combination of indexables has become too large!");
                }
                return n;
            }
        };
    }

    @Deprecated
    @NotNull
    public static String toString(@NotNull Indexable<?> indexable) {
        return Countable.toString(indexable);
    }

    @Deprecated
    public static <E> boolean equal(@NotNull Indexable<? extends E> indexable, @NotNull Indexable<? extends E> indexable2, @NotNull BiPredicate<E, E> biPredicate) {
        return Countable.equal(indexable, indexable2, biPredicate);
    }

    @Deprecated
    public static <E> int compare(@NotNull Indexable<? extends E> indexable, @NotNull Indexable<? extends E> indexable2, @NotNull Comparator<E> comparator) {
        return Types.lexicalCompare(indexable, indexable2, comparator);
    }

    @Deprecated
    public static int hash(@NotNull Indexable<?> indexable) {
        return Types.hash(indexable);
    }

    @NotNull
    public static <E> Indexable<E> withCachedHash(final @NotNull Indexable<E> indexable) {
        final int n = Indexable.hash(indexable);
        return new Base<E>(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public E get(int n2) {
                return indexable.get(n2);
            }

            @Override
            @NotNull
            public Iterator<E> iterator() {
                return indexable.iterator();
            }

            @Override
            @NotNull
            public ListIterator<E> listIterator() {
                return indexable.listIterator();
            }

            @Override
            @NotNull
            public Indexable<E> subSet(int n3, int n2) {
                return indexable.subSet(n3, n2);
            }

            @Override
            public int hashCode() {
                return n;
            }
        };
    }

    @NotNull
    public static <C> Indexable<C> viewTuple(final @NotNull ITuple2<? extends C, ? extends C> iTuple2) {
        return new Base<C>(){

            @Override
            public C get(int n) {
                switch (n) {
                    case 0: {
                        return iTuple2._1();
                    }
                    case 1: {
                        return iTuple2._2();
                    }
                }
                throw new IndexOutOfBoundsException("Trying to get [" + n + "] from Tuple2!");
            }

            @Override
            public int size() {
                return 2;
            }
        };
    }

    @NotNull
    public static <C> Indexable<C> viewTuple(final @NotNull ITuple3<? extends C, ? extends C, ? extends C> iTuple3) {
        return new Base<C>(){

            @Override
            public C get(int n) {
                switch (n) {
                    case 0: {
                        return iTuple3._1();
                    }
                    case 1: {
                        return iTuple3._2();
                    }
                    case 2: {
                        return iTuple3._3();
                    }
                }
                throw new IndexOutOfBoundsException("Trying to get [" + n + "] from Tuple3!");
            }

            @Override
            public int size() {
                return 3;
            }
        };
    }

    @NotNull
    public static <C> Indexable<C> viewTuple(final @NotNull ITuple4<? extends C, ? extends C, ? extends C, ? extends C> iTuple4) {
        return new Base<C>(){

            @Override
            public C get(int n) {
                switch (n) {
                    case 0: {
                        return iTuple4._1();
                    }
                    case 1: {
                        return iTuple4._2();
                    }
                    case 2: {
                        return iTuple4._3();
                    }
                    case 3: {
                        return iTuple4._4();
                    }
                }
                throw new IndexOutOfBoundsException("Trying to get [" + n + "] from Tuple4!");
            }

            @Override
            public int size() {
                return 4;
            }
        };
    }

    @NotNull
    public static <C> Indexable<C> viewTuple(final @NotNull ITuple5<? extends C, ? extends C, ? extends C, ? extends C, ? extends C> iTuple5) {
        return new Base<C>(){

            @Override
            public C get(int n) {
                switch (n) {
                    case 0: {
                        return iTuple5._1();
                    }
                    case 1: {
                        return iTuple5._2();
                    }
                    case 2: {
                        return iTuple5._3();
                    }
                    case 3: {
                        return iTuple5._4();
                    }
                    case 4: {
                        return iTuple5._5();
                    }
                }
                throw new IndexOutOfBoundsException("Trying to get [" + n + "] from Tuple5!");
            }

            @Override
            public int size() {
                return 5;
            }
        };
    }

    @NotNull
    public static <C> Indexable<C> viewTuple(final @NotNull ITuple6<? extends C, ? extends C, ? extends C, ? extends C, ? extends C, ? extends C> iTuple6) {
        return new Base<C>(){

            @Override
            public C get(int n) {
                switch (n) {
                    case 0: {
                        return iTuple6._1();
                    }
                    case 1: {
                        return iTuple6._2();
                    }
                    case 2: {
                        return iTuple6._3();
                    }
                    case 3: {
                        return iTuple6._4();
                    }
                    case 4: {
                        return iTuple6._5();
                    }
                    case 5: {
                        return iTuple6._6();
                    }
                }
                throw new IndexOutOfBoundsException("Trying to get [" + n + "] from Tuple6!");
            }

            @Override
            public int size() {
                return 6;
            }
        };
    }

    @NotNull
    public static <C> Indexable<C> viewTuple(final @NotNull ITuple7<? extends C, ? extends C, ? extends C, ? extends C, ? extends C, ? extends C, ? extends C> iTuple7) {
        return new Base<C>(){

            @Override
            public C get(int n) {
                switch (n) {
                    case 0: {
                        return iTuple7._1();
                    }
                    case 1: {
                        return iTuple7._2();
                    }
                    case 2: {
                        return iTuple7._3();
                    }
                    case 3: {
                        return iTuple7._4();
                    }
                    case 4: {
                        return iTuple7._5();
                    }
                    case 5: {
                        return iTuple7._6();
                    }
                    case 6: {
                        return iTuple7._7();
                    }
                }
                throw new IndexOutOfBoundsException("Trying to get [" + n + "] from Tuple7!");
            }

            @Override
            public int size() {
                return 7;
            }
        };
    }

    @NotNull
    public static <C> Indexable<C> viewTuple(final @NotNull ITuple8<? extends C, ? extends C, ? extends C, ? extends C, ? extends C, ? extends C, ? extends C, ? extends C> iTuple8) {
        return new Base<C>(){

            @Override
            public C get(int n) {
                switch (n) {
                    case 0: {
                        return iTuple8._1();
                    }
                    case 1: {
                        return iTuple8._2();
                    }
                    case 2: {
                        return iTuple8._3();
                    }
                    case 3: {
                        return iTuple8._4();
                    }
                    case 4: {
                        return iTuple8._5();
                    }
                    case 5: {
                        return iTuple8._6();
                    }
                    case 6: {
                        return iTuple8._7();
                    }
                    case 7: {
                        return iTuple8._8();
                    }
                }
                throw new IndexOutOfBoundsException("Trying to get [" + n + "] from Tuple8!");
            }

            @Override
            public int size() {
                return 8;
            }
        };
    }

    @NotNull
    public static <C> Indexable<C> viewTuple(final @NotNull ITuple9<? extends C, ? extends C, ? extends C, ? extends C, ? extends C, ? extends C, ? extends C, ? extends C, ? extends C> iTuple9) {
        return new Base<C>(){

            @Override
            public C get(int n) {
                switch (n) {
                    case 0: {
                        return iTuple9._1();
                    }
                    case 1: {
                        return iTuple9._2();
                    }
                    case 2: {
                        return iTuple9._3();
                    }
                    case 3: {
                        return iTuple9._4();
                    }
                    case 4: {
                        return iTuple9._5();
                    }
                    case 5: {
                        return iTuple9._6();
                    }
                    case 6: {
                        return iTuple9._7();
                    }
                    case 7: {
                        return iTuple9._8();
                    }
                    case 8: {
                        return iTuple9._9();
                    }
                }
                throw new IndexOutOfBoundsException("Trying to get [" + n + "] from Tuple9!");
            }

            @Override
            public int size() {
                return 9;
            }
        };
    }

    public static class IndexableSpliterator<TElem>
    implements Spliterator<TElem> {
        @NotNull
        private final Indexable<TElem> indexable;
        private int index;
        private final int fence;
        private final int character;

        public IndexableSpliterator(@NotNull Indexable<TElem> indexable) {
            this(indexable, 0, indexable.size(), false);
        }

        public IndexableSpliterator(@NotNull Indexable<TElem> indexable, int n, int n2, boolean bl) {
            this(indexable, n, n2, bl ? 17488 : 16464);
        }

        private IndexableSpliterator(@NotNull Indexable<TElem> indexable, int n, int n2, int n3) {
            this.indexable = indexable;
            this.index = n;
            this.fence = n2;
            this.character = n3;
        }

        @Override
        public boolean tryAdvance(Consumer<? super TElem> consumer) {
            if (this.index < this.fence) {
                consumer.accept(this.indexable.get(this.index++));
                return true;
            }
            return false;
        }

        @Override
        public IndexableSpliterator<TElem> trySplit() {
            int n = this.index;
            int n2 = (n + this.fence) / 2;
            if (n < n2) {
                this.index = n2;
                return new IndexableSpliterator<TElem>(this.indexable, n, n2, this.character);
            }
            return null;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.character;
        }
    }

    public static abstract class Base<TT>
    extends Countable.Base<TT>
    implements Indexable<TT> {
        @Override
        @NotNull
        public Base<TT> asBase() {
            return this;
        }
    }

    public static class ListView<T>
    extends AbstractList<T>
    implements RandomAccess {
        @NotNull
        private final Indexable<T> indexable;

        public ListView(@NotNull Indexable<T> indexable) {
            this.indexable = indexable;
        }

        @Override
        public T get(int n) {
            return this.indexable.get(n);
        }

        @Override
        public int size() {
            return this.indexable.size();
        }

        @Override
        public boolean isEmpty() {
            return this.indexable.isEmpty();
        }

        @Override
        public Iterator<T> iterator() {
            return this.indexable.iterator();
        }
    }
}

