/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.Countable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;

public class IdentityHashSet<T>
extends AbstractSet<T> {
    @NotNull
    private final Map<T, Boolean> map;

    public IdentityHashSet() {
        this.map = new IdentityHashMap<T, Boolean>();
    }

    public IdentityHashSet(int n) {
        this.map = new IdentityHashMap<T, Boolean>(n);
    }

    public IdentityHashSet(@NotNull Iterable<? extends T> iterable) {
        this();
        iterable.forEach(this::add);
    }

    public IdentityHashSet(@NotNull Collection<? extends T> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    public IdentityHashSet(@NotNull Countable<? extends T> countable) {
        this(countable.size());
        countable.addAllTo(this);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    @NotNull
    public Spliterator<T> spliterator() {
        return this.map.keySet().spliterator();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        return this.map.keySet().removeAll(collection);
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] T1Array) {
        return this.map.keySet().toArray(T1Array);
    }

    @Override
    public boolean add(T t) {
        if (this.map.containsKey(t)) {
            return false;
        }
        this.map.put(t, Boolean.TRUE);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) != null;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        return this.map.keySet().containsAll(collection);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> collection) {
        boolean bl = false;
        for (T t : collection) {
            bl |= this.add(t);
        }
        return bl;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean removeIf(@NotNull Predicate<? super T> predicate) {
        return this.map.keySet().removeIf(predicate);
    }

    @Override
    @NotNull
    public Stream<T> stream() {
        return this.map.keySet().stream();
    }

    @Override
    @NotNull
    public Stream<T> parallelStream() {
        return this.map.keySet().parallelStream();
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        this.map.keySet().forEach(consumer);
    }
}

