/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.Empty;
import de.caff.generics.HashCodeCalculator;
import de.caff.generics.HashCoder;
import de.caff.generics.IteratorConverter;
import de.caff.generics.Matcher;
import de.caff.generics.Types;
import de.caff.generics.function.Function1;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class HashCoderSet<V>
implements Set<V> {
    @NotNull
    private final HashCoder<V> hashCoder;
    @NotNull
    private final Set<HashKey> hashSet;

    public HashCoderSet(@NotNull HashCoder<V> hashCoder) {
        this.hashCoder = hashCoder;
        this.hashSet = new HashSet<HashKey>();
    }

    public HashCoderSet(@NotNull HashCoder<V> hashCoder, int n) {
        this.hashCoder = hashCoder;
        this.hashSet = new HashSet<HashKey>(n);
    }

    public HashCoderSet(@NotNull HashCoder<V> hashCoder, int n, float f) {
        this.hashCoder = hashCoder;
        this.hashSet = new HashSet<HashKey>(n, f);
    }

    public HashCoderSet(@NotNull HashCoder<V> hashCoder, @NotNull Collection<? extends V> collection) {
        this.hashCoder = hashCoder;
        this.hashSet = new HashSet<HashKey>(collection.size());
        this.addAll((Collection<? extends V>)collection);
    }

    public HashCoderSet(@NotNull HashCoder<V> hashCoder, @NotNull Iterable<? extends V> iterable) {
        this.hashCoder = hashCoder;
        this.hashSet = new HashSet<HashKey>();
    }

    public HashCoderSet(@NotNull HashCodeCalculator<? super V> hashCodeCalculator) {
        this(new HashCoder<V>(hashCodeCalculator));
    }

    public HashCoderSet(@NotNull HashCodeCalculator<? super V> hashCodeCalculator, @NotNull Matcher<? super V, ? super V> matcher) {
        this(new HashCoder<V>(hashCodeCalculator, matcher));
    }

    public HashCoderSet(@NotNull HashCodeCalculator<? super V> hashCodeCalculator, @NotNull Matcher<? super V, ? super V> matcher, @NotNull Function1<V, V> function1) {
        this(new HashCoder<V>(hashCodeCalculator, matcher, function1));
    }

    public HashCoderSet(@NotNull Function1<V, V> function1) {
        this(new HashCoder<V>(function1));
    }

    @NotNull
    public HashCoder<? super V> getHashCoder() {
        return this.hashCoder;
    }

    @Override
    public int size() {
        return this.hashSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.hashSet.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.hashSet.contains(new HashKey(object));
    }

    @Override
    @NotNull
    public Iterator<V> iterator() {
        return new IteratorConverter<Object, HashKey>(this.hashSet.iterator(), HashKey::getOriginalKey);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        int n = this.size();
        if (n == 0) {
            return Empty.OBJECT_ARRAY;
        }
        Object[] objectArray = new Object[n];
        int n2 = 0;
        for (HashKey hashKey : this.hashSet) {
            objectArray[n2++] = hashKey.originalKey;
        }
        return objectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] TArray) {
        List list = Types.map(new ArrayList(this.size()), this.hashSet, HashKey::getOriginalKey);
        return list.toArray(TArray);
    }

    @Override
    public boolean add(V v) {
        return this.hashSet.add(new HashKey(v));
    }

    @Override
    public boolean remove(Object object) {
        return this.hashSet.remove(new HashKey(object));
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(collection)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends V> collection) {
        boolean bl = false;
        for (V v : collection) {
            if (!this.hashSet.add(new HashKey(v))) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean addAll(@NotNull Iterable<? extends V> iterable) {
        boolean bl = false;
        for (V v : iterable) {
            if (!this.hashSet.add(new HashKey(v))) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        return this.hashSet.retainAll(Types.map(collection, object -> new HashKey(object)));
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        boolean bl = false;
        for (Object obj : collection) {
            if (!this.remove(obj)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        this.hashSet.clear();
    }

    private class HashKey {
        private final V originalKey;
        private final int hashCode;

        private HashKey(V v) {
            this.originalKey = HashCoderSet.this.hashCoder.copy(v);
            this.hashCode = HashCoderSet.this.hashCoder.getHashCode(v);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof HashKey)) {
                return false;
            }
            HashKey hashKey = (HashKey)object;
            return HashCoderSet.this.hashCoder.areEqual(this.originalKey, hashKey.originalKey);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public V getOriginalKey() {
            return HashCoderSet.this.hashCoder.copy(this.originalKey);
        }
    }
}

