/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.HashCodeCalculator;
import de.caff.generics.HashCoder;
import de.caff.generics.HashCoderSet;
import de.caff.generics.Matcher;
import de.caff.generics.Types;
import de.caff.generics.function.Function1;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class HashCoderMap<K, V>
implements Map<K, V> {
    @NotNull
    private final HashCoder<K> hashCoder;
    @NotNull
    private final HashMap<HashKey, V> hashMap;

    public HashCoderMap(@NotNull HashCoder<K> hashCoder) {
        this.hashCoder = hashCoder;
        this.hashMap = new HashMap();
    }

    public HashCoderMap(@NotNull HashCoder<K> hashCoder, int n) {
        this.hashCoder = hashCoder;
        this.hashMap = new HashMap(n);
    }

    public HashCoderMap(@NotNull HashCoder<K> hashCoder, int n, float f) {
        this.hashCoder = hashCoder;
        this.hashMap = new HashMap(n, f);
    }

    public HashCoderMap(@NotNull HashCoder<K> hashCoder, @NotNull Map<? extends K, ? extends V> map) {
        this.hashCoder = hashCoder;
        this.hashMap = new HashMap(map.size());
        this.putAll(map);
    }

    public HashCoderMap(@NotNull HashCodeCalculator<? super K> hashCodeCalculator) {
        this(new HashCoder<K>(hashCodeCalculator));
    }

    public HashCoderMap(@NotNull HashCodeCalculator<? super K> hashCodeCalculator, @NotNull Matcher<? super K, ? super K> matcher) {
        this(new HashCoder<K>(hashCodeCalculator, matcher));
    }

    public HashCoderMap(@NotNull HashCodeCalculator<? super K> hashCodeCalculator, @NotNull Matcher<? super K, ? super K> matcher, @NotNull Function1<K, K> function1) {
        this(new HashCoder<K>(hashCodeCalculator, matcher, function1));
    }

    public HashCoderMap(@NotNull Function<K, K> function) {
        this(new HashCoder<K>(function));
    }

    @NotNull
    public HashCoder<? super K> getHashCoder() {
        return this.hashCoder;
    }

    @Override
    public int size() {
        return this.hashMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.hashMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.hashMap.containsKey(new HashKey(object));
    }

    @Override
    public boolean containsValue(Object object) {
        return this.hashMap.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.hashMap.get(new HashKey(object));
    }

    @Override
    public V put(K k, V v) {
        return this.hashMap.put(new HashKey(k), v);
    }

    @Override
    public V remove(Object object) {
        return this.hashMap.remove(new HashKey(object));
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.hashMap.put(new HashKey(entry.getKey()), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.hashMap.clear();
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return new HashCoderSet<Object>(this.hashCoder, Types.view(this.hashMap.keySet(), HashKey::getOriginalKey));
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.hashMap.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return Types.map(new HashSet(), this.hashMap.entrySet(), entry -> new Map.Entry<K, V>((Map.Entry)entry){
            final /* synthetic */ Map.Entry val$e;
            {
                this.val$e = entry;
            }

            @Override
            public K getKey() {
                return ((HashKey)this.val$e.getKey()).getOriginalKey();
            }

            @Override
            public V getValue() {
                return this.val$e.getValue();
            }

            @Override
            public V setValue(V v) {
                return this.val$e.setValue(v);
            }
        });
    }

    private class HashKey {
        private final K originalKey;
        private final int hashCode;

        private HashKey(K k) {
            this.originalKey = HashCoderMap.this.hashCoder.copy(k);
            this.hashCode = HashCoderMap.this.hashCoder.getHashCode(k);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof HashKey)) {
                return false;
            }
            HashKey hashKey = (HashKey)object;
            return HashCoderMap.this.hashCoder.areEqual(this.originalKey, hashKey.originalKey);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public K getOriginalKey() {
            return HashCoderMap.this.hashCoder.copy(this.originalKey);
        }
    }
}

