/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.HashCodeCalculator;
import de.caff.generics.Matcher;
import de.caff.generics.UniformMatcher;
import java.util.Objects;
import java.util.function.Function;

public class HashCoder<T>
implements HashCodeCalculator<T>,
UniformMatcher<T> {
    private static final HashCoder<Object> NATURAL = new HashCoder<Object>(HashCodeCalculator.NATURAL, UniformMatcher.NATURAL, Function.identity());
    private static final HashCoder<Object> NATURAL_NULL_SAFE = new HashCoder<Object>(HashCodeCalculator.NATURAL_NULL_SAFE, UniformMatcher.NATURAL_NULL_SAFE, Function.identity());
    @NotNull
    private final HashCodeCalculator<? super T> codeCalculator;
    @NotNull
    private final Matcher<? super T, ? super T> matcher;
    @NotNull
    private final Function<T, T> copier;

    public HashCoder(@NotNull HashCodeCalculator<? super T> hashCodeCalculator, @NotNull Matcher<? super T, ? super T> matcher, @NotNull Function<T, T> function) {
        this.codeCalculator = hashCodeCalculator;
        this.matcher = matcher;
        this.copier = function;
    }

    public HashCoder(@NotNull HashCodeCalculator<? super T> hashCodeCalculator, @NotNull Matcher<? super T, ? super T> matcher) {
        this(hashCodeCalculator, matcher, object -> object);
    }

    public HashCoder(@NotNull HashCodeCalculator<? super T> hashCodeCalculator) {
        this(hashCodeCalculator, Objects::equals, object -> object);
    }

    public HashCoder(@NotNull Function<T, T> function) {
        this(Objects::hashCode, Objects::equals, function);
    }

    @Override
    public int getHashCode(T t) {
        return this.codeCalculator.getHashCode(t);
    }

    @Override
    public boolean areEqual(T t, T t2) {
        return this.matcher.areEqual(t, t2);
    }

    public T copy(T t) {
        return this.copier.apply(t);
    }

    @NotNull
    public static <V> HashCoder<V> natural() {
        return NATURAL;
    }

    @NotNull
    public static <V> HashCoder<V> naturalNullSafe() {
        return NATURAL_NULL_SAFE;
    }
}

