/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import java.util.Objects;

public interface HashCodeCalculator<T> {
    public static final HashCodeCalculator<Object> OBJECTS = Objects::hashCode;
    public static final HashCodeCalculator<Object> NATURAL = Object::hashCode;
    public static final HashCodeCalculator<Object> NATURAL_NULL_SAFE = object -> object == null ? 0 : object.hashCode();

    public int getHashCode(T var1);

    @NotNull
    public static <K> HashCodeCalculator<K> objects() {
        return OBJECTS;
    }

    @NotNull
    public static <K> HashCodeCalculator<K> natural() {
        return NATURAL;
    }

    @NotNull
    public static <K> HashCodeCalculator<K> naturalNullSafe() {
        return NATURAL_NULL_SAFE;
    }
}

