/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.HashCodeCalculator;
import de.caff.generics.UniformMatcher;
import de.caff.generics.matcher.Match;

public class HashCacheWrapper<T> {
    private final T wrapped;
    private final int hashCodeValue;
    @NotNull
    private final UniformMatcher<? super T> matcher;

    public HashCacheWrapper(T t, int n, @Nullable UniformMatcher<? super T> uniformMatcher) {
        this.wrapped = t;
        this.hashCodeValue = n;
        this.matcher = uniformMatcher == null ? Match.DEFAULT_MATCHER : uniformMatcher;
    }

    public HashCacheWrapper(@NotNull T t) {
        this(t, t.hashCode(), null);
    }

    public HashCacheWrapper(@NotNull T t, @Nullable UniformMatcher<? super T> uniformMatcher) {
        this((T)t, t.hashCode(), uniformMatcher);
    }

    public HashCacheWrapper(T t, @NotNull HashCodeCalculator<? super T> hashCodeCalculator, @Nullable UniformMatcher<? super T> uniformMatcher) {
        this((T)t, hashCodeCalculator.getHashCode(t), uniformMatcher);
    }

    public T getWrapped() {
        return this.wrapped;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        HashCacheWrapper hashCacheWrapper = (HashCacheWrapper)object;
        return this.hashCodeValue == hashCacheWrapper.hashCodeValue && this.matcher.areEqual(this.wrapped, hashCacheWrapper.wrapped);
    }

    public int hashCode() {
        return this.hashCodeValue;
    }
}

