/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.DoublePair;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Primitives;
import de.caff.generics.function.FloatFunction2;
import de.caff.generics.function.FloatOperator2;
import de.caff.generics.function.FloatPredicate2;
import de.caff.generics.tuple.Tuple;
import de.caff.generics.tuple.Tuple2;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

public final class FloatPair
implements Serializable,
FloatIndexable {
    private static final long serialVersionUID = -832244696920409438L;
    public final float first;
    public final float second;

    public FloatPair(float f, float f2) {
        this.first = f;
        this.second = f2;
    }

    @NotNull
    public DoublePair toDoublePair() {
        return new DoublePair(this.first, this.second);
    }

    @NotNull
    public FloatPair withFirst(float f) {
        if (Float.compare(this.first, f) == 0) {
            return this;
        }
        return new FloatPair(f, this.second);
    }

    @NotNull
    public FloatPair withSecond(float f) {
        if (Float.compare(this.second, f) == 0) {
            return this;
        }
        return new FloatPair(this.first, f);
    }

    @NotNull
    public FloatPair swapped() {
        if (Float.compare(this.first, this.second) == 0) {
            return this;
        }
        return new FloatPair(this.second, this.first);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public float get(int n) {
        switch (n) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
        }
        throw new IndexOutOfBoundsException(String.format("Pair has only 2 elements, so %d is out of bounds!", n));
    }

    public <T> T applyAsFloats(@NotNull FloatFunction2<T> floatFunction2) {
        return floatFunction2.applyAsFloat(this.first, this.second);
    }

    public float operate(@NotNull FloatOperator2 floatOperator2) {
        return floatOperator2.applyAsFloat(this.first, this.second);
    }

    public boolean test(@NotNull FloatPredicate2 floatPredicate2) {
        return floatPredicate2.testFloats(this.first, this.second);
    }

    @NotNull
    public Tuple2<Float, Float> toTuple() {
        return Tuple.of(Float.valueOf(this.first), Float.valueOf(this.second));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        FloatPair floatPair = (FloatPair)object;
        return Primitives.areEqual(floatPair.first, this.first) && Primitives.areEqual(floatPair.second, this.second);
    }

    public int hashCode() {
        return Objects.hash(Primitives.boxed(this.first), Primitives.boxed(this.second));
    }

    @NotNull
    public String toString() {
        return String.format(Locale.US, "FloatPair(%s, %s)", Float.valueOf(this.first), Float.valueOf(this.second));
    }
}

