/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.ByteIndexable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.Indexable;
import de.caff.generics.IndexableHelper;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongIndexable;
import de.caff.generics.MutableFloatIndexable;
import de.caff.generics.Order;
import de.caff.generics.PrimitiveFloatIterable;
import de.caff.generics.PrimitiveFloatIterator;
import de.caff.generics.Primitives;
import de.caff.generics.Pythonesque;
import de.caff.generics.ShortIndexable;
import de.caff.generics.Sizeable;
import de.caff.generics.Types;
import de.caff.generics.function.FloatConsumer;
import de.caff.generics.function.FloatFunction1;
import de.caff.generics.function.FloatOperator1;
import de.caff.generics.function.FloatOperator2;
import de.caff.generics.function.FloatOrdering;
import de.caff.generics.function.FloatPredicate1;
import de.caff.generics.function.FloatPredicate2;
import de.caff.generics.function.FragileFloatConsumer;
import de.caff.generics.function.IntToFloatFunction1;
import de.caff.generics.function.ToFloatFunction;
import de.caff.generics.range.Range;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;

public interface FloatIndexable
extends PrimitiveFloatIterable,
Sizeable {
    public static final FloatIndexable SINGLE_0 = FloatIndexable.singleton(0.0f);
    @NotNull
    public static final Base EMPTY = new Base(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public float get(int n) {
            throw new IndexOutOfBoundsException("Empty indexable has no elements!");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public float[] toArray() {
            return Empty.FLOAT_ARRAY;
        }

        @Override
        public int addToArray(@NotNull float[] fArray, int n) {
            return n;
        }

        @Override
        public int addToArray(@NotNull float[] fArray, int n, int n2, int n3) {
            return n;
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfDouble doubleIterator() {
            return Types.EMPTY_DOUBLE_ITERATOR;
        }

        @Override
        @NotNull
        public PrimitiveFloatIterator floatIterator() {
            return Types.EMPTY_FLOAT_ITERATOR;
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        @NotNull
        public FloatIndexable frozen() {
            return this;
        }

        @Override
        @NotNull
        public Iterator<Float> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public ListIterator<Float> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        public int compareTo(@NotNull FloatIndexable floatIndexable) {
            return floatIndexable.isEmpty() ? 0 : -1;
        }

        @Override
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof FloatIndexable && ((FloatIndexable)object).isEmpty();
        }

        @Override
        @NotNull
        public Collection<Float> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Float> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public DoubleIndexable.Base asDoubleIndexable() {
            return DoubleIndexable.EMPTY;
        }

        @Override
        public float foldLeft(float f, @NotNull FloatOperator2 floatOperator2) {
            return f;
        }

        @Override
        public void forEachFloat(@NotNull FloatConsumer floatConsumer) {
        }

        @Override
        public <E extends Exception> void forEachFloatFragile(@NotNull FragileFloatConsumer<E> fragileFloatConsumer) throws E {
        }

        @Override
        public boolean containsFloat(float f) {
            return false;
        }

        @Override
        public boolean containsFloat(float f, float f2) {
            return false;
        }

        @Override
        public void forEach(Consumer<? super Float> consumer) {
        }
    };

    public float get(int var1);

    default public float gyt(int n) {
        return this.get(Pythonesque.mapX(n, this));
    }

    default public float getMod(int n) {
        int n2 = this.size();
        if (n2 == 0) {
            throw new IndexOutOfBoundsException("No element for empty indexable!");
        }
        return this.gyt(n % n2);
    }

    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }

            @Override
            public float get(int n) {
                return FloatIndexable.this.get(FloatIndexable.this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return FloatIndexable.based(FloatIndexable.this);
            }
        };
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @NotNull
    default public PrimitiveIterator.OfDouble doubleIterator() {
        return new PrimitiveIterator.OfDouble(){
            private int index = 0;

            @Override
            public double nextDouble() {
                if (this.index >= FloatIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return FloatIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < FloatIndexable.this.size();
            }
        };
    }

    @Override
    @NotNull
    default public PrimitiveFloatIterator floatIterator() {
        return this.floatIterator(0, this.size());
    }

    @NotNull
    default public PrimitiveFloatIterator floatIterator(final int n, final int n2) {
        return new PrimitiveFloatIterator(){
            private int index;
            {
                this.index = n;
            }

            @Override
            public float nextFloat() {
                if (this.index >= n2) {
                    throw new NoSuchElementException(String.format("Index %s out of allowed range [%d, %d[!", this.index, n, n2));
                }
                return FloatIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < n2;
            }
        };
    }

    @Override
    @NotNull
    default public Iterator<Float> iterator() {
        return this.listIterator();
    }

    @NotNull
    default public ListIterator<Float> listIterator() {
        return new ListIterator<Float>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < FloatIndexable.this.size();
            }

            @Override
            public Float next() {
                if (this.index >= FloatIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return Float.valueOf(FloatIndexable.this.get(this.index++));
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Float previous() {
                if (this.index == 0) {
                    throw new NoSuchElementException("index: -1");
                }
                return Float.valueOf(FloatIndexable.this.get(--this.index));
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Float f) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Float f) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    default public Base subSet(final int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return n3 == 0 ? EMPTY : new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public float get(int n2) {
                if (n2 >= n3) {
                    throw new IndexOutOfBoundsException("No such element: " + n2);
                }
                return FloatIndexable.this.get(n2 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n2) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n2 > n3) {
                    throw new IndexOutOfBoundsException("toIndex = " + n2);
                }
                if (n4 > n2) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n2 + ")");
                }
                return FloatIndexable.this.subSet(n + n4, n + n2);
            }
        };
    }

    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(Pythonesque.mapX(n, this), this.size());
    }

    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, Pythonesque.mapX(n, this));
    }

    @NotNull
    default public <T> Indexable<T> view(final @NotNull FloatFunction1<? extends T> floatFunction1) {
        return new Indexable.Base<T>(){

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }

            @Override
            public T get(int n) {
                return floatFunction1.applyAsFloat(FloatIndexable.this.get(n));
            }
        };
    }

    @NotNull
    default public Collection<Float> asCollection() {
        return new AbstractCollection<Float>(){

            @Override
            @NotNull
            public Iterator<Float> iterator() {
                return FloatIndexable.this.iterator();
            }

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }
        };
    }

    @NotNull
    default public List<Float> asList() {
        return new AbstractList<Float>(){

            @Override
            public Float get(int n) {
                return Float.valueOf(FloatIndexable.this.get(n));
            }

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }

            @Override
            @NotNull
            public Iterator<Float> iterator() {
                return FloatIndexable.this.iterator();
            }
        };
    }

    @NotNull
    default public ArrayList<Float> toList() {
        ArrayList<Float> arrayList = new ArrayList<Float>(this.size());
        this.addAllTo(arrayList);
        return arrayList;
    }

    default public void addAllTo(@NotNull Collection<? super Float> collection) {
        for (Float f : this) {
            collection.add(f);
        }
    }

    @NotNull
    default public Indexable<Float> asIndexable() {
        return new Indexable.Base<Float>(){

            @Override
            public Float get(int n) {
                return Float.valueOf(FloatIndexable.this.get(n));
            }

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }
        };
    }

    @NotNull
    default public float[] toArray() {
        if (this.isEmpty()) {
            return Empty.FLOAT_ARRAY;
        }
        float[] fArray = new float[this.size()];
        this.addToArray(fArray, 0);
        return fArray;
    }

    default public int addToArray(@NotNull float[] fArray, int n) {
        return this.addToArray(fArray, n, 0, this.size());
    }

    default public int addToArray(@NotNull float[] fArray, int n, int n2, int n3) {
        PrimitiveFloatIterator primitiveFloatIterator = this.floatIterator(n2, n2 + n3);
        while (primitiveFloatIterator.hasNext()) {
            fArray[n++] = primitiveFloatIterator.nextFloat();
        }
        return n;
    }

    @NotNull
    default public Iterable<Integer> indexes() {
        return Range.indexes(this.size());
    }

    @NotNull
    default public IntIndexable intIndexes() {
        return IntIndexable.rangeFromSize(this.size());
    }

    @NotNull
    default public DoubleIndexable.Base asDoubleIndexable() {
        return new DoubleIndexable.Base(){

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }

            @Override
            public double get(int n) {
                return FloatIndexable.this.get(n);
            }
        };
    }

    default public float foldLeft(float f, @NotNull FloatOperator2 floatOperator2) {
        float f2 = f;
        PrimitiveFloatIterator primitiveFloatIterator = this.floatIterator();
        while (primitiveFloatIterator.hasNext()) {
            f2 = floatOperator2.applyAsFloat(f2, primitiveFloatIterator.nextFloat());
        }
        return f2;
    }

    @NotNull
    default public FloatIndexable withInsertedValueAt(int n, final float f) {
        final int n2 = n;
        final int n3 = this.size() + 1;
        if (n2 == 0) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public float get(int n) {
                    return n == 0 ? f : FloatIndexable.this.get(n - 1);
                }
            };
        }
        if (n2 == n3 - 1) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public float get(int n) {
                    return n == n3 - 1 ? f : FloatIndexable.this.get(n);
                }
            };
        }
        return new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public float get(int n) {
                if (n == n2) {
                    return f;
                }
                return FloatIndexable.this.get(n < n2 ? n : n - 1);
            }
        };
    }

    @NotNull
    default public FloatIndexable withAppendedValue(float f) {
        return this.withInsertedValueAt(this.size(), f);
    }

    @NotNull
    default public FloatIndexable withExchangedValueAt(int n, final float f) {
        final int n2 = Pythonesque.mapX(n, this);
        return new Base(){

            @Override
            public float get(int n) {
                return n == n2 ? f : FloatIndexable.this.get(n);
            }

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }
        };
    }

    @NotNull
    default public FloatIndexable withRemovedValueAt(int n) {
        final int n2 = Pythonesque.mapX(n, this);
        if (n2 == 0) {
            return this.tailSet(1);
        }
        final int n3 = this.size() - 1;
        if (n2 == n3) {
            return this.headSet(-1);
        }
        return new Base(){

            @Override
            public float get(int n) {
                return n < n2 ? FloatIndexable.this.get(n) : FloatIndexable.this.get(n + 1);
            }

            @Override
            public int size() {
                return n3;
            }
        };
    }

    @NotNull
    default public FloatIndexable withSwappedValuesAt(int n, int n2) {
        int n3;
        final int n4 = Pythonesque.mapX(n, this);
        if (n4 == (n3 = Pythonesque.mapX(n2, this))) {
            return this;
        }
        return new Base(){

            @Override
            public float get(int n) {
                if (n == n4) {
                    return FloatIndexable.this.get(n3);
                }
                if (n == n3) {
                    return FloatIndexable.this.get(n4);
                }
                return FloatIndexable.this.get(n);
            }

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }
        };
    }

    @NotNull
    default public FloatIndexable rotated(int n) {
        if (this.isEmpty()) {
            return this;
        }
        if ((n %= this.size()) == 0) {
            return this;
        }
        if (n < 0) {
            n += this.size();
        }
        final int n2 = n;
        return new Base(){

            @Override
            public float get(int n) {
                return FloatIndexable.this.get((n + n2) % this.size());
            }

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }

            @Override
            @NotNull
            public FloatIndexable rotated(int n) {
                return FloatIndexable.this.rotated(n2 + n);
            }
        };
    }

    @NotNull
    default public FloatIndexable viewOp(@NotNull FloatOperator1 floatOperator1) {
        return FloatIndexable.viewByIndex(this.size(), n -> floatOperator1.applyAsFloat(this.get(n)));
    }

    @NotNull
    default public DoubleIndexable viewAsDouble() {
        return new DoubleIndexable.Base(){

            @Override
            public double get(int n) {
                return FloatIndexable.this.get(n);
            }

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }
        };
    }

    @NotNull
    default public LongIndexable viewAsLong() {
        return new LongIndexable.Base(){

            @Override
            public long get(int n) {
                return (long)FloatIndexable.this.get(n);
            }

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }
        };
    }

    @NotNull
    default public IntIndexable viewAsInt() {
        return new IntIndexable.Base(){

            @Override
            public int get(int n) {
                return (int)FloatIndexable.this.get(n);
            }

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ShortIndexable viewAsShort() {
        return new ShortIndexable.Base(){

            @Override
            public short get(int n) {
                return (short)FloatIndexable.this.get(n);
            }

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ByteIndexable viewAsByte() {
        return new ByteIndexable.Base(){

            @Override
            public byte get(int n) {
                return (byte)FloatIndexable.this.get(n);
            }

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }
        };
    }

    @NotNull
    default public BooleanIndexable viewAsBoolean(final @NotNull FloatPredicate1 floatPredicate1) {
        return new BooleanIndexable.Base(){

            @Override
            public boolean get(int n) {
                return floatPredicate1.test(Float.valueOf(FloatIndexable.this.get(n)));
            }

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Number> list) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public float get(int n) {
                return ((Number)list.get(n)).floatValue();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Number> list, final float f) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public float get(int n) {
                Number number = (Number)list.get(n);
                return number != null ? number.floatValue() : f;
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static <T> Base viewList(final @NotNull List<T> list, final @NotNull ToFloatFunction<? super T> toFloatFunction) {
        return new Base(){

            @Override
            public float get(int n) {
                return toFloatFunction.applyAsFloat(list.get(n));
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Number> indexable) {
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public float get(int n) {
                return ((Number)indexable.get(n)).floatValue();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Number> indexable, final float f) {
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public float get(int n) {
                Number number = (Number)indexable.get(n);
                return number != null ? number.floatValue() : f;
            }
        };
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToFloatFunction<? super T> toFloatFunction) {
        return new Base(){

            @Override
            public float get(int n) {
                return toFloatFunction.applyAsFloat(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public boolean isEmpty() {
                return indexable.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewNumberArray(final Number ... numberArray) {
        return new Base(){

            @Override
            public int size() {
                return numberArray.length;
            }

            @Override
            public float get(int n) {
                return numberArray[n].floatValue();
            }
        };
    }

    @NotNull
    public static Base viewArray(final float ... fArray) {
        return new Base(){

            @Override
            public int size() {
                return fArray.length;
            }

            @Override
            public float get(int n) {
                return fArray[n];
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull float[] fArray, final int n, final int n2) {
        if (n < 0 || n2 < 0 || n + n2 > fArray.length) {
            throw new IndexOutOfBoundsException("Start or end outside of range!");
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return n2;
            }

            @Override
            public float get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("Index %d outside range [0, %d[!", n3, n2));
                }
                return fArray[n3 + n];
            }
        };
    }

    @NotNull
    public static <T> Base viewArray(final @NotNull T[] TArray, final @NotNull ToFloatFunction<? super T> toFloatFunction) {
        if (TArray.length == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public float get(int n) {
                return toFloatFunction.applyAsFloat(TArray[n]);
            }

            @Override
            public int size() {
                return TArray.length;
            }
        };
    }

    @NotNull
    public static Base singleton(final float f) {
        return new Base(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public float get(int n) {
                if (n != 0) {
                    throw new IndexOutOfBoundsException(String.format("Index %d for indexable of size 1!", n));
                }
                return f;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public Base reverse() {
                return this;
            }

            @Override
            @NotNull
            public FloatIndexable rotated(int n) {
                return this;
            }

            @Override
            @NotNull
            public Collection<Float> asCollection() {
                return Collections.singleton(Float.valueOf(f));
            }

            @Override
            @NotNull
            public List<Float> asList() {
                return Collections.singletonList(Float.valueOf(f));
            }

            @Override
            @NotNull
            public float[] toArray() {
                return new float[]{f};
            }

            @Override
            public int addToArray(@NotNull float[] fArray, int n) {
                fArray[n] = f;
                return n + 1;
            }

            @Override
            @NotNull
            public Iterable<Integer> indexes() {
                return IntIndexable.SINGLE_0;
            }

            @Override
            @NotNull
            public IntIndexable intIndexes() {
                return IntIndexable.SINGLE_0;
            }
        };
    }

    @NotNull
    public static Base init(final int n, final float f) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public float get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return f;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            @NotNull
            public FloatIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    public static Base viewByIndex(final int n, final @NotNull IntToFloatFunction1 intToFloatFunction1) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public float get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return intToFloatFunction1.applyAsFloat(n2);
            }

            @Override
            public int size() {
                return 0;
            }
        };
    }

    @NotNull
    public static FloatIndexable initByIndex(int n, @NotNull IntToFloatFunction1 intToFloatFunction1) {
        return FloatIndexable.viewByIndex(n, intToFloatFunction1).frozen();
    }

    @NotNull
    public static Base emptyIndexable() {
        return EMPTY;
    }

    @NotNull
    public static String toString(@NotNull FloatIndexable floatIndexable) {
        if (floatIndexable.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(floatIndexable.get(0));
        PrimitiveFloatIterator primitiveFloatIterator = floatIndexable.tailSet(1).floatIterator();
        while (primitiveFloatIterator.hasNext()) {
            stringBuilder.append(',').append(primitiveFloatIterator.nextFloat());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static boolean equal(@NotNull FloatIndexable floatIndexable, @NotNull FloatIndexable floatIndexable2) {
        return FloatIndexable.equal(floatIndexable, floatIndexable2, FloatPredicate2.EQUAL_EVEN_NAN);
    }

    public static boolean equalStandard(@NotNull FloatIndexable floatIndexable, @NotNull FloatIndexable floatIndexable2) {
        return FloatIndexable.equal(floatIndexable, floatIndexable2, FloatPredicate2.EQUAL_STANDARD);
    }

    public static boolean equal(@NotNull FloatIndexable floatIndexable, @NotNull FloatIndexable floatIndexable2, @NotNull FloatPredicate2 floatPredicate2) {
        if (floatIndexable == floatIndexable2) {
            return true;
        }
        if (floatIndexable.size() != floatIndexable2.size()) {
            return false;
        }
        PrimitiveFloatIterator primitiveFloatIterator = floatIndexable.floatIterator();
        PrimitiveFloatIterator primitiveFloatIterator2 = floatIndexable2.floatIterator();
        while (primitiveFloatIterator.hasNext() && primitiveFloatIterator2.hasNext()) {
            if (floatPredicate2.testFloats(primitiveFloatIterator.next().floatValue(), primitiveFloatIterator2.next().floatValue())) continue;
            return false;
        }
        return !primitiveFloatIterator.hasNext() && !primitiveFloatIterator2.hasNext();
    }

    public static boolean equal(@NotNull FloatIndexable floatIndexable, @Nullable Object object) {
        if (object instanceof FloatIndexable) {
            return FloatIndexable.equal(floatIndexable, (FloatIndexable)object);
        }
        return false;
    }

    public static int compare(@NotNull FloatIndexable floatIndexable, @NotNull FloatIndexable floatIndexable2) {
        PrimitiveFloatIterator primitiveFloatIterator = floatIndexable.floatIterator();
        PrimitiveFloatIterator primitiveFloatIterator2 = floatIndexable2.floatIterator();
        while (primitiveFloatIterator.hasNext() && primitiveFloatIterator2.hasNext()) {
            int n = Float.compare(primitiveFloatIterator.nextFloat(), primitiveFloatIterator2.nextFloat());
            if (n == 0) continue;
            return n;
        }
        if (primitiveFloatIterator.hasNext()) {
            return 1;
        }
        if (primitiveFloatIterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int hash(@NotNull FloatIndexable floatIndexable) {
        int n = 1;
        PrimitiveFloatIterator primitiveFloatIterator = floatIndexable.floatIterator();
        while (primitiveFloatIterator.hasNext()) {
            n = 31 * n + Primitives.hash(primitiveFloatIterator.next().floatValue());
        }
        return n;
    }

    @NotNull
    public static Base withCachedHash(final @NotNull FloatIndexable floatIndexable) {
        final int n = FloatIndexable.hash(floatIndexable);
        return new Base(){

            @Override
            public int size() {
                return floatIndexable.size();
            }

            @Override
            public float get(int n2) {
                return floatIndexable.get(n2);
            }

            @Override
            @NotNull
            public PrimitiveFloatIterator floatIterator() {
                return floatIndexable.floatIterator();
            }

            @Override
            @NotNull
            public PrimitiveFloatIterator floatIterator(int n3, int n2) {
                return floatIndexable.floatIterator(n3, n2);
            }

            @Override
            @NotNull
            public Iterator<Float> iterator() {
                return floatIndexable.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Float> listIterator() {
                return floatIndexable.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n2) {
                return floatIndexable.subSet(n3, n2);
            }

            @Override
            public int addToArray(@NotNull float[] fArray, int n2) {
                return floatIndexable.addToArray(fArray, n2);
            }

            @Override
            public int addToArray(@NotNull float[] fArray, int n4, int n2, int n3) {
                return floatIndexable.addToArray(fArray, n4, n2, n3);
            }

            @Override
            public int hashCode() {
                return n;
            }

            @Override
            public boolean equals(Object object) {
                return FloatIndexable.equal(floatIndexable, object);
            }

            @Override
            public String toString() {
                return FloatIndexable.toString(floatIndexable);
            }
        };
    }

    default public int nextMatch(int n, @NotNull FloatPredicate1 floatPredicate1) {
        int n2 = this.size();
        for (int i = Pythonesque.mapX(n, this); i < n2; ++i) {
            if (!floatPredicate1.testFloat(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int firstMatch(@NotNull FloatPredicate1 floatPredicate1) {
        return this.nextMatch(0, floatPredicate1);
    }

    default public int previousMatch(int n, @NotNull FloatPredicate1 floatPredicate1) {
        for (int i = Pythonesque.mapX(n, this); i >= 0; --i) {
            if (!floatPredicate1.testFloat(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int lastMatch(@NotNull FloatPredicate1 floatPredicate1) {
        return this.previousMatch(-1, floatPredicate1);
    }

    @NotNull
    default public FloatIndexable frozen() {
        return IndexableHelper.frozenFromArray(this.toArray());
    }

    default public boolean isOrdered(@NotNull FloatOrdering floatOrdering) {
        if (this.size() < 2) {
            return true;
        }
        float f = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            float f2 = this.get(i);
            if (floatOrdering.checkFloat(f2, f) == Order.Descending) {
                return false;
            }
            f = f2;
        }
        return true;
    }

    default public boolean isStrictlyOrdered(@NotNull FloatOrdering floatOrdering) {
        if (this.size() < 2) {
            return true;
        }
        float f = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            float f2 = this.get(i);
            if (floatOrdering.checkFloat(f2, f) != Order.Ascending) {
                return false;
            }
            f = f2;
        }
        return true;
    }

    default public int binarySearch(float f) {
        int n = 0;
        int n2 = this.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            float f2 = this.get(n3);
            if (f2 < f) {
                n = n3 + 1;
                continue;
            }
            if (f2 > f) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    default public int binarySearch(float f, @NotNull FloatOrdering floatOrdering) {
        int n = 0;
        int n2 = this.size() - 1;
        block4: while (n <= n2) {
            int n3 = n + n2 >>> 1;
            float f2 = this.get(n3);
            switch (floatOrdering.checkFloat(f2, f)) {
                case Ascending: {
                    n = n3 + 1;
                    continue block4;
                }
                case Descending: {
                    n2 = n3 - 1;
                    continue block4;
                }
            }
            return n3;
        }
        return -(n + 1);
    }

    @NotNull
    default public MutableFloatIndexable ordered(@NotNull FloatOrdering floatOrdering) {
        MutableFloatIndexable.Base base = MutableFloatIndexable.fromFloatIndexable(this);
        base.order(floatOrdering);
        return base;
    }

    @NotNull
    default public MutableFloatIndexable ordered() {
        MutableFloatIndexable.Base base = MutableFloatIndexable.fromFloatIndexable(this);
        base.order();
        return base;
    }

    @NotNull
    default public Base asBase() {
        return new Base(){

            @Override
            public int size() {
                return FloatIndexable.this.size();
            }

            @Override
            public float get(int n) {
                return FloatIndexable.this.get(n);
            }

            @Override
            @NotNull
            public Base reverse() {
                return FloatIndexable.this.reverse();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfDouble doubleIterator() {
                return FloatIndexable.this.doubleIterator();
            }

            @Override
            @NotNull
            public PrimitiveFloatIterator floatIterator() {
                return FloatIndexable.this.floatIterator();
            }

            @Override
            @NotNull
            public PrimitiveFloatIterator floatIterator(int n, int n2) {
                return FloatIndexable.this.floatIterator(n, n2);
            }

            @Override
            @NotNull
            public Iterator<Float> iterator() {
                return FloatIndexable.this.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Float> listIterator() {
                return FloatIndexable.this.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return FloatIndexable.based(FloatIndexable.this.subSet(n, n2));
            }

            @Override
            @NotNull
            public float[] toArray() {
                return FloatIndexable.this.toArray();
            }

            @Override
            public int addToArray(@NotNull float[] fArray, int n) {
                return FloatIndexable.this.addToArray(fArray, n);
            }

            @Override
            public int addToArray(@NotNull float[] fArray, int n, int n2, int n3) {
                return FloatIndexable.this.addToArray(fArray, n, n2, n3);
            }

            @Override
            @NotNull
            public DoubleIndexable.Base asDoubleIndexable() {
                return FloatIndexable.this.asDoubleIndexable();
            }

            @Override
            public float foldLeft(float f, @NotNull FloatOperator2 floatOperator2) {
                return f;
            }
        };
    }

    @NotNull
    public static Base based(final @NotNull FloatIndexable floatIndexable) {
        if (floatIndexable instanceof Base) {
            return (Base)floatIndexable;
        }
        return new Base(){

            @Override
            public int size() {
                return floatIndexable.size();
            }

            @Override
            public float get(int n) {
                return floatIndexable.get(n);
            }

            @Override
            @NotNull
            public Base reverse() {
                return floatIndexable.reverse();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfDouble doubleIterator() {
                return floatIndexable.doubleIterator();
            }

            @Override
            @NotNull
            public PrimitiveFloatIterator floatIterator() {
                return floatIndexable.floatIterator();
            }

            @Override
            @NotNull
            public PrimitiveFloatIterator floatIterator(int n, int n2) {
                return floatIndexable.floatIterator(n, n2);
            }

            @Override
            @NotNull
            public Iterator<Float> iterator() {
                return floatIndexable.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Float> listIterator() {
                return floatIndexable.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return FloatIndexable.based(floatIndexable.subSet(n, n2));
            }

            @Override
            @NotNull
            public float[] toArray() {
                return floatIndexable.toArray();
            }

            @Override
            public int addToArray(@NotNull float[] fArray, int n) {
                return floatIndexable.addToArray(fArray, n);
            }

            @Override
            public int addToArray(@NotNull float[] fArray, int n, int n2, int n3) {
                return floatIndexable.addToArray(fArray, n, n2, n3);
            }

            @Override
            @NotNull
            public DoubleIndexable.Base asDoubleIndexable() {
                return floatIndexable.asDoubleIndexable();
            }

            @Override
            public float foldLeft(float f, @NotNull FloatOperator2 floatOperator2) {
                return f;
            }
        };
    }

    public static abstract class Base
    implements FloatIndexable,
    Comparable<FloatIndexable> {
        @Override
        public int compareTo(@NotNull FloatIndexable floatIndexable) {
            Objects.requireNonNull(floatIndexable);
            return FloatIndexable.compare(this, floatIndexable);
        }

        public int hashCode() {
            return FloatIndexable.hash(this);
        }

        public boolean equals(Object object) {
            return FloatIndexable.equal((FloatIndexable)this, object);
        }

        public String toString() {
            return FloatIndexable.toString(this);
        }
    }
}

