/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Predicate;

public class FilteringIteratorWrapper<T>
implements Iterator<T> {
    @NotNull
    private final Iterator<T> iterator;
    @NotNull
    private final Predicate<? super T> filter;
    private T nextElement;
    private boolean hasNext = false;

    public FilteringIteratorWrapper(@NotNull Iterator<T> iterator, @NotNull Predicate<? super T> predicate) {
        this.iterator = iterator;
        this.filter = predicate;
        this.forward();
    }

    private void forward() {
        while (this.iterator.hasNext()) {
            this.nextElement = this.iterator.next();
            if (!this.filter.test(this.nextElement)) continue;
            this.hasNext = true;
            return;
        }
        this.hasNext = false;
        this.nextElement = null;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public T next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        try {
            T t = this.nextElement;
            return t;
        }
        finally {
            this.forward();
        }
    }
}

