/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.FStack;
import java.util.EmptyStackException;

class FStackImpl<T>
implements FStack<T> {
    static FStack<Object> EMPTY = new FStack<Object>(){

        @Override
        public Object top() {
            throw new EmptyStackException();
        }

        @Override
        @NotNull
        public FStack<Object> push(Object object) {
            return new FStackImpl<Object>(object, this);
        }

        @Override
        @NotNull
        public FStack<Object> pop() {
            throw new EmptyStackException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }
    };
    private final T element;
    @NotNull
    private final FStack<T> tail;

    FStackImpl(T t, @NotNull FStack<T> fStack) {
        this.element = t;
        this.tail = fStack;
    }

    @Override
    public T top() {
        return this.element;
    }

    @Override
    @NotNull
    public FStack<T> push(T t) {
        return new FStackImpl<T>(t, this);
    }

    @Override
    @NotNull
    public FStack<T> pop() {
        return this.tail;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return 1 + this.tail.size();
    }
}

