/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.Copier;
import de.caff.generics.CopierFStackImpl;
import de.caff.generics.Copyable;
import de.caff.generics.FStackImpl;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.NoSuchElementException;

public interface FStack<T>
extends Iterable<T> {
    public T top();

    @NotNull
    public FStack<T> push(T var1);

    @NotNull
    default public FStack<T> pushAll(@NotNull Iterable<? extends T> iterable) {
        FStack<T> fStack = this;
        for (T t : iterable) {
            fStack = fStack.push(t);
        }
        return fStack;
    }

    @NotNull
    default public FStack<T> reversePushAll(@NotNull Iterable<? extends T> iterable) {
        FStack fStack = FStack.empty();
        for (T t : iterable) {
            fStack.push(t);
        }
        return this.pushAll(fStack);
    }

    @NotNull
    public FStack<T> pop();

    public boolean isEmpty();

    public int size();

    @Override
    @NotNull
    default public Iterator<T> iterator() {
        return new Iterator<T>(){
            private FStack<T> remaining;
            {
                this.remaining = FStack.this;
            }

            @Override
            public boolean hasNext() {
                return !this.remaining.isEmpty();
            }

            @Override
            public T next() {
                try {
                    Object t = this.remaining.top();
                    this.remaining = this.remaining.pop();
                    return t;
                }
                catch (EmptyStackException emptyStackException) {
                    throw new NoSuchElementException();
                }
            }
        };
    }

    @NotNull
    public static <E> FStack<E> empty() {
        return FStackImpl.EMPTY;
    }

    @NotNull
    public static <E> FStack<E> empty(@NotNull Copier<E> copier) {
        return new CopierFStackImpl.Empty<E>(copier);
    }

    @NotNull
    public static <E extends Copyable<E>> FStack<E> emptyCopyable() {
        return FStack.empty(Copyable::getCopy);
    }

    @NotNull
    public static <E> FStack<E> from(@NotNull Iterable<E> iterable) {
        return FStack.empty().pushAll(iterable);
    }

    @NotNull
    public static <E> FStack<E> from(@NotNull Copier<E> copier, @NotNull Iterable<E> iterable) {
        return FStack.empty(copier).pushAll(iterable);
    }

    @NotNull
    public static <E extends Copyable<E>> FStack<E> fromCopyable(@NotNull Iterable<E> iterable) {
        return FStack.emptyCopyable().pushAll(iterable);
    }

    @NotNull
    public static <E> FStack<E> reverseFrom(@NotNull Iterable<E> iterable) {
        return FStack.empty().reversePushAll(iterable);
    }

    @NotNull
    public static <E> FStack<E> reverseFrom(@NotNull Copier<E> copier, @NotNull Iterable<E> iterable) {
        return FStack.empty(copier).reversePushAll(iterable);
    }

    @NotNull
    public static <E extends Copyable<E>> FStack<E> reverseFromCopyable(@NotNull Iterable<E> iterable) {
        return FStack.emptyCopyable().reversePushAll(iterable);
    }
}

