/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Empty;
import de.caff.generics.ExpandableLongIndexable;
import de.caff.generics.LongIndexable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

class ExpandableLongIndexableImpl {
    static final int PART_SIZE = 64;
    static final int LARGE_SIZE_LIMIT = 0x1FFFFFF;
    private static ExpandableLongIndexableNode EMPTY = new ExpandableLongIndexableNode(){

        @Override
        @NotNull
        public ExpandableLongIndexableNode add(int n, long l) {
            if (n != 0) {
                throw new IndexOutOfBoundsException("Cannot add outside range [0,0] but index is " + n + "!");
            }
            return new Leaf(l);
        }

        @Override
        public ExpandableLongIndexableNode tryAdd(int n, long l) {
            return this.add(n, l);
        }

        @Override
        @NotNull
        public ExpandableLongIndexableNode remove(int n) {
            throw new IndexOutOfBoundsException("No element to remove in empty indexable!");
        }

        @Override
        @NotNull
        public ExpandableLongIndexable getCopy() {
            return this;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public long get(int n) {
            throw new IndexOutOfBoundsException("No element to get in empty indexable!");
        }

        @Override
        public int getWeight() {
            return 0;
        }

        @Override
        public int depth() {
            return 1;
        }

        @Override
        public int addToArray(@NotNull long[] lArray, int n) {
            return n;
        }

        @Override
        public int addToArray(@NotNull long[] lArray, int n, int n2, int n3) {
            return n;
        }

        @Override
        @NotNull
        public long[] toArray() {
            return Empty.LONG_ARRAY;
        }

        @Override
        public boolean isFilled() {
            return false;
        }

        @Override
        public long getCapacity() {
            return 64L;
        }

        public String toString() {
            return "[]";
        }
    };

    ExpandableLongIndexableImpl() {
    }

    public static int size(@NotNull LongIndexable[] longIndexableArray) {
        int n = 0;
        for (LongIndexable longIndexable : longIndexableArray) {
            n += longIndexable.size();
        }
        return n;
    }

    @NotNull
    static ExpandableLongIndexableNode from(long[] lArray, int n, int n2) {
        int n3;
        if (n2 <= 64) {
            return new Leaf(lArray, n, n2);
        }
        int n4 = 4096;
        int n5 = 64;
        while (n4 < n2) {
            n5 = n4;
            n4 = Integer.MAX_VALUE / n5 < 64 ? n5 * 64 : Integer.MAX_VALUE;
        }
        ExpandableLongIndexableNode[] expandableLongIndexableNodeArray = new ExpandableLongIndexableNode[(n2 + n5 - 1) / n5];
        int n6 = 0;
        int n7 = n2 - n5;
        for (n3 = 0; n3 < n7 && n3 >= 0; n3 += n5) {
            expandableLongIndexableNodeArray[n6++] = ExpandableLongIndexableImpl.from(lArray, n + n3, n5);
        }
        expandableLongIndexableNodeArray[n6] = ExpandableLongIndexableImpl.from(lArray, n + n3, n2 - n3);
        return new Node(expandableLongIndexableNodeArray);
    }

    @NotNull
    static ExpandableLongIndexableNode from(long ... lArray) {
        int n = lArray.length;
        if (n == 0) {
            return EMPTY;
        }
        if (n <= 64) {
            return new Leaf(lArray);
        }
        return ExpandableLongIndexableImpl.from(lArray, 0, n);
    }

    @NotNull
    static ExpandableLongIndexableNode from(@NotNull LongIndexable longIndexable) {
        int n;
        if (longIndexable.isEmpty()) {
            return EMPTY;
        }
        int n2 = longIndexable.size();
        if (n2 <= 64) {
            return new Leaf(longIndexable.toArray());
        }
        int n3 = 4096;
        int n4 = 64;
        while (n3 < n2) {
            n4 = n3;
            n3 = Integer.MAX_VALUE / n4 < 64 ? n4 * 64 : Integer.MAX_VALUE;
        }
        ExpandableLongIndexableNode[] expandableLongIndexableNodeArray = new ExpandableLongIndexableNode[(n2 + n4 - 1) / n4];
        int n5 = 0;
        int n6 = n2 - n4;
        for (n = 0; n >= 0 && n < n6; n += n4) {
            expandableLongIndexableNodeArray[n5++] = ExpandableLongIndexableImpl.from(longIndexable.subSet(n, n + n4));
        }
        expandableLongIndexableNodeArray[n5] = ExpandableLongIndexableImpl.from(longIndexable.tailSet(n));
        return new Node(expandableLongIndexableNodeArray);
    }

    private static class Node
    extends ExpandableLongIndexableNode {
        private final int numValues;
        private final long capacity;
        @NotNull
        private final SubNode[] subNodes;

        public Node(ExpandableLongIndexableNode ... expandableLongIndexableNodeArray) {
            this.subNodes = new SubNode[expandableLongIndexableNodeArray.length];
            long l = 64L;
            int n = 0;
            int n2 = 0;
            for (ExpandableLongIndexableNode expandableLongIndexableNode : expandableLongIndexableNodeArray) {
                this.subNodes[n++] = new SubNode(n2, expandableLongIndexableNode);
                n2 += expandableLongIndexableNode.size();
                l = Math.max(l, expandableLongIndexableNode.getCapacity());
            }
            this.numValues = n2;
            this.capacity = 64L * l;
        }

        @Override
        @NotNull
        public ExpandableLongIndexableNode add(int n, final long l) {
            ExpandableLongIndexableNode expandableLongIndexableNode;
            if (this.numValues == Integer.MAX_VALUE) {
                throw new RuntimeException("Size is becoming too large for 32bit integer!");
            }
            if (n < 0 || n > this.numValues) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.numValues));
            }
            ExpandableLongIndexableNode expandableLongIndexableNode2 = this.tryAdd(n, l);
            if (expandableLongIndexableNode2 != null) {
                return expandableLongIndexableNode2;
            }
            if (n == this.numValues) {
                return new Node(this, new Leaf(l));
            }
            if (this.subNodes.length == 64 && this.numValues <= 0x1FFFFFF && (long)this.numValues < this.capacity / 64L) {
                return this.recreateWithInsertedValue(n, l);
            }
            int n2 = this.subNodeIndex(n);
            SubNode subNode = this.subNodes[n2];
            int n3 = n - subNode.offset;
            ExpandableLongIndexableNode expandableLongIndexableNode3 = ExpandableLongIndexableImpl.from(subNode.sub.headSet(n3));
            final LongIndexable.Base base = subNode.sub.tailSet(n3);
            final int n4 = base.size() + 1;
            ExpandableLongIndexableNode expandableLongIndexableNode4 = ExpandableLongIndexableImpl.from(new LongIndexable.Base(){

                @Override
                public int size() {
                    return n4;
                }

                @Override
                public long get(int n) {
                    return n == 0 ? l : base.get(n - 1);
                }

                @Override
                public int addToArray(@NotNull long[] lArray, int n, int n2, int n3) {
                    if (n2 == 0) {
                        lArray[n++] = l;
                    }
                    if (n3 > 1) {
                        n += base.addToArray(lArray, n, 0, n3 - 1);
                    }
                    return n;
                }
            });
            ExpandableLongIndexableNode[] expandableLongIndexableNodeArray = new ExpandableLongIndexableNode[this.subNodes.length];
            for (int i = 0; i < n2; ++i) {
                expandableLongIndexableNodeArray[i] = this.subNodes[i].sub;
            }
            expandableLongIndexableNodeArray[n2] = expandableLongIndexableNode3;
            if (n2 == this.subNodes.length - 1) {
                expandableLongIndexableNode = expandableLongIndexableNode4;
            } else {
                expandableLongIndexableNode = this.subNodes[this.subNodes.length - 1].sub;
                expandableLongIndexableNodeArray[n2 + 1] = expandableLongIndexableNode4;
                for (int i = n2 + 2; i < this.subNodes.length; ++i) {
                    expandableLongIndexableNodeArray[i] = this.subNodes[i - 1].sub;
                }
            }
            return new Node(new Node(expandableLongIndexableNodeArray), new Node(expandableLongIndexableNode));
        }

        @Override
        public ExpandableLongIndexableNode tryAdd(int n, long l) {
            SubNode subNode;
            int n2 = this.subNodeIndex(n);
            SubNode subNode2 = this.subNodes[n2];
            ExpandableLongIndexableNode expandableLongIndexableNode = subNode2.sub.tryAdd(n - subNode2.offset, l);
            if (expandableLongIndexableNode != null) {
                return this.withExchangedSubNode(n2, expandableLongIndexableNode);
            }
            if (n == subNode2.getEndIndex() && n2 < this.subNodes.length - 1 && (expandableLongIndexableNode = (subNode = this.subNodes[n2 + 1]).sub.tryAdd(n - subNode.offset, l)) != null) {
                return this.withExchangedSubNode(n2 + 1, expandableLongIndexableNode);
            }
            if (n == subNode2.offset && n2 > 0 && (expandableLongIndexableNode = (subNode = this.subNodes[n2 - 1]).sub.tryAdd(n - subNode.offset, l)) != null) {
                return this.withExchangedSubNode(n2 - 1, expandableLongIndexableNode);
            }
            if (n == this.size()) {
                if (this.subNodes.length == 64) {
                    return null;
                }
                return this.withInsertedSubNode(this.subNodes.length, new Leaf(l));
            }
            if (this.isFilled()) {
                return null;
            }
            return this.recreateWithInsertedValue(n, l);
        }

        @NotNull
        private ExpandableLongIndexableNode recreateWithInsertedValue(final int n, final long l) {
            final int n2 = this.numValues + 1;
            return ExpandableLongIndexableImpl.from(new LongIndexable.Base(){

                @Override
                public int size() {
                    return n2;
                }

                @Override
                public long get(int n3) {
                    if (n3 < n) {
                        return this.get(n3);
                    }
                    if (n3 > n) {
                        return this.get(n3 - 1);
                    }
                    return l;
                }

                @Override
                public int addToArray(@NotNull long[] lArray, int n6, int n22, int n3) {
                    int n4 = n22 + n3;
                    if (n22 < n) {
                        int n5 = Math.min(n3, n - n22);
                        n6 = this.addToArray(lArray, n6, n22, n5);
                        n3 -= n5;
                    }
                    if (n22 <= n && n4 > n) {
                        lArray[n6++] = l;
                        --n3;
                    }
                    if (n4 > n + 1) {
                        n6 = this.addToArray(lArray, n6, n, n3);
                    }
                    return n6;
                }
            });
        }

        @NotNull
        private ExpandableLongIndexableNode withExchangedSubNode(int n, @NotNull ExpandableLongIndexableNode expandableLongIndexableNode) {
            int n2;
            ExpandableLongIndexableNode[] expandableLongIndexableNodeArray = new ExpandableLongIndexableNode[this.subNodes.length];
            for (n2 = 0; n2 < n; ++n2) {
                expandableLongIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            expandableLongIndexableNodeArray[n] = expandableLongIndexableNode;
            for (n2 = n + 1; n2 < expandableLongIndexableNodeArray.length; ++n2) {
                expandableLongIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            return new Node(expandableLongIndexableNodeArray);
        }

        @NotNull
        private ExpandableLongIndexableNode withInsertedSubNode(int n, @NotNull ExpandableLongIndexableNode expandableLongIndexableNode) {
            int n2;
            ExpandableLongIndexableNode[] expandableLongIndexableNodeArray = new ExpandableLongIndexableNode[this.subNodes.length + 1];
            for (n2 = 0; n2 < n; ++n2) {
                expandableLongIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            expandableLongIndexableNodeArray[n] = expandableLongIndexableNode;
            for (n2 = n + 1; n2 < expandableLongIndexableNodeArray.length; ++n2) {
                expandableLongIndexableNodeArray[n2] = this.subNodes[n2 - 1].sub;
            }
            return new Node(expandableLongIndexableNodeArray);
        }

        private int subNodeIndex(int n) {
            if (n == this.numValues) {
                return this.subNodes.length - 1;
            }
            int n2 = 0;
            int n3 = this.subNodes.length;
            while (n3 > n2 - 1) {
                int n4 = (n3 + n2) / 2;
                SubNode subNode = this.subNodes[n4];
                if (n < subNode.offset) {
                    n3 = n4;
                    continue;
                }
                if (n >= subNode.offset + subNode.sub.size()) {
                    n2 = n4 + 1;
                    continue;
                }
                return n4;
            }
            return n2;
        }

        @Override
        @NotNull
        public ExpandableLongIndexableNode remove(int n) {
            int n2;
            if (n < 0 || n >= this.numValues) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.numValues));
            }
            int n3 = this.subNodeIndex(n);
            SubNode subNode = this.subNodes[n3];
            ExpandableLongIndexableNode expandableLongIndexableNode = subNode.sub.remove(n - subNode.offset);
            if (expandableLongIndexableNode.isEmpty()) {
                int n4;
                if (this.subNodes.length == 1) {
                    return EMPTY;
                }
                ExpandableLongIndexableNode[] expandableLongIndexableNodeArray = new ExpandableLongIndexableNode[this.subNodes.length - 1];
                for (n4 = 0; n4 < n3; ++n4) {
                    expandableLongIndexableNodeArray[n4] = this.subNodes[n4].sub;
                }
                for (n4 = n3; n4 < expandableLongIndexableNodeArray.length; ++n4) {
                    expandableLongIndexableNodeArray[n4] = this.subNodes[n4 + 1].sub;
                }
                return new Node(expandableLongIndexableNodeArray);
            }
            ExpandableLongIndexableNode[] expandableLongIndexableNodeArray = new ExpandableLongIndexableNode[this.subNodes.length];
            for (n2 = 0; n2 < n3; ++n2) {
                expandableLongIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            expandableLongIndexableNodeArray[n3] = expandableLongIndexableNode;
            for (n2 = n3 + 1; n2 < expandableLongIndexableNodeArray.length; ++n2) {
                expandableLongIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            return new Node(expandableLongIndexableNodeArray);
        }

        @Override
        @NotNull
        public ExpandableLongIndexable getCopy() {
            return this;
        }

        @Override
        public int size() {
            return this.numValues;
        }

        @Override
        public int getWeight() {
            return this.subNodes.length;
        }

        @Override
        public int depth() {
            int n = 0;
            for (SubNode subNode : this.subNodes) {
                n = Math.max(n, subNode.sub.depth());
            }
            return n + 1;
        }

        @Override
        public long get(int n) {
            if (n < 0 || n >= this.numValues) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d[!", n, this.numValues));
            }
            SubNode subNode = this.subNodes[this.subNodeIndex(n)];
            return subNode.sub.get(n - subNode.offset);
        }

        @Override
        @NotNull
        public Iterator<Long> iterator() {
            return this.longIterator();
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfLong longIterator(int n, int n2) {
            Object object;
            if (this.subNodes.length == 1) {
                return this.subNodes[0].sub.longIterator(n, n2);
            }
            int n3 = this.subNodeIndex(n);
            int n4 = this.subNodeIndex(n2);
            SubNode subNode = this.subNodes[n3];
            if (n3 == n4) {
                return subNode.sub.longIterator(n - subNode.offset, n2 - subNode.offset);
            }
            ArrayList<PrimitiveIterator.OfLong> arrayList = new ArrayList<PrimitiveIterator.OfLong>(n4 - n3 + 1);
            arrayList.add(subNode.sub.longIterator(n - subNode.offset, subNode.sub.size()));
            for (int i = n3 + 1; i < n4; ++i) {
                object = this.subNodes[i];
                arrayList.add(((SubNode)object).sub.longIterator());
            }
            SubNode subNode2 = this.subNodes[n4];
            arrayList.add(subNode2.sub.longIterator(0, n2 - subNode2.offset));
            object = arrayList.iterator();
            return new PrimitiveIterator.OfLong((Iterator)object){
                private PrimitiveIterator.OfLong longIterator;
                final /* synthetic */ Iterator val$longIteratorIterator;
                {
                    this.val$longIteratorIterator = iterator;
                    this.longIterator = this.val$longIteratorIterator.hasNext() ? (PrimitiveIterator.OfLong)this.val$longIteratorIterator.next() : null;
                }

                @Override
                public long nextLong() {
                    if (this.longIterator == null) {
                        throw new NoSuchElementException("Cannot iterate past the end!");
                    }
                    long l = this.longIterator.nextLong();
                    while (!this.longIterator.hasNext()) {
                        if (this.val$longIteratorIterator.hasNext()) {
                            this.longIterator = (PrimitiveIterator.OfLong)this.val$longIteratorIterator.next();
                            continue;
                        }
                        this.longIterator = null;
                        break;
                    }
                    return l;
                }

                @Override
                public boolean hasNext() {
                    return this.longIterator != null;
                }
            };
        }

        @Override
        public int addToArray(@NotNull long[] lArray, int n) {
            for (SubNode subNode : this.subNodes) {
                n = subNode.sub.addToArray(lArray, n);
            }
            return n;
        }

        @Override
        public int addToArray(@NotNull long[] lArray, int n, int n2, int n3) {
            int n4;
            int n5 = n2;
            int n6 = n2 + n3;
            int n7 = this.subNodeIndex(n5);
            if (n7 == (n4 = this.subNodeIndex(n6))) {
                SubNode subNode = this.subNodes[n7];
                return subNode.sub.addToArray(lArray, n, n2 - subNode.offset, n3);
            }
            SubNode subNode = this.subNodes[n7];
            int n8 = n2 - subNode.offset;
            n = subNode.sub.addToArray(lArray, n, n8, subNode.sub.size() - n8);
            for (int i = n7 + 1; i < n4; ++i) {
                SubNode subNode2 = this.subNodes[i];
                n = subNode2.sub.addToArray(lArray, n);
            }
            SubNode subNode3 = this.subNodes[n4];
            return subNode3.sub.addToArray(lArray, n, 0, n6 - subNode3.offset);
        }

        @Override
        public boolean isFilled() {
            if (this.subNodes.length < 64) {
                return true;
            }
            for (SubNode subNode : this.subNodes) {
                if (subNode.sub.isFilled()) continue;
                return false;
            }
            return true;
        }

        @Override
        public long getCapacity() {
            return this.capacity;
        }

        public String toString() {
            return LongIndexable.toString(this);
        }
    }

    private static class SubNode {
        private final int offset;
        @NotNull
        private final ExpandableLongIndexableNode sub;

        public SubNode(int n, @NotNull ExpandableLongIndexableNode expandableLongIndexableNode) {
            this.offset = n;
            this.sub = expandableLongIndexableNode;
        }

        public int getEndIndex() {
            return this.offset + this.sub.size();
        }
    }

    private static class Leaf
    extends ExpandableLongIndexableNode {
        @NotNull
        private final long[] values;

        public Leaf(long ... lArray) {
            this.values = lArray;
        }

        public Leaf(@NotNull long[] lArray, int n, int n2) {
            this.values = Arrays.copyOfRange(lArray, n, n + n2);
        }

        public Leaf(long l, @NotNull long[] lArray, int n, int n2) {
            this.values = new long[n2 + 1];
            this.values[0] = l;
            System.arraycopy(lArray, n, this.values, 1, n2);
        }

        @Override
        @NotNull
        public ExpandableLongIndexableNode add(int n, long l) {
            if (n < 0 || n > this.values.length) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.values.length));
            }
            if (this.values.length == 64) {
                if (n == 64) {
                    return new Node(this, new Leaf(l));
                }
                return new Node(new Leaf(this.values, 0, n), new Leaf(l, this.values, n, this.values.length - n));
            }
            long[] lArray = new long[this.values.length + 1];
            if (n > 0) {
                System.arraycopy(this.values, 0, lArray, 0, n);
            }
            lArray[n] = l;
            if (n < this.values.length) {
                System.arraycopy(this.values, n, lArray, n + 1, this.values.length - n);
            }
            return new Leaf(lArray);
        }

        @Override
        public ExpandableLongIndexableNode tryAdd(int n, long l) {
            return this.values.length < 64 ? this.add(n, l) : null;
        }

        @Override
        @NotNull
        public ExpandableLongIndexableNode remove(int n) {
            int n2 = this.values.length;
            if (n < 0 || n >= n2) {
                throw new IndexOutOfBoundsException(String.format("Index %d out of range [0,%d[!", n, this.values.length));
            }
            if (n2 == 1) {
                return EMPTY;
            }
            if (n == n2 - 1) {
                return new Leaf(Arrays.copyOf(this.values, n2 - 1));
            }
            long[] lArray = new long[n2 - 1];
            if (n > 0) {
                System.arraycopy(this.values, 0, lArray, 0, n);
            }
            if (n < n2 - 1) {
                System.arraycopy(this.values, n + 1, lArray, n, n2 - n - 1);
            }
            return new Leaf(lArray);
        }

        @Override
        @NotNull
        public ExpandableLongIndexable getCopy() {
            return this;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public int getWeight() {
            return this.values.length;
        }

        @Override
        public int depth() {
            return 1;
        }

        @Override
        public long get(int n) {
            if (n < 0 || n >= this.values.length) {
                throw new IndexOutOfBoundsException(String.format("Index %d out of range [0,%d[!", n, this.values.length));
            }
            return this.values[n];
        }

        @Override
        public int addToArray(@NotNull long[] lArray, int n) {
            System.arraycopy(this.values, 0, lArray, n, this.values.length);
            return n + this.values.length;
        }

        @Override
        public int addToArray(@NotNull long[] lArray, int n, int n2, int n3) {
            System.arraycopy(this.values, n2, lArray, n, n3);
            return n + n3;
        }

        @Override
        @NotNull
        public long[] toArray() {
            return (long[])this.values.clone();
        }

        @Override
        public boolean isFilled() {
            return this.values.length == 64;
        }

        @Override
        public long getCapacity() {
            return 64L;
        }

        public String toString() {
            return LongIndexable.toString(this);
        }
    }

    private static abstract class ExpandableLongIndexableNode
    implements ExpandableLongIndexable {
        private ExpandableLongIndexableNode() {
        }

        public abstract long getCapacity();

        public abstract int getWeight();

        @Nullable
        public abstract ExpandableLongIndexableNode tryAdd(int var1, long var2);

        @Override
        @NotNull
        public abstract ExpandableLongIndexableNode add(int var1, long var2);

        @Override
        @NotNull
        public abstract ExpandableLongIndexableNode remove(int var1);

        public abstract int depth();

        public abstract boolean isFilled();

        @Override
        public abstract int addToArray(@NotNull long[] var1, int var2, int var3, int var4);
    }
}

