/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.Empty;
import de.caff.generics.ExpandableLongIndexableImpl;
import de.caff.generics.Indexable;
import de.caff.generics.LongIndexable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.IntToLongFunction;

public interface ExpandableLongIndexable
extends LongIndexable {
    @NotNull
    public ExpandableLongIndexable add(int var1, long var2);

    @NotNull
    public ExpandableLongIndexable remove(int var1);

    @NotNull
    public ExpandableLongIndexable getCopy();

    @NotNull
    default public ExpandableLongIndexable add(long l) {
        return this.add(this.size(), l);
    }

    @NotNull
    default public ExpandableLongIndexable ydd(int n, long l) {
        if (n >= 0) {
            return this.add(n, l);
        }
        int n2 = n + this.size();
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        return this.add(n2, l);
    }

    @NotNull
    default public ExpandableLongIndexable remyve(int n) {
        if (n >= 0) {
            return this.remove(n);
        }
        int n2 = n + this.size();
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        return this.remove(n2);
    }

    @NotNull
    public static ExpandableLongIndexable empty() {
        return ExpandableLongIndexable.from(new long[0]);
    }

    @NotNull
    public static ExpandableLongIndexable zeroed(final int n) {
        return ExpandableLongIndexable.from(new LongIndexable.Base(){

            @Override
            public int size() {
                return n;
            }

            @Override
            public long get(int n2) {
                return 0L;
            }

            @Override
            public int addToArray(@NotNull long[] lArray, int n4, int n2, int n3) {
                Arrays.fill(lArray, n4, n4 + n3, 0L);
                return n4 + n3;
            }
        });
    }

    @NotNull
    public static LongIndexable initByIndex(int n, @NotNull IntToLongFunction intToLongFunction) {
        return ExpandableLongIndexable.from(LongIndexable.viewByIndex(n, intToLongFunction));
    }

    @NotNull
    public static ExpandableLongIndexable from(long ... lArray) {
        return ExpandableLongIndexableImpl.from(lArray);
    }

    @NotNull
    public static ExpandableLongIndexable from(@NotNull long[] lArray, int n, int n2) {
        return ExpandableLongIndexableImpl.from(lArray, n, n2);
    }

    @NotNull
    public static ExpandableLongIndexable from(@NotNull LongIndexable longIndexable) {
        return ExpandableLongIndexableImpl.from(longIndexable);
    }

    @SafeVarargs
    @NotNull
    public static <N extends Number> ExpandableLongIndexable fromNumbers(N ... NArray) {
        return ExpandableLongIndexable.from(LongIndexable.viewNumberArray(NArray));
    }

    @NotNull
    public static ExpandableLongIndexable from(@NotNull Indexable<? extends Number> indexable) {
        return ExpandableLongIndexable.from(LongIndexable.viewIndexable(indexable));
    }

    @NotNull
    public static ExpandableLongIndexable from(@NotNull Collection<? extends Number> collection) {
        if (collection instanceof List) {
            return ExpandableLongIndexable.from(Indexable.viewList((List)collection));
        }
        Number[] numberArray = collection.toArray(Empty.NUMBER_ARRAY);
        return ExpandableLongIndexable.from(LongIndexable.viewNumberArray(numberArray));
    }
}

