/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Empty;
import de.caff.generics.ExpandableIntIndexable;
import de.caff.generics.IntIndexable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

class ExpandableIntIndexableImpl {
    static final int PART_SIZE = 64;
    static final int LARGE_SIZE_LIMIT = 0x1FFFFFF;
    private static ExpandableIntIndexableNode EMPTY = new ExpandableIntIndexableNode(){

        @Override
        @NotNull
        public ExpandableIntIndexableNode add(int n, int n2) {
            if (n != 0) {
                throw new IndexOutOfBoundsException("Cannot add outside range [0,0] but index is " + n + "!");
            }
            return new Leaf(n2);
        }

        @Override
        public ExpandableIntIndexableNode tryAdd(int n, int n2) {
            return this.add(n, n2);
        }

        @Override
        @NotNull
        public ExpandableIntIndexableNode remove(int n) {
            throw new IndexOutOfBoundsException("No element to remove in empty indexable!");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int get(int n) {
            throw new IndexOutOfBoundsException("No element to get in empty indexable!");
        }

        @Override
        public int getWeight() {
            return 0;
        }

        @Override
        public int depth() {
            return 1;
        }

        @Override
        public int addToArray(@NotNull int[] nArray, int n) {
            return n;
        }

        @Override
        public int addToArray(@NotNull int[] nArray, int n, int n2, int n3) {
            return n;
        }

        @Override
        @NotNull
        public int[] toArray() {
            return Empty.INT_ARRAY;
        }

        @Override
        public boolean isFilled() {
            return false;
        }

        @Override
        public long getCapacity() {
            return 64L;
        }

        @Override
        public String toString() {
            return "[]";
        }
    };

    ExpandableIntIndexableImpl() {
    }

    public static int size(@NotNull IntIndexable[] intIndexableArray) {
        int n = 0;
        for (IntIndexable intIndexable : intIndexableArray) {
            n += intIndexable.size();
        }
        return n;
    }

    @NotNull
    static ExpandableIntIndexableNode from(int[] nArray, int n, int n2) {
        int n3;
        if (n2 <= 64) {
            return new Leaf(nArray, n, n2);
        }
        int n4 = 4096;
        int n5 = 64;
        while (n4 < n2) {
            n5 = n4;
            n4 = Integer.MAX_VALUE / n5 < 64 ? n5 * 64 : Integer.MAX_VALUE;
        }
        ExpandableIntIndexableNode[] expandableIntIndexableNodeArray = new ExpandableIntIndexableNode[(n2 + n5 - 1) / n5];
        int n6 = 0;
        int n7 = n2 - n5;
        for (n3 = 0; n3 < n7 && n3 >= 0; n3 += n5) {
            expandableIntIndexableNodeArray[n6++] = ExpandableIntIndexableImpl.from(nArray, n + n3, n5);
        }
        expandableIntIndexableNodeArray[n6] = ExpandableIntIndexableImpl.from(nArray, n + n3, n2 - n3);
        return new Node(expandableIntIndexableNodeArray);
    }

    @NotNull
    static ExpandableIntIndexableNode from(int ... nArray) {
        int n = nArray.length;
        if (n == 0) {
            return EMPTY;
        }
        if (n <= 64) {
            return new Leaf(nArray);
        }
        return ExpandableIntIndexableImpl.from(nArray, 0, n);
    }

    @NotNull
    static ExpandableIntIndexableNode from(@NotNull IntIndexable intIndexable) {
        int n;
        if (intIndexable.isEmpty()) {
            return EMPTY;
        }
        int n2 = intIndexable.size();
        if (n2 <= 64) {
            return new Leaf(intIndexable.toArray());
        }
        int n3 = 4096;
        int n4 = 64;
        while (n3 < n2) {
            n4 = n3;
            n3 = Integer.MAX_VALUE / n4 < 64 ? n4 * 64 : Integer.MAX_VALUE;
        }
        ExpandableIntIndexableNode[] expandableIntIndexableNodeArray = new ExpandableIntIndexableNode[(n2 + n4 - 1) / n4];
        int n5 = 0;
        int n6 = n2 - n4;
        for (n = 0; n >= 0 && n < n6; n += n4) {
            expandableIntIndexableNodeArray[n5++] = ExpandableIntIndexableImpl.from(intIndexable.subSet(n, n + n4));
        }
        expandableIntIndexableNodeArray[n5] = ExpandableIntIndexableImpl.from(intIndexable.tailSet(n));
        return new Node(expandableIntIndexableNodeArray);
    }

    private static class Node
    extends ExpandableIntIndexableNode {
        private final int numValues;
        private final long capacity;
        @NotNull
        private final SubNode[] subNodes;

        public Node(ExpandableIntIndexableNode ... expandableIntIndexableNodeArray) {
            this.subNodes = new SubNode[expandableIntIndexableNodeArray.length];
            long l = 64L;
            int n = 0;
            int n2 = 0;
            for (ExpandableIntIndexableNode expandableIntIndexableNode : expandableIntIndexableNodeArray) {
                this.subNodes[n++] = new SubNode(n2, expandableIntIndexableNode);
                n2 += expandableIntIndexableNode.size();
                l = Math.max(l, expandableIntIndexableNode.getCapacity());
            }
            this.numValues = n2;
            this.capacity = 64L * l;
        }

        @Override
        @NotNull
        public ExpandableIntIndexableNode add(int n, final int n2) {
            ExpandableIntIndexableNode expandableIntIndexableNode;
            if (this.numValues == Integer.MAX_VALUE) {
                throw new RuntimeException("Size is becoming too large for 32bit integer!");
            }
            if (n < 0 || n > this.numValues) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.numValues));
            }
            ExpandableIntIndexableNode expandableIntIndexableNode2 = this.tryAdd(n, n2);
            if (expandableIntIndexableNode2 != null) {
                return expandableIntIndexableNode2;
            }
            if (n == this.numValues) {
                return new Node(this, new Leaf(n2));
            }
            if (this.subNodes.length == 64 && this.numValues <= 0x1FFFFFF && (long)this.numValues < this.capacity / 64L) {
                return this.recreateWithInsertedValue(n, n2);
            }
            int n3 = this.subNodeIndex(n);
            SubNode subNode = this.subNodes[n3];
            int n4 = n - subNode.offset;
            ExpandableIntIndexableNode expandableIntIndexableNode3 = ExpandableIntIndexableImpl.from(subNode.sub.headSet(n4));
            final IntIndexable.Base base = subNode.sub.tailSet(n4);
            final int n5 = base.size() + 1;
            ExpandableIntIndexableNode expandableIntIndexableNode4 = ExpandableIntIndexableImpl.from(new IntIndexable.Base(){

                @Override
                public int size() {
                    return n5;
                }

                @Override
                public int get(int n) {
                    return n == 0 ? n2 : base.get(n - 1);
                }

                @Override
                public int addToArray(@NotNull int[] nArray, int n, int n22, int n3) {
                    if (n22 == 0) {
                        nArray[n++] = n2;
                    }
                    if (n3 > 1) {
                        n += base.addToArray(nArray, n, 0, n3 - 1);
                    }
                    return n;
                }
            });
            ExpandableIntIndexableNode[] expandableIntIndexableNodeArray = new ExpandableIntIndexableNode[this.subNodes.length];
            for (int i = 0; i < n3; ++i) {
                expandableIntIndexableNodeArray[i] = this.subNodes[i].sub;
            }
            expandableIntIndexableNodeArray[n3] = expandableIntIndexableNode3;
            if (n3 == this.subNodes.length - 1) {
                expandableIntIndexableNode = expandableIntIndexableNode4;
            } else {
                expandableIntIndexableNode = this.subNodes[this.subNodes.length - 1].sub;
                expandableIntIndexableNodeArray[n3 + 1] = expandableIntIndexableNode4;
                for (int i = n3 + 2; i < this.subNodes.length; ++i) {
                    expandableIntIndexableNodeArray[i] = this.subNodes[i - 1].sub;
                }
            }
            return new Node(new Node(expandableIntIndexableNodeArray), new Node(expandableIntIndexableNode));
        }

        @Override
        public ExpandableIntIndexableNode tryAdd(int n, int n2) {
            SubNode subNode;
            int n3 = this.subNodeIndex(n);
            SubNode subNode2 = this.subNodes[n3];
            ExpandableIntIndexableNode expandableIntIndexableNode = subNode2.sub.tryAdd(n - subNode2.offset, n2);
            if (expandableIntIndexableNode != null) {
                return this.withExchangedSubNode(n3, expandableIntIndexableNode);
            }
            if (n == subNode2.getEndIndex() && n3 < this.subNodes.length - 1 && (expandableIntIndexableNode = (subNode = this.subNodes[n3 + 1]).sub.tryAdd(n - subNode.offset, n2)) != null) {
                return this.withExchangedSubNode(n3 + 1, expandableIntIndexableNode);
            }
            if (n == subNode2.offset && n3 > 0 && (expandableIntIndexableNode = (subNode = this.subNodes[n3 - 1]).sub.tryAdd(n - subNode.offset, n2)) != null) {
                return this.withExchangedSubNode(n3 - 1, expandableIntIndexableNode);
            }
            if (n == this.size()) {
                if (this.subNodes.length == 64) {
                    return null;
                }
                return this.withInsertedSubNode(this.subNodes.length, new Leaf(n2));
            }
            if (this.isFilled()) {
                return null;
            }
            return this.recreateWithInsertedValue(n, n2);
        }

        @NotNull
        private ExpandableIntIndexableNode recreateWithInsertedValue(final int n, final int n2) {
            final int n3 = this.numValues + 1;
            return ExpandableIntIndexableImpl.from(new IntIndexable.Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public int get(int n4) {
                    if (n4 < n) {
                        return this.get(n4);
                    }
                    if (n4 > n) {
                        return this.get(n4 - 1);
                    }
                    return n2;
                }

                @Override
                public int addToArray(@NotNull int[] nArray, int n6, int n22, int n32) {
                    int n4 = n22 + n32;
                    if (n22 < n) {
                        int n5 = Math.min(n32, n - n22);
                        n6 = this.addToArray(nArray, n6, n22, n5);
                        n32 -= n5;
                    }
                    if (n22 <= n && n4 > n) {
                        nArray[n6++] = n2;
                        --n32;
                    }
                    if (n4 > n + 1) {
                        n6 = this.addToArray(nArray, n6, n, n32);
                    }
                    return n6;
                }
            });
        }

        @NotNull
        private ExpandableIntIndexableNode withExchangedSubNode(int n, @NotNull ExpandableIntIndexableNode expandableIntIndexableNode) {
            int n2;
            ExpandableIntIndexableNode[] expandableIntIndexableNodeArray = new ExpandableIntIndexableNode[this.subNodes.length];
            for (n2 = 0; n2 < n; ++n2) {
                expandableIntIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            expandableIntIndexableNodeArray[n] = expandableIntIndexableNode;
            for (n2 = n + 1; n2 < expandableIntIndexableNodeArray.length; ++n2) {
                expandableIntIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            return new Node(expandableIntIndexableNodeArray);
        }

        @NotNull
        private ExpandableIntIndexableNode withInsertedSubNode(int n, @NotNull ExpandableIntIndexableNode expandableIntIndexableNode) {
            int n2;
            ExpandableIntIndexableNode[] expandableIntIndexableNodeArray = new ExpandableIntIndexableNode[this.subNodes.length + 1];
            for (n2 = 0; n2 < n; ++n2) {
                expandableIntIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            expandableIntIndexableNodeArray[n] = expandableIntIndexableNode;
            for (n2 = n + 1; n2 < expandableIntIndexableNodeArray.length; ++n2) {
                expandableIntIndexableNodeArray[n2] = this.subNodes[n2 - 1].sub;
            }
            return new Node(expandableIntIndexableNodeArray);
        }

        private int subNodeIndex(int n) {
            if (n == this.numValues) {
                return this.subNodes.length - 1;
            }
            int n2 = 0;
            int n3 = this.subNodes.length;
            while (n3 > n2 - 1) {
                int n4 = (n3 + n2) / 2;
                SubNode subNode = this.subNodes[n4];
                if (n < subNode.offset) {
                    n3 = n4;
                    continue;
                }
                if (n >= subNode.offset + subNode.sub.size()) {
                    n2 = n4 + 1;
                    continue;
                }
                return n4;
            }
            return n2;
        }

        @Override
        @NotNull
        public ExpandableIntIndexableNode remove(int n) {
            int n2;
            if (n < 0 || n >= this.numValues) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.numValues));
            }
            int n3 = this.subNodeIndex(n);
            SubNode subNode = this.subNodes[n3];
            ExpandableIntIndexableNode expandableIntIndexableNode = subNode.sub.remove(n - subNode.offset);
            if (expandableIntIndexableNode.isEmpty()) {
                int n4;
                if (this.subNodes.length == 1) {
                    return EMPTY;
                }
                ExpandableIntIndexableNode[] expandableIntIndexableNodeArray = new ExpandableIntIndexableNode[this.subNodes.length - 1];
                for (n4 = 0; n4 < n3; ++n4) {
                    expandableIntIndexableNodeArray[n4] = this.subNodes[n4].sub;
                }
                for (n4 = n3; n4 < expandableIntIndexableNodeArray.length; ++n4) {
                    expandableIntIndexableNodeArray[n4] = this.subNodes[n4 + 1].sub;
                }
                return new Node(expandableIntIndexableNodeArray);
            }
            ExpandableIntIndexableNode[] expandableIntIndexableNodeArray = new ExpandableIntIndexableNode[this.subNodes.length];
            for (n2 = 0; n2 < n3; ++n2) {
                expandableIntIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            expandableIntIndexableNodeArray[n3] = expandableIntIndexableNode;
            for (n2 = n3 + 1; n2 < expandableIntIndexableNodeArray.length; ++n2) {
                expandableIntIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            return new Node(expandableIntIndexableNodeArray);
        }

        @Override
        public int size() {
            return this.numValues;
        }

        @Override
        public int getWeight() {
            return this.subNodes.length;
        }

        @Override
        public int depth() {
            int n = 0;
            for (SubNode subNode : this.subNodes) {
                n = Math.max(n, subNode.sub.depth());
            }
            return n + 1;
        }

        @Override
        public int get(int n) {
            if (n < 0 || n >= this.numValues) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d[!", n, this.numValues));
            }
            SubNode subNode = this.subNodes[this.subNodeIndex(n)];
            return subNode.sub.get(n - subNode.offset);
        }

        @Override
        @NotNull
        public Iterator<Integer> iterator() {
            return this.intIterator();
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfInt intIterator(int n, int n2) {
            Object object;
            if (this.subNodes.length == 1) {
                return this.subNodes[0].sub.intIterator(n, n2);
            }
            int n3 = this.subNodeIndex(n);
            int n4 = this.subNodeIndex(n2);
            SubNode subNode = this.subNodes[n3];
            if (n3 == n4) {
                return subNode.sub.intIterator(n - subNode.offset, n2 - subNode.offset);
            }
            ArrayList<PrimitiveIterator.OfInt> arrayList = new ArrayList<PrimitiveIterator.OfInt>(n4 - n3 + 1);
            arrayList.add(subNode.sub.intIterator(n - subNode.offset, subNode.sub.size()));
            for (int i = n3 + 1; i < n4; ++i) {
                object = this.subNodes[i];
                arrayList.add(((SubNode)object).sub.intIterator());
            }
            SubNode subNode2 = this.subNodes[n4];
            arrayList.add(subNode2.sub.intIterator(0, n2 - subNode2.offset));
            object = arrayList.iterator();
            return new PrimitiveIterator.OfInt((Iterator)object){
                private PrimitiveIterator.OfInt intIterator;
                final /* synthetic */ Iterator val$intIteratorIterator;
                {
                    this.val$intIteratorIterator = iterator;
                    this.intIterator = this.val$intIteratorIterator.hasNext() ? (PrimitiveIterator.OfInt)this.val$intIteratorIterator.next() : null;
                }

                @Override
                public int nextInt() {
                    if (this.intIterator == null) {
                        throw new NoSuchElementException("Cannot iterate past the end!");
                    }
                    int n = this.intIterator.nextInt();
                    while (!this.intIterator.hasNext()) {
                        if (this.val$intIteratorIterator.hasNext()) {
                            this.intIterator = (PrimitiveIterator.OfInt)this.val$intIteratorIterator.next();
                            continue;
                        }
                        this.intIterator = null;
                        break;
                    }
                    return n;
                }

                @Override
                public boolean hasNext() {
                    return this.intIterator != null;
                }
            };
        }

        @Override
        public int addToArray(@NotNull int[] nArray, int n) {
            for (SubNode subNode : this.subNodes) {
                n = subNode.sub.addToArray(nArray, n);
            }
            return n;
        }

        @Override
        public int addToArray(@NotNull int[] nArray, int n, int n2, int n3) {
            int n4;
            int n5 = n2;
            int n6 = n2 + n3;
            int n7 = this.subNodeIndex(n5);
            if (n7 == (n4 = this.subNodeIndex(n6))) {
                SubNode subNode = this.subNodes[n7];
                return subNode.sub.addToArray(nArray, n, n2 - subNode.offset, n3);
            }
            SubNode subNode = this.subNodes[n7];
            int n8 = n2 - subNode.offset;
            n = subNode.sub.addToArray(nArray, n, n8, subNode.sub.size() - n8);
            for (int i = n7 + 1; i < n4; ++i) {
                SubNode subNode2 = this.subNodes[i];
                n = subNode2.sub.addToArray(nArray, n);
            }
            SubNode subNode3 = this.subNodes[n4];
            return subNode3.sub.addToArray(nArray, n, 0, n6 - subNode3.offset);
        }

        @Override
        public boolean isFilled() {
            if (this.subNodes.length < 64) {
                return true;
            }
            for (SubNode subNode : this.subNodes) {
                if (subNode.sub.isFilled()) continue;
                return false;
            }
            return true;
        }

        @Override
        public long getCapacity() {
            return this.capacity;
        }

        @Override
        public String toString() {
            return IntIndexable.toString(this);
        }
    }

    private static class SubNode {
        private final int offset;
        @NotNull
        private final ExpandableIntIndexableNode sub;

        public SubNode(int n, @NotNull ExpandableIntIndexableNode expandableIntIndexableNode) {
            this.offset = n;
            this.sub = expandableIntIndexableNode;
        }

        public int getEndIndex() {
            return this.offset + this.sub.size();
        }
    }

    private static class Leaf
    extends ExpandableIntIndexableNode {
        @NotNull
        private final int[] values;

        public Leaf(int ... nArray) {
            this.values = nArray;
        }

        public Leaf(@NotNull int[] nArray, int n, int n2) {
            this.values = Arrays.copyOfRange(nArray, n, n + n2);
        }

        public Leaf(int n, @NotNull int[] nArray, int n2, int n3) {
            this.values = new int[n3 + 1];
            this.values[0] = n;
            System.arraycopy(nArray, n2, this.values, 1, n3);
        }

        @Override
        @NotNull
        public ExpandableIntIndexableNode add(int n, int n2) {
            if (n < 0 || n > this.values.length) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.values.length));
            }
            if (this.values.length == 64) {
                if (n == 64) {
                    return new Node(this, new Leaf(n2));
                }
                return new Node(new Leaf(this.values, 0, n), new Leaf(n2, this.values, n, this.values.length - n));
            }
            int[] nArray = new int[this.values.length + 1];
            if (n > 0) {
                System.arraycopy(this.values, 0, nArray, 0, n);
            }
            nArray[n] = n2;
            if (n < this.values.length) {
                System.arraycopy(this.values, n, nArray, n + 1, this.values.length - n);
            }
            return new Leaf(nArray);
        }

        @Override
        public ExpandableIntIndexableNode tryAdd(int n, int n2) {
            return this.values.length < 64 ? this.add(n, n2) : null;
        }

        @Override
        @NotNull
        public ExpandableIntIndexableNode remove(int n) {
            int n2 = this.values.length;
            if (n < 0 || n >= n2) {
                throw new IndexOutOfBoundsException(String.format("Index %d out of range [0,%d[!", n, this.values.length));
            }
            if (n2 == 1) {
                return EMPTY;
            }
            if (n == n2 - 1) {
                return new Leaf(Arrays.copyOf(this.values, n2 - 1));
            }
            int[] nArray = new int[n2 - 1];
            if (n > 0) {
                System.arraycopy(this.values, 0, nArray, 0, n);
            }
            if (n < n2 - 1) {
                System.arraycopy(this.values, n + 1, nArray, n, n2 - n - 1);
            }
            return new Leaf(nArray);
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public int getWeight() {
            return this.values.length;
        }

        @Override
        public int depth() {
            return 1;
        }

        @Override
        public int get(int n) {
            if (n < 0 || n >= this.values.length) {
                throw new IndexOutOfBoundsException(String.format("Index %d out of range [0,%d[!", n, this.values.length));
            }
            return this.values[n];
        }

        @Override
        public int addToArray(@NotNull int[] nArray, int n) {
            System.arraycopy(this.values, 0, nArray, n, this.values.length);
            return n + this.values.length;
        }

        @Override
        public int addToArray(@NotNull int[] nArray, int n, int n2, int n3) {
            System.arraycopy(this.values, n2, nArray, n, n3);
            return n + n3;
        }

        @Override
        @NotNull
        public int[] toArray() {
            return (int[])this.values.clone();
        }

        @Override
        public boolean isFilled() {
            return this.values.length == 64;
        }

        @Override
        public long getCapacity() {
            return 64L;
        }

        @Override
        public String toString() {
            return IntIndexable.toString(this);
        }
    }

    private static abstract class ExpandableIntIndexableNode
    extends IntIndexable.Base
    implements ExpandableIntIndexable {
        private ExpandableIntIndexableNode() {
        }

        public abstract long getCapacity();

        public abstract int getWeight();

        @Nullable
        public abstract ExpandableIntIndexableNode tryAdd(int var1, int var2);

        @Override
        @NotNull
        public abstract ExpandableIntIndexableNode add(int var1, int var2);

        @Override
        @NotNull
        public abstract ExpandableIntIndexableNode remove(int var1);

        public abstract int depth();

        public abstract boolean isFilled();

        @Override
        public abstract int addToArray(@NotNull int[] var1, int var2, int var3, int var4);
    }
}

