/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.Empty;
import de.caff.generics.ExpandableIntIndexableImpl;
import de.caff.generics.Indexable;
import de.caff.generics.IntIndexable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.IntUnaryOperator;

public interface ExpandableIntIndexable
extends IntIndexable {
    @NotNull
    public ExpandableIntIndexable add(int var1, int var2);

    @NotNull
    public ExpandableIntIndexable remove(int var1);

    @NotNull
    default public ExpandableIntIndexable add(int n) {
        return this.add(this.size(), n);
    }

    @NotNull
    default public ExpandableIntIndexable addAll(int ... nArray) {
        ExpandableIntIndexable expandableIntIndexable = this;
        for (int n : nArray) {
            expandableIntIndexable = expandableIntIndexable.add(n);
        }
        return expandableIntIndexable;
    }

    @NotNull
    default public ExpandableIntIndexable ydd(int n, int n2) {
        if (n >= 0) {
            return this.add(n, n2);
        }
        int n3 = n + this.size();
        if (n3 < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        return this.add(n3, n2);
    }

    @NotNull
    default public ExpandableIntIndexable remyve(int n) {
        if (n >= 0) {
            return this.remove(n);
        }
        int n2 = n + this.size();
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        return this.remove(n2);
    }

    @NotNull
    public static ExpandableIntIndexable empty() {
        return ExpandableIntIndexable.from(new int[0]);
    }

    @NotNull
    public static ExpandableIntIndexable zeroed(final int n) {
        return ExpandableIntIndexable.from(new IntIndexable.Base(){

            @Override
            public int size() {
                return n;
            }

            @Override
            public int get(int n2) {
                return 0;
            }

            @Override
            public int addToArray(@NotNull int[] nArray, int n4, int n2, int n3) {
                Arrays.fill(nArray, n4, n4 + n3, 0);
                return n4 + n3;
            }
        });
    }

    @NotNull
    public static IntIndexable initByIndex(int n, @NotNull IntUnaryOperator intUnaryOperator) {
        return ExpandableIntIndexable.from(IntIndexable.viewByIndex(n, intUnaryOperator));
    }

    @NotNull
    public static ExpandableIntIndexable from(int ... nArray) {
        return ExpandableIntIndexableImpl.from(nArray);
    }

    @NotNull
    public static ExpandableIntIndexable from(@NotNull int[] nArray, int n, int n2) {
        return ExpandableIntIndexableImpl.from(nArray, n, n2);
    }

    @NotNull
    public static ExpandableIntIndexable from(@NotNull IntIndexable intIndexable) {
        return ExpandableIntIndexableImpl.from(intIndexable);
    }

    @SafeVarargs
    @NotNull
    public static <N extends Number> ExpandableIntIndexable fromNumbers(N ... NArray) {
        return ExpandableIntIndexable.from(IntIndexable.viewNumberArray(NArray));
    }

    @NotNull
    public static ExpandableIntIndexable from(@NotNull Indexable<? extends Number> indexable) {
        return ExpandableIntIndexable.from(IntIndexable.viewIndexable(indexable));
    }

    @NotNull
    public static ExpandableIntIndexable from(@NotNull Collection<? extends Number> collection) {
        if (collection instanceof List) {
            return ExpandableIntIndexable.from(Indexable.viewList((List)collection));
        }
        Number[] numberArray = collection.toArray(Empty.NUMBER_ARRAY);
        return ExpandableIntIndexable.from(IntIndexable.viewNumberArray(numberArray));
    }
}

