/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Countable;
import de.caff.generics.Empty;
import de.caff.generics.ExpandableIndexable;
import de.caff.generics.Indexable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;

class ExpandableIndexableImpl {
    static final int PART_SIZE = 64;
    static final int LARGE_SIZE_LIMIT = 0x1FFFFFF;
    private static ExpandableIndexableNode<Object> EMPTY = new ExpandableIndexableNode<Object>(){

        @Override
        @NotNull
        public ExpandableIndexableNode<Object> add(int n, Object object) {
            if (n != 0) {
                throw new IndexOutOfBoundsException("Cannot add outside range [0,0] but index is " + n + "!");
            }
            return new Leaf<Object>(object);
        }

        @Override
        @Nullable
        public ExpandableIndexableNode<Object> tryAdd(int n, Object object) {
            return this.add(n, object);
        }

        @Override
        @NotNull
        public ExpandableIndexableNode<Object> remove(int n) {
            throw new IndexOutOfBoundsException("No element to remove in empty indexable!");
        }

        @Override
        @NotNull
        public ExpandableIndexableNode<Object> set(int n, Object object) {
            throw new IndexOutOfBoundsException("No element to set in empty indexable!");
        }

        @Override
        @NotNull
        public ExpandableIndexable<Object> syt(int n, Object object) {
            throw new IndexOutOfBoundsException("No element to set in empty indexable!");
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Object get(int n) {
            throw new IndexOutOfBoundsException("No element to get in empty indexable!");
        }

        @Override
        public int getWeight() {
            return 0;
        }

        @Override
        public int depth() {
            return 1;
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return Empty.OBJECT_ARRAY;
        }

        @Override
        public int addToArray(@NotNull Object[] objectArray, int n, int n2, int n3) {
            return n;
        }

        @Override
        public boolean isFilled() {
            return false;
        }

        @Override
        public long getCapacity() {
            return 64L;
        }

        @Override
        public String toString() {
            return "[]";
        }
    };

    ExpandableIndexableImpl() {
    }

    public static int size(@NotNull Indexable<?>[] indexableArray) {
        int n = 0;
        for (Indexable<?> indexable : indexableArray) {
            n += indexable.size();
        }
        return n;
    }

    @NotNull
    private static <E> ExpandableIndexableNode<E> empty() {
        return EMPTY;
    }

    @NotNull
    static <E> ExpandableIndexableNode<E> fromArray(E[] EArray, int n, int n2) {
        int n3;
        if (n2 <= 64) {
            return new Leaf<E>(EArray, n, n2);
        }
        int n4 = 4096;
        int n5 = 64;
        while (n4 < n2) {
            n5 = n4;
            n4 = Integer.MAX_VALUE / n5 < 64 ? n5 * 64 : Integer.MAX_VALUE;
        }
        ExpandableIndexableNode[] expandableIndexableNodeArray = new ExpandableIndexableNode[(n2 + n5 - 1) / n5];
        int n6 = 0;
        int n7 = n2 - n5;
        for (n3 = 0; n3 < n7 && n3 >= 0; n3 += n5) {
            expandableIndexableNodeArray[n6++] = ExpandableIndexableImpl.fromArray(EArray, n + n3, n5);
        }
        expandableIndexableNodeArray[n6] = ExpandableIndexableImpl.fromArray(EArray, n + n3, n2 - n3);
        return new Node(expandableIndexableNodeArray);
    }

    @SafeVarargs
    @NotNull
    static <E> ExpandableIndexableNode<E> fromArray(E ... EArray) {
        int n = EArray.length;
        if (n == 0) {
            return ExpandableIndexableImpl.empty();
        }
        if (n <= 64) {
            return new Leaf<E>(EArray);
        }
        return ExpandableIndexableImpl.fromArray(EArray, 0, n);
    }

    @NotNull
    static <E> ExpandableIndexableNode<E> fromIndexable(@NotNull Indexable<? extends E> indexable) {
        int n;
        if (indexable.isEmpty()) {
            return ExpandableIndexableImpl.empty();
        }
        if (indexable instanceof ExpandableIndexableNode) {
            return (ExpandableIndexableNode)indexable;
        }
        int n2 = indexable.size();
        if (n2 <= 64) {
            return new Leaf<Object>(indexable.toArray());
        }
        int n3 = 4096;
        int n4 = 64;
        while (n3 < n2) {
            n4 = n3;
            n3 = Integer.MAX_VALUE / n4 < 64 ? n4 * 64 : Integer.MAX_VALUE;
        }
        ExpandableIndexableNode[] expandableIndexableNodeArray = new ExpandableIndexableNode[(n2 + n4 - 1) / n4];
        int n5 = 0;
        int n6 = n2 - n4;
        for (n = 0; n >= 0 && n < n6; n += n4) {
            expandableIndexableNodeArray[n5++] = ExpandableIndexableImpl.fromIndexable(indexable.subSet(n, n + n4));
        }
        expandableIndexableNodeArray[n5] = ExpandableIndexableImpl.fromIndexable(indexable.tailSet(n));
        return new Node(expandableIndexableNodeArray);
    }

    private static class Node<T>
    extends ExpandableIndexableNode<T> {
        private final int numValues;
        private final long capacity;
        @NotNull
        private final SubNode<?>[] subNodes;

        public Node(ExpandableIndexableNode<T> ... expandableIndexableNodeArray) {
            this.subNodes = new SubNode[expandableIndexableNodeArray.length];
            long l = 64L;
            int n = 0;
            int n2 = 0;
            for (ExpandableIndexableNode<T> expandableIndexableNode : expandableIndexableNodeArray) {
                this.subNodes[n++] = new SubNode<T>(n2, expandableIndexableNode);
                n2 += expandableIndexableNode.size();
                l = Math.max(l, expandableIndexableNode.getCapacity());
            }
            this.numValues = n2;
            this.capacity = 64L * l;
        }

        @Override
        @NotNull
        public ExpandableIndexableNode<T> add(int n, final T t) {
            ExpandableIndexableNode expandableIndexableNode;
            if (this.numValues == Integer.MAX_VALUE) {
                throw new RuntimeException("Size is becoming too large for 32bit integer!");
            }
            if (n < 0 || n > this.numValues) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.numValues));
            }
            ExpandableIndexableNode<T> expandableIndexableNode2 = this.tryAdd(n, t);
            if (expandableIndexableNode2 != null) {
                return expandableIndexableNode2;
            }
            if (n == this.numValues) {
                return new Node<T>(this, new Leaf<Object>(t));
            }
            if (this.subNodes.length == 64 && this.numValues <= 0x1FFFFFF && (long)this.numValues < this.capacity / 64L) {
                return this.recreateWithInsertedValue(n, t);
            }
            int n2 = this.subNodeIndex(n);
            SubNode<?> subNode = this.subNodes[n2];
            int n3 = n - ((SubNode)subNode).offset;
            ExpandableIndexableNode expandableIndexableNode3 = ExpandableIndexableImpl.fromIndexable(((SubNode)subNode).sub.headSet(n3));
            final Indexable indexable = ((SubNode)subNode).sub.tailSet(n3);
            final int n4 = indexable.size() + 1;
            ExpandableIndexableNode expandableIndexableNode4 = ExpandableIndexableImpl.fromIndexable(new Indexable.Base<T>(){

                @Override
                public int size() {
                    return n4;
                }

                @Override
                public T get(int n) {
                    return n == 0 ? t : indexable.get(n - 1);
                }

                @Override
                public int addToArray(@NotNull T[] TArray, int n, int n2, int n3) {
                    if (n2 == 0) {
                        TArray[n++] = t;
                    }
                    if (n3 > 1) {
                        n += indexable.addToArray(TArray, n, 0, n3 - 1);
                    }
                    return n;
                }
            });
            ExpandableIndexableNode[] expandableIndexableNodeArray = new ExpandableIndexableNode[this.subNodes.length];
            for (int i = 0; i < n2; ++i) {
                expandableIndexableNodeArray[i] = ((SubNode)this.subNodes[i]).sub;
            }
            expandableIndexableNodeArray[n2] = expandableIndexableNode3;
            if (n2 == this.subNodes.length - 1) {
                expandableIndexableNode = expandableIndexableNode4;
            } else {
                expandableIndexableNode = ((SubNode)this.subNodes[this.subNodes.length - 1]).sub;
                expandableIndexableNodeArray[n2 + 1] = expandableIndexableNode4;
                for (int i = n2 + 2; i < this.subNodes.length; ++i) {
                    expandableIndexableNodeArray[i] = ((SubNode)this.subNodes[i - 1]).sub;
                }
            }
            return new Node<T>(new Node<T>(expandableIndexableNodeArray), new Node<T>(expandableIndexableNode));
        }

        @Override
        public ExpandableIndexableNode<T> tryAdd(int n, T t) {
            SubNode<?> subNode;
            int n2 = this.subNodeIndex(n);
            SubNode<?> subNode2 = this.subNodes[n2];
            ExpandableIndexableNode<T> expandableIndexableNode = ((SubNode)subNode2).sub.tryAdd(n - ((SubNode)subNode2).offset, t);
            if (expandableIndexableNode != null) {
                return this.withExchangedSubNode(n2, expandableIndexableNode);
            }
            if (n == subNode2.getEndIndex() && n2 < this.subNodes.length - 1 && (expandableIndexableNode = ((SubNode)(subNode = this.subNodes[n2 + 1])).sub.tryAdd(n - ((SubNode)subNode).offset, t)) != null) {
                return this.withExchangedSubNode(n2 + 1, expandableIndexableNode);
            }
            if (n == ((SubNode)subNode2).offset && n2 > 0 && (expandableIndexableNode = ((SubNode)(subNode = this.subNodes[n2 - 1])).sub.tryAdd(n - ((SubNode)subNode).offset, t)) != null) {
                return this.withExchangedSubNode(n2 - 1, expandableIndexableNode);
            }
            if (n == this.size()) {
                if (this.subNodes.length == 64) {
                    return null;
                }
                return this.withInsertedSubNode(this.subNodes.length, new Leaf<Object>(t));
            }
            if (this.isFilled()) {
                return null;
            }
            return this.recreateWithInsertedValue(n, t);
        }

        @Override
        @NotNull
        public ExpandableIndexableNode<T> set(int n, T t) {
            if (n < 0 || n >= this.numValues) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.numValues));
            }
            int n2 = this.subNodeIndex(n);
            SubNode<?> subNode = this.subNodes[n2];
            int n3 = n - ((SubNode)subNode).offset;
            ExpandableIndexable expandableIndexable = ((SubNode)subNode).sub.set(n3, (Object)t);
            return this.withExchangedSubNode(n2, (ExpandableIndexableNode<T>)expandableIndexable);
        }

        @NotNull
        private ExpandableIndexableNode<T> recreateWithInsertedValue(final int n, final T t) {
            final int n2 = this.numValues + 1;
            return ExpandableIndexableImpl.fromIndexable(new Indexable.Base<T>(){

                @Override
                public int size() {
                    return n2;
                }

                @Override
                public T get(int n3) {
                    if (n3 < n) {
                        return this.get(n3);
                    }
                    if (n3 > n) {
                        return this.get(n3 - 1);
                    }
                    return t;
                }

                @Override
                public int addToArray(@NotNull T[] TArray, int n6, int n22, int n3) {
                    int n4 = n22 + n3;
                    if (n22 < n) {
                        int n5 = Math.min(n3, n - n22);
                        n6 = this.addToArray(TArray, n6, n22, n5);
                        n3 -= n5;
                    }
                    if (n22 <= n && n4 > n) {
                        TArray[n6++] = t;
                        --n3;
                    }
                    if (n4 > n + 1) {
                        n6 = this.addToArray(TArray, n6, n, n3);
                    }
                    return n6;
                }
            });
        }

        @NotNull
        private ExpandableIndexableNode<T> withExchangedSubNode(int n, @NotNull ExpandableIndexableNode<T> expandableIndexableNode) {
            int n2;
            ExpandableIndexableNode[] expandableIndexableNodeArray = new ExpandableIndexableNode[this.subNodes.length];
            for (n2 = 0; n2 < n; ++n2) {
                expandableIndexableNodeArray[n2] = ((SubNode)this.subNodes[n2]).sub;
            }
            expandableIndexableNodeArray[n] = expandableIndexableNode;
            for (n2 = n + 1; n2 < expandableIndexableNodeArray.length; ++n2) {
                expandableIndexableNodeArray[n2] = ((SubNode)this.subNodes[n2]).sub;
            }
            return new Node<T>(expandableIndexableNodeArray);
        }

        @NotNull
        private ExpandableIndexableNode<T> withInsertedSubNode(int n, @NotNull ExpandableIndexableNode<T> expandableIndexableNode) {
            int n2;
            ExpandableIndexableNode[] expandableIndexableNodeArray = new ExpandableIndexableNode[this.subNodes.length + 1];
            for (n2 = 0; n2 < n; ++n2) {
                expandableIndexableNodeArray[n2] = ((SubNode)this.subNodes[n2]).sub;
            }
            expandableIndexableNodeArray[n] = expandableIndexableNode;
            for (n2 = n + 1; n2 < expandableIndexableNodeArray.length; ++n2) {
                expandableIndexableNodeArray[n2] = ((SubNode)this.subNodes[n2 - 1]).sub;
            }
            return new Node<T>(expandableIndexableNodeArray);
        }

        private int subNodeIndex(int n) {
            if (n == this.numValues) {
                return this.subNodes.length - 1;
            }
            int n2 = 0;
            int n3 = this.subNodes.length;
            while (n3 > n2 - 1) {
                int n4 = (n3 + n2) / 2;
                SubNode<?> subNode = this.subNodes[n4];
                if (n < ((SubNode)subNode).offset) {
                    n3 = n4;
                    continue;
                }
                if (n >= ((SubNode)subNode).offset + ((SubNode)subNode).sub.size()) {
                    n2 = n4 + 1;
                    continue;
                }
                return n4;
            }
            return n2;
        }

        @Override
        @NotNull
        public ExpandableIndexableNode<T> remove(int n) {
            int n2;
            if (n < 0 || n >= this.numValues) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.numValues));
            }
            int n3 = this.subNodeIndex(n);
            SubNode<?> subNode = this.subNodes[n3];
            ExpandableIndexable expandableIndexable = ((SubNode)subNode).sub.remove(n - ((SubNode)subNode).offset);
            if (expandableIndexable.isEmpty()) {
                int n4;
                if (this.subNodes.length == 1) {
                    return ExpandableIndexableImpl.empty();
                }
                ExpandableIndexableNode[] expandableIndexableNodeArray = new ExpandableIndexableNode[this.subNodes.length - 1];
                for (n4 = 0; n4 < n3; ++n4) {
                    expandableIndexableNodeArray[n4] = ((SubNode)this.subNodes[n4]).sub;
                }
                for (n4 = n3; n4 < expandableIndexableNodeArray.length; ++n4) {
                    expandableIndexableNodeArray[n4] = ((SubNode)this.subNodes[n4 + 1]).sub;
                }
                return new Node<T>(expandableIndexableNodeArray);
            }
            ExpandableIndexableNode[] expandableIndexableNodeArray = new ExpandableIndexableNode[this.subNodes.length];
            for (n2 = 0; n2 < n3; ++n2) {
                expandableIndexableNodeArray[n2] = ((SubNode)this.subNodes[n2]).sub;
            }
            expandableIndexableNodeArray[n3] = expandableIndexable;
            for (n2 = n3 + 1; n2 < expandableIndexableNodeArray.length; ++n2) {
                expandableIndexableNodeArray[n2] = ((SubNode)this.subNodes[n2]).sub;
            }
            return new Node<T>(expandableIndexableNodeArray);
        }

        @Override
        public int size() {
            return this.numValues;
        }

        @Override
        public int getWeight() {
            return this.subNodes.length;
        }

        @Override
        public int depth() {
            int n = 0;
            for (SubNode<?> subNode : this.subNodes) {
                n = Math.max(n, ((SubNode)subNode).sub.depth());
            }
            return n + 1;
        }

        @Override
        public T get(int n) {
            if (n < 0 || n >= this.numValues) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d[!", n, this.numValues));
            }
            SubNode<?> subNode = this.subNodes[this.subNodeIndex(n)];
            return ((SubNode)subNode).sub.get(n - ((SubNode)subNode).offset);
        }

        @Override
        @NotNull
        public Iterator<T> iterator(int n, int n2) {
            Object object;
            if (this.subNodes.length == 1) {
                return ((SubNode)this.subNodes[0]).sub.iterator(n, n2);
            }
            int n3 = this.subNodeIndex(n);
            int n4 = this.subNodeIndex(n2);
            SubNode<?> subNode = this.subNodes[n3];
            if (n3 == n4) {
                return ((SubNode)subNode).sub.iterator(n - ((SubNode)subNode).offset, n2 - ((SubNode)subNode).offset);
            }
            ArrayList arrayList = new ArrayList(n4 - n3 + 1);
            arrayList.add(((SubNode)subNode).sub.iterator(n - ((SubNode)subNode).offset, ((SubNode)subNode).sub.size()));
            for (int i = n3 + 1; i < n4; ++i) {
                object = this.subNodes[i];
                arrayList.add(((SubNode)object).sub.iterator());
            }
            SubNode<?> subNode2 = this.subNodes[n4];
            arrayList.add(((SubNode)subNode2).sub.iterator(0, n2 - ((SubNode)subNode2).offset));
            object = arrayList.iterator();
            return new Iterator<T>((Iterator)object){
                private Iterator<T> subIterator;
                final /* synthetic */ Iterator val$subIteratorIterator;
                {
                    this.val$subIteratorIterator = iterator;
                    this.subIterator = this.val$subIteratorIterator.hasNext() ? (Iterator)this.val$subIteratorIterator.next() : null;
                }

                @Override
                public T next() {
                    if (this.subIterator == null) {
                        throw new NoSuchElementException("Cannot iterate past the end!");
                    }
                    Object t = this.subIterator.next();
                    while (!this.subIterator.hasNext()) {
                        if (this.val$subIteratorIterator.hasNext()) {
                            this.subIterator = (Iterator)this.val$subIteratorIterator.next();
                            continue;
                        }
                        this.subIterator = null;
                        break;
                    }
                    return t;
                }

                @Override
                public boolean hasNext() {
                    return this.subIterator != null;
                }
            };
        }

        @Override
        public int addToArray(@NotNull T[] TArray, int n, int n2, int n3) {
            int n4;
            int n5 = n2;
            int n6 = n2 + n3;
            int n7 = this.subNodeIndex(n5);
            if (n7 == (n4 = this.subNodeIndex(n6))) {
                SubNode<?> subNode = this.subNodes[n7];
                return ((SubNode)subNode).sub.addToArray(TArray, n, n2 - ((SubNode)subNode).offset, n3);
            }
            SubNode<?> subNode = this.subNodes[n7];
            int n8 = n2 - ((SubNode)subNode).offset;
            n = ((SubNode)subNode).sub.addToArray(TArray, n, n8, ((SubNode)subNode).sub.size() - n8);
            for (int i = n7 + 1; i < n4; ++i) {
                SubNode<?> subNode2 = this.subNodes[i];
                n = ((SubNode)subNode2).sub.addToArray(TArray, n);
            }
            SubNode<?> subNode3 = this.subNodes[n4];
            return ((SubNode)subNode3).sub.addToArray(TArray, n, 0, n6 - ((SubNode)subNode3).offset);
        }

        @Override
        public boolean isFilled() {
            if (this.subNodes.length < 64) {
                return true;
            }
            for (SubNode<?> subNode : this.subNodes) {
                if (((SubNode)subNode).sub.isFilled()) continue;
                return false;
            }
            return true;
        }

        @Override
        public long getCapacity() {
            return this.capacity;
        }
    }

    private static class SubNode<T> {
        private final int offset;
        @NotNull
        private final ExpandableIndexableNode<T> sub;

        public SubNode(int n, @NotNull ExpandableIndexableNode<T> expandableIndexableNode) {
            this.offset = n;
            this.sub = expandableIndexableNode;
        }

        public int getEndIndex() {
            return this.offset + this.sub.size();
        }
    }

    private static class Leaf<T>
    extends ExpandableIndexableNode<T> {
        @NotNull
        private final Object[] values;

        @SafeVarargs
        public Leaf(T ... TArray) {
            this.values = TArray;
        }

        public Leaf(@NotNull T[] TArray, int n, int n2) {
            this.values = Arrays.copyOfRange(TArray, n, n + n2);
        }

        public Leaf(T t, @NotNull T[] TArray, int n, int n2) {
            this.values = new Object[n2 + 1];
            this.values[0] = t;
            System.arraycopy(TArray, n, this.values, 1, n2);
        }

        @Override
        @NotNull
        public ExpandableIndexableNode<T> add(int n, T t) {
            if (n < 0 || n > this.values.length) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.values.length));
            }
            if (this.values.length == 64) {
                if (n == 64) {
                    return new Node(this, new Leaf<Object>(t));
                }
                return new Node(new Leaf<Object>(this.values, 0, n), new Leaf<Object>(t, this.values, n, this.values.length - n));
            }
            Object[] objectArray = new Object[this.values.length + 1];
            if (n > 0) {
                System.arraycopy(this.values, 0, objectArray, 0, n);
            }
            objectArray[n] = t;
            if (n < this.values.length) {
                System.arraycopy(this.values, n, objectArray, n + 1, this.values.length - n);
            }
            return new Leaf<Object>(objectArray);
        }

        @Override
        @NotNull
        public ExpandableIndexableNode<T> set(int n, T t) {
            if (n < 0 || n > this.values.length) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.values.length));
            }
            if (t == this.values[n]) {
                return this;
            }
            Object[] objectArray = (Object[])this.values.clone();
            objectArray[n] = t;
            return new Leaf<Object>(objectArray);
        }

        @Override
        public ExpandableIndexableNode<T> tryAdd(int n, T t) {
            return this.values.length < 64 ? this.add(n, (Object)t) : null;
        }

        @Override
        @NotNull
        public ExpandableIndexableNode<T> remove(int n) {
            int n2 = this.values.length;
            if (n < 0 || n >= n2) {
                throw new IndexOutOfBoundsException(String.format("Index %d out of range [0,%d[!", n, this.values.length));
            }
            if (n2 == 1) {
                return ExpandableIndexableImpl.empty();
            }
            if (n == n2 - 1) {
                return new Leaf<Object>(Arrays.copyOf(this.values, n2 - 1));
            }
            Object[] objectArray = new Object[n2 - 1];
            if (n > 0) {
                System.arraycopy(this.values, 0, objectArray, 0, n);
            }
            if (n < n2 - 1) {
                System.arraycopy(this.values, n + 1, objectArray, n, n2 - n - 1);
            }
            return new Leaf<Object>(objectArray);
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public int getWeight() {
            return this.values.length;
        }

        @Override
        public int depth() {
            return 1;
        }

        @Override
        public T get(int n) {
            if (n < 0 || n >= this.values.length) {
                throw new IndexOutOfBoundsException(String.format("Index %d out of range [0,%d[!", n, this.values.length));
            }
            return (T)this.values[n];
        }

        @Override
        public int addToArray(@NotNull T[] TArray, int n, int n2, int n3) {
            System.arraycopy(this.values, n2, TArray, n, n3);
            return n + n3;
        }

        @Override
        public boolean isFilled() {
            return this.values.length == 64;
        }

        @Override
        public long getCapacity() {
            return 64L;
        }

        @Override
        public String toString() {
            return Countable.toString(this);
        }
    }

    private static abstract class ExpandableIndexableNode<T>
    extends Indexable.Base<T>
    implements ExpandableIndexable<T> {
        private ExpandableIndexableNode() {
        }

        public abstract long getCapacity();

        public abstract int getWeight();

        @Nullable
        public abstract ExpandableIndexableNode<T> tryAdd(int var1, T var2);

        @Override
        @NotNull
        public abstract ExpandableIndexableNode<T> add(int var1, T var2);

        @Override
        @NotNull
        public abstract ExpandableIndexableNode<T> set(int var1, T var2);

        @Override
        @NotNull
        public abstract ExpandableIndexableNode<T> remove(int var1);

        public abstract int depth();

        public abstract boolean isFilled();

        @Override
        public abstract int addToArray(@NotNull T[] var1, int var2, int var3, int var4);
    }
}

