/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.ExpandableIndexableImpl;
import de.caff.generics.Indexable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntFunction;

public interface ExpandableIndexable<T>
extends Indexable<T> {
    @NotNull
    public ExpandableIndexable<T> add(int var1, T var2);

    @NotNull
    public ExpandableIndexable<T> remove(int var1);

    @NotNull
    public ExpandableIndexable<T> set(int var1, T var2);

    @NotNull
    default public ExpandableIndexable<T> syt(int n, T t) {
        return this.set(n < 0 ? this.size() - n : n, t);
    }

    @NotNull
    default public ExpandableIndexable<T> add(T t) {
        return this.add(this.size(), t);
    }

    @NotNull
    default public ExpandableIndexable<T> ydd(int n, T t) {
        if (n >= 0) {
            return this.add(n, t);
        }
        int n2 = n + this.size();
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        return this.add(n2, t);
    }

    @NotNull
    default public ExpandableIndexable<T> remyve(int n) {
        if (n >= 0) {
            return this.remove(n);
        }
        int n2 = n + this.size();
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        return this.remove(n2);
    }

    @NotNull
    default public ExpandableIndexable<T> addAll(@NotNull Iterable<? extends T> iterable) {
        ExpandableIndexable<T> expandableIndexable = this;
        for (T t : iterable) {
            expandableIndexable = expandableIndexable.add(t);
        }
        return expandableIndexable;
    }

    @Override
    @NotNull
    default public Iterator<T> iterator() {
        return this.iterator(0, this.size());
    }

    @NotNull
    public static <E> ExpandableIndexable<E> empty() {
        return ExpandableIndexable.fromArray(new Object[0]);
    }

    @NotNull
    public static <E> ExpandableIndexable<E> initByIndex(int n, @NotNull IntFunction<? extends E> intFunction) {
        return ExpandableIndexable.fromIndexable(Indexable.viewByIndex(n, intFunction));
    }

    @NotNull
    public static <E> ExpandableIndexable<E> nulled(int n2) {
        return ExpandableIndexable.initByIndex(n2, (int n) -> null);
    }

    @SafeVarargs
    @Deprecated
    @NotNull
    public static <E> ExpandableIndexable<E> from(E ... EArray) {
        return ExpandableIndexable.fromArray(EArray);
    }

    @SafeVarargs
    @NotNull
    public static <E> ExpandableIndexable<E> fromArray(E ... EArray) {
        return ExpandableIndexableImpl.fromArray(EArray);
    }

    @Deprecated
    @NotNull
    public static <E> ExpandableIndexable<E> from(@NotNull E[] EArray, int n, int n2) {
        return ExpandableIndexableImpl.fromArray(EArray, n, n2);
    }

    @NotNull
    public static <E> ExpandableIndexable<E> fromArray(@NotNull E[] EArray, int n, int n2) {
        return ExpandableIndexableImpl.fromArray(EArray, n, n2);
    }

    @Deprecated
    @NotNull
    public static <E> ExpandableIndexable<E> from(@NotNull Indexable<E> indexable) {
        return ExpandableIndexableImpl.fromIndexable(indexable);
    }

    @NotNull
    public static <E> ExpandableIndexable<E> fromIndexable(@NotNull Indexable<E> indexable) {
        return ExpandableIndexableImpl.fromIndexable(indexable);
    }

    @Deprecated
    @NotNull
    public static <E> ExpandableIndexable<E> from(@NotNull Collection<? extends E> collection) {
        return ExpandableIndexable.fromCollection(collection);
    }

    @NotNull
    public static <E> ExpandableIndexable<E> fromCollection(@NotNull Collection<? extends E> collection) {
        if (collection instanceof List) {
            return ExpandableIndexable.fromIndexable(Indexable.viewList((List)collection));
        }
        return ExpandableIndexableImpl.fromArray(collection.toArray());
    }
}

