/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.ExpandableDoubleIndexable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

class ExpandableDoubleIndexableImpl {
    static final int PART_SIZE = 64;
    static final int LARGE_SIZE_LIMIT = 0x1FFFFFF;
    private static ExpandableDoubleIndexableNode EMPTY = new ExpandableDoubleIndexableNode(){

        @Override
        @NotNull
        public ExpandableDoubleIndexableNode add(int n, double d) {
            if (n != 0) {
                throw new IndexOutOfBoundsException("Cannot add outside range [0,0] but index is " + n + "!");
            }
            return new Leaf(d);
        }

        @Override
        public ExpandableDoubleIndexableNode tryAdd(int n, double d) {
            return this.add(n, d);
        }

        @Override
        @NotNull
        public ExpandableDoubleIndexableNode remove(int n) {
            throw new IndexOutOfBoundsException("No element to remove in empty indexable!");
        }

        @Override
        @NotNull
        public ExpandableDoubleIndexable getCopy() {
            return this;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public double get(int n) {
            throw new IndexOutOfBoundsException("No element to get in empty indexable!");
        }

        @Override
        public int getWeight() {
            return 0;
        }

        @Override
        public int depth() {
            return 1;
        }

        @Override
        public int addToArray(@NotNull double[] dArray, int n) {
            return n;
        }

        @Override
        public int addToArray(@NotNull double[] dArray, int n, int n2, int n3) {
            return n;
        }

        @Override
        @NotNull
        public double[] toArray() {
            return Empty.DOUBLE_ARRAY;
        }

        @Override
        public boolean isFilled() {
            return false;
        }

        @Override
        public long getCapacity() {
            return 64L;
        }

        @Override
        public String toString() {
            return "[]";
        }
    };

    ExpandableDoubleIndexableImpl() {
    }

    public static int size(@NotNull DoubleIndexable[] doubleIndexableArray) {
        int n = 0;
        for (DoubleIndexable doubleIndexable : doubleIndexableArray) {
            n += doubleIndexable.size();
        }
        return n;
    }

    @NotNull
    static ExpandableDoubleIndexableNode from(double[] dArray, int n, int n2) {
        int n3;
        if (n2 <= 64) {
            return new Leaf(dArray, n, n2);
        }
        int n4 = 4096;
        int n5 = 64;
        while (n4 < n2) {
            n5 = n4;
            n4 = Integer.MAX_VALUE / n5 < 64 ? n5 * 64 : Integer.MAX_VALUE;
        }
        ExpandableDoubleIndexableNode[] expandableDoubleIndexableNodeArray = new ExpandableDoubleIndexableNode[(n2 + n5 - 1) / n5];
        int n6 = 0;
        int n7 = n2 - n5;
        for (n3 = 0; n3 < n7 && n3 >= 0; n3 += n5) {
            expandableDoubleIndexableNodeArray[n6++] = ExpandableDoubleIndexableImpl.from(dArray, n + n3, n5);
        }
        expandableDoubleIndexableNodeArray[n6] = ExpandableDoubleIndexableImpl.from(dArray, n + n3, n2 - n3);
        return new Node(expandableDoubleIndexableNodeArray);
    }

    @NotNull
    static ExpandableDoubleIndexableNode from(double ... dArray) {
        int n = dArray.length;
        if (n == 0) {
            return EMPTY;
        }
        if (n <= 64) {
            return new Leaf(dArray);
        }
        return ExpandableDoubleIndexableImpl.from(dArray, 0, n);
    }

    @NotNull
    static ExpandableDoubleIndexableNode from(@NotNull DoubleIndexable doubleIndexable) {
        int n;
        if (doubleIndexable.isEmpty()) {
            return EMPTY;
        }
        int n2 = doubleIndexable.size();
        if (n2 <= 64) {
            return new Leaf(doubleIndexable.toArray());
        }
        int n3 = 4096;
        int n4 = 64;
        while (n3 < n2) {
            n4 = n3;
            n3 = Integer.MAX_VALUE / n4 < 64 ? n4 * 64 : Integer.MAX_VALUE;
        }
        ExpandableDoubleIndexableNode[] expandableDoubleIndexableNodeArray = new ExpandableDoubleIndexableNode[(n2 + n4 - 1) / n4];
        int n5 = 0;
        int n6 = n2 - n4;
        for (n = 0; n >= 0 && n < n6; n += n4) {
            expandableDoubleIndexableNodeArray[n5++] = ExpandableDoubleIndexableImpl.from(doubleIndexable.subSet(n, n + n4));
        }
        expandableDoubleIndexableNodeArray[n5] = ExpandableDoubleIndexableImpl.from(doubleIndexable.tailSet(n));
        return new Node(expandableDoubleIndexableNodeArray);
    }

    private static class Node
    extends ExpandableDoubleIndexableNode {
        private final int numValues;
        private final long capacity;
        @NotNull
        private final SubNode[] subNodes;

        public Node(ExpandableDoubleIndexableNode ... expandableDoubleIndexableNodeArray) {
            this.subNodes = new SubNode[expandableDoubleIndexableNodeArray.length];
            long l = 64L;
            int n = 0;
            int n2 = 0;
            for (ExpandableDoubleIndexableNode expandableDoubleIndexableNode : expandableDoubleIndexableNodeArray) {
                this.subNodes[n++] = new SubNode(n2, expandableDoubleIndexableNode);
                n2 += expandableDoubleIndexableNode.size();
                l = Math.max(l, expandableDoubleIndexableNode.getCapacity());
            }
            this.numValues = n2;
            this.capacity = 64L * l;
        }

        @Override
        @NotNull
        public ExpandableDoubleIndexableNode add(int n, final double d) {
            ExpandableDoubleIndexableNode expandableDoubleIndexableNode;
            if (this.numValues == Integer.MAX_VALUE) {
                throw new RuntimeException("Size is becoming too large for 32bit integer!");
            }
            if (n < 0 || n > this.numValues) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.numValues));
            }
            ExpandableDoubleIndexableNode expandableDoubleIndexableNode2 = this.tryAdd(n, d);
            if (expandableDoubleIndexableNode2 != null) {
                return expandableDoubleIndexableNode2;
            }
            if (n == this.numValues) {
                return new Node(this, new Leaf(d));
            }
            if (this.subNodes.length == 64 && this.numValues <= 0x1FFFFFF && (long)this.numValues < this.capacity / 64L) {
                return this.recreateWithInsertedValue(n, d);
            }
            int n2 = this.subNodeIndex(n);
            SubNode subNode = this.subNodes[n2];
            int n3 = n - subNode.offset;
            ExpandableDoubleIndexableNode expandableDoubleIndexableNode3 = ExpandableDoubleIndexableImpl.from(subNode.sub.headSet(n3));
            final DoubleIndexable.Base base = subNode.sub.tailSet(n3);
            final int n4 = base.size() + 1;
            ExpandableDoubleIndexableNode expandableDoubleIndexableNode4 = ExpandableDoubleIndexableImpl.from(new DoubleIndexable.Base(){

                @Override
                public int size() {
                    return n4;
                }

                @Override
                public double get(int n) {
                    return n == 0 ? d : base.get(n - 1);
                }

                @Override
                public int addToArray(@NotNull double[] dArray, int n, int n2, int n3) {
                    if (n2 == 0) {
                        dArray[n++] = d;
                    }
                    if (n3 > 1) {
                        n += base.addToArray(dArray, n, 0, n3 - 1);
                    }
                    return n;
                }
            });
            ExpandableDoubleIndexableNode[] expandableDoubleIndexableNodeArray = new ExpandableDoubleIndexableNode[this.subNodes.length];
            for (int i = 0; i < n2; ++i) {
                expandableDoubleIndexableNodeArray[i] = this.subNodes[i].sub;
            }
            expandableDoubleIndexableNodeArray[n2] = expandableDoubleIndexableNode3;
            if (n2 == this.subNodes.length - 1) {
                expandableDoubleIndexableNode = expandableDoubleIndexableNode4;
            } else {
                expandableDoubleIndexableNode = this.subNodes[this.subNodes.length - 1].sub;
                expandableDoubleIndexableNodeArray[n2 + 1] = expandableDoubleIndexableNode4;
                for (int i = n2 + 2; i < this.subNodes.length; ++i) {
                    expandableDoubleIndexableNodeArray[i] = this.subNodes[i - 1].sub;
                }
            }
            return new Node(new Node(expandableDoubleIndexableNodeArray), new Node(expandableDoubleIndexableNode));
        }

        @Override
        public ExpandableDoubleIndexableNode tryAdd(int n, double d) {
            SubNode subNode;
            int n2 = this.subNodeIndex(n);
            SubNode subNode2 = this.subNodes[n2];
            ExpandableDoubleIndexableNode expandableDoubleIndexableNode = subNode2.sub.tryAdd(n - subNode2.offset, d);
            if (expandableDoubleIndexableNode != null) {
                return this.withExchangedSubNode(n2, expandableDoubleIndexableNode);
            }
            if (n == subNode2.getEndIndex() && n2 < this.subNodes.length - 1 && (expandableDoubleIndexableNode = (subNode = this.subNodes[n2 + 1]).sub.tryAdd(n - subNode.offset, d)) != null) {
                return this.withExchangedSubNode(n2 + 1, expandableDoubleIndexableNode);
            }
            if (n == subNode2.offset && n2 > 0 && (expandableDoubleIndexableNode = (subNode = this.subNodes[n2 - 1]).sub.tryAdd(n - subNode.offset, d)) != null) {
                return this.withExchangedSubNode(n2 - 1, expandableDoubleIndexableNode);
            }
            if (n == this.size()) {
                if (this.subNodes.length == 64) {
                    return null;
                }
                return this.withInsertedSubNode(this.subNodes.length, new Leaf(d));
            }
            if (this.isFilled()) {
                return null;
            }
            return this.recreateWithInsertedValue(n, d);
        }

        @NotNull
        private ExpandableDoubleIndexableNode recreateWithInsertedValue(final int n, final double d) {
            final int n2 = this.numValues + 1;
            return ExpandableDoubleIndexableImpl.from(new DoubleIndexable.Base(){

                @Override
                public int size() {
                    return n2;
                }

                @Override
                public double get(int n3) {
                    if (n3 < n) {
                        return this.get(n3);
                    }
                    if (n3 > n) {
                        return this.get(n3 - 1);
                    }
                    return d;
                }

                @Override
                public int addToArray(@NotNull double[] dArray, int n6, int n22, int n3) {
                    int n4 = n22 + n3;
                    if (n22 < n) {
                        int n5 = Math.min(n3, n - n22);
                        n6 = this.addToArray(dArray, n6, n22, n5);
                        n3 -= n5;
                    }
                    if (n22 <= n && n4 > n) {
                        dArray[n6++] = d;
                        --n3;
                    }
                    if (n4 > n + 1) {
                        n6 = this.addToArray(dArray, n6, n, n3);
                    }
                    return n6;
                }
            });
        }

        @NotNull
        private ExpandableDoubleIndexableNode withExchangedSubNode(int n, @NotNull ExpandableDoubleIndexableNode expandableDoubleIndexableNode) {
            int n2;
            ExpandableDoubleIndexableNode[] expandableDoubleIndexableNodeArray = new ExpandableDoubleIndexableNode[this.subNodes.length];
            for (n2 = 0; n2 < n; ++n2) {
                expandableDoubleIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            expandableDoubleIndexableNodeArray[n] = expandableDoubleIndexableNode;
            for (n2 = n + 1; n2 < expandableDoubleIndexableNodeArray.length; ++n2) {
                expandableDoubleIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            return new Node(expandableDoubleIndexableNodeArray);
        }

        @NotNull
        private ExpandableDoubleIndexableNode withInsertedSubNode(int n, @NotNull ExpandableDoubleIndexableNode expandableDoubleIndexableNode) {
            int n2;
            ExpandableDoubleIndexableNode[] expandableDoubleIndexableNodeArray = new ExpandableDoubleIndexableNode[this.subNodes.length + 1];
            for (n2 = 0; n2 < n; ++n2) {
                expandableDoubleIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            expandableDoubleIndexableNodeArray[n] = expandableDoubleIndexableNode;
            for (n2 = n + 1; n2 < expandableDoubleIndexableNodeArray.length; ++n2) {
                expandableDoubleIndexableNodeArray[n2] = this.subNodes[n2 - 1].sub;
            }
            return new Node(expandableDoubleIndexableNodeArray);
        }

        private int subNodeIndex(int n) {
            if (n == this.numValues) {
                return this.subNodes.length - 1;
            }
            int n2 = 0;
            int n3 = this.subNodes.length;
            while (n3 > n2 - 1) {
                int n4 = (n3 + n2) / 2;
                SubNode subNode = this.subNodes[n4];
                if (n < subNode.offset) {
                    n3 = n4;
                    continue;
                }
                if (n >= subNode.offset + subNode.sub.size()) {
                    n2 = n4 + 1;
                    continue;
                }
                return n4;
            }
            return n2;
        }

        @Override
        @NotNull
        public ExpandableDoubleIndexableNode remove(int n) {
            int n2;
            if (n < 0 || n >= this.numValues) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.numValues));
            }
            int n3 = this.subNodeIndex(n);
            SubNode subNode = this.subNodes[n3];
            ExpandableDoubleIndexableNode expandableDoubleIndexableNode = subNode.sub.remove(n - subNode.offset);
            if (expandableDoubleIndexableNode.isEmpty()) {
                int n4;
                if (this.subNodes.length == 1) {
                    return EMPTY;
                }
                ExpandableDoubleIndexableNode[] expandableDoubleIndexableNodeArray = new ExpandableDoubleIndexableNode[this.subNodes.length - 1];
                for (n4 = 0; n4 < n3; ++n4) {
                    expandableDoubleIndexableNodeArray[n4] = this.subNodes[n4].sub;
                }
                for (n4 = n3; n4 < expandableDoubleIndexableNodeArray.length; ++n4) {
                    expandableDoubleIndexableNodeArray[n4] = this.subNodes[n4 + 1].sub;
                }
                return new Node(expandableDoubleIndexableNodeArray);
            }
            ExpandableDoubleIndexableNode[] expandableDoubleIndexableNodeArray = new ExpandableDoubleIndexableNode[this.subNodes.length];
            for (n2 = 0; n2 < n3; ++n2) {
                expandableDoubleIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            expandableDoubleIndexableNodeArray[n3] = expandableDoubleIndexableNode;
            for (n2 = n3 + 1; n2 < expandableDoubleIndexableNodeArray.length; ++n2) {
                expandableDoubleIndexableNodeArray[n2] = this.subNodes[n2].sub;
            }
            return new Node(expandableDoubleIndexableNodeArray);
        }

        @Override
        @NotNull
        public ExpandableDoubleIndexable getCopy() {
            return this;
        }

        @Override
        public int size() {
            return this.numValues;
        }

        @Override
        public int getWeight() {
            return this.subNodes.length;
        }

        @Override
        public int depth() {
            int n = 0;
            for (SubNode subNode : this.subNodes) {
                n = Math.max(n, subNode.sub.depth());
            }
            return n + 1;
        }

        @Override
        public double get(int n) {
            if (n < 0 || n >= this.numValues) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d[!", n, this.numValues));
            }
            SubNode subNode = this.subNodes[this.subNodeIndex(n)];
            return subNode.sub.get(n - subNode.offset);
        }

        @Override
        @NotNull
        public Iterator<Double> iterator() {
            return this.doubleIterator();
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfDouble doubleIterator(int n, int n2) {
            Object object;
            if (this.subNodes.length == 1) {
                return this.subNodes[0].sub.doubleIterator(n, n2);
            }
            int n3 = this.subNodeIndex(n);
            int n4 = this.subNodeIndex(n2);
            SubNode subNode = this.subNodes[n3];
            if (n3 == n4) {
                return subNode.sub.doubleIterator(n - subNode.offset, n2 - subNode.offset);
            }
            ArrayList<PrimitiveIterator.OfDouble> arrayList = new ArrayList<PrimitiveIterator.OfDouble>(n4 - n3 + 1);
            arrayList.add(subNode.sub.doubleIterator(n - subNode.offset, subNode.sub.size()));
            for (int i = n3 + 1; i < n4; ++i) {
                object = this.subNodes[i];
                arrayList.add(((SubNode)object).sub.doubleIterator());
            }
            SubNode subNode2 = this.subNodes[n4];
            arrayList.add(subNode2.sub.doubleIterator(0, n2 - subNode2.offset));
            object = arrayList.iterator();
            return new PrimitiveIterator.OfDouble((Iterator)object){
                private PrimitiveIterator.OfDouble doubleIterator;
                final /* synthetic */ Iterator val$doubleIteratorIterator;
                {
                    this.val$doubleIteratorIterator = iterator;
                    this.doubleIterator = this.val$doubleIteratorIterator.hasNext() ? (PrimitiveIterator.OfDouble)this.val$doubleIteratorIterator.next() : null;
                }

                @Override
                public double nextDouble() {
                    if (this.doubleIterator == null) {
                        throw new NoSuchElementException("Cannot iterate past the end!");
                    }
                    double d = this.doubleIterator.nextDouble();
                    while (!this.doubleIterator.hasNext()) {
                        if (this.val$doubleIteratorIterator.hasNext()) {
                            this.doubleIterator = (PrimitiveIterator.OfDouble)this.val$doubleIteratorIterator.next();
                            continue;
                        }
                        this.doubleIterator = null;
                        break;
                    }
                    return d;
                }

                @Override
                public boolean hasNext() {
                    return this.doubleIterator != null;
                }
            };
        }

        @Override
        public int addToArray(@NotNull double[] dArray, int n) {
            for (SubNode subNode : this.subNodes) {
                n = subNode.sub.addToArray(dArray, n);
            }
            return n;
        }

        @Override
        public int addToArray(@NotNull double[] dArray, int n, int n2, int n3) {
            int n4;
            int n5 = n2;
            int n6 = n2 + n3;
            int n7 = this.subNodeIndex(n5);
            if (n7 == (n4 = this.subNodeIndex(n6))) {
                SubNode subNode = this.subNodes[n7];
                return subNode.sub.addToArray(dArray, n, n2 - subNode.offset, n3);
            }
            SubNode subNode = this.subNodes[n7];
            int n8 = n2 - subNode.offset;
            n = subNode.sub.addToArray(dArray, n, n8, subNode.sub.size() - n8);
            for (int i = n7 + 1; i < n4; ++i) {
                SubNode subNode2 = this.subNodes[i];
                n = subNode2.sub.addToArray(dArray, n);
            }
            SubNode subNode3 = this.subNodes[n4];
            return subNode3.sub.addToArray(dArray, n, 0, n6 - subNode3.offset);
        }

        @Override
        public boolean isFilled() {
            if (this.subNodes.length < 64) {
                return true;
            }
            for (SubNode subNode : this.subNodes) {
                if (subNode.sub.isFilled()) continue;
                return false;
            }
            return true;
        }

        @Override
        public long getCapacity() {
            return this.capacity;
        }

        @Override
        public String toString() {
            return DoubleIndexable.toString(this);
        }
    }

    private static class SubNode {
        private final int offset;
        @NotNull
        private final ExpandableDoubleIndexableNode sub;

        public SubNode(int n, @NotNull ExpandableDoubleIndexableNode expandableDoubleIndexableNode) {
            this.offset = n;
            this.sub = expandableDoubleIndexableNode;
        }

        public int getEndIndex() {
            return this.offset + this.sub.size();
        }
    }

    private static class Leaf
    extends ExpandableDoubleIndexableNode {
        @NotNull
        private final double[] values;

        public Leaf(double ... dArray) {
            this.values = dArray;
        }

        public Leaf(@NotNull double[] dArray, int n, int n2) {
            this.values = Arrays.copyOfRange(dArray, n, n + n2);
        }

        public Leaf(double d, @NotNull double[] dArray, int n, int n2) {
            this.values = new double[n2 + 1];
            this.values[0] = d;
            System.arraycopy(dArray, n, this.values, 1, n2);
        }

        @Override
        @NotNull
        public ExpandableDoubleIndexableNode add(int n, double d) {
            if (n < 0 || n > this.values.length) {
                throw new IndexOutOfBoundsException(String.format("Index %d is out of range [0,%d]!", n, this.values.length));
            }
            if (this.values.length == 64) {
                if (n == 64) {
                    return new Node(this, new Leaf(d));
                }
                return new Node(new Leaf(this.values, 0, n), new Leaf(d, this.values, n, this.values.length - n));
            }
            double[] dArray = new double[this.values.length + 1];
            if (n > 0) {
                System.arraycopy(this.values, 0, dArray, 0, n);
            }
            dArray[n] = d;
            if (n < this.values.length) {
                System.arraycopy(this.values, n, dArray, n + 1, this.values.length - n);
            }
            return new Leaf(dArray);
        }

        @Override
        public ExpandableDoubleIndexableNode tryAdd(int n, double d) {
            return this.values.length < 64 ? this.add(n, d) : null;
        }

        @Override
        @NotNull
        public ExpandableDoubleIndexableNode remove(int n) {
            int n2 = this.values.length;
            if (n < 0 || n >= n2) {
                throw new IndexOutOfBoundsException(String.format("Index %d out of range [0,%d[!", n, this.values.length));
            }
            if (n2 == 1) {
                return EMPTY;
            }
            if (n == n2 - 1) {
                return new Leaf(Arrays.copyOf(this.values, n2 - 1));
            }
            double[] dArray = new double[n2 - 1];
            if (n > 0) {
                System.arraycopy(this.values, 0, dArray, 0, n);
            }
            if (n < n2 - 1) {
                System.arraycopy(this.values, n + 1, dArray, n, n2 - n - 1);
            }
            return new Leaf(dArray);
        }

        @Override
        @NotNull
        public ExpandableDoubleIndexable getCopy() {
            return this;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        public int getWeight() {
            return this.values.length;
        }

        @Override
        public int depth() {
            return 1;
        }

        @Override
        public double get(int n) {
            if (n < 0 || n >= this.values.length) {
                throw new IndexOutOfBoundsException(String.format("Index %d out of range [0,%d[!", n, this.values.length));
            }
            return this.values[n];
        }

        @Override
        public int addToArray(@NotNull double[] dArray, int n) {
            System.arraycopy(this.values, 0, dArray, n, this.values.length);
            return n + this.values.length;
        }

        @Override
        public int addToArray(@NotNull double[] dArray, int n, int n2, int n3) {
            System.arraycopy(this.values, n2, dArray, n, n3);
            return n + n3;
        }

        @Override
        @NotNull
        public double[] toArray() {
            return (double[])this.values.clone();
        }

        @Override
        public boolean isFilled() {
            return this.values.length == 64;
        }

        @Override
        public long getCapacity() {
            return 64L;
        }

        @Override
        public String toString() {
            return DoubleIndexable.toString(this);
        }
    }

    private static abstract class ExpandableDoubleIndexableNode
    extends DoubleIndexable.Base
    implements ExpandableDoubleIndexable {
        private ExpandableDoubleIndexableNode() {
        }

        public abstract long getCapacity();

        public abstract int getWeight();

        @Nullable
        public abstract ExpandableDoubleIndexableNode tryAdd(int var1, double var2);

        @Override
        @NotNull
        public abstract ExpandableDoubleIndexableNode add(int var1, double var2);

        @Override
        @NotNull
        public abstract ExpandableDoubleIndexableNode remove(int var1);

        public abstract int depth();

        public abstract boolean isFilled();

        @Override
        public abstract int addToArray(@NotNull double[] var1, int var2, int var3, int var4);
    }
}

