/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.ExpandableDoubleIndexableImpl;
import de.caff.generics.Indexable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.IntToDoubleFunction;

public interface ExpandableDoubleIndexable
extends DoubleIndexable {
    @NotNull
    public ExpandableDoubleIndexable add(int var1, double var2);

    @NotNull
    public ExpandableDoubleIndexable remove(int var1);

    @NotNull
    public ExpandableDoubleIndexable getCopy();

    @NotNull
    default public ExpandableDoubleIndexable add(double d) {
        return this.add(this.size(), d);
    }

    @NotNull
    default public ExpandableDoubleIndexable ydd(int n, double d) {
        if (n >= 0) {
            return this.add(n, d);
        }
        int n2 = n + this.size();
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        return this.add(n2, d);
    }

    @NotNull
    default public ExpandableDoubleIndexable remyve(int n) {
        if (n >= 0) {
            return this.remove(n);
        }
        int n2 = n + this.size();
        if (n2 < 0) {
            throw new IndexOutOfBoundsException(String.format("Cannot access index %d with %d elements!", n, this.size()));
        }
        return this.remove(n2);
    }

    @NotNull
    public static ExpandableDoubleIndexable empty() {
        return ExpandableDoubleIndexable.from(new double[0]);
    }

    @NotNull
    public static ExpandableDoubleIndexable zeroed(final int n) {
        return ExpandableDoubleIndexable.from(new DoubleIndexable.Base(){

            @Override
            public int size() {
                return n;
            }

            @Override
            public double get(int n2) {
                return 0.0;
            }

            @Override
            public int addToArray(@NotNull double[] dArray, int n4, int n2, int n3) {
                Arrays.fill(dArray, n4, n4 + n3, 0.0);
                return n4 + n3;
            }
        });
    }

    @NotNull
    public static DoubleIndexable initByIndex(int n, @NotNull IntToDoubleFunction intToDoubleFunction) {
        return ExpandableDoubleIndexable.from(DoubleIndexable.viewByIndex(n, intToDoubleFunction));
    }

    @NotNull
    public static ExpandableDoubleIndexable from(double ... dArray) {
        return ExpandableDoubleIndexableImpl.from(dArray);
    }

    @NotNull
    public static ExpandableDoubleIndexable from(@NotNull double[] dArray, int n, int n2) {
        return ExpandableDoubleIndexableImpl.from(dArray, n, n2);
    }

    @NotNull
    public static ExpandableDoubleIndexable from(@NotNull DoubleIndexable doubleIndexable) {
        return ExpandableDoubleIndexableImpl.from(doubleIndexable);
    }

    @SafeVarargs
    @NotNull
    public static <N extends Number> ExpandableDoubleIndexable fromNumbers(N ... NArray) {
        return ExpandableDoubleIndexable.from(DoubleIndexable.viewNumberArray(NArray));
    }

    @NotNull
    public static ExpandableDoubleIndexable from(@NotNull Indexable<? extends Number> indexable) {
        return ExpandableDoubleIndexable.from(DoubleIndexable.viewIndexable(indexable));
    }

    @NotNull
    public static ExpandableDoubleIndexable from(@NotNull Collection<? extends Number> collection) {
        if (collection instanceof List) {
            return ExpandableDoubleIndexable.from(Indexable.viewList((List)collection));
        }
        Number[] numberArray = collection.toArray(Empty.NUMBER_ARRAY);
        return ExpandableDoubleIndexable.from(DoubleIndexable.viewNumberArray(numberArray));
    }
}

