/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Primitives;
import de.caff.generics.function.DoubleFunction2;
import de.caff.generics.function.DoubleOperator2;
import de.caff.generics.function.DoublePredicate2;
import de.caff.generics.tuple.Tuple;
import de.caff.generics.tuple.Tuple2;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

public final class DoublePair
implements Serializable,
DoubleIndexable {
    private static final long serialVersionUID = 2437672519488765631L;
    public final double first;
    public final double second;

    public DoublePair(double d, double d2) {
        this.first = d;
        this.second = d2;
    }

    @NotNull
    public DoublePair withFirst(double d) {
        if (Primitives.areEqual(this.first, d)) {
            return this;
        }
        return new DoublePair(d, this.second);
    }

    @NotNull
    public DoublePair withSecond(double d) {
        if (Primitives.areEqual(this.second, d)) {
            return this;
        }
        return new DoublePair(this.first, d);
    }

    @NotNull
    public DoublePair swapped() {
        if (Primitives.areEqual(this.first, this.second)) {
            return this;
        }
        return new DoublePair(this.second, this.first);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public double get(int n) {
        switch (n) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
        }
        throw new IndexOutOfBoundsException(String.format("Pair has only 2 elements, so %d is out of bounds!", n));
    }

    public <T> T applyAsDoubles(@NotNull DoubleFunction2<T> doubleFunction2) {
        return doubleFunction2.applyAsDouble(this.first, this.second);
    }

    public double operate(@NotNull DoubleOperator2 doubleOperator2) {
        return doubleOperator2.applyAsDouble(this.first, this.second);
    }

    public boolean test(@NotNull DoublePredicate2 doublePredicate2) {
        return doublePredicate2.testDoubles(this.first, this.second);
    }

    @NotNull
    public Tuple2<Double, Double> toTuple() {
        return Tuple.of(this.first, this.second);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        DoublePair doublePair = (DoublePair)object;
        return Primitives.areEqual(doublePair.first, this.first) && Primitives.areEqual(doublePair.second, this.second);
    }

    public int hashCode() {
        return Objects.hash(Primitives.boxed(this.first), Primitives.boxed(this.second));
    }

    @NotNull
    public String toString() {
        return String.format(Locale.US, "DoublePair(%s, %s)", this.first, this.second);
    }
}

