/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.ByteIndexable;
import de.caff.generics.Empty;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IndexableHelper;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongIndexable;
import de.caff.generics.MutableDoubleIndexable;
import de.caff.generics.Order;
import de.caff.generics.PrimitiveDoubleIterable;
import de.caff.generics.Primitives;
import de.caff.generics.Pythonesque;
import de.caff.generics.ShortIndexable;
import de.caff.generics.Sizeable;
import de.caff.generics.Types;
import de.caff.generics.function.DoubleOperator1;
import de.caff.generics.function.DoubleOrdering;
import de.caff.generics.function.DoublePredicate2;
import de.caff.generics.function.FragileDoubleConsumer;
import de.caff.generics.range.Range;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoublePredicate;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import java.util.function.ToDoubleFunction;

public interface DoubleIndexable
extends PrimitiveDoubleIterable,
Sizeable {
    public static final DoubleIndexable SINGLE_0 = DoubleIndexable.singleton(0.0);
    @NotNull
    public static final Base EMPTY = new Base(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public double get(int n) {
            throw new IndexOutOfBoundsException("Empty indexable has no elements!");
        }

        @Override
        public double firstValue() {
            throw new IndexOutOfBoundsException("Empty indexable has no first value!");
        }

        @Override
        public double lastValue() {
            throw new IndexOutOfBoundsException("Empty indexable has no last value!");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public double[] toArray() {
            return Empty.DOUBLE_ARRAY;
        }

        @Override
        public int addToArray(@NotNull double[] dArray, int n) {
            return n;
        }

        @Override
        public int addToArray(@NotNull double[] dArray, int n, int n2, int n3) {
            return n;
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        public double foldLeft(double d, @NotNull DoubleBinaryOperator doubleBinaryOperator) {
            return d;
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        @NotNull
        public DoubleIndexable rotated(int n) {
            return this;
        }

        @Override
        @NotNull
        public Iterator<Double> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public ListIterator<Double> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfDouble doubleIterator() {
            return Types.EMPTY_DOUBLE_ITERATOR;
        }

        @Override
        public int compareTo(@NotNull DoubleIndexable doubleIndexable) {
            return doubleIndexable.isEmpty() ? 0 : -1;
        }

        @Override
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof DoubleIndexable && ((DoubleIndexable)object).isEmpty();
        }

        @Override
        @NotNull
        public Collection<Double> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Double> asList() {
            return Collections.emptyList();
        }

        @Override
        public void forEachDouble(@NotNull DoubleConsumer doubleConsumer) {
        }

        @Override
        public <E extends Exception> void forEachDoubleFragile(@NotNull FragileDoubleConsumer<E> fragileDoubleConsumer) throws E {
        }

        @Override
        public boolean containsDouble(double d) {
            return false;
        }

        @Override
        public boolean containsDouble(double d, double d2) {
            return false;
        }

        @Override
        @NotNull
        public Base transformed(@NotNull DoubleOperator1 doubleOperator1) {
            return this;
        }

        @Override
        @NotNull
        public Base frozen() {
            return this;
        }

        @Override
        @NotNull
        public <T> Indexable<T> view(@NotNull DoubleFunction<? extends T> doubleFunction) {
            return Indexable.emptyIndexable();
        }

        @Override
        public void forEach(Consumer<? super Double> consumer) {
        }

        @Override
        public boolean isOrdered(@NotNull DoubleOrdering doubleOrdering) {
            return true;
        }

        @Override
        public boolean isStrictlyOrdered(@NotNull DoubleOrdering doubleOrdering) {
            return true;
        }

        @Override
        public int binarySearch(double d) {
            return -1;
        }

        @Override
        public int binarySearch(double d, @NotNull DoubleOrdering doubleOrdering) {
            return -1;
        }

        @Override
        public double sum() {
            return 0.0;
        }

        @Override
        @NotNull
        public OptionalDouble average() {
            return OptionalDouble.empty();
        }

        @Override
        @NotNull
        public Spliterator.OfDouble doubleSpliterator() {
            return Spliterators.emptyDoubleSpliterator();
        }
    };

    public double get(int var1);

    default public double gyt(int n) {
        return this.get(Pythonesque.mapX(n, this));
    }

    default public double getMod(int n) {
        int n2 = this.size();
        if (n2 == 0) {
            throw new IndexOutOfBoundsException("No element for empty indexable!");
        }
        return this.gyt(n % n2);
    }

    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }

            @Override
            public double get(int n) {
                return DoubleIndexable.this.get(DoubleIndexable.this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return DoubleIndexable.this.asBase();
            }
        };
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    default public PrimitiveIterator.OfDouble doubleIterator() {
        return this.doubleIterator(0, this.size());
    }

    @NotNull
    default public PrimitiveIterator.OfDouble doubleIterator(final int n, final int n2) {
        return new PrimitiveIterator.OfDouble(){
            private int index;
            {
                this.index = n;
            }

            @Override
            public double nextDouble() {
                if (this.index >= n2) {
                    throw new NoSuchElementException(String.format("Index %s out of allowed range [%d, %d[!", this.index, n, n2));
                }
                return DoubleIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < n2;
            }
        };
    }

    @Override
    @NotNull
    default public Iterator<Double> iterator() {
        return this.listIterator();
    }

    default public double firstValue() {
        return this.get(0);
    }

    default public double lastValue() {
        return this.gyt(-1);
    }

    @NotNull
    default public ListIterator<Double> listIterator() {
        return new ListIterator<Double>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < DoubleIndexable.this.size();
            }

            @Override
            public Double next() {
                if (this.index >= DoubleIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return DoubleIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Double previous() {
                if (this.index == 0) {
                    throw new NoSuchElementException("index: -1");
                }
                return DoubleIndexable.this.get(--this.index);
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Double d) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Double d) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    default public Base subSet(final int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return n3 == 0 ? EMPTY : new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public double get(int n2) {
                if (n2 < 0 || n2 >= n3) {
                    throw new IndexOutOfBoundsException("No such element: " + n2);
                }
                return DoubleIndexable.this.get(n2 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n2) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n2 > n3) {
                    throw new IndexOutOfBoundsException("toIndex = " + n2);
                }
                if (n4 > n2) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n2 + ")");
                }
                return DoubleIndexable.this.subSet(n + n4, n + n2);
            }
        };
    }

    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(Pythonesque.mapX(n, this), this.size());
    }

    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, Pythonesque.mapX(n, this));
    }

    @NotNull
    default public Collection<Double> asCollection() {
        return new AbstractCollection<Double>(){

            @Override
            @NotNull
            public Iterator<Double> iterator() {
                return DoubleIndexable.this.iterator();
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }
        };
    }

    @NotNull
    default public List<Double> asList() {
        return new AbstractList<Double>(){

            @Override
            public Double get(int n) {
                return DoubleIndexable.this.get(n);
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }

            @Override
            @NotNull
            public Iterator<Double> iterator() {
                return DoubleIndexable.this.iterator();
            }
        };
    }

    @NotNull
    default public ArrayList<Double> toList() {
        ArrayList<Double> arrayList = new ArrayList<Double>(this.size());
        this.addAllTo(arrayList);
        return arrayList;
    }

    default public void addAllTo(@NotNull Collection<? super Double> collection) {
        for (Double d : this) {
            collection.add(d);
        }
    }

    @NotNull
    default public Indexable<Double> asIndexable() {
        return new Indexable.Base<Double>(){

            @Override
            public Double get(int n) {
                return DoubleIndexable.this.get(n);
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }
        };
    }

    @NotNull
    default public double[] toArray() {
        if (this.isEmpty()) {
            return Empty.DOUBLE_ARRAY;
        }
        double[] dArray = new double[this.size()];
        this.addToArray(dArray, 0);
        return dArray;
    }

    default public int addToArray(@NotNull double[] dArray, int n) {
        return this.addToArray(dArray, n, 0, this.size());
    }

    default public int addToArray(@NotNull double[] dArray, int n, int n2, int n3) {
        PrimitiveIterator.OfDouble ofDouble = this.doubleIterator(n2, n2 + n3);
        while (ofDouble.hasNext()) {
            dArray[n++] = ofDouble.nextDouble();
        }
        return n;
    }

    @NotNull
    default public Iterable<Integer> indexes() {
        return Range.indexes(this.size());
    }

    @NotNull
    default public IntIndexable intIndexes() {
        return IntIndexable.rangeFromSize(this.size());
    }

    default public double foldLeft(double d, @NotNull DoubleBinaryOperator doubleBinaryOperator) {
        double d2 = d;
        PrimitiveIterator.OfDouble ofDouble = this.doubleIterator();
        while (ofDouble.hasNext()) {
            d2 = doubleBinaryOperator.applyAsDouble(d2, ofDouble.nextDouble());
        }
        return d2;
    }

    @NotNull
    default public Base transformed(final @NotNull DoubleOperator1 doubleOperator1) {
        return new Base(){

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }

            @Override
            public double get(int n) {
                return doubleOperator1.applyAsDouble(DoubleIndexable.this.get(n));
            }
        };
    }

    default public int nextMatch(int n, @NotNull DoublePredicate doublePredicate) {
        int n2 = this.size();
        for (int i = Pythonesque.mapX(n, this); i < n2; ++i) {
            if (!doublePredicate.test(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int firstMatch(@NotNull DoublePredicate doublePredicate) {
        return this.nextMatch(0, doublePredicate);
    }

    default public int previousMatch(int n, @NotNull DoublePredicate doublePredicate) {
        for (int i = Pythonesque.mapX(n, this); i >= 0; --i) {
            if (!doublePredicate.test(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int lastMatch(@NotNull DoublePredicate doublePredicate) {
        return this.previousMatch(-1, doublePredicate);
    }

    @NotNull
    default public DoubleIndexable frozen() {
        return IndexableHelper.frozenFromArray(this.toArray());
    }

    @NotNull
    default public Spliterator.OfDouble doubleSpliterator() {
        return new DoubleIndexableSpliterator(this);
    }

    @NotNull
    default public Spliterator.OfDouble frozenDoubleSpliterator() {
        DoubleIndexable doubleIndexable = this.frozen();
        return new DoubleIndexableSpliterator(doubleIndexable, 0, doubleIndexable.size(), true);
    }

    @NotNull
    default public <T> Indexable<T> view(final @NotNull DoubleFunction<? extends T> doubleFunction) {
        return new Indexable.Base<T>(){

            @Override
            public T get(int n) {
                return doubleFunction.apply(DoubleIndexable.this.get(n));
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }
        };
    }

    @NotNull
    default public DoubleIndexable withInsertedValueAt(int n, final double d) {
        final int n2 = n;
        final int n3 = this.size() + 1;
        if (n2 == 0) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public double get(int n) {
                    return n == 0 ? d : DoubleIndexable.this.get(n - 1);
                }
            };
        }
        if (n2 == n3 - 1) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public double get(int n) {
                    return n == n3 - 1 ? d : DoubleIndexable.this.get(n);
                }
            };
        }
        return new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public double get(int n) {
                if (n == n2) {
                    return d;
                }
                return DoubleIndexable.this.get(n < n2 ? n : n - 1);
            }
        };
    }

    @NotNull
    default public DoubleIndexable withAppendedValue(double d) {
        return this.withInsertedValueAt(this.size(), d);
    }

    @NotNull
    default public DoubleIndexable withExchangedValueAt(int n, final double d) {
        final int n2 = Pythonesque.mapX(n, this);
        return new Base(){

            @Override
            public double get(int n) {
                return n == n2 ? d : DoubleIndexable.this.get(n);
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }
        };
    }

    @NotNull
    default public DoubleIndexable withRemovedValueAt(int n) {
        final int n2 = Pythonesque.mapX(n, this);
        if (n2 == 0) {
            return this.tailSet(1);
        }
        final int n3 = this.size() - 1;
        if (n2 == n3) {
            return this.headSet(-1);
        }
        return new Base(){

            @Override
            public double get(int n) {
                return n < n2 ? DoubleIndexable.this.get(n) : DoubleIndexable.this.get(n + 1);
            }

            @Override
            public int size() {
                return n3;
            }
        };
    }

    @NotNull
    default public DoubleIndexable withSwappedValuesAt(int n, int n2) {
        int n3;
        final int n4 = Pythonesque.mapX(n, this);
        if (n4 == (n3 = Pythonesque.mapX(n2, this))) {
            return this;
        }
        return new Base(){

            @Override
            public double get(int n) {
                if (n == n4) {
                    return DoubleIndexable.this.get(n3);
                }
                if (n == n3) {
                    return DoubleIndexable.this.get(n4);
                }
                return DoubleIndexable.this.get(n);
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }
        };
    }

    @NotNull
    default public DoubleIndexable rotated(int n) {
        if ((n %= this.size()) == 0) {
            return this;
        }
        if (n < 0) {
            n += this.size();
        }
        final int n2 = n;
        return new Base(){

            @Override
            public double get(int n) {
                return DoubleIndexable.this.get((n + n2) % this.size());
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }

            @Override
            @NotNull
            public DoubleIndexable rotated(int n) {
                return DoubleIndexable.this.rotated(n2 + n);
            }
        };
    }

    @NotNull
    default public DoubleIndexable viewOp(@NotNull DoubleUnaryOperator doubleUnaryOperator) {
        return DoubleIndexable.viewByIndex(this.size(), n -> doubleUnaryOperator.applyAsDouble(this.get(n)));
    }

    @NotNull
    default public FloatIndexable viewAsFloat() {
        return new FloatIndexable.Base(){

            @Override
            public float get(int n) {
                return (float)DoubleIndexable.this.get(n);
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }
        };
    }

    @NotNull
    default public LongIndexable viewAsLong() {
        return new LongIndexable.Base(){

            @Override
            public long get(int n) {
                return (long)DoubleIndexable.this.get(n);
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }
        };
    }

    @NotNull
    default public LongIndexable viewAsLong(final @NotNull DoubleToLongFunction doubleToLongFunction) {
        return new LongIndexable.Base(){

            @Override
            public long get(int n) {
                return doubleToLongFunction.applyAsLong(DoubleIndexable.this.get(n));
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }
        };
    }

    @NotNull
    default public IntIndexable viewAsInt() {
        return new IntIndexable.Base(){

            @Override
            public int get(int n) {
                return (int)DoubleIndexable.this.get(n);
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }
        };
    }

    @NotNull
    default public IntIndexable viewAsInt(final @NotNull DoubleToIntFunction doubleToIntFunction) {
        return new IntIndexable.Base(){

            @Override
            public int get(int n) {
                return doubleToIntFunction.applyAsInt(DoubleIndexable.this.get(n));
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ShortIndexable viewAsShort() {
        return new ShortIndexable.Base(){

            @Override
            public short get(int n) {
                return (short)DoubleIndexable.this.get(n);
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ByteIndexable viewAsByte() {
        return new ByteIndexable.Base(){

            @Override
            public byte get(int n) {
                return (byte)DoubleIndexable.this.get(n);
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }
        };
    }

    @NotNull
    default public BooleanIndexable viewAsBoolean(final @NotNull DoublePredicate doublePredicate) {
        return new BooleanIndexable.Base(){

            @Override
            public boolean get(int n) {
                return doublePredicate.test(DoubleIndexable.this.get(n));
            }

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }
        };
    }

    @NotNull
    default public DoubleIndexable deltas() {
        int n2 = this.size() - 1;
        if (n2 <= 0) {
            return DoubleIndexable.emptyIndexable();
        }
        return DoubleIndexable.viewByIndex(n2, n -> this.get(n + 1) - this.get(n));
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Number> list) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public double get(int n) {
                return ((Number)list.get(n)).doubleValue();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Number> list, final double d) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public double get(int n) {
                Number number = (Number)list.get(n);
                return number != null ? number.doubleValue() : d;
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static <T> Base viewList(final @NotNull List<T> list, final @NotNull ToDoubleFunction<? super T> toDoubleFunction) {
        return new Base(){

            @Override
            public double get(int n) {
                return toDoubleFunction.applyAsDouble(list.get(n));
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Number> indexable) {
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public double get(int n) {
                return ((Number)indexable.get(n)).doubleValue();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Number> indexable, final double d) {
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public double get(int n) {
                Number number = (Number)indexable.get(n);
                return number != null ? number.doubleValue() : d;
            }
        };
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToDoubleFunction<? super T> toDoubleFunction) {
        return new Base(){

            @Override
            public double get(int n) {
                return toDoubleFunction.applyAsDouble(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public boolean isEmpty() {
                return indexable.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewNumberArray(final Number ... numberArray) {
        return new Base(){

            @Override
            public int size() {
                return numberArray.length;
            }

            @Override
            public double get(int n) {
                return numberArray[n].doubleValue();
            }
        };
    }

    @NotNull
    public static Base viewArray(final double ... dArray) {
        return new Base(){

            @Override
            public int size() {
                return dArray.length;
            }

            @Override
            public double get(int n) {
                return dArray[n];
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull double[] dArray, final int n, final int n2) {
        if (n < 0 || n2 < 0 || n + n2 > dArray.length) {
            throw new IndexOutOfBoundsException("Start or end outside of range!");
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return n2;
            }

            @Override
            public double get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("Index %d outside range [0, %d[!", n3, n2));
                }
                return dArray[n3 + n];
            }
        };
    }

    @NotNull
    public static <T> Base viewArray(final @NotNull T[] TArray, final @NotNull ToDoubleFunction<? super T> toDoubleFunction) {
        if (TArray.length == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public double get(int n) {
                return toDoubleFunction.applyAsDouble(TArray[n]);
            }

            @Override
            public int size() {
                return TArray.length;
            }
        };
    }

    @SafeVarargs
    @NotNull
    public static <T> Base viewArray(final @NotNull ToDoubleFunction<? super T> toDoubleFunction, final T ... TArray) {
        return new Base(){

            @Override
            public int size() {
                return TArray.length;
            }

            @Override
            public double get(int n) {
                return toDoubleFunction.applyAsDouble(TArray[n]);
            }
        };
    }

    @NotNull
    public static Base init(final int n, final double d) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public double get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return d;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            @NotNull
            public DoubleIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    public static Base viewByIndex(final int n, final @NotNull IntToDoubleFunction intToDoubleFunction) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public double get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return intToDoubleFunction.applyAsDouble(n2);
            }

            @Override
            public int size() {
                return n;
            }
        };
    }

    @NotNull
    public static DoubleIndexable initByIndex(int n, @NotNull IntToDoubleFunction intToDoubleFunction) {
        return DoubleIndexable.viewByIndex(n, intToDoubleFunction).frozen();
    }

    @NotNull
    public static Base singleton(final double d) {
        return new Base(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public double get(int n) {
                if (n != 0) {
                    throw new IndexOutOfBoundsException(String.format("Index %d for indexable of size 1!", n));
                }
                return d;
            }

            @Override
            public double firstValue() {
                return d;
            }

            @Override
            public double lastValue() {
                return d;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public Base reverse() {
                return this;
            }

            @Override
            @NotNull
            public DoubleIndexable rotated(int n) {
                return this;
            }

            @Override
            @NotNull
            public Collection<Double> asCollection() {
                return Collections.singleton(d);
            }

            @Override
            @NotNull
            public List<Double> asList() {
                return Collections.singletonList(d);
            }

            @Override
            @NotNull
            public double[] toArray() {
                return new double[]{d};
            }

            @Override
            public int addToArray(@NotNull double[] dArray, int n) {
                dArray[n] = d;
                return n + 1;
            }

            @Override
            @NotNull
            public Iterable<Integer> indexes() {
                return IntIndexable.SINGLE_0;
            }

            @Override
            @NotNull
            public IntIndexable intIndexes() {
                return IntIndexable.SINGLE_0;
            }

            @Override
            public double sum() {
                return d;
            }

            @Override
            @NotNull
            public OptionalDouble average() {
                return OptionalDouble.of(d);
            }

            @Override
            public boolean isOrdered(@NotNull DoubleOrdering doubleOrdering) {
                return true;
            }

            @Override
            public boolean isStrictlyOrdered(@NotNull DoubleOrdering doubleOrdering) {
                return true;
            }
        };
    }

    @NotNull
    public static Base emptyIndexable() {
        return EMPTY;
    }

    @NotNull
    public static String toString(@NotNull DoubleIndexable doubleIndexable) {
        if (doubleIndexable.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(doubleIndexable.get(0));
        PrimitiveIterator.OfDouble ofDouble = doubleIndexable.tailSet(1).doubleIterator();
        while (ofDouble.hasNext()) {
            stringBuilder.append(',').append(ofDouble.nextDouble());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static boolean equal(@NotNull DoubleIndexable doubleIndexable, @NotNull DoubleIndexable doubleIndexable2) {
        return DoubleIndexable.equal(doubleIndexable, doubleIndexable2, DoublePredicate2.EQUAL_EVEN_NAN);
    }

    public static boolean equalStandard(@NotNull DoubleIndexable doubleIndexable, @NotNull DoubleIndexable doubleIndexable2) {
        return DoubleIndexable.equal(doubleIndexable, doubleIndexable2, DoublePredicate2.EQUAL_STANDARD);
    }

    public static boolean equal(@NotNull DoubleIndexable doubleIndexable, @NotNull DoubleIndexable doubleIndexable2, @NotNull DoublePredicate2 doublePredicate2) {
        if (doubleIndexable == doubleIndexable2) {
            return true;
        }
        if (doubleIndexable.size() != doubleIndexable2.size()) {
            return false;
        }
        PrimitiveIterator.OfDouble ofDouble = doubleIndexable.doubleIterator();
        PrimitiveIterator.OfDouble ofDouble2 = doubleIndexable2.doubleIterator();
        while (ofDouble.hasNext() && ofDouble2.hasNext()) {
            if (doublePredicate2.testDoubles(ofDouble.next(), ofDouble2.next())) continue;
            return false;
        }
        return !ofDouble.hasNext() && !ofDouble2.hasNext();
    }

    public static boolean equal(@NotNull DoubleIndexable doubleIndexable, @Nullable Object object) {
        if (object instanceof DoubleIndexable) {
            return DoubleIndexable.equal(doubleIndexable, (DoubleIndexable)object);
        }
        return false;
    }

    public static int compare(@NotNull DoubleIndexable doubleIndexable, @NotNull DoubleIndexable doubleIndexable2) {
        PrimitiveIterator.OfDouble ofDouble = doubleIndexable.doubleIterator();
        PrimitiveIterator.OfDouble ofDouble2 = doubleIndexable2.doubleIterator();
        while (ofDouble.hasNext() && ofDouble2.hasNext()) {
            int n = Double.compare(ofDouble.nextDouble(), ofDouble2.nextDouble());
            if (n == 0) continue;
            return n;
        }
        if (ofDouble.hasNext()) {
            return 1;
        }
        if (ofDouble2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int hash(@NotNull DoubleIndexable doubleIndexable) {
        int n = 1;
        PrimitiveIterator.OfDouble ofDouble = doubleIndexable.doubleIterator();
        while (ofDouble.hasNext()) {
            n = 31 * n + Primitives.hash(ofDouble.next());
        }
        return n;
    }

    @NotNull
    public static Base withCachedHash(final @NotNull DoubleIndexable doubleIndexable) {
        final int n = DoubleIndexable.hash(doubleIndexable);
        return new Base(){

            @Override
            public int size() {
                return doubleIndexable.size();
            }

            @Override
            public double get(int n2) {
                return doubleIndexable.get(n2);
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfDouble doubleIterator() {
                return doubleIndexable.doubleIterator();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfDouble doubleIterator(int n3, int n2) {
                return doubleIndexable.doubleIterator(n3, n2);
            }

            @Override
            @NotNull
            public Iterator<Double> iterator() {
                return doubleIndexable.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Double> listIterator() {
                return doubleIndexable.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n2) {
                return doubleIndexable.subSet(n3, n2);
            }

            @Override
            public int addToArray(@NotNull double[] dArray, int n2) {
                return doubleIndexable.addToArray(dArray, n2);
            }

            @Override
            public int addToArray(@NotNull double[] dArray, int n4, int n2, int n3) {
                return doubleIndexable.addToArray(dArray, n4, n2, n3);
            }

            @Override
            public int hashCode() {
                return n;
            }

            @Override
            public boolean equals(Object object) {
                return DoubleIndexable.equal(doubleIndexable, object);
            }

            @Override
            public String toString() {
                return DoubleIndexable.toString(doubleIndexable);
            }
        };
    }

    default public boolean isOrdered(@NotNull DoubleOrdering doubleOrdering) {
        if (this.size() < 2) {
            return true;
        }
        double d = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            double d2 = this.get(i);
            if (doubleOrdering.checkDouble(d2, d) == Order.Descending) {
                return false;
            }
            d = d2;
        }
        return true;
    }

    default public boolean isStrictlyOrdered(@NotNull DoubleOrdering doubleOrdering) {
        if (this.size() < 2) {
            return true;
        }
        double d = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            double d2 = this.get(i);
            if (doubleOrdering.checkDouble(d2, d) != Order.Ascending) {
                return false;
            }
            d = d2;
        }
        return true;
    }

    default public int binarySearch(double d) {
        int n = 0;
        int n2 = this.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            double d2 = this.get(n3);
            if (d2 < d) {
                n = n3 + 1;
                continue;
            }
            if (d2 > d) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    default public int binarySearch(double d, @NotNull DoubleOrdering doubleOrdering) {
        int n = 0;
        int n2 = this.size() - 1;
        block4: while (n <= n2) {
            int n3 = n + n2 >>> 1;
            double d2 = this.get(n3);
            switch (doubleOrdering.checkDouble(d2, d)) {
                case Ascending: {
                    n = n3 + 1;
                    continue block4;
                }
                case Descending: {
                    n2 = n3 - 1;
                    continue block4;
                }
            }
            return n3;
        }
        return -(n + 1);
    }

    @NotNull
    default public MutableDoubleIndexable ordered(@NotNull DoubleOrdering doubleOrdering) {
        MutableDoubleIndexable.Base base = MutableDoubleIndexable.fromDoubleIndexable(this);
        base.order(doubleOrdering);
        return base;
    }

    @NotNull
    default public MutableDoubleIndexable ordered() {
        MutableDoubleIndexable.Base base = MutableDoubleIndexable.fromDoubleIndexable(this);
        base.order();
        return base;
    }

    @NotNull
    default public Base asBase() {
        return new Base(){

            @Override
            public int size() {
                return DoubleIndexable.this.size();
            }

            @Override
            public double get(int n) {
                return DoubleIndexable.this.get(n);
            }

            @Override
            @NotNull
            public Base reverse() {
                return DoubleIndexable.this.reverse();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfDouble doubleIterator() {
                return DoubleIndexable.this.doubleIterator();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfDouble doubleIterator(int n, int n2) {
                return DoubleIndexable.this.doubleIterator(n, n2);
            }

            @Override
            @NotNull
            public Iterator<Double> iterator() {
                return DoubleIndexable.this.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Double> listIterator() {
                return DoubleIndexable.this.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return DoubleIndexable.this.subSet(n, n2).asBase();
            }

            @Override
            @NotNull
            public double[] toArray() {
                return DoubleIndexable.this.toArray();
            }

            @Override
            public int addToArray(@NotNull double[] dArray, int n) {
                return DoubleIndexable.this.addToArray(dArray, n);
            }

            @Override
            public int addToArray(@NotNull double[] dArray, int n, int n2, int n3) {
                return DoubleIndexable.this.addToArray(dArray, n, n2, n3);
            }
        };
    }

    public static abstract class Base
    implements DoubleIndexable,
    Comparable<DoubleIndexable> {
        @Override
        public int compareTo(@NotNull DoubleIndexable doubleIndexable) {
            Objects.requireNonNull(doubleIndexable);
            return DoubleIndexable.compare(this, doubleIndexable);
        }

        public int hashCode() {
            return DoubleIndexable.hash(this);
        }

        public boolean equals(Object object) {
            return DoubleIndexable.equal((DoubleIndexable)this, object);
        }

        public String toString() {
            return DoubleIndexable.toString(this);
        }

        @Override
        @NotNull
        public Base asBase() {
            return this;
        }
    }

    public static class DoubleIndexableSpliterator
    implements Spliterator.OfDouble {
        @NotNull
        private final DoubleIndexable indexable;
        private int index;
        private final int fence;
        private final int character;

        public DoubleIndexableSpliterator(@NotNull DoubleIndexable doubleIndexable) {
            this(doubleIndexable, 0, doubleIndexable.size(), false);
        }

        public DoubleIndexableSpliterator(@NotNull DoubleIndexable doubleIndexable, int n, int n2, boolean bl) {
            this(doubleIndexable, n, n2, bl ? 17488 : 16464);
        }

        private DoubleIndexableSpliterator(@NotNull DoubleIndexable doubleIndexable, int n, int n2, int n3) {
            this.indexable = doubleIndexable;
            this.index = n;
            this.fence = n2;
            this.character = n3;
        }

        @Override
        public Spliterator.OfDouble trySplit() {
            int n = this.index;
            int n2 = (n + this.fence) / 2;
            if (n < n2) {
                this.index = n2;
                return new DoubleIndexableSpliterator(this.indexable, n, n2, this.character);
            }
            return null;
        }

        @Override
        public boolean tryAdvance(@NotNull DoubleConsumer doubleConsumer) {
            if (this.index < this.fence) {
                doubleConsumer.accept(this.indexable.get(this.index++));
                return true;
            }
            return false;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return this.character;
        }
    }
}

