/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Countable;
import de.caff.generics.Types;
import de.caff.generics.function.FragileFunction2;
import de.caff.generics.function.FragileProcedure2;
import de.caff.generics.tuple.ITuple2;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Dict<K, V> {
    public static final Dict<?, ?> EMPTY = new Base<Object, Object>(){

        @Override
        @Nullable
        public Object get(Object object) {
            return null;
        }

        @Override
        @NotNull
        public Object getNonNull(Object object) {
            throw new NullPointerException("Empty dict has no elements!");
        }

        @Override
        @NotNull
        public Object getOrDefault(Object object, @NotNull Object object2) {
            return object2;
        }

        @Override
        @Nullable
        public Object require(Object object) {
            throw new NoSuchElementException("Empty dict has no elements!");
        }

        @Override
        @NotNull
        public Countable<Entry<Object, Object>> entries() {
            return Countable.empty();
        }

        @Override
        public boolean hasKey(Object object) {
            return false;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public <NV> Dict<Object, NV> valueView(@NotNull Function<? super Object, ? extends NV> function) {
            return this;
        }

        @Override
        @NotNull
        public Countable<Object> values() {
            return Countable.empty();
        }

        @Override
        @NotNull
        public Countable<Object> keys() {
            return Countable.empty();
        }

        @Override
        @NotNull
        public Dict<Object, Object> frozen() {
            return this;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof Dict && ((Dict)object).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        @NotNull
        public String toString() {
            return "{}";
        }
    };

    @NotNull
    public static <TK, TV> Dict<TK, TV> fromTuples(@NotNull Iterable<? extends ITuple2<? extends TK, ? extends TV>> iterable) {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        iterable.forEach(iTuple2 -> linkedHashMap.put(iTuple2._1(), iTuple2._2()));
        return Dict.viewMap(linkedHashMap);
    }

    @Nullable
    public V get(K var1);

    @NotNull
    public Countable<Entry<K, V>> entries();

    @NotNull
    default public V getNonNull(K k) {
        return Objects.requireNonNull(this.get(k));
    }

    @NotNull
    default public V getOrDefault(K k, @NotNull V v) {
        return Types.notNull(this.get(k), v);
    }

    default public V getOr(K k, @NotNull Function<? super K, ? extends V> function) {
        V v = this.get(k);
        return v != null ? v : Objects.requireNonNull(function.apply(k));
    }

    @Nullable
    default public V require(K k) {
        V v = this.get(k);
        if (v == null && !this.hasKey(k)) {
            throw new NoSuchElementException("No element for key " + k);
        }
        return v;
    }

    @NotNull
    default public V requireNonNull(K k) {
        V v = this.get(k);
        if (v == null) {
            if (!this.hasKey(k)) {
                throw new NoSuchElementException("No element for key " + k);
            }
            throw new NullPointerException("Value of key " + k + " is null");
        }
        return v;
    }

    default public int size() {
        return this.entries().size();
    }

    default public boolean isEmpty() {
        return this.entries().isEmpty();
    }

    default public boolean hasKey(K k) {
        return this.get(k) != null;
    }

    @NotNull
    default public <NV> Dict<K, NV> valueView(final @NotNull Function<? super V, ? extends NV> function) {
        return new Base<K, NV>(){

            @Override
            @Nullable
            public NV get(@NotNull K k) {
                Object v = Dict.this.get(k);
                return v != null ? (Object)function.apply(v) : null;
            }

            @Override
            public boolean hasKey(@NotNull K k) {
                return Dict.this.hasKey(k);
            }

            @Override
            @NotNull
            public Countable<Entry<K, NV>> entries() {
                return Dict.this.entries().view(entry -> entry.valueView(function));
            }

            @Override
            @NotNull
            public Countable<NV> values() {
                return Dict.this.values().view(function);
            }

            @Override
            public int size() {
                return Dict.this.size();
            }

            @Override
            public boolean isEmpty() {
                return Dict.this.isEmpty();
            }
        };
    }

    @NotNull
    default public Base<K, V> asBase() {
        return new Base<K, V>(){

            @Override
            @Nullable
            public V get(K k) {
                return Dict.this.get(k);
            }

            @Override
            @NotNull
            public Countable<Entry<K, V>> entries() {
                return Dict.this.entries();
            }

            @Override
            public int size() {
                return Dict.this.size();
            }

            @Override
            public boolean isEmpty() {
                return Dict.this.isEmpty();
            }

            @Override
            public boolean hasKey(K k) {
                return Dict.this.hasKey(k);
            }

            @Override
            @NotNull
            public <NV> Dict<K, NV> valueView(@NotNull Function<? super V, ? extends NV> function) {
                return Dict.this.valueView(function);
            }
        };
    }

    @NotNull
    default public Dict<K, V> frozen() {
        if (this.isEmpty()) {
            return Dict.empty();
        }
        final LinkedHashMap linkedHashMap = new LinkedHashMap(this.size());
        this.entries().forEach(entry -> linkedHashMap.put(entry.getKey(), entry.getValue()));
        return new Base<K, V>(){

            @Override
            @Nullable
            public V get(K k) {
                return linkedHashMap.get(k);
            }

            @Override
            @NotNull
            public Countable<Entry<K, V>> entries() {
                Set set = linkedHashMap.entrySet();
                return Countable.viewCollection(set, Entry::viewMapEntry);
            }

            @Override
            public int size() {
                return linkedHashMap.size();
            }

            @Override
            public boolean isEmpty() {
                return linkedHashMap.isEmpty();
            }

            @Override
            public boolean hasKey(K k) {
                return linkedHashMap.containsKey(k);
            }

            @Override
            @NotNull
            public Dict<K, V> frozen() {
                return this;
            }
        };
    }

    @NotNull
    default public Countable<V> values() {
        return this.entries().view(Entry::getValue);
    }

    @NotNull
    default public Countable<K> keys() {
        return this.entries().view(Entry::getKey);
    }

    @NotNull
    default public Dict<K, V> filtered(@NotNull Predicate<? super Entry<? super K, ? super V>> predicate) {
        final LinkedHashMap linkedHashMap = new LinkedHashMap();
        this.entries().forEach(entry -> {
            if (predicate.test((Object)entry)) {
                linkedHashMap.put(entry.getKey(), entry.getValue());
            }
        });
        if (linkedHashMap.isEmpty()) {
            return Dict.empty();
        }
        return new Base<K, V>(){

            @Override
            @Nullable
            public V get(K k) {
                return linkedHashMap.get(k);
            }

            @Override
            @NotNull
            public Countable<Entry<K, V>> entries() {
                return Countable.viewCollection(linkedHashMap.entrySet(), Entry::viewMapEntry);
            }

            @Override
            public int size() {
                return linkedHashMap.size();
            }

            @Override
            public boolean isEmpty() {
                return true;
            }

            @Override
            public boolean hasKey(K k) {
                return linkedHashMap.containsKey(k);
            }

            @Override
            @NotNull
            public Dict<K, V> frozen() {
                return this;
            }
        };
    }

    default public void forEachEntry(@NotNull BiConsumer<? super K, ? super V> biConsumer) {
        this.entries().forEach(entry -> biConsumer.accept((Object)entry.getKey(), (Object)entry.getValue()));
    }

    default public <E extends Exception> void forEachEntryFragile(@NotNull FragileProcedure2<E, ? super K, ? super V> fragileProcedure2) throws E {
        this.entries().forEachFragile(entry -> fragileProcedure2.apply((Object)entry.getKey(), (Object)entry.getValue()));
    }

    default public void addAllTo(@NotNull Map<? super K, ? super V> map) {
        this.forEachEntry(map::put);
    }

    default public boolean trySupply(@NotNull K k, @NotNull BiConsumer<? super K, ? super V> biConsumer) {
        V v = this.get(k);
        if (v == null && !this.hasKey(k)) {
            return false;
        }
        biConsumer.accept(k, v);
        return true;
    }

    default public <E extends Exception> boolean trySupplyFragile(@NotNull K k, @NotNull FragileProcedure2<E, ? super K, ? super V> fragileProcedure2) throws E {
        V v = this.get(k);
        if (v == null && !this.hasKey(k)) {
            return false;
        }
        fragileProcedure2.apply(k, v);
        return true;
    }

    default public void supplyOrElse(@NotNull K k, @NotNull BiConsumer<? super K, ? super V> biConsumer, @NotNull Consumer<? super K> consumer) {
        V v = this.get(k);
        if (v == null && !this.hasKey(k)) {
            consumer.accept(k);
        }
        biConsumer.accept(k, v);
    }

    default public <E extends Exception> void supplyFragileOrElse(@NotNull K k, @NotNull FragileProcedure2<E, ? super K, ? super V> fragileProcedure2, @NotNull Consumer<? super K> consumer) throws E {
        V v = this.get(k);
        if (v == null && !this.hasKey(k)) {
            consumer.accept(k);
        }
        fragileProcedure2.apply(k, v);
    }

    default public <T> T digestOrElse(@NotNull K k, @NotNull BiFunction<? super K, ? super V, ? extends T> biFunction, @NotNull Function<? super K, ? extends T> function) {
        V v = this.get(k);
        if (v == null && !this.hasKey(k)) {
            return function.apply(k);
        }
        return biFunction.apply(k, v);
    }

    @Nullable
    default public <T> T digest(@NotNull K k, @NotNull BiFunction<? super K, ? super V, ? extends T> biFunction) {
        return (T)this.digestOrElse(k, biFunction, object -> null);
    }

    default public <T, E extends Exception> T digestFragileOrElse(@NotNull K k, @NotNull FragileFunction2<? extends T, E, ? super K, ? super V> fragileFunction2, @NotNull Function<? super K, ? extends T> function) throws E {
        V v = this.get(k);
        if (v == null && !this.hasKey(k)) {
            return function.apply(k);
        }
        return fragileFunction2.apply(k, v);
    }

    @Nullable
    default public <T, E extends Exception> T digestFragile(@NotNull K k, @NotNull FragileFunction2<? extends T, E, ? super K, ? super V> fragileFunction2) throws E {
        return (T)this.digestFragileOrElse(k, fragileFunction2, object -> null);
    }

    @NotNull
    public static <KT, VT> Dict<KT, VT> empty() {
        return (Base)EMPTY;
    }

    @NotNull
    public static <KT, VT> Dict<KT, VT> singleton(final @NotNull KT KT, final @NotNull VT VT) {
        final Entry<KT, VT> entry = Entry.view(KT, VT);
        return new Base<KT, VT>(){

            @Override
            @Nullable
            public VT get(KT KT2) {
                return KT.equals(KT2) ? VT : null;
            }

            @Override
            @NotNull
            public Countable<Entry<KT, VT>> entries() {
                return Countable.singleton(entry);
            }

            @Override
            @NotNull
            public Countable<VT> values() {
                return Countable.singleton(VT);
            }

            @Override
            @NotNull
            public Countable<KT> keys() {
                return Countable.singleton(KT);
            }

            @Override
            public int size() {
                return 1;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            public boolean hasKey(KT KT2) {
                return KT2.equals(KT);
            }

            @Override
            @NotNull
            public Dict<KT, VT> frozen() {
                return this;
            }

            @Override
            public String toString() {
                return "{" + entry + "}";
            }
        };
    }

    @NotNull
    public static <MK, MV> Dict<MK, MV> viewMap(final @NotNull Map<? extends MK, ? extends MV> map) {
        return new Base<MK, MV>(){

            @Override
            @Nullable
            public MV get(MK MK) {
                return map.get(MK);
            }

            @Override
            @NotNull
            public Countable<Entry<MK, MV>> entries() {
                return Countable.viewCollection(map.entrySet(), Entry::viewMapEntry);
            }

            @Override
            @NotNull
            public Countable<MV> values() {
                return Countable.viewCollection(map.values());
            }

            @Override
            @NotNull
            public Countable<MK> keys() {
                return Countable.viewCollection(map.keySet());
            }

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean isEmpty() {
                return map.isEmpty();
            }

            @Override
            public boolean hasKey(MK MK) {
                return map.containsKey(MK);
            }
        };
    }

    @NotNull
    public static <MK, MV> Dict<MK, MV> viewNullableMap(@Nullable Map<? extends MK, ? extends MV> map) {
        return map == null ? Dict.empty() : Dict.viewMap(map);
    }

    @NotNull
    public static <MK, MV, DV> Dict<MK, DV> viewMap(final @NotNull Map<MK, MV> map, final @NotNull Function<? super MV, ? extends DV> function) {
        return new Base<MK, DV>(){

            @Override
            @Nullable
            public DV get(MK MK) {
                return function.apply(map.get(MK));
            }

            @Override
            @NotNull
            public Countable<Entry<MK, DV>> entries() {
                Set set = map.entrySet();
                return Countable.viewCollection(set, entry -> Entry.viewMapEntry(entry).valueView(function));
            }

            @Override
            public int size() {
                return map.size();
            }

            @Override
            public boolean isEmpty() {
                return map.isEmpty();
            }

            @Override
            public boolean hasKey(MK MK) {
                return map.containsKey(MK);
            }

            @Override
            @NotNull
            public Countable<DV> values() {
                return Countable.viewCollection(map.values(), function);
            }

            @Override
            @NotNull
            public Countable<MK> keys() {
                return Countable.viewCollection(map.keySet());
            }
        };
    }

    @NotNull
    public static <MK, MV, DV> Dict<MK, DV> viewNullableMap(@Nullable Map<MK, MV> map, @NotNull Function<? super MV, ? extends DV> function) {
        return map == null ? Dict.empty() : Dict.viewMap(map, function);
    }

    @NotNull
    public static <MK1, MK2, MV> Dict<MK1, Dict<MK2, MV>> viewMap2(@NotNull Map<MK1, Map<MK2, MV>> map2) {
        return Dict.viewMap(map2, map -> map != null ? Dict.viewMap(map) : null);
    }

    @NotNull
    public static <MK1, MK2, MV, DV> Dict<MK1, Dict<MK2, DV>> viewMap2(@NotNull Map<MK1, Map<MK2, MV>> map2, @NotNull Function<? super MV, ? extends DV> function) {
        return Dict.viewMap(map2, map -> map != null ? Dict.viewMap(map, function) : null);
    }

    public static <KK, VV> boolean equal(@NotNull Dict<KK, VV> dict, @NotNull Object object) {
        if (object == dict) {
            return true;
        }
        if (!(object instanceof Dict)) {
            return false;
        }
        Dict dict2 = (Dict)object;
        if (dict2.size() != dict.size()) {
            return false;
        }
        return Types.areEqual(dict.entries(), dict2.entries());
    }

    @NotNull
    public static String toString(@NotNull Dict<?, ?> dict) {
        return "{" + Types.join(", ", Types.view(dict.entries(), Object::toString)) + "}";
    }

    public static abstract class Entry<EK, EV>
    implements ITuple2<EK, EV> {
        public abstract EK getKey();

        public abstract EV getValue();

        @NotNull
        public EV getNonNullValue() {
            return Objects.requireNonNull(this.getValue());
        }

        @NotNull
        public EV getValueOrDefault(@NotNull EV EV) {
            return Types.notNull(this.getValue(), EV);
        }

        @Override
        public EK _1() {
            return this.getKey();
        }

        @Override
        public EV _2() {
            return this.getValue();
        }

        @NotNull
        public <NEK> Entry<NEK, EV> keyView(final @NotNull Function<? super EK, ? extends NEK> function) {
            return new Entry<NEK, EV>(){

                @Override
                public NEK getKey() {
                    return function.apply(this.getKey());
                }

                @Override
                public EV getValue() {
                    return this.getValue();
                }
            };
        }

        @NotNull
        public <NEV> Entry<EK, NEV> valueView(final @NotNull Function<? super EV, ? extends NEV> function) {
            return new Entry<EK, NEV>(){

                @Override
                public EK getKey() {
                    return this.getKey();
                }

                @Override
                public NEV getValue() {
                    return function.apply(this.getValue());
                }
            };
        }

        @NotNull
        public <NEK, NEV> Entry<NEK, NEV> viewMapped(final @NotNull Function<? super EK, ? extends NEK> function, final @NotNull Function<? super EV, ? extends NEV> function2) {
            return new Entry<NEK, NEV>(){

                @Override
                public NEK getKey() {
                    return function.apply(this.getKey());
                }

                @Override
                public NEV getValue() {
                    return function2.apply(this.getValue());
                }
            };
        }

        @NotNull
        public String toString() {
            return String.format("%s\u2192%s", this.getKey(), this.getValue());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Dict)) {
                return false;
            }
            Entry entry = (Entry)object;
            return this.getKey().equals(entry.getKey()) && this.getValue().equals(entry.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getKey(), this.getValue());
        }

        @NotNull
        public static <KT, VT> Entry<KT, VT> view(final KT KT, final @NotNull VT VT) {
            return new Entry<KT, VT>(){

                @Override
                public KT getKey() {
                    return KT;
                }

                @Override
                public VT getValue() {
                    return VT;
                }
            };
        }

        @NotNull
        public static <MEK, MEV> Entry<MEK, MEV> viewMapEntry(@NotNull Map.Entry<? extends MEK, ? extends MEV> entry) {
            final MEK MEK = entry.getKey();
            final MEV MEV = entry.getValue();
            if (MEV == null) {
                throw new IllegalArgumentException("entry has null value!");
            }
            return new Entry<MEK, MEV>(){

                @Override
                public MEK getKey() {
                    return MEK;
                }

                @Override
                public MEV getValue() {
                    return MEV;
                }
            };
        }
    }

    public static abstract class Base<KK, VV>
    implements Dict<KK, VV> {
        @Override
        @NotNull
        public Base<KK, VV> asBase() {
            return this;
        }

        public boolean equals(Object object) {
            return Dict.equal(this, object);
        }

        public int hashCode() {
            return Types.hash(this.entries());
        }

        public String toString() {
            return Dict.toString(this);
        }
    }
}

