/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.ArrayIterator;
import de.caff.generics.ConcatenatedIterators;
import de.caff.generics.Dict;
import de.caff.generics.Empty;
import de.caff.generics.FilteringIteratorWrapper;
import de.caff.generics.Indexable;
import de.caff.generics.IndexableHelper;
import de.caff.generics.IteratorConverter;
import de.caff.generics.Pair;
import de.caff.generics.SingletonIterator;
import de.caff.generics.Sizeable;
import de.caff.generics.Types;
import de.caff.generics.function.FragileFunction1;
import de.caff.generics.function.FragileProcedure1;
import de.caff.generics.util.Counter;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public interface Countable<T>
extends Iterable<T>,
Sizeable {
    public static final Countable<Object> EMPTY = new Base<Object>(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public Iterator<Object> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        @NotNull
        public Collection<Object> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public Object[] toArray() {
            return Empty.OBJECT_ARRAY;
        }

        @Override
        public int addToArray(@NotNull Object[] objectArray, int n) {
            return n;
        }

        @Override
        @NotNull
        public <R> Countable<R> view(@NotNull Function<? super Object, ? extends R> function) {
            return Countable.empty();
        }

        @Override
        @NotNull
        public <R, E extends Exception> Countable<R> viewFragile(@NotNull FragileFunction1<? extends R, E, ? super Object> fragileFunction1) {
            return Countable.empty();
        }

        @Override
        public <V> V foldLeft(V v, @NotNull BiFunction<? super V, ? super Object, ? extends V> biFunction) {
            return v;
        }

        @Override
        @NotNull
        public ArrayList<Object> toList() {
            return new ArrayList<Object>();
        }

        @Override
        public void addAllTo(@NotNull Collection<? super Object> collection) {
        }

        @Override
        @NotNull
        public Object[] toArray(@NotNull Class<Object> clazz) {
            return Empty.OBJECT_ARRAY;
        }

        @Override
        @NotNull
        public Iterable<Object> filtered(@NotNull Predicate<? super Object> predicate) {
            return Types.emptyIterable();
        }

        @Override
        @NotNull
        public Countable<Object> filterToCountable(@NotNull Predicate<? super Object> predicate) {
            return this;
        }

        @Override
        @NotNull
        public Indexable<Object> filteredToIndexable(@NotNull Predicate<? super Object> predicate) {
            return Indexable.emptyIndexable();
        }

        @Override
        public <E extends Exception> void forEachFragile(@NotNull FragileProcedure1<E, ? super Object> fragileProcedure1) throws E {
        }

        @Override
        public void forEach(Consumer<? super Object> consumer) {
        }

        @Override
        @NotNull
        public Indexable<Object> sorted(@NotNull Comparator<? super Object> comparator) {
            return Indexable.emptyIndexable();
        }

        @Override
        public boolean isSorted(@NotNull Comparator<? super Object> comparator) {
            return true;
        }

        @Override
        public boolean isStrictlySorted(@NotNull Comparator<? super Object> comparator) {
            return true;
        }

        @Override
        public Object first() {
            throw new NoSuchElementException("No first element in an empty countable!");
        }

        @Override
        @Nullable
        public Object firstOrNull() {
            return null;
        }

        @Override
        @NotNull
        public Optional<Object> optFirst() {
            return Optional.empty();
        }

        @Override
        public Object last() {
            throw new NoSuchElementException("No last element in an empty countable!");
        }

        @Override
        public Object lastOrNull() {
            return null;
        }

        @Override
        @NotNull
        public Optional<Object> optLast() {
            return Optional.empty();
        }

        @Override
        @NotNull
        public Countable<Object> withPrependedItem(Object object) {
            return Countable.singleton(object);
        }

        @Override
        @NotNull
        public Countable<Object> withAppendedItem(Object object) {
            return Countable.singleton(object);
        }

        @Override
        public boolean containsEq(Object object) {
            return false;
        }

        @Override
        public boolean containsRef(Object object) {
            return false;
        }

        @Override
        public boolean hasAny(@NotNull Predicate<? super Object> predicate) {
            return false;
        }

        @Override
        @Nullable
        public Object getAny(@NotNull Predicate<? super Object> predicate) {
            return null;
        }

        @Override
        public boolean hasAll(@NotNull Predicate<? super Object> predicate) {
            return true;
        }

        @Override
        @NotNull
        public <K> Dict<K, Indexable<Object>> groupingBy(@NotNull Function<? super Object, ? extends K> function) {
            return Dict.empty();
        }

        @Override
        @NotNull
        public <K, V> Dict<K, Indexable<V>> groupingBy(@NotNull Function<? super Object, ? extends K> function, @NotNull Function<? super Object, ? extends V> function2) {
            return Dict.empty();
        }

        @Override
        @NotNull
        public <K> Dict<K, Object> mappingBy(boolean bl, @NotNull Function<? super Object, ? extends K> function) {
            return Dict.empty();
        }

        @Override
        @NotNull
        public <K, V> Dict<K, V> mappingBy(boolean bl, @NotNull Function<? super Object, ? extends K> function, @NotNull Function<? super Object, ? extends V> function2) {
            return Dict.empty();
        }

        @Override
        @NotNull
        public Indexable<Object> frozen() {
            return Indexable.emptyIndexable();
        }

        @Override
        @NotNull
        public Indexable<Object> frozen(@NotNull Function<? super Object, ?> function, boolean bl) {
            return Indexable.emptyIndexable();
        }

        @Override
        @NotNull
        public Spliterator<Object> spliterator() {
            return Spliterators.emptySpliterator();
        }

        @Override
        @NotNull
        public Stream<Object> stream() {
            return Stream.empty();
        }

        @Override
        @NotNull
        public Stream<Object> parellelStream() {
            return Stream.empty();
        }
    };

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @NotNull
    default public Collection<T> asCollection() {
        return new AbstractCollection<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return Countable.this.iterator();
            }

            @Override
            public int size() {
                return Countable.this.size();
            }
        };
    }

    @NotNull
    default public ArrayList<T> toList() {
        ArrayList arrayList = new ArrayList(this.size());
        this.addAllTo(arrayList);
        return arrayList;
    }

    default public void addAllTo(@NotNull Collection<? super T> collection) {
        for (Object t : this) {
            collection.add(t);
        }
    }

    @NotNull
    default public Object[] toArray() {
        int n = this.size();
        if (n == 0) {
            return Empty.OBJECT_ARRAY;
        }
        Object[] objectArray = new Object[n];
        this.addToArray(objectArray, 0);
        return objectArray;
    }

    @NotNull
    default public T[] toArray(@NotNull Class<T> clazz) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, this.size());
        this.addToArray(objectArray, 0);
        return objectArray;
    }

    default public int addToArray(@NotNull T[] TArray, int n) {
        for (Object t : this) {
            TArray[n++] = t;
        }
        return n;
    }

    @NotNull
    default public <R> Countable<R> view(final @NotNull Function<? super T, ? extends R> function) {
        return new Base<R>(){

            @Override
            public int size() {
                return Countable.this.size();
            }

            @Override
            @NotNull
            public Iterator<R> iterator() {
                return new IteratorConverter(Countable.this.iterator(), function);
            }

            @Override
            public boolean isEmpty() {
                return Countable.this.isEmpty();
            }
        };
    }

    @NotNull
    default public <R, E extends Exception> Countable<R> viewFragile(@NotNull FragileFunction1<? extends R, E, ? super T> fragileFunction1) {
        return this.view(fragileFunction1.nonFragile());
    }

    @NotNull
    default public Iterable<T> filtered(@NotNull Predicate<? super T> predicate) {
        return () -> new FilteringIteratorWrapper(this.iterator(), predicate);
    }

    @NotNull
    default public Countable<T> filterToCountable(@NotNull Predicate<? super T> predicate) {
        return Countable.viewCollection(Types.filter(this, predicate));
    }

    @NotNull
    default public Indexable<T> filteredToIndexable(@NotNull Predicate<? super T> predicate) {
        ArrayList arrayList = new ArrayList(this.size());
        Types.filter(arrayList, this, predicate);
        arrayList.trimToSize();
        return IndexableHelper.frozenFromList(arrayList);
    }

    default public <E extends Exception> void forEachFragile(@NotNull FragileProcedure1<E, ? super T> fragileProcedure1) throws E {
        for (Object t : this) {
            fragileProcedure1.apply(t);
        }
    }

    default public <V> V foldLeft(V v, @NotNull BiFunction<? super V, ? super T, ? extends V> biFunction) {
        return Types.foldLeft(this, v, biFunction);
    }

    @NotNull
    default public Indexable<T> frozen() {
        ArrayList<T> arrayList = this.toList();
        arrayList.trimToSize();
        return IndexableHelper.frozenFromList(arrayList);
    }

    @NotNull
    public static <TT> Indexable<TT> freeze(@NotNull Countable<? extends TT> countable) {
        return countable.frozen();
    }

    @NotNull
    default public Indexable<T> sorted(@NotNull Comparator<? super T> comparator) {
        ArrayList<T> arrayList = this.toList();
        arrayList.trimToSize();
        arrayList.sort(comparator);
        return IndexableHelper.frozenFromList(arrayList);
    }

    default public boolean isSorted(@NotNull Comparator<? super T> comparator) {
        if (this.size() < 2) {
            return true;
        }
        Iterator iterator = this.iterator();
        Object t = iterator.next();
        while (iterator.hasNext()) {
            Object t2 = iterator.next();
            if (comparator.compare(t, t2) > 0) {
                return false;
            }
            t = t2;
        }
        return true;
    }

    default public boolean isStrictlySorted(@NotNull Comparator<? super T> comparator) {
        if (this.size() < 2) {
            return true;
        }
        Iterator iterator = this.iterator();
        Object t = iterator.next();
        while (iterator.hasNext()) {
            Object t2 = iterator.next();
            if (comparator.compare(t, t2) >= 0) {
                return false;
            }
            t = t2;
        }
        return true;
    }

    @NotNull
    default public Indexable<T> frozen(@NotNull Function<? super T, ? extends T> function, boolean bl) {
        ArrayList<T> arrayList = new ArrayList<T>(this.size());
        for (Object t : this) {
            arrayList.add(function.apply(t));
        }
        arrayList.trimToSize();
        return bl ? IndexableHelper.frozenFromList(arrayList, function) : IndexableHelper.frozenFromList(arrayList);
    }

    default public T first() {
        return this.iterator().next();
    }

    @Nullable
    default public T firstOrNull() {
        return this.isEmpty() ? null : (T)this.first();
    }

    @NotNull
    default public Optional<T> optFirst() {
        return this.isEmpty() ? Optional.empty() : Optional.of(this.first());
    }

    default public T last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("No last element because there are no elements!");
        }
        T t = null;
        for (Object t2 : this) {
            t = t2;
        }
        return t;
    }

    default public T lastOrNull() {
        return this.isEmpty() ? null : (T)this.last();
    }

    @NotNull
    default public Optional<T> optLast() {
        return this.isEmpty() ? Optional.empty() : Optional.of(this.last());
    }

    @NotNull
    default public Countable<T> withPrependedItem(final T t) {
        return new Base<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<T> basicIterator;

                    @Override
                    public boolean hasNext() {
                        return this.basicIterator == null || this.basicIterator.hasNext();
                    }

                    @Override
                    public T next() {
                        if (this.basicIterator == null) {
                            this.basicIterator = Countable.this.iterator();
                            return t;
                        }
                        return this.basicIterator.next();
                    }
                };
            }

            @Override
            public int size() {
                return Countable.this.size() + 1;
            }
        };
    }

    @NotNull
    default public Countable<T> withAppendedItem(final T t) {
        return new Base<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                return new Iterator<T>(){
                    Iterator<T> basicIterator;
                    {
                        this.basicIterator = Countable.this.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.basicIterator != null && this.basicIterator.hasNext();
                    }

                    @Override
                    public T next() {
                        if (this.basicIterator == null) {
                            throw new NoSuchElementException("No more elements available!");
                        }
                        if (this.basicIterator.hasNext()) {
                            return this.basicIterator.next();
                        }
                        this.basicIterator = null;
                        return t;
                    }
                };
            }

            @Override
            public int size() {
                return Countable.this.size() + 1;
            }
        };
    }

    default public boolean containsEq(T t) {
        return this.hasAny(object2 -> Objects.deepEquals(t, object2));
    }

    default public boolean containsRef(T t) {
        return this.hasAny(object2 -> t == object2);
    }

    default public boolean hasAny(@NotNull Predicate<? super T> predicate) {
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    default public T getAny(@NotNull Predicate<? super T> predicate) {
        for (Object t : this) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    default public boolean hasAll(@NotNull Predicate<? super T> predicate) {
        for (Object t : this) {
            if (predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public <K> Dict<K, Indexable<T>> groupingBy(@NotNull Function<? super T, ? extends K> function) {
        HashMap<Object, List> hashMap = new HashMap<Object, List>();
        for (Object t : this) {
            hashMap.computeIfAbsent(function.apply(t), object -> new ArrayList()).add(t);
        }
        return Dict.viewMap(hashMap, Indexable::viewList);
    }

    @NotNull
    default public <K, V> Dict<K, Indexable<V>> groupingBy(@NotNull Function<? super T, ? extends K> function, @NotNull Function<? super T, ? extends V> function2) {
        HashMap<Object, List> hashMap = new HashMap<Object, List>();
        for (Object t : this) {
            hashMap.computeIfAbsent(function.apply(t), object -> new ArrayList()).add(function2.apply(t));
        }
        return Dict.viewMap(hashMap, Indexable::viewList);
    }

    @NotNull
    default public <K> Dict<K, T> mappingBy(boolean bl, @NotNull Function<? super T, ? extends K> function) {
        HashMap hashMap = new HashMap();
        if (bl) {
            for (Object t : this) {
                hashMap.putIfAbsent(function.apply(t), t);
            }
        } else {
            for (Object t : this) {
                hashMap.put(function.apply(t), t);
            }
        }
        return Dict.viewMap(hashMap);
    }

    @NotNull
    default public <K, V> Dict<K, V> mappingBy(boolean bl, @NotNull Function<? super T, ? extends K> function, @NotNull Function<? super T, ? extends V> function2) {
        HashMap<K, V> hashMap = new HashMap<K, V>();
        if (bl) {
            for (Object t : this) {
                hashMap.putIfAbsent(function.apply(t), function2.apply(t));
            }
        } else {
            for (Object t : this) {
                hashMap.put(function.apply(t), function2.apply(t));
            }
        }
        return Dict.viewMap(hashMap);
    }

    @NotNull
    default public Base<T> asBase() {
        return new Base<T>(){

            @Override
            public Iterator<T> iterator() {
                return Countable.this.iterator();
            }

            @Override
            public int size() {
                return Countable.this.size();
            }
        };
    }

    default public <E> boolean equals(@NotNull Countable<E> countable, @NotNull BiPredicate<? super T, ? super E> biPredicate) {
        return Countable.equal(this, countable, biPredicate);
    }

    @Override
    @NotNull
    default public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 0);
    }

    @NotNull
    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @NotNull
    default public Stream<T> parellelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    @NotNull
    public static <E> Countable<E> viewCollection(final @NotNull Collection<? extends E> collection) {
        return new Base<E>(){

            @Override
            public int size() {
                return collection.size();
            }

            @Override
            @NotNull
            public Iterator<E> iterator() {
                final Iterator iterator = collection.iterator();
                return new Iterator<E>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public E next() {
                        return iterator.next();
                    }
                };
            }

            @Override
            @NotNull
            public Collection<E> asCollection() {
                return Collections.unmodifiableCollection(collection);
            }
        };
    }

    @NotNull
    public static <E> Countable<E> viewCollectionN(@Nullable Collection<? extends E> collection) {
        return collection == null ? Countable.empty() : Countable.viewCollection(collection);
    }

    @NotNull
    public static <E, T> Countable<T> viewCollection(final @NotNull Collection<E> collection, final @NotNull Function<? super E, ? extends T> function) {
        if (collection.isEmpty()) {
            return Countable.empty();
        }
        return new Base<T>(){

            @Override
            public int size() {
                return collection.size();
            }

            @Override
            @NotNull
            public Iterator<T> iterator() {
                final Iterator iterator = collection.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return function.apply(iterator.next());
                    }
                };
            }
        };
    }

    @NotNull
    public static <E, T> Countable<T> viewCollectionN(@Nullable Collection<E> collection, @NotNull Function<? super E, ? extends T> function) {
        return collection == null ? Countable.empty() : Countable.viewCollection(collection, function);
    }

    @SafeVarargs
    @NotNull
    public static <E> Countable<E> viewArray(final E ... EArray) {
        if (EArray.length == 0) {
            return Countable.empty();
        }
        return new Base<E>(){

            @Override
            public int size() {
                return EArray.length;
            }

            @Override
            @NotNull
            public Iterator<E> iterator() {
                return new ArrayIterator<Object>(EArray);
            }
        };
    }

    @NotNull
    public static <E> Countable<E> viewArray(final @NotNull E[] EArray, final int n, final int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("start has to be non-negative, but is " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("length has to be non-negative, but is " + n2);
        }
        if (n > EArray.length - n2) {
            throw new IllegalArgumentException(String.format("End %d+%d=%d lies outside range for array with %d elements!", n, n2, (long)n + (long)n2, EArray.length));
        }
        if (n2 == 0) {
            return Countable.empty();
        }
        return new Base<E>(){

            @Override
            public int size() {
                return n2;
            }

            @Override
            @NotNull
            public Iterator<E> iterator() {
                return new ArrayIterator<Object>(EArray, n, n2);
            }
        };
    }

    @NotNull
    public static <E> Countable<E> downCast(@NotNull Countable<? extends E> countable) {
        return countable;
    }

    @NotNull
    public static <E> Countable<E> empty() {
        return EMPTY;
    }

    @NotNull
    public static <E> Countable<E> singleton(final E e) {
        return new Base<E>(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public Iterator<E> iterator() {
                return new SingletonIterator<Object>(e);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public Indexable<E> frozen() {
                return Indexable.singleton(e);
            }

            @Override
            @NotNull
            public Indexable<E> sorted(@NotNull Comparator<? super E> comparator) {
                return Indexable.singleton(e);
            }

            @Override
            public boolean isSorted(@NotNull Comparator<? super E> comparator) {
                return true;
            }

            @Override
            public boolean isStrictlySorted(@NotNull Comparator<? super E> comparator) {
                return true;
            }

            @Override
            public E first() {
                return e;
            }

            @Override
            @NotNull
            public E firstOrNull() {
                return e;
            }

            @Override
            @NotNull
            public Optional<E> optFirst() {
                return Optional.of(e);
            }

            @Override
            public E last() {
                return e;
            }

            @Override
            public E lastOrNull() {
                return e;
            }

            @Override
            @NotNull
            public Optional<E> optLast() {
                return Optional.of(e);
            }

            @Override
            @NotNull
            public <K> Dict<K, Indexable<E>> groupingBy(@NotNull Function<? super E, ? extends K> function) {
                return Dict.singleton(function.apply(e), Indexable.singleton(e));
            }

            @Override
            @NotNull
            public <K, V> Dict<K, Indexable<V>> groupingBy(@NotNull Function<? super E, ? extends K> function, @NotNull Function<? super E, ? extends V> function2) {
                return Dict.singleton(function.apply(e), Indexable.singleton(function2.apply(e)));
            }

            @Override
            @NotNull
            public <K> Dict<K, E> mappingBy(boolean bl, @NotNull Function<? super E, ? extends K> function) {
                return Dict.singleton(function.apply(e), e);
            }

            @Override
            @NotNull
            public <K, V> Dict<K, V> mappingBy(boolean bl, @NotNull Function<? super E, ? extends K> function, @NotNull Function<? super E, ? extends V> function2) {
                return Dict.singleton(function.apply(e), function2.apply(e));
            }
        };
    }

    @NotNull
    public static <E> Countable<E> optional(@Nullable E e) {
        return e != null ? Countable.singleton(e) : Countable.empty();
    }

    @NotNull
    public static <E> Countable<E> fromOptional(@NotNull Optional<E> optional) {
        return optional.map(Countable::singleton).orElseGet(Countable::empty);
    }

    @NotNull
    public static <E> Countable<E> uniform(final @NotNull E e, final int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Count has to be positive or 0, but is " + n);
        }
        if (n == 0) {
            return Countable.empty();
        }
        if (n == 1) {
            return Countable.singleton(e);
        }
        return new Base<E>(){

            @Override
            public int size() {
                return n;
            }

            @Override
            @NotNull
            public Iterator<E> iterator() {
                return new Iterator<E>(){
                    private int index = 0;

                    @Override
                    public boolean hasNext() {
                        return this.index < n;
                    }

                    @Override
                    public E next() {
                        if (this.index >= n) {
                            throw new NoSuchElementException("No element " + this.index + " in this Countable!");
                        }
                        ++this.index;
                        return e;
                    }
                };
            }
        };
    }

    @SafeVarargs
    @NotNull
    public static <E> Countable<E> combined(Countable<? extends E> ... countableArray) {
        return Countable.combined(Countable.viewArray(countableArray));
    }

    @NotNull
    public static <E> Countable<E> combined(final @NotNull Countable<? extends Countable<? extends E>> countable) {
        switch (countable.size()) {
            case 0: {
                return Countable.empty();
            }
            case 1: {
                return countable.first();
            }
        }
        return new Base<E>(){

            @Override
            public Iterator<E> iterator() {
                return new ConcatenatedIterators(countable.view(countable -> countable.iterator()));
            }

            @Override
            public int size() {
                Counter counter = Counter.SIMPLE.get();
                countable.forEach(countable -> counter.add(countable.size()));
                return counter.getValue();
            }
        };
    }

    @NotNull
    public static <VV> Indexable<Pair<VV>> orderedCombination(@NotNull Countable<VV> countable, @NotNull Countable<VV> countable2, @NotNull Comparator<? super VV> comparator) {
        Indexable<VV> indexable = countable.sorted(comparator);
        Indexable<VV> indexable2 = countable2.sorted(comparator);
        int n = indexable.size();
        int n2 = indexable2.size();
        ArrayList<Pair<Object>> arrayList = new ArrayList<Pair<Object>>(Math.max(n, n2));
        int n3 = 0;
        int n4 = 0;
        while (n3 < n && n4 < n2) {
            VV VV;
            VV VV2 = indexable.get(n3);
            int n5 = comparator.compare(VV2, VV = indexable2.get(n4));
            if (n5 == 0) {
                arrayList.add(Pair.createPair(VV2, VV));
                ++n3;
                ++n4;
                continue;
            }
            if (n5 < 0) {
                arrayList.add(Pair.createPair(VV2, null));
                ++n3;
                continue;
            }
            arrayList.add(Pair.createPair(null, VV));
            ++n4;
        }
        while (n3 < n) {
            arrayList.add(Pair.createPair(indexable.get(n3++), null));
        }
        while (n4 < n2) {
            arrayList.add(Pair.createPair(null, indexable2.get(n4++)));
        }
        arrayList.trimToSize();
        return IndexableHelper.frozenFromList(arrayList);
    }

    public static <E1, E2> boolean equal(@NotNull Countable<E1> countable, @NotNull Countable<E2> countable2, @NotNull BiPredicate<? super E1, ? super E2> biPredicate) {
        if (countable == countable2) {
            return true;
        }
        if (countable.size() != countable2.size()) {
            return false;
        }
        return Types.areEqual(countable.iterator(), countable2.iterator(), biPredicate);
    }

    @NotNull
    public static String toString(@NotNull Countable<?> countable) {
        if (countable.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        boolean bl = true;
        for (Object t : countable) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            stringBuilder.append(t);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static abstract class Base<TT>
    implements Countable<TT> {
        public int hashCode() {
            return Types.hash(this);
        }

        public boolean equals(Object object) {
            if (!(object instanceof Indexable)) {
                return false;
            }
            return Countable.equal(this, (Indexable)object, Objects::deepEquals);
        }

        public String toString() {
            return Countable.toString(this);
        }

        @Override
        @NotNull
        public Base<TT> asBase() {
            return this;
        }
    }
}

