/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.Copier;
import de.caff.generics.FStack;
import java.util.EmptyStackException;

class CopierFStackImpl<T>
implements FStack<T> {
    @NotNull
    private final Copier<T> copier;
    private final T element;
    @NotNull
    private final FStack<T> tail;

    CopierFStackImpl(@NotNull Copier<T> copier, T t, @NotNull FStack<T> fStack) {
        this.copier = copier;
        this.element = t;
        this.tail = fStack;
    }

    @Override
    public T top() {
        return this.copier.nullableCopy(this.element);
    }

    @Override
    @NotNull
    public FStack<T> push(T t) {
        return new CopierFStackImpl<T>(this.copier, t, this);
    }

    @Override
    @NotNull
    public FStack<T> pop() {
        return this.tail;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int size() {
        return 1 + this.tail.size();
    }

    static class Empty<T>
    implements FStack<T> {
        private final Copier<T> copier;

        public Empty(Copier<T> copier) {
            this.copier = copier;
        }

        @Override
        public T top() {
            throw new EmptyStackException();
        }

        @Override
        @NotNull
        public FStack<T> push(T t) {
            return new CopierFStackImpl<T>(this.copier, t, this);
        }

        @Override
        @NotNull
        public FStack<T> pop() {
            throw new EmptyStackException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int size() {
            return 0;
        }
    }
}

