/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Types;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ConcatenatedIterators<T>
implements Iterator<T> {
    @NotNull
    private final Iterator<? extends Iterator<? extends T>> iterableIterator;
    @Nullable
    private Iterator<? extends T> nextIterator;

    @SafeVarargs
    public ConcatenatedIterators(Iterator<? extends T> ... iteratorArray) {
        this(Types.asList(iteratorArray));
    }

    public ConcatenatedIterators(@NotNull Iterable<? extends Iterator<? extends T>> iterable) {
        this.iterableIterator = iterable.iterator();
        this.forward();
    }

    private void forward() {
        while (this.iterableIterator.hasNext()) {
            this.nextIterator = this.iterableIterator.next();
            if (!this.nextIterator.hasNext()) continue;
            return;
        }
        this.nextIterator = null;
    }

    @Override
    public boolean hasNext() {
        if (this.nextIterator == null) {
            return false;
        }
        return this.nextIterator.hasNext();
    }

    @Override
    public T next() {
        if (this.nextIterator == null) {
            throw new NoSuchElementException();
        }
        T t = this.nextIterator.next();
        if (!this.nextIterator.hasNext()) {
            this.forward();
        }
        return t;
    }
}

