/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.ConcatenatedIterators;
import de.caff.generics.Types;
import java.util.Iterator;
import java.util.LinkedList;

public class ConcatenatedIterables<T>
implements Iterable<T> {
    @NotNull
    private final Iterable<? extends Iterable<? extends T>> iterables;

    @SafeVarargs
    public ConcatenatedIterables(Iterable<? extends T> ... iterableArray) {
        this((Iterable<Iterable<? extends T>>)Types.asList(iterableArray));
    }

    public ConcatenatedIterables(@NotNull Iterable<? extends Iterable<? extends T>> iterable) {
        this.iterables = iterable;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new ConcatenatedIterators(Types.view(this.iterables, iterable -> iterable.iterator()));
    }

    @NotNull
    public static <U> ConcatenatedIterables<U> flatten2(@NotNull Iterable<? extends Iterable<? extends Iterable<U>>> iterable) {
        LinkedList<ConcatenatedIterables<U>> linkedList = new LinkedList<ConcatenatedIterables<U>>();
        for (Iterable<Iterable<U>> iterable2 : iterable) {
            linkedList.add(new ConcatenatedIterables<U>(iterable2));
        }
        return new ConcatenatedIterables(linkedList);
    }
}

