/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.CharIndexable;
import de.caff.generics.IntPair;
import de.caff.generics.function.CharFunction2;
import de.caff.generics.function.CharOperator2;
import de.caff.generics.function.CharPredicate2;
import de.caff.generics.tuple.Tuple;
import de.caff.generics.tuple.Tuple2;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

public final class CharPair
implements Serializable,
CharIndexable {
    private static final long serialVersionUID = -4898033497781881954L;
    public final char first;
    public final char second;

    public CharPair(char c, char c2) {
        this.first = c;
        this.second = c2;
    }

    public CharPair(@NotNull String string) {
        if (string.length() != 2) {
            throw new IllegalArgumentException(String.format("pair does not have 2 characters: \"%s\"", string));
        }
        this.first = string.charAt(0);
        this.second = string.charAt(1);
    }

    @NotNull
    public IntPair toIntPair() {
        return new IntPair(this.first, this.second);
    }

    @NotNull
    public CharPair withFirst(char c) {
        if (c == this.first) {
            return this;
        }
        return new CharPair(c, this.second);
    }

    @NotNull
    public CharPair withSecond(char c) {
        if (c == this.second) {
            return this;
        }
        return new CharPair(this.first, c);
    }

    @NotNull
    public CharPair swapped() {
        if (this.first == this.second) {
            return this;
        }
        return new CharPair(this.second, this.first);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public char get(int n) {
        switch (n) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
        }
        throw new IndexOutOfBoundsException(String.format("Pair has only 2 elements, so %d is out of bounds!", n));
    }

    public <T> T applyAsChars(@NotNull CharFunction2<T> charFunction2) {
        return charFunction2.applyAsChar(this.first, this.second);
    }

    public char operate(@NotNull CharOperator2 charOperator2) {
        return charOperator2.applyAsChar(this.first, this.second);
    }

    public boolean test(@NotNull CharPredicate2 charPredicate2) {
        return charPredicate2.testChars(this.first, this.second);
    }

    @NotNull
    public Tuple2<Character, Character> toTuple() {
        return Tuple.of(Character.valueOf(this.first), Character.valueOf(this.second));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CharPair charPair = (CharPair)object;
        return charPair.first == this.first && charPair.second == this.second;
    }

    public int hashCode() {
        return Objects.hash(Character.valueOf(this.first), Character.valueOf(this.second));
    }

    @NotNull
    public String toString() {
        return String.format(Locale.US, "CharPair(%s, %s)", Character.valueOf(this.first), Character.valueOf(this.second));
    }
}

