/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.Empty;
import de.caff.generics.Indexable;
import de.caff.generics.IndexableHelper;
import de.caff.generics.IntIndexable;
import de.caff.generics.MutableCharIndexable;
import de.caff.generics.Order;
import de.caff.generics.PrimitiveCharIterable;
import de.caff.generics.PrimitiveCharIterator;
import de.caff.generics.Pythonesque;
import de.caff.generics.Sizeable;
import de.caff.generics.Types;
import de.caff.generics.function.CharConsumer;
import de.caff.generics.function.CharFunction1;
import de.caff.generics.function.CharOperator1;
import de.caff.generics.function.CharOperator2;
import de.caff.generics.function.CharOrdering;
import de.caff.generics.function.CharPredicate1;
import de.caff.generics.function.FragileCharConsumer;
import de.caff.generics.function.IntToCharFunction1;
import de.caff.generics.function.ToCharFunction;
import de.caff.generics.range.Range;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;

public interface CharIndexable
extends PrimitiveCharIterable,
Sizeable {
    @NotNull
    public static final Base EMPTY = new Base(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public char get(int n) {
            throw new IndexOutOfBoundsException("Empty indexable has no elements!");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        @NotNull
        public CharIndexable rotated(int n) {
            return this;
        }

        @Override
        @NotNull
        public Collection<Character> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Character> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public PrimitiveIterator.OfInt intIterator() {
            return Types.EMPTY_INT_ITERATOR;
        }

        @Override
        @NotNull
        public PrimitiveCharIterator charIterator() {
            return Types.EMPTY_CHAR_ITERATOR;
        }

        @Override
        @NotNull
        public Iterator<Character> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public ListIterator<Character> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public char[] toArray() {
            return Empty.CHAR_ARRAY;
        }

        @Override
        public int addToArray(@NotNull char[] cArray, int n) {
            return n;
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return Types.emptyIterable();
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public IntIndexable.Base asIntIndexable() {
            return IntIndexable.EMPTY;
        }

        @Override
        public char foldLeft(char c, @NotNull CharOperator2 charOperator2) {
            return c;
        }

        @Override
        @NotNull
        public CharIndexable frozen() {
            return this;
        }

        @Override
        @NotNull
        public <T> Indexable<T> viewChars(@NotNull CharFunction1<? extends T> charFunction1) {
            return Indexable.emptyIndexable();
        }

        @Override
        public void forEachChar(@NotNull CharConsumer charConsumer) {
        }

        @Override
        public <E extends Exception> void forEachCharFragile(@NotNull FragileCharConsumer<E> fragileCharConsumer) throws E {
        }

        @Override
        public boolean containsChar(char c) {
            return false;
        }

        @Override
        public void forEach(Consumer<? super Character> consumer) {
        }

        @Override
        @NotNull
        public String makeString() {
            return "";
        }

        @Override
        public int addToArray(@NotNull char[] cArray, int n, int n2, int n3) {
            return n2;
        }
    };

    public char get(int var1);

    default public char gyt(int n) {
        return this.get(Pythonesque.mapX(n, this));
    }

    default public char getMod(int n) {
        int n2 = this.size();
        if (n2 == 0) {
            throw new IndexOutOfBoundsException("No element for empty indexable!");
        }
        return this.gyt(n % n2);
    }

    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public int size() {
                return CharIndexable.this.size();
            }

            @Override
            public char get(int n) {
                return CharIndexable.this.get(CharIndexable.this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return CharIndexable.this.asBase();
            }
        };
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @NotNull
    default public <T> Indexable<T> viewChars(final @NotNull CharFunction1<? extends T> charFunction1) {
        return new Indexable.Base<T>(){

            @Override
            public T get(int n) {
                return charFunction1.applyAsChar(CharIndexable.this.get(n));
            }

            @Override
            public int size() {
                return CharIndexable.this.size();
            }
        };
    }

    @NotNull
    default public PrimitiveIterator.OfInt intIterator() {
        return new PrimitiveIterator.OfInt(){
            private int index = 0;

            @Override
            public int nextInt() {
                if (this.index >= CharIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return CharIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < CharIndexable.this.size();
            }
        };
    }

    @Override
    @NotNull
    default public PrimitiveCharIterator charIterator() {
        return new PrimitiveCharIterator(){
            private int index = 0;

            @Override
            public char nextChar() {
                if (this.index >= CharIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return CharIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < CharIndexable.this.size();
            }
        };
    }

    @NotNull
    default public PrimitiveCharIterator charIterator(final int n, final int n2) {
        return new PrimitiveCharIterator(){
            private int index;
            {
                this.index = n;
            }

            @Override
            public char nextChar() {
                if (this.index >= n2) {
                    throw new NoSuchElementException(String.format("Index %s out of allowed range [%d, %d[!", this.index, n, n2));
                }
                return CharIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < n2;
            }
        };
    }

    @Override
    @NotNull
    default public Iterator<Character> iterator() {
        return this.listIterator();
    }

    @NotNull
    default public ListIterator<Character> listIterator() {
        return new ListIterator<Character>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < CharIndexable.this.size();
            }

            @Override
            public Character next() {
                if (this.index >= CharIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return Character.valueOf(CharIndexable.this.get(this.index++));
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Character previous() {
                if (this.index == 0) {
                    throw new NoSuchElementException("index: -1");
                }
                return Character.valueOf(CharIndexable.this.get(--this.index));
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Character c) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Character c) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    default public Base subSet(final int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return n3 == 0 ? EMPTY : new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public char get(int n2) {
                if (n2 >= n3) {
                    throw new IndexOutOfBoundsException("No such element: " + n2);
                }
                return CharIndexable.this.get(n2 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n2) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n2 > n3) {
                    throw new IndexOutOfBoundsException("toIndex = " + n2);
                }
                if (n4 > n2) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n2 + ")");
                }
                return CharIndexable.this.subSet(n + n4, n + n2);
            }
        };
    }

    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(Pythonesque.mapX(n, this), this.size());
    }

    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, Pythonesque.mapX(n, this));
    }

    @NotNull
    default public <T> Indexable<T> view(final @NotNull CharFunction1<? extends T> charFunction1) {
        return new Indexable.Base<T>(){

            @Override
            public int size() {
                return CharIndexable.this.size();
            }

            @Override
            public T get(int n) {
                return charFunction1.applyAsChar(CharIndexable.this.get(n));
            }
        };
    }

    @NotNull
    default public Collection<Character> asCollection() {
        return new AbstractCollection<Character>(){

            @Override
            @NotNull
            public Iterator<Character> iterator() {
                return CharIndexable.this.iterator();
            }

            @Override
            public int size() {
                return CharIndexable.this.size();
            }
        };
    }

    @NotNull
    default public List<Character> asList() {
        return new AbstractList<Character>(){

            @Override
            public Character get(int n) {
                return Character.valueOf(CharIndexable.this.get(n));
            }

            @Override
            public int size() {
                return CharIndexable.this.size();
            }

            @Override
            @NotNull
            public Iterator<Character> iterator() {
                return CharIndexable.this.iterator();
            }
        };
    }

    @NotNull
    default public ArrayList<Character> toList() {
        ArrayList<Character> arrayList = new ArrayList<Character>(this.size());
        this.addAllTo(arrayList);
        return arrayList;
    }

    default public void addAllTo(@NotNull Collection<? super Character> collection) {
        for (Character c : this) {
            collection.add(c);
        }
    }

    @NotNull
    default public Indexable<Character> asIndexable() {
        return new Indexable.Base<Character>(){

            @Override
            public Character get(int n) {
                return Character.valueOf(CharIndexable.this.get(n));
            }

            @Override
            public int size() {
                return CharIndexable.this.size();
            }
        };
    }

    @NotNull
    default public char[] toArray() {
        if (this.isEmpty()) {
            return Empty.CHAR_ARRAY;
        }
        char[] cArray = new char[this.size()];
        this.addToArray(cArray, 0);
        return cArray;
    }

    @NotNull
    default public String makeString() {
        StringBuilder stringBuilder = new StringBuilder(this.size());
        PrimitiveCharIterator primitiveCharIterator = this.charIterator();
        while (primitiveCharIterator.hasNext()) {
            stringBuilder.append(primitiveCharIterator.nextChar());
        }
        return stringBuilder.toString();
    }

    @NotNull
    default public CharIndexable viewOp(@NotNull CharOperator1 charOperator1) {
        return CharIndexable.viewByIndex(this.size(), n -> charOperator1.applyAsChar(this.get(n)));
    }

    @NotNull
    default public CharSequence viewAsCharSequence() {
        return new CharSequence(){

            @Override
            public int length() {
                return CharIndexable.this.size();
            }

            @Override
            public char charAt(int n) {
                return CharIndexable.this.get(n);
            }

            @Override
            @NotNull
            public CharSequence subSequence(int n, int n2) {
                return CharIndexable.this.subSet(n, n2).viewAsCharSequence();
            }

            @Override
            @NotNull
            public String toString() {
                return CharIndexable.this.makeString();
            }
        };
    }

    default public int addToArray(@NotNull char[] cArray, int n) {
        return this.addToArray(cArray, n, 0, this.size());
    }

    default public int addToArray(@NotNull char[] cArray, int n, int n2, int n3) {
        PrimitiveCharIterator primitiveCharIterator = this.charIterator(n2, n2 + n3);
        while (primitiveCharIterator.hasNext()) {
            cArray[n++] = primitiveCharIterator.nextChar();
        }
        return n;
    }

    @NotNull
    default public int[] toIntArray() {
        if (this.isEmpty()) {
            return Empty.INT_ARRAY;
        }
        int[] nArray = new int[this.size()];
        this.addToArray(nArray, 0);
        return nArray;
    }

    default public int addToArray(@NotNull int[] nArray, int n) {
        return this.addToArray(nArray, n, 0, this.size());
    }

    default public int addToArray(@NotNull int[] nArray, int n, int n2, int n3) {
        PrimitiveCharIterator primitiveCharIterator = this.charIterator(n2, n2 + n3);
        while (primitiveCharIterator.hasNext()) {
            nArray[n++] = primitiveCharIterator.nextChar();
        }
        return n;
    }

    @NotNull
    default public Iterable<Integer> indexes() {
        return Range.indexes(this.size());
    }

    @NotNull
    default public IntIndexable intIndexes() {
        return IntIndexable.rangeFromSize(this.size());
    }

    @NotNull
    default public IntIndexable.Base asIntIndexable() {
        return new IntIndexable.Base(){

            @Override
            public int size() {
                return CharIndexable.this.size();
            }

            @Override
            public int get(int n) {
                return CharIndexable.this.get(n);
            }
        };
    }

    default public char foldLeft(char c, @NotNull CharOperator2 charOperator2) {
        char c2 = c;
        PrimitiveCharIterator primitiveCharIterator = this.charIterator();
        while (primitiveCharIterator.hasNext()) {
            c2 = charOperator2.applyAsChar(c2, primitiveCharIterator.nextChar());
        }
        return c2;
    }

    default public int nextMatch(int n, @NotNull CharPredicate1 charPredicate1) {
        int n2 = this.size();
        for (int i = Pythonesque.mapLB(n, this); i < n2; ++i) {
            if (!charPredicate1.testChar(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int firstMatch(@NotNull CharPredicate1 charPredicate1) {
        return this.nextMatch(0, charPredicate1);
    }

    default public int previousMatch(int n, @NotNull CharPredicate1 charPredicate1) {
        for (int i = Pythonesque.mapUB(n, this); i >= 0; --i) {
            if (!charPredicate1.testChar(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int lastMatch(@NotNull CharPredicate1 charPredicate1) {
        return this.previousMatch(-1, charPredicate1);
    }

    @NotNull
    default public CharIndexable frozen() {
        return IndexableHelper.frozenFromArray(this.toArray());
    }

    default public boolean isOrdered(@NotNull CharOrdering charOrdering) {
        if (this.size() < 2) {
            return true;
        }
        char c = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            char c2 = this.get(i);
            if (charOrdering.checkChar(c2, c) == Order.Descending) {
                return false;
            }
            c = c2;
        }
        return true;
    }

    default public boolean isOrdered() {
        if (this.size() < 2) {
            return true;
        }
        char c = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            char c2 = this.get(i);
            if (c2 < c) {
                return false;
            }
            c = c2;
        }
        return true;
    }

    default public boolean isStrictlyOrdered(@NotNull CharOrdering charOrdering) {
        if (this.size() < 2) {
            return true;
        }
        char c = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            char c2 = this.get(i);
            if (charOrdering.checkChar(c2, c) != Order.Ascending) {
                return false;
            }
            c = c2;
        }
        return true;
    }

    default public boolean isStrictlyOrdered() {
        if (this.size() < 2) {
            return true;
        }
        char c = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            char c2 = this.get(i);
            if (c2 >= c) {
                return false;
            }
            c = c2;
        }
        return true;
    }

    default public int binarySearch(char c) {
        char c2 = c;
        int n = 0;
        int n2 = this.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            char c3 = this.get(n3);
            if (c3 < c2) {
                n = n3 + 1;
                continue;
            }
            if (c3 > c2) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    default public int binarySearch(char c, @NotNull CharOrdering charOrdering) {
        int n = 0;
        int n2 = this.size() - 1;
        block4: while (n <= n2) {
            int n3 = n + n2 >>> 1;
            char c2 = this.get(n3);
            switch (charOrdering.checkChar(c2, c)) {
                case Ascending: {
                    n = n3 + 1;
                    continue block4;
                }
                case Descending: {
                    n2 = n3 - 1;
                    continue block4;
                }
            }
            return n3;
        }
        return -(n + 1);
    }

    @NotNull
    default public MutableCharIndexable ordered(@NotNull CharOrdering charOrdering) {
        MutableCharIndexable.Base base = MutableCharIndexable.fromCharIndexable(this);
        base.order(charOrdering);
        return base;
    }

    @NotNull
    default public Base asBase() {
        return new Base(){

            @Override
            public int size() {
                return CharIndexable.this.size();
            }

            @Override
            public char get(int n) {
                return CharIndexable.this.get(n);
            }

            @Override
            @NotNull
            public Base reverse() {
                return CharIndexable.this.reverse();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfInt intIterator() {
                return CharIndexable.this.intIterator();
            }

            @Override
            @NotNull
            public PrimitiveCharIterator charIterator() {
                return CharIndexable.this.charIterator();
            }

            @Override
            @NotNull
            public PrimitiveCharIterator charIterator(int n, int n2) {
                return CharIndexable.this.charIterator(n, n2);
            }

            @Override
            @NotNull
            public Iterator<Character> iterator() {
                return CharIndexable.this.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Character> listIterator() {
                return CharIndexable.this.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return CharIndexable.this.subSet(n, n2);
            }

            @Override
            @NotNull
            public char[] toArray() {
                return CharIndexable.this.toArray();
            }

            @Override
            public int addToArray(@NotNull char[] cArray, int n) {
                return CharIndexable.this.addToArray(cArray, n);
            }

            @Override
            public int addToArray(@NotNull char[] cArray, int n, int n2, int n3) {
                return CharIndexable.this.addToArray(cArray, n, n2, n3);
            }

            @Override
            @NotNull
            public IntIndexable.Base asIntIndexable() {
                return CharIndexable.this.asIntIndexable();
            }
        };
    }

    @NotNull
    default public CharIndexable withInsertedValueAt(int n, final char c) {
        final int n2 = n;
        final int n3 = this.size() + 1;
        if (n2 == 0) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public char get(int n) {
                    return n == 0 ? c : CharIndexable.this.get(n - 1);
                }
            };
        }
        if (n2 == n3 - 1) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public char get(int n) {
                    return n == n3 - 1 ? c : CharIndexable.this.get(n);
                }
            };
        }
        return new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public char get(int n) {
                if (n == n2) {
                    return c;
                }
                return CharIndexable.this.get(n < n2 ? n : n - 1);
            }
        };
    }

    @NotNull
    default public CharIndexable withAppendedValue(char c) {
        return this.withInsertedValueAt(this.size(), c);
    }

    @NotNull
    default public CharIndexable withExchangedValueAt(int n, final char c) {
        final int n2 = Pythonesque.mapX(n, this);
        return new Base(){

            @Override
            public char get(int n) {
                return n == n2 ? c : CharIndexable.this.get(n);
            }

            @Override
            public int size() {
                return CharIndexable.this.size();
            }
        };
    }

    @NotNull
    default public CharIndexable withRemovedValueAt(int n) {
        final int n2 = Pythonesque.mapX(n, this);
        if (n2 == 0) {
            return this.tailSet(1);
        }
        final int n3 = this.size() - 1;
        if (n2 == n3) {
            return this.headSet(-1);
        }
        return new Base(){

            @Override
            public char get(int n) {
                return n < n2 ? CharIndexable.this.get(n) : CharIndexable.this.get(n + 1);
            }

            @Override
            public int size() {
                return n3;
            }
        };
    }

    @NotNull
    default public CharIndexable withSwappedValuesAt(int n, int n2) {
        int n3;
        final int n4 = Pythonesque.mapX(n, this);
        if (n4 == (n3 = Pythonesque.mapX(n2, this))) {
            return this;
        }
        return new Base(){

            @Override
            public char get(int n) {
                if (n == n4) {
                    return CharIndexable.this.get(n3);
                }
                if (n == n3) {
                    return CharIndexable.this.get(n4);
                }
                return CharIndexable.this.get(n);
            }

            @Override
            public int size() {
                return CharIndexable.this.size();
            }
        };
    }

    @NotNull
    default public CharIndexable rotated(int n) {
        if ((n %= this.size()) == 0) {
            return this;
        }
        if (n < 0) {
            n += this.size();
        }
        final int n2 = n;
        return new Base(){

            @Override
            public char get(int n) {
                return CharIndexable.this.get((n + n2) % this.size());
            }

            @Override
            public int size() {
                return CharIndexable.this.size();
            }

            @Override
            @NotNull
            public CharIndexable rotated(int n) {
                return CharIndexable.this.rotated(n2 + n);
            }
        };
    }

    @NotNull
    default public BooleanIndexable viewAsBoolean(final @NotNull CharPredicate1 charPredicate1) {
        return new BooleanIndexable.Base(){

            @Override
            public boolean get(int n) {
                return charPredicate1.testChar(CharIndexable.this.get(n));
            }

            @Override
            public int size() {
                return CharIndexable.this.size();
            }
        };
    }

    @NotNull
    default public String toText() {
        return CharIndexable.toString(this);
    }

    @NotNull
    default public CharSequence asCharSequence() {
        return new CharSequence(){

            @Override
            public int length() {
                return CharIndexable.this.size();
            }

            @Override
            public char charAt(int n) {
                return CharIndexable.this.get(n);
            }

            @Override
            public CharSequence subSequence(int n, int n2) {
                return CharIndexable.this.subSet(n, n2).viewAsCharSequence();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Character> list) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public char get(int n) {
                return ((Character)list.get(n)).charValue();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Character> list, final char c) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public char get(int n) {
                Character c2 = (Character)list.get(n);
                return c2 != null ? c2.charValue() : c;
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static <T> Base viewList(final @NotNull List<T> list, final @NotNull ToCharFunction<? super T> toCharFunction) {
        return new Base(){

            @Override
            public char get(int n) {
                return toCharFunction.applyAsChar(list.get(n));
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Character> indexable) {
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public char get(int n) {
                return ((Character)indexable.get(n)).charValue();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Character> indexable, final char c) {
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public char get(int n) {
                Character c2 = (Character)indexable.get(n);
                return c2 != null ? c2.charValue() : c;
            }
        };
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToCharFunction<? super T> toCharFunction) {
        return new Base(){

            @Override
            public char get(int n) {
                return toCharFunction.applyAsChar(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public boolean isEmpty() {
                return indexable.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewString(final @NotNull CharSequence charSequence) {
        if (charSequence.length() == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return charSequence.length();
            }

            @Override
            public char get(int n) {
                return charSequence.charAt(n);
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public CharIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    public static Base viewArray(final char ... cArray) {
        return new Base(){

            @Override
            public int size() {
                return cArray.length;
            }

            @Override
            public char get(int n) {
                return cArray[n];
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull char[] cArray, final int n, final int n2) {
        if (n < 0 || n2 < 0 || n + n2 > cArray.length) {
            throw new IndexOutOfBoundsException("Start or end outside of range!");
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return n2;
            }

            @Override
            public char get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("Index %d outside range [0, %d[!", n3, n2));
                }
                return cArray[n3 + n];
            }
        };
    }

    @NotNull
    public static <T> Base viewArray(final @NotNull T[] TArray, final @NotNull ToCharFunction<? super T> toCharFunction) {
        if (TArray.length == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public char get(int n) {
                return toCharFunction.applyAsChar(TArray[n]);
            }

            @Override
            public int size() {
                return TArray.length;
            }
        };
    }

    @NotNull
    public static Base singleton(final char c) {
        return new Base(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public char get(int n) {
                if (n != 0) {
                    throw new IndexOutOfBoundsException(String.format("Index %d for indexable of size 1!", n));
                }
                return c;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public Base reverse() {
                return this;
            }

            @Override
            @NotNull
            public CharIndexable rotated(int n) {
                return this;
            }

            @Override
            @NotNull
            public Collection<Character> asCollection() {
                return Collections.singleton(Character.valueOf(c));
            }

            @Override
            @NotNull
            public List<Character> asList() {
                return Collections.singletonList(Character.valueOf(c));
            }

            @Override
            @NotNull
            public char[] toArray() {
                return new char[]{c};
            }

            @Override
            public int addToArray(@NotNull char[] cArray, int n) {
                cArray[n] = c;
                return n + 1;
            }

            @Override
            @NotNull
            public Iterable<Integer> indexes() {
                return IntIndexable.SINGLE_0;
            }

            @Override
            @NotNull
            public IntIndexable intIndexes() {
                return IntIndexable.SINGLE_0;
            }
        };
    }

    @NotNull
    public static Base init(final int n, final char c) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public char get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return c;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            @NotNull
            public CharIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    public static Base viewByIndex(final int n, final @NotNull IntToCharFunction1 intToCharFunction1) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public char get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return intToCharFunction1.applyAsChar(n2);
            }

            @Override
            public int size() {
                return n;
            }
        };
    }

    @NotNull
    public static CharIndexable initByIndex(int n, @NotNull IntToCharFunction1 intToCharFunction1) {
        return CharIndexable.viewByIndex(n, intToCharFunction1).frozen();
    }

    @NotNull
    public static Base emptyIndexable() {
        return EMPTY;
    }

    @NotNull
    public static String toString(@NotNull CharIndexable charIndexable) {
        if (charIndexable.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(charIndexable.get(0));
        PrimitiveCharIterator primitiveCharIterator = charIndexable.tailSet(1).charIterator();
        while (primitiveCharIterator.hasNext()) {
            stringBuilder.append(',').append(primitiveCharIterator.nextChar());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static int hash(@NotNull CharIndexable charIndexable) {
        int n = 1;
        PrimitiveCharIterator primitiveCharIterator = charIndexable.charIterator();
        while (primitiveCharIterator.hasNext()) {
            n = 31 * n + Character.hashCode(primitiveCharIterator.next().charValue());
        }
        return n;
    }

    public static boolean equal(@NotNull CharIndexable charIndexable, @NotNull CharIndexable charIndexable2) {
        if (charIndexable == charIndexable2) {
            return true;
        }
        if (charIndexable.size() != charIndexable2.size()) {
            return false;
        }
        PrimitiveCharIterator primitiveCharIterator = charIndexable.charIterator();
        PrimitiveCharIterator primitiveCharIterator2 = charIndexable2.charIterator();
        while (primitiveCharIterator.hasNext() && primitiveCharIterator2.hasNext()) {
            if (primitiveCharIterator.nextChar() == primitiveCharIterator2.nextChar()) continue;
            return false;
        }
        return !primitiveCharIterator.hasNext() && !primitiveCharIterator2.hasNext();
    }

    public static boolean equal(@NotNull CharIndexable charIndexable, @Nullable Object object) {
        if (object instanceof CharIndexable) {
            return CharIndexable.equal(charIndexable, (CharIndexable)object);
        }
        return false;
    }

    public static int compare(@NotNull CharIndexable charIndexable, @NotNull CharIndexable charIndexable2) {
        PrimitiveCharIterator primitiveCharIterator = charIndexable.charIterator();
        PrimitiveCharIterator primitiveCharIterator2 = charIndexable2.charIterator();
        while (primitiveCharIterator.hasNext() && primitiveCharIterator2.hasNext()) {
            int n = Character.compare(primitiveCharIterator.nextChar(), primitiveCharIterator2.nextChar());
            if (n == 0) continue;
            return n;
        }
        if (primitiveCharIterator.hasNext()) {
            return 1;
        }
        if (primitiveCharIterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static abstract class Base
    implements CharIndexable,
    Comparable<CharIndexable> {
        @Override
        public int compareTo(@NotNull CharIndexable charIndexable) {
            Objects.requireNonNull(charIndexable);
            return CharIndexable.compare(this, charIndexable);
        }

        public int hashCode() {
            return CharIndexable.hash(this);
        }

        public boolean equals(Object object) {
            return CharIndexable.equal((CharIndexable)this, object);
        }

        public String toString() {
            return CharIndexable.toString(this);
        }

        @Override
        @NotNull
        public Base asBase() {
            return this;
        }
    }
}

