/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.ByteIndexable;
import de.caff.generics.IntPair;
import de.caff.generics.Primitives;
import de.caff.generics.function.ByteFunction2;
import de.caff.generics.function.ByteOperator2;
import de.caff.generics.function.BytePredicate2;
import de.caff.generics.tuple.Tuple;
import de.caff.generics.tuple.Tuple2;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

public final class BytePair
implements Serializable,
ByteIndexable {
    private static final long serialVersionUID = 4196797097671990594L;
    public final byte first;
    public final byte second;

    public BytePair(byte by, byte by2) {
        this.first = by;
        this.second = by2;
    }

    @NotNull
    public IntPair toIntPair() {
        return new IntPair(this.first, this.second);
    }

    @NotNull
    public IntPair toUnsignedIntPair() {
        return new IntPair(Primitives.unsigned(this.first), Primitives.unsigned(this.second));
    }

    @NotNull
    public BytePair withFirst(byte by) {
        if (by == this.first) {
            return this;
        }
        return new BytePair(by, this.second);
    }

    @NotNull
    public BytePair withSecond(byte by) {
        if (by == this.second) {
            return this;
        }
        return new BytePair(this.first, by);
    }

    @NotNull
    public BytePair swapped() {
        if (this.first == this.second) {
            return this;
        }
        return new BytePair(this.second, this.first);
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public byte get(int n) {
        switch (n) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
        }
        throw new IndexOutOfBoundsException(String.format("Pair has only 2 elements, so %d is out of bounds!", n));
    }

    public <T> T applyAsBytes(@NotNull ByteFunction2<T> byteFunction2) {
        return byteFunction2.applyAsByte(this.first, this.second);
    }

    public byte operate(@NotNull ByteOperator2 byteOperator2) {
        return byteOperator2.applyAsByte(this.first, this.second);
    }

    public boolean test(@NotNull BytePredicate2 bytePredicate2) {
        return bytePredicate2.testBytes(this.first, this.second);
    }

    @NotNull
    public Tuple2<Byte, Byte> toTuple() {
        return Tuple.of(this.first, this.second);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BytePair bytePair = (BytePair)object;
        return bytePair.first == this.first && bytePair.second == this.second;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    @NotNull
    public String toString() {
        return String.format(Locale.US, "BytePair(%s, %s)", this.first, this.second);
    }
}

