/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.DoubleIndexable;
import de.caff.generics.Empty;
import de.caff.generics.FloatIndexable;
import de.caff.generics.Indexable;
import de.caff.generics.IndexableHelper;
import de.caff.generics.IntIndexable;
import de.caff.generics.LongIndexable;
import de.caff.generics.MutableByteIndexable;
import de.caff.generics.Order;
import de.caff.generics.PrimitiveByteIterable;
import de.caff.generics.PrimitiveByteIterator;
import de.caff.generics.Primitives;
import de.caff.generics.Pythonesque;
import de.caff.generics.ShortIndexable;
import de.caff.generics.Sizeable;
import de.caff.generics.Types;
import de.caff.generics.function.ByteConsumer;
import de.caff.generics.function.ByteFunction1;
import de.caff.generics.function.ByteOperator1;
import de.caff.generics.function.ByteOperator2;
import de.caff.generics.function.ByteOrdering;
import de.caff.generics.function.BytePredicate1;
import de.caff.generics.function.IntToByteFunction1;
import de.caff.generics.function.ToByteFunction;
import de.caff.generics.range.Range;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.function.Consumer;

public interface ByteIndexable
extends PrimitiveByteIterable,
Sizeable {
    public static final ByteIndexable SINGLE_0 = ByteIndexable.singleton((byte)0);
    public static final Indexable<String> UPPERCASE_2DIGIT_HEXCODES = Indexable.viewByIndex(256, (int n) -> String.format("%02X", n)).frozen();
    public static final Indexable<String> LOWERCASE_2DIGIT_HEXCODES = Indexable.viewByIndex(256, (int n) -> String.format("%02x", n)).frozen();
    public static final Base EMPTY = new Base(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public byte get(int n) {
            throw new IndexOutOfBoundsException("Empty indexable has no elements!");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int addToArray(@NotNull byte[] byArray, int n) {
            return n;
        }

        @Override
        public int addToArray(@NotNull byte[] byArray, int n, int n2, int n3) {
            return n;
        }

        @Override
        @NotNull
        public byte[] toArray() {
            return Empty.BYTE_ARRAY;
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        @NotNull
        public ByteIndexable rotated(int n) {
            return this;
        }

        @Override
        @NotNull
        public ByteIndexable frozen() {
            return this;
        }

        @Override
        @NotNull
        public Iterator<Byte> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public ListIterator<Byte> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public PrimitiveByteIterator byteIterator() {
            return Types.EMPTY_BYTE_ITERATOR;
        }

        @Override
        public int compareTo(@NotNull ByteIndexable byteIndexable) {
            return byteIndexable.isEmpty() ? 0 : -1;
        }

        @Override
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof ByteIndexable && ((ByteIndexable)object).isEmpty();
        }

        @Override
        @NotNull
        public Collection<Byte> asCollection() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<Byte> asList() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public IntIndexable.Base asIntIndexable() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public IntIndexable.Base asUnsignedIndexable() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public byte[] toByteArray() {
            return Empty.BYTE_ARRAY;
        }

        @Override
        public void copyTo(@NotNull byte[] byArray, int n) {
        }

        @Override
        public void copyTo(@NotNull byte[] byArray, int n, int n2, int n3) {
        }

        @Override
        public byte foldLeft(byte by, @NotNull ByteOperator2 byteOperator2) {
            return by;
        }

        @Override
        public void forEachByte(@NotNull ByteConsumer byteConsumer) {
        }

        @Override
        public boolean containsByte(byte by) {
            return false;
        }

        @Override
        public void forEach(Consumer<? super Byte> consumer) {
        }

        @Override
        @NotNull
        public String toHexString() {
            return "";
        }

        @Override
        @NotNull
        public String toHexString(boolean bl) {
            return "";
        }
    };

    public byte get(int var1);

    default public byte gyt(int n) {
        return this.get(Pythonesque.mapX(n, this));
    }

    default public byte getMod(int n) {
        int n2 = this.size();
        if (n2 == 0) {
            throw new IndexOutOfBoundsException("No element for empty indexable!");
        }
        return this.gyt(n % n2);
    }

    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }

            @Override
            public byte get(int n) {
                return ByteIndexable.this.get(ByteIndexable.this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return ByteIndexable.this.asBase();
            }
        };
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @NotNull
    default public PrimitiveIterator.OfInt intIterator() {
        return new PrimitiveIterator.OfInt(){
            private int index = 0;

            @Override
            public int nextInt() {
                if (this.index >= ByteIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return ByteIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < ByteIndexable.this.size();
            }
        };
    }

    @Override
    @NotNull
    default public PrimitiveByteIterator byteIterator() {
        return this.byteIterator(0, this.size());
    }

    @NotNull
    default public PrimitiveByteIterator byteIterator(final int n, final int n2) {
        return new PrimitiveByteIterator(){
            private int index;
            {
                this.index = n;
            }

            @Override
            public byte nextByte() {
                if (this.index >= n2) {
                    throw new NoSuchElementException(String.format("Index %s out of allowed range [%d, %d[!", this.index, n, n2));
                }
                return ByteIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < n2;
            }
        };
    }

    @Override
    @NotNull
    default public Iterator<Byte> iterator() {
        return this.listIterator();
    }

    @NotNull
    default public ListIterator<Byte> listIterator() {
        return new ListIterator<Byte>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < ByteIndexable.this.size();
            }

            @Override
            public Byte next() {
                if (this.index >= ByteIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return ByteIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Byte previous() {
                if (this.index == 0) {
                    throw new NoSuchElementException("index: -1");
                }
                return ByteIndexable.this.get(--this.index);
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Byte by) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Byte by) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    default public Base subSet(final int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return n3 == 0 ? EMPTY : new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public byte get(int n2) {
                if (n2 >= n3) {
                    throw new IndexOutOfBoundsException("No such element: " + n2);
                }
                return ByteIndexable.this.get(n2 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n2) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n2 > n3) {
                    throw new IndexOutOfBoundsException("toIndex = " + n2);
                }
                if (n4 > n2) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n2 + ")");
                }
                return ByteIndexable.this.subSet(n + n4, n + n2);
            }
        };
    }

    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(Pythonesque.mapX(n, this), this.size());
    }

    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, Pythonesque.mapX(n, this));
    }

    @NotNull
    default public <T> Indexable<T> view(final @NotNull ByteFunction1<? extends T> byteFunction1) {
        return new Indexable.Base<T>(){

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }

            @Override
            public T get(int n) {
                return byteFunction1.applyAsByte(ByteIndexable.this.get(n));
            }
        };
    }

    @NotNull
    default public Collection<Byte> asCollection() {
        return new AbstractCollection<Byte>(){

            @Override
            @NotNull
            public Iterator<Byte> iterator() {
                return ByteIndexable.this.iterator();
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }
        };
    }

    @NotNull
    default public List<Byte> asList() {
        return new AbstractList<Byte>(){

            @Override
            public Byte get(int n) {
                return ByteIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }

            @Override
            @NotNull
            public Iterator<Byte> iterator() {
                return ByteIndexable.this.iterator();
            }
        };
    }

    @NotNull
    default public ArrayList<Byte> toList() {
        ArrayList<Byte> arrayList = new ArrayList<Byte>(this.size());
        this.addAllTo(arrayList);
        return arrayList;
    }

    default public void addAllTo(@NotNull Collection<? super Byte> collection) {
        for (Byte by : this) {
            collection.add(by);
        }
    }

    @NotNull
    default public Indexable<Byte> asIndexable() {
        return new Indexable.Base<Byte>(){

            @Override
            public Byte get(int n) {
                return ByteIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }
        };
    }

    @NotNull
    default public byte[] toArray() {
        if (this.isEmpty()) {
            return Empty.BYTE_ARRAY;
        }
        byte[] byArray = new byte[this.size()];
        this.addToArray(byArray, 0);
        return byArray;
    }

    default public int addToArray(@NotNull byte[] byArray, int n) {
        return this.addToArray(byArray, n, 0, this.size());
    }

    default public int addToArray(@NotNull byte[] byArray, int n, int n2, int n3) {
        PrimitiveByteIterator primitiveByteIterator = this.byteIterator(n2, n2 + n3);
        while (primitiveByteIterator.hasNext()) {
            byArray[n++] = primitiveByteIterator.nextByte();
        }
        return n;
    }

    @NotNull
    default public int[] toIntArray() {
        if (this.isEmpty()) {
            return Empty.INT_ARRAY;
        }
        int[] nArray = new int[this.size()];
        this.addToArray(nArray, 0);
        return nArray;
    }

    default public int addToArray(@NotNull int[] nArray, int n) {
        return this.addToArray(nArray, n, 0, this.size());
    }

    default public int addToArray(@NotNull int[] nArray, int n, int n2, int n3) {
        PrimitiveByteIterator primitiveByteIterator = this.byteIterator(n2, n2 + n3);
        while (primitiveByteIterator.hasNext()) {
            nArray[n++] = primitiveByteIterator.nextByte();
        }
        return n;
    }

    @NotNull
    default public Iterable<Integer> indexes() {
        return Range.indexes(this.size());
    }

    @NotNull
    default public IntIndexable intIndexes() {
        return IntIndexable.rangeFromSize(this.size());
    }

    @NotNull
    default public IntIndexable.Base asIntIndexable() {
        return new IntIndexable.Base(){

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }

            @Override
            public int get(int n) {
                return ByteIndexable.this.get(n);
            }
        };
    }

    @NotNull
    default public IntIndexable.Base asUnsignedIndexable() {
        return new IntIndexable.Base(){

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }

            @Override
            public int get(int n) {
                return ByteIndexable.this.get(n) & 0xFF;
            }
        };
    }

    @NotNull
    default public byte[] toByteArray() {
        int n = this.size();
        if (n == 0) {
            return Empty.BYTE_ARRAY;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (byte by : this) {
            byArray[n2++] = by;
        }
        return byArray;
    }

    default public void copyTo(@NotNull byte[] byArray, int n) {
        this.copyTo(byArray, n, 0, this.size());
    }

    default public void copyTo(@NotNull byte[] byArray, int n, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray[n + i] = this.get(n2 + i);
        }
    }

    default public byte foldLeft(byte by, @NotNull ByteOperator2 byteOperator2) {
        byte by2 = by;
        PrimitiveByteIterator primitiveByteIterator = this.byteIterator();
        while (primitiveByteIterator.hasNext()) {
            by2 = byteOperator2.applyAsByte(by2, primitiveByteIterator.nextByte());
        }
        return by2;
    }

    @NotNull
    default public String toHexString() {
        return this.toHexString(true);
    }

    @NotNull
    default public String toHexString(boolean bl) {
        if (this.isEmpty()) {
            return "";
        }
        Indexable<String> indexable = bl ? UPPERCASE_2DIGIT_HEXCODES : LOWERCASE_2DIGIT_HEXCODES;
        StringBuilder stringBuilder = new StringBuilder(2 * this.size());
        this.forEachByte(by -> stringBuilder.append((String)indexable.get(by & 0xFF)));
        return stringBuilder.toString();
    }

    @NotNull
    default public ByteIndexable withInsertedValueAt(int n, final byte by) {
        final int n2 = n;
        final int n3 = this.size() + 1;
        if (n2 == 0) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public byte get(int n) {
                    return n == 0 ? by : ByteIndexable.this.get(n - 1);
                }
            };
        }
        if (n2 == n3 - 1) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public byte get(int n) {
                    return n == n3 - 1 ? by : ByteIndexable.this.get(n);
                }
            };
        }
        return new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public byte get(int n) {
                if (n == n2) {
                    return by;
                }
                return ByteIndexable.this.get(n < n2 ? n : n - 1);
            }
        };
    }

    @NotNull
    default public ByteIndexable withAppendedValue(byte by) {
        return this.withInsertedValueAt(this.size(), by);
    }

    @NotNull
    default public ByteIndexable withExchangedValueAt(int n, final byte by) {
        final int n2 = Pythonesque.mapX(n, this);
        return new Base(){

            @Override
            public byte get(int n) {
                return n == n2 ? by : ByteIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ByteIndexable withRemovedValueAt(int n) {
        final int n2 = Pythonesque.mapX(n, this);
        if (n2 == 0) {
            return this.tailSet(1);
        }
        final int n3 = this.size() - 1;
        if (n2 == n3) {
            return this.headSet(-1);
        }
        return new Base(){

            @Override
            public byte get(int n) {
                return n < n2 ? ByteIndexable.this.get(n) : ByteIndexable.this.get(n + 1);
            }

            @Override
            public int size() {
                return n3;
            }
        };
    }

    @NotNull
    default public ByteIndexable viewOp(@NotNull ByteOperator1 byteOperator1) {
        return ByteIndexable.viewByIndex(this.size(), n -> byteOperator1.applyAsByte(this.get(n)));
    }

    @NotNull
    default public DoubleIndexable viewAsDouble() {
        return new DoubleIndexable.Base(){

            @Override
            public double get(int n) {
                return ByteIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }
        };
    }

    @NotNull
    default public FloatIndexable viewAsFloat() {
        return new FloatIndexable.Base(){

            @Override
            public float get(int n) {
                return ByteIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }
        };
    }

    @NotNull
    default public LongIndexable viewAsLong() {
        return new LongIndexable.Base(){

            @Override
            public long get(int n) {
                return ByteIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }
        };
    }

    @NotNull
    default public LongIndexable viewAsUnsignedLong() {
        return new LongIndexable.Base(){

            @Override
            public long get(int n) {
                return (long)ByteIndexable.this.get(n) & 0xFFL;
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }
        };
    }

    @NotNull
    default public IntIndexable viewAsInt() {
        return new IntIndexable.Base(){

            @Override
            public int get(int n) {
                return ByteIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }
        };
    }

    @NotNull
    default public IntIndexable viewAsUnsignedInt() {
        return new IntIndexable.Base(){

            @Override
            public int get(int n) {
                return ByteIndexable.this.get(n) & 0xFF;
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ShortIndexable viewAsShort() {
        return new ShortIndexable.Base(){

            @Override
            public short get(int n) {
                return ByteIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ShortIndexable viewAsUnsignedShort() {
        return new ShortIndexable.Base(){

            @Override
            public short get(int n) {
                return (short)(ByteIndexable.this.get(n) & 0xFF);
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ByteIndexable withSwappedValuesAt(int n, int n2) {
        int n3;
        final int n4 = Pythonesque.mapX(n, this);
        if (n4 == (n3 = Pythonesque.mapX(n2, this))) {
            return this;
        }
        return new Base(){

            @Override
            public byte get(int n) {
                if (n == n4) {
                    return ByteIndexable.this.get(n3);
                }
                if (n == n3) {
                    return ByteIndexable.this.get(n4);
                }
                return ByteIndexable.this.get(n);
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }
        };
    }

    @NotNull
    default public ByteIndexable rotated(int n) {
        if ((n %= this.size()) == 0) {
            return this;
        }
        if (n < 0) {
            n += this.size();
        }
        final int n2 = n;
        return new Base(){

            @Override
            public byte get(int n) {
                return ByteIndexable.this.get((n + n2) % this.size());
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }

            @Override
            @NotNull
            public ByteIndexable rotated(int n) {
                return ByteIndexable.this.rotated(n2 + n);
            }
        };
    }

    @NotNull
    default public BooleanIndexable viewAsBoolean(final @NotNull BytePredicate1 bytePredicate1) {
        return new BooleanIndexable.Base(){

            @Override
            public boolean get(int n) {
                return bytePredicate1.testByte(ByteIndexable.this.get(n));
            }

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Number> list) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public byte get(int n) {
                return ((Number)list.get(n)).byteValue();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Number> list, final byte by) {
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public byte get(int n) {
                Number number = (Number)list.get(n);
                return number != null ? number.byteValue() : by;
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static <T> Base viewList(final @NotNull List<T> list, final @NotNull ToByteFunction<? super T> toByteFunction) {
        return new Base(){

            @Override
            public byte get(int n) {
                return toByteFunction.applyAsByte(list.get(n));
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Number> indexable) {
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public byte get(int n) {
                return ((Number)indexable.get(n)).byteValue();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Number> indexable, final byte by) {
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public byte get(int n) {
                Number number = (Number)indexable.get(n);
                return number != null ? number.byteValue() : by;
            }
        };
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull ToByteFunction<? super T> toByteFunction) {
        return new Base(){

            @Override
            public byte get(int n) {
                return toByteFunction.applyAsByte(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public boolean isEmpty() {
                return indexable.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewNumberArray(final Number ... numberArray) {
        return new Base(){

            @Override
            public int size() {
                return numberArray.length;
            }

            @Override
            public byte get(int n) {
                return numberArray[n].byteValue();
            }
        };
    }

    @NotNull
    public static Base viewArray(final byte ... byArray) {
        return byArray.length == 0 ? EMPTY : new Base(){

            @Override
            public int size() {
                return byArray.length;
            }

            @Override
            public byte get(int n) {
                return byArray[n];
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull byte[] byArray, final int n, final int n2) {
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("Start or end outside of range!");
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return n2;
            }

            @Override
            public byte get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("Index %d outside range [0, %d[!", n3, n2));
                }
                return byArray[n3 + n];
            }
        };
    }

    @NotNull
    public static <T> Base viewArray(final @NotNull T[] TArray, final @NotNull ToByteFunction<? super T> toByteFunction) {
        if (TArray.length == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public byte get(int n) {
                return toByteFunction.applyAsByte(TArray[n]);
            }

            @Override
            public int size() {
                return TArray.length;
            }
        };
    }

    @NotNull
    public static Base singleton(final byte by) {
        return new Base(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public byte get(int n) {
                if (n != 0) {
                    throw new IndexOutOfBoundsException(String.format("Index %d for indexable of size 1!", n));
                }
                return by;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public Base reverse() {
                return this;
            }

            @Override
            @NotNull
            public ByteIndexable rotated(int n) {
                return this;
            }

            @Override
            @NotNull
            public Collection<Byte> asCollection() {
                return Collections.singleton(by);
            }

            @Override
            @NotNull
            public List<Byte> asList() {
                return Collections.singletonList(by);
            }

            @Override
            @NotNull
            public byte[] toArray() {
                return new byte[]{by};
            }

            @Override
            public int addToArray(@NotNull byte[] byArray, int n) {
                byArray[n] = by;
                return n + 1;
            }

            @Override
            @NotNull
            public Iterable<Integer> indexes() {
                return IntIndexable.SINGLE_0;
            }

            @Override
            @NotNull
            public IntIndexable intIndexes() {
                return IntIndexable.SINGLE_0;
            }
        };
    }

    @NotNull
    public static Base init(final int n, final byte by) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public byte get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return by;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            @NotNull
            public ByteIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    public static Base viewByIndex(final int n, final @NotNull IntToByteFunction1 intToByteFunction1) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public byte get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return intToByteFunction1.applyAsByte(n2);
            }

            @Override
            public int size() {
                return n;
            }
        };
    }

    @NotNull
    public static ByteIndexable initByIndex(int n, @NotNull IntToByteFunction1 intToByteFunction1) {
        return ByteIndexable.viewByIndex(n, intToByteFunction1).frozen();
    }

    @NotNull
    public static Base emptyIndexable() {
        return EMPTY;
    }

    @NotNull
    public static String toString(@NotNull ByteIndexable byteIndexable) {
        if (byteIndexable.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(byteIndexable.get(0));
        PrimitiveByteIterator primitiveByteIterator = byteIndexable.tailSet(1).byteIterator();
        while (primitiveByteIterator.hasNext()) {
            stringBuilder.append(',').append(primitiveByteIterator.nextByte());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static boolean equal(@NotNull ByteIndexable byteIndexable, @NotNull ByteIndexable byteIndexable2) {
        if (byteIndexable == byteIndexable2) {
            return true;
        }
        if (byteIndexable.size() != byteIndexable2.size()) {
            return false;
        }
        PrimitiveByteIterator primitiveByteIterator = byteIndexable.byteIterator();
        PrimitiveByteIterator primitiveByteIterator2 = byteIndexable2.byteIterator();
        while (primitiveByteIterator.hasNext() && primitiveByteIterator2.hasNext()) {
            if (primitiveByteIterator.nextByte() == primitiveByteIterator2.nextByte()) continue;
            return false;
        }
        return !primitiveByteIterator.hasNext() && !primitiveByteIterator2.hasNext();
    }

    public static boolean equal(@NotNull ByteIndexable byteIndexable, @Nullable Object object) {
        if (object instanceof ByteIndexable) {
            return ByteIndexable.equal(byteIndexable, (ByteIndexable)object);
        }
        return false;
    }

    public static int compare(@NotNull ByteIndexable byteIndexable, @NotNull ByteIndexable byteIndexable2) {
        PrimitiveByteIterator primitiveByteIterator = byteIndexable.byteIterator();
        PrimitiveByteIterator primitiveByteIterator2 = byteIndexable2.byteIterator();
        while (primitiveByteIterator.hasNext() && primitiveByteIterator2.hasNext()) {
            int n = Byte.compare(primitiveByteIterator.nextByte(), primitiveByteIterator2.nextByte());
            if (n == 0) continue;
            return n;
        }
        if (primitiveByteIterator.hasNext()) {
            return 1;
        }
        if (primitiveByteIterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int compareUnsigned(@NotNull ByteIndexable byteIndexable, @NotNull ByteIndexable byteIndexable2) {
        PrimitiveByteIterator primitiveByteIterator = byteIndexable.byteIterator();
        PrimitiveByteIterator primitiveByteIterator2 = byteIndexable2.byteIterator();
        while (primitiveByteIterator.hasNext() && primitiveByteIterator2.hasNext()) {
            int n = Primitives.compareUnsigned(primitiveByteIterator.nextByte(), primitiveByteIterator2.nextByte());
            if (n == 0) continue;
            return n;
        }
        if (primitiveByteIterator.hasNext()) {
            return 1;
        }
        if (primitiveByteIterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int hash(@NotNull ByteIndexable byteIndexable) {
        int n = 1;
        PrimitiveByteIterator primitiveByteIterator = byteIndexable.byteIterator();
        while (primitiveByteIterator.hasNext()) {
            n = 31 * n + Byte.hashCode(primitiveByteIterator.next());
        }
        return n;
    }

    @NotNull
    public static Base withCachedHash(final @NotNull ByteIndexable byteIndexable) {
        final int n = ByteIndexable.hash(byteIndexable);
        return new Base(){

            @Override
            public int size() {
                return byteIndexable.size();
            }

            @Override
            public byte get(int n2) {
                return byteIndexable.get(n2);
            }

            @Override
            @NotNull
            public PrimitiveByteIterator byteIterator() {
                return byteIndexable.byteIterator();
            }

            @Override
            @NotNull
            public PrimitiveByteIterator byteIterator(int n3, int n2) {
                return byteIndexable.byteIterator(n3, n2);
            }

            @Override
            @NotNull
            public Iterator<Byte> iterator() {
                return byteIndexable.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Byte> listIterator() {
                return byteIndexable.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n2) {
                return byteIndexable.subSet(n3, n2);
            }

            @Override
            public int addToArray(@NotNull byte[] byArray, int n2) {
                return byteIndexable.addToArray(byArray, n2);
            }

            @Override
            public int addToArray(@NotNull byte[] byArray, int n4, int n2, int n3) {
                return byteIndexable.addToArray(byArray, n4, n2, n3);
            }

            @Override
            public int hashCode() {
                return n;
            }

            @Override
            public boolean equals(Object object) {
                return ByteIndexable.equal(byteIndexable, object);
            }

            @Override
            public String toString() {
                return ByteIndexable.toString(byteIndexable);
            }
        };
    }

    @NotNull
    public static ByteIndexable fromHexString(@NotNull String string) {
        return ByteIndexable.viewArray(ByteIndexable.bytesFromHexString(string));
    }

    @NotNull
    public static byte[] bytesFromHexString(@NotNull String string) {
        if (string.isEmpty()) {
            return Empty.BYTE_ARRAY;
        }
        if (string.length() % 2 == 1) {
            throw new IllegalArgumentException("String has to contain an even number of characters!");
        }
        byte[] byArray = new byte[string.length() / 2];
        for (int i = 0; i < byArray.length; ++i) {
            byArray[i] = (byte)Integer.parseInt(string.substring(2 * i, 2 * i + 2), 16);
        }
        return byArray;
    }

    default public int nextMatch(int n, @NotNull BytePredicate1 bytePredicate1) {
        int n2 = this.size();
        for (int i = Pythonesque.mapLB(n, this); i < n2; ++i) {
            if (!bytePredicate1.testByte(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int firstMatch(@NotNull BytePredicate1 bytePredicate1) {
        return this.nextMatch(0, bytePredicate1);
    }

    default public int previousMatch(int n, @NotNull BytePredicate1 bytePredicate1) {
        for (int i = Pythonesque.mapUB(n, this); i >= 0; --i) {
            if (!bytePredicate1.testByte(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int lastMatch(@NotNull BytePredicate1 bytePredicate1) {
        return this.previousMatch(-1, bytePredicate1);
    }

    @NotNull
    default public ByteIndexable frozen() {
        return IndexableHelper.frozenFromArray(this.toArray());
    }

    default public boolean isOrdered(@NotNull ByteOrdering byteOrdering) {
        if (this.size() < 2) {
            return true;
        }
        byte by = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            byte by2 = this.get(i);
            if (byteOrdering.checkByte(by2, by) == Order.Descending) {
                return false;
            }
            by = by2;
        }
        return true;
    }

    default public boolean isOrdered() {
        if (this.size() < 2) {
            return true;
        }
        byte by = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            byte by2 = this.get(i);
            if (by2 < by) {
                return false;
            }
            by = by2;
        }
        return true;
    }

    default public boolean isStrictlyOrdered(@NotNull ByteOrdering byteOrdering) {
        if (this.size() < 2) {
            return true;
        }
        byte by = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            byte by2 = this.get(i);
            if (byteOrdering.checkByte(by2, by) != Order.Ascending) {
                return false;
            }
            by = by2;
        }
        return true;
    }

    default public boolean isStrictlyOrdered() {
        if (this.size() < 2) {
            return true;
        }
        byte by = this.gyt(-1);
        for (int i = this.size() - 2; i >= 0; --i) {
            byte by2 = this.get(i);
            if (by2 >= by) {
                return false;
            }
            by = by2;
        }
        return true;
    }

    default public int binarySearch(byte by) {
        byte by2 = by;
        int n = 0;
        int n2 = this.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            byte by3 = this.get(n3);
            if (by3 < by2) {
                n = n3 + 1;
                continue;
            }
            if (by3 > by2) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    default public int binarySearch(byte by, @NotNull ByteOrdering byteOrdering) {
        int n = 0;
        int n2 = this.size() - 1;
        block4: while (n <= n2) {
            int n3 = n + n2 >>> 1;
            byte by2 = this.get(n3);
            switch (byteOrdering.checkByte(by2, by)) {
                case Ascending: {
                    n = n3 + 1;
                    continue block4;
                }
                case Descending: {
                    n = n3 - 1;
                    continue block4;
                }
            }
            return n3;
        }
        return -(n + 1);
    }

    @NotNull
    default public MutableByteIndexable ordered(@NotNull ByteOrdering byteOrdering) {
        MutableByteIndexable.Base base = MutableByteIndexable.fromByteIndexable(this);
        base.order(byteOrdering);
        return base;
    }

    @NotNull
    default public Base asBase() {
        return new Base(){

            @Override
            public int size() {
                return ByteIndexable.this.size();
            }

            @Override
            public byte get(int n) {
                return ByteIndexable.this.get(n);
            }

            @Override
            @NotNull
            public Base reverse() {
                return ByteIndexable.this.reverse();
            }

            @Override
            @NotNull
            public PrimitiveIterator.OfInt intIterator() {
                return ByteIndexable.this.intIterator();
            }

            @Override
            @NotNull
            public PrimitiveByteIterator byteIterator() {
                return ByteIndexable.this.byteIterator();
            }

            @Override
            @NotNull
            public PrimitiveByteIterator byteIterator(int n, int n2) {
                return ByteIndexable.this.byteIterator(n, n2);
            }

            @Override
            @NotNull
            public Iterator<Byte> iterator() {
                return ByteIndexable.this.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Byte> listIterator() {
                return ByteIndexable.this.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return ByteIndexable.this.subSet(n, n2);
            }

            @Override
            @NotNull
            public byte[] toArray() {
                return ByteIndexable.this.toArray();
            }

            @Override
            public int addToArray(@NotNull byte[] byArray, int n) {
                return ByteIndexable.this.addToArray(byArray, n);
            }

            @Override
            public int addToArray(@NotNull byte[] byArray, int n, int n2, int n3) {
                return ByteIndexable.this.addToArray(byArray, n, n2, n3);
            }

            @Override
            @NotNull
            public IntIndexable.Base asIntIndexable() {
                return ByteIndexable.this.asIntIndexable();
            }

            @Override
            @NotNull
            public IntIndexable.Base asUnsignedIndexable() {
                return ByteIndexable.this.asUnsignedIndexable();
            }
        };
    }

    public static abstract class Base
    implements ByteIndexable,
    Comparable<ByteIndexable> {
        @Override
        public int compareTo(@NotNull ByteIndexable byteIndexable) {
            Objects.requireNonNull(byteIndexable);
            return ByteIndexable.compare(this, byteIndexable);
        }

        public int hashCode() {
            return ByteIndexable.hash(this);
        }

        public boolean equals(Object object) {
            return ByteIndexable.equal((ByteIndexable)this, object);
        }

        public String toString() {
            return ByteIndexable.toString(this);
        }

        @Override
        @NotNull
        public Base asBase() {
            return this;
        }
    }
}

