/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.BooleanIndexable;
import de.caff.generics.function.BooleanFunction2;
import de.caff.generics.function.BooleanOperator2;
import de.caff.generics.function.BooleanPredicate2;
import de.caff.generics.tuple.Tuple;
import de.caff.generics.tuple.Tuple2;
import java.io.Serializable;
import java.util.Locale;
import java.util.Objects;

public final class BooleanPair
implements Serializable,
BooleanIndexable {
    private static final long serialVersionUID = -4169359896148258597L;
    public final boolean first;
    public final boolean second;

    public BooleanPair(boolean bl, boolean bl2) {
        this.first = bl;
        this.second = bl2;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public boolean get(int n) {
        switch (n) {
            case 0: {
                return this.first;
            }
            case 1: {
                return this.second;
            }
        }
        throw new IndexOutOfBoundsException(String.format("Pair has only 2 elements, so %d is out of bounds!", n));
    }

    public <T> T applyAsBooleans(@NotNull BooleanFunction2<T> booleanFunction2) {
        return booleanFunction2.applyAsBoolean(this.first, this.second);
    }

    public boolean operate(@NotNull BooleanOperator2 booleanOperator2) {
        return booleanOperator2.applyAsBoolean(this.first, this.second);
    }

    public boolean test(@NotNull BooleanPredicate2 booleanPredicate2) {
        return booleanPredicate2.testBools(this.first, this.second);
    }

    @NotNull
    public Tuple2<Boolean, Boolean> toTuple() {
        return Tuple.of(this.first, this.second);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BooleanPair booleanPair = (BooleanPair)object;
        return booleanPair.first == this.first && booleanPair.second == this.second;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    @NotNull
    public String toString() {
        return String.format(Locale.US, "BooleanPair(%s, %s)", this.first, this.second);
    }
}

