/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Empty;
import de.caff.generics.Indexable;
import de.caff.generics.IndexableHelper;
import de.caff.generics.IntIndexable;
import de.caff.generics.PrimitiveBooleanIterable;
import de.caff.generics.PrimitiveBooleanIterator;
import de.caff.generics.Pythonesque;
import de.caff.generics.Sizeable;
import de.caff.generics.Types;
import de.caff.generics.function.BooleanConsumer;
import de.caff.generics.function.BooleanFunction1;
import de.caff.generics.function.BooleanOperator2;
import de.caff.generics.function.BooleanPredicate1;
import de.caff.generics.function.IntPredicate1;
import de.caff.generics.range.Range;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Predicate;

public interface BooleanIndexable
extends PrimitiveBooleanIterable,
Sizeable {
    public static final BooleanIndexable SINGLE_FALSE = BooleanIndexable.singleton(false);
    public static final BooleanIndexable SINGLE_TRUE = BooleanIndexable.singleton(true);
    @NotNull
    public static final Base EMPTY = new Base(){

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean get(int n) {
            throw new IndexOutOfBoundsException("Empty indexable has no elements!");
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public int addToArray(@NotNull boolean[] blArray, int n) {
            return n;
        }

        @Override
        public int addToArray(@NotNull boolean[] blArray, int n, int n2, int n3) {
            return n;
        }

        @Override
        @NotNull
        public boolean[] toArray() {
            return Empty.BOOLEAN_ARRAY;
        }

        @Override
        @NotNull
        public Iterable<Integer> indexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        @NotNull
        public IntIndexable intIndexes() {
            return IntIndexable.EMPTY;
        }

        @Override
        public boolean foldLeft(boolean bl, @NotNull BooleanOperator2 booleanOperator2) {
            return bl;
        }

        @Override
        @NotNull
        public Base reverse() {
            return this;
        }

        @Override
        @NotNull
        public BooleanIndexable rotated(int n) {
            return this;
        }

        @Override
        @NotNull
        public Base frozen() {
            return this;
        }

        @Override
        @NotNull
        public Iterator<Boolean> iterator() {
            return Types.emptyIterator();
        }

        @Override
        @NotNull
        public ListIterator<Boolean> listIterator() {
            return Types.emptyListIterator();
        }

        @Override
        @NotNull
        public PrimitiveBooleanIterator booleanIterator() {
            return Types.EMPTY_BOOLEAN_ITERATOR;
        }

        @Override
        public void forEachBool(@NotNull BooleanConsumer booleanConsumer) {
        }

        @Override
        public boolean containsBool(boolean bl) {
            return false;
        }

        @Override
        public boolean containsTrue() {
            return false;
        }

        @Override
        public boolean containsFalse() {
            return false;
        }

        @Override
        public boolean or() {
            return false;
        }

        @Override
        public boolean and() {
            return false;
        }

        @Override
        public boolean xor() {
            return false;
        }

        @Override
        public int compareTo(@NotNull BooleanIndexable booleanIndexable) {
            return booleanIndexable.isEmpty() ? 0 : -1;
        }

        @Override
        public String toString() {
            return "[]";
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof BooleanIndexable && ((BooleanIndexable)object).isEmpty();
        }
    };

    public boolean get(int var1);

    default public boolean gyt(int n) {
        return this.get(Pythonesque.mapX(n, this));
    }

    default public boolean getMod(int n) {
        int n2 = this.size();
        if (n2 == 0) {
            throw new IndexOutOfBoundsException("No element for empty indexable!");
        }
        return this.gyt(n % n2);
    }

    @NotNull
    default public Base reverse() {
        return new Base(){

            @Override
            public int size() {
                return BooleanIndexable.this.size();
            }

            @Override
            public boolean get(int n) {
                return BooleanIndexable.this.get(BooleanIndexable.this.size() - n - 1);
            }

            @Override
            @NotNull
            public Base reverse() {
                return BooleanIndexable.this.asBase();
            }
        };
    }

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @NotNull
    default public PrimitiveBooleanIterator booleanIterator() {
        return this.booleanIterator(0, this.size());
    }

    @NotNull
    default public PrimitiveBooleanIterator booleanIterator(final int n, final int n2) {
        return new PrimitiveBooleanIterator(){
            private int index;
            {
                this.index = n;
            }

            @Override
            public boolean nextBool() {
                if (this.index >= n2) {
                    throw new NoSuchElementException(String.format("Index %s out of allowed range [%d, %d[!", this.index, n, n2));
                }
                return BooleanIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasNext() {
                return this.index < n2;
            }
        };
    }

    @Override
    @NotNull
    default public Iterator<Boolean> iterator() {
        return this.listIterator();
    }

    @NotNull
    default public ListIterator<Boolean> listIterator() {
        return new ListIterator<Boolean>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < BooleanIndexable.this.size();
            }

            @Override
            public Boolean next() {
                if (this.index >= BooleanIndexable.this.size()) {
                    throw new NoSuchElementException("index: " + this.index);
                }
                return BooleanIndexable.this.get(this.index++);
            }

            @Override
            public boolean hasPrevious() {
                return this.index > 0;
            }

            @Override
            public Boolean previous() {
                if (this.index == 0) {
                    throw new NoSuchElementException("index: -1");
                }
                return BooleanIndexable.this.get(--this.index);
            }

            @Override
            public int nextIndex() {
                return this.index;
            }

            @Override
            public int previousIndex() {
                return this.index - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Boolean bl) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Boolean bl) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @NotNull
    default public Base subSet(final int n, int n2) {
        if (n < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + n);
        }
        if (n2 > this.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + n2);
        }
        if (n > n2) {
            throw new IllegalArgumentException("fromIndex(" + n + ") > toIndex(" + n2 + ")");
        }
        final int n3 = n2 - n;
        return n3 == 0 ? EMPTY : new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public boolean get(int n2) {
                if (n2 < 0 || n2 >= n3) {
                    throw new IndexOutOfBoundsException("No such element: " + n2);
                }
                return BooleanIndexable.this.get(n2 + n);
            }

            @Override
            @NotNull
            public Base subSet(int n4, int n2) {
                if (n4 < 0) {
                    throw new IndexOutOfBoundsException("fromIndex = " + n4);
                }
                if (n2 > n3) {
                    throw new IndexOutOfBoundsException("toIndex = " + n2);
                }
                if (n4 > n2) {
                    throw new IllegalArgumentException("fromIndex(" + n4 + ") > toIndex(" + n2 + ")");
                }
                return BooleanIndexable.this.subSet(n + n4, n + n2);
            }
        };
    }

    @NotNull
    default public Base sybSet(int n, int n2) {
        return this.subSet(Pythonesque.mapX(n, this), Pythonesque.mapX(n2, this));
    }

    @NotNull
    default public Base tailSet(int n) {
        return this.subSet(Pythonesque.mapX(n, this), this.size());
    }

    @NotNull
    default public Base headSet(int n) {
        return this.subSet(0, Pythonesque.mapX(n, this));
    }

    @NotNull
    default public <T> Indexable<T> view(final @NotNull BooleanFunction1<? extends T> booleanFunction1) {
        return new Indexable.Base<T>(){

            @Override
            public int size() {
                return BooleanIndexable.this.size();
            }

            @Override
            public T get(int n) {
                return booleanFunction1.applyAsBool(BooleanIndexable.this.get(n));
            }
        };
    }

    @NotNull
    default public Collection<Boolean> asCollection() {
        return new AbstractCollection<Boolean>(){

            @Override
            @NotNull
            public Iterator<Boolean> iterator() {
                return BooleanIndexable.this.iterator();
            }

            @Override
            public int size() {
                return BooleanIndexable.this.size();
            }
        };
    }

    @NotNull
    default public List<Boolean> asList() {
        return new AbstractList<Boolean>(){

            @Override
            public Boolean get(int n) {
                return BooleanIndexable.this.get(n);
            }

            @Override
            public int size() {
                return BooleanIndexable.this.size();
            }

            @Override
            @NotNull
            public Iterator<Boolean> iterator() {
                return BooleanIndexable.this.iterator();
            }
        };
    }

    @NotNull
    default public ArrayList<Boolean> toList() {
        ArrayList<Boolean> arrayList = new ArrayList<Boolean>(this.size());
        this.addAllTo(arrayList);
        return arrayList;
    }

    default public void addAllTo(@NotNull Collection<? super Boolean> collection) {
        for (Boolean bl : this) {
            collection.add(bl);
        }
    }

    @NotNull
    default public Indexable<Boolean> asIndexable() {
        return new Indexable.Base<Boolean>(){

            @Override
            public Boolean get(int n) {
                return BooleanIndexable.this.get(n);
            }

            @Override
            public int size() {
                return BooleanIndexable.this.size();
            }
        };
    }

    @NotNull
    default public boolean[] toArray() {
        if (this.isEmpty()) {
            return Empty.BOOLEAN_ARRAY;
        }
        boolean[] blArray = new boolean[this.size()];
        this.addToArray(blArray, 0);
        return blArray;
    }

    default public int addToArray(@NotNull boolean[] blArray, int n) {
        return this.addToArray(blArray, n, 0, this.size());
    }

    default public int addToArray(@NotNull boolean[] blArray, int n, int n2, int n3) {
        PrimitiveBooleanIterator primitiveBooleanIterator = this.booleanIterator(n2, n2 + n3);
        while (primitiveBooleanIterator.hasNext()) {
            blArray[n++] = primitiveBooleanIterator.nextBool();
        }
        return n;
    }

    @NotNull
    default public Iterable<Integer> indexes() {
        return Range.indexes(this.size());
    }

    @NotNull
    default public IntIndexable intIndexes() {
        return IntIndexable.rangeFromSize(this.size());
    }

    default public boolean foldLeft(boolean bl, @NotNull BooleanOperator2 booleanOperator2) {
        boolean bl2 = bl;
        PrimitiveBooleanIterator primitiveBooleanIterator = this.booleanIterator();
        while (primitiveBooleanIterator.hasNext()) {
            bl2 = booleanOperator2.applyAsBoolean(bl2, primitiveBooleanIterator.nextBool());
        }
        return bl2;
    }

    @NotNull
    default public BooleanIndexable withInsertedValueAt(int n, final boolean bl) {
        final int n2 = n;
        final int n3 = this.size() + 1;
        if (n2 == 0) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public boolean get(int n) {
                    return n == 0 ? bl : BooleanIndexable.this.get(n - 1);
                }
            };
        }
        if (n2 == n3 - 1) {
            return new Base(){

                @Override
                public int size() {
                    return n3;
                }

                @Override
                public boolean get(int n) {
                    return n == n3 - 1 ? bl : BooleanIndexable.this.get(n);
                }
            };
        }
        return new Base(){

            @Override
            public int size() {
                return n3;
            }

            @Override
            public boolean get(int n) {
                if (n == n2) {
                    return bl;
                }
                return BooleanIndexable.this.get(n < n2 ? n : n - 1);
            }
        };
    }

    @NotNull
    default public BooleanIndexable withAppendedValue(boolean bl) {
        return this.withInsertedValueAt(this.size(), bl);
    }

    @NotNull
    default public BooleanIndexable withExchangedValueAt(int n, final boolean bl) {
        final int n2 = Pythonesque.mapX(n, this);
        return new Base(){

            @Override
            public boolean get(int n) {
                return n == n2 ? bl : BooleanIndexable.this.get(n);
            }

            @Override
            public int size() {
                return BooleanIndexable.this.size();
            }
        };
    }

    @NotNull
    default public BooleanIndexable withRemovedValueAt(int n) {
        final int n2 = Pythonesque.mapX(n, this);
        if (n2 == 0) {
            return this.tailSet(1);
        }
        final int n3 = this.size() - 1;
        if (n2 == n3) {
            return this.headSet(-1);
        }
        return new Base(){

            @Override
            public boolean get(int n) {
                return n < n2 ? BooleanIndexable.this.get(n) : BooleanIndexable.this.get(n + 1);
            }

            @Override
            public int size() {
                return n3;
            }
        };
    }

    @NotNull
    default public BooleanIndexable withSwappedValuesAt(int n, int n2) {
        int n3;
        final int n4 = Pythonesque.mapX(n, this);
        if (n4 == (n3 = Pythonesque.mapX(n2, this))) {
            return this;
        }
        return new Base(){

            @Override
            public boolean get(int n) {
                if (n == n4) {
                    return BooleanIndexable.this.get(n3);
                }
                if (n == n3) {
                    return BooleanIndexable.this.get(n4);
                }
                return BooleanIndexable.this.get(n);
            }

            @Override
            public int size() {
                return BooleanIndexable.this.size();
            }
        };
    }

    @NotNull
    default public BooleanIndexable rotated(int n) {
        if ((n %= this.size()) == 0) {
            return this;
        }
        if (n < 0) {
            n += this.size();
        }
        final int n2 = n;
        return new Base(){

            @Override
            public boolean get(int n) {
                return BooleanIndexable.this.get((n + n2) % this.size());
            }

            @Override
            public int size() {
                return BooleanIndexable.this.size();
            }

            @Override
            @NotNull
            public BooleanIndexable rotated(int n) {
                return BooleanIndexable.this.rotated(n2 + n);
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Boolean> list) {
        if (list.isEmpty()) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean get(int n) {
                return (Boolean)list.get(n);
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewList(final @NotNull List<? extends Boolean> list, final boolean bl) {
        if (list.isEmpty()) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean get(int n) {
                Boolean bl2 = (Boolean)list.get(n);
                return bl2 != null ? bl2 : bl;
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static <T> Base viewList(final @NotNull List<T> list, final @NotNull Predicate<? super T> predicate) {
        if (list.isEmpty()) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public boolean get(int n) {
                return predicate.test(list.get(n));
            }

            @Override
            public int size() {
                return list.size();
            }

            @Override
            public boolean isEmpty() {
                return list.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Boolean> indexable) {
        if (indexable.isEmpty()) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public boolean get(int n) {
                return (Boolean)indexable.get(n);
            }
        };
    }

    @NotNull
    public static Base viewIndexable(final @NotNull Indexable<? extends Boolean> indexable, final boolean bl) {
        if (indexable.isEmpty()) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public boolean get(int n) {
                Boolean bl2 = (Boolean)indexable.get(n);
                return bl2 != null ? bl2 : bl;
            }
        };
    }

    @NotNull
    public static <T> Base viewIndexable(final @NotNull Indexable<T> indexable, final @NotNull Predicate<? super T> predicate) {
        if (indexable.isEmpty()) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public boolean get(int n) {
                return predicate.test(indexable.get(n));
            }

            @Override
            public int size() {
                return indexable.size();
            }

            @Override
            public boolean isEmpty() {
                return indexable.isEmpty();
            }
        };
    }

    @NotNull
    public static Base viewArray(final boolean ... blArray) {
        if (blArray.length == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return blArray.length;
            }

            @Override
            public boolean get(int n) {
                return blArray[n];
            }
        };
    }

    @NotNull
    public static Base viewArray(final @NotNull boolean[] blArray, final int n, final int n2) {
        if (n < 0 || n2 < 0 || n + n2 > blArray.length) {
            throw new IndexOutOfBoundsException("Start or end outside of range!");
        }
        if (n2 == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public int size() {
                return n2;
            }

            @Override
            public boolean get(int n3) {
                if (n3 < 0 || n3 >= n2) {
                    throw new IndexOutOfBoundsException(String.format("Index %d outside range [0, %d[!", n3, n2));
                }
                return blArray[n3 + n];
            }
        };
    }

    @NotNull
    public static <T> Base viewArray(final @NotNull T[] TArray, final @NotNull Predicate<? super T> predicate) {
        if (TArray.length == 0) {
            return EMPTY;
        }
        return new Base(){

            @Override
            public boolean get(int n) {
                return predicate.test(TArray[n]);
            }

            @Override
            public int size() {
                return TArray.length;
            }
        };
    }

    @NotNull
    public static Base singleton(final boolean bl) {
        return new Base(){

            @Override
            public int size() {
                return 1;
            }

            @Override
            public boolean get(int n) {
                if (n != 0) {
                    throw new IndexOutOfBoundsException(String.format("Index %d for indexable of size 1!", n));
                }
                return bl;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }

            @Override
            @NotNull
            public Base reverse() {
                return this;
            }

            @Override
            @NotNull
            public BooleanIndexable rotated(int n) {
                return this;
            }

            @Override
            @NotNull
            public Collection<Boolean> asCollection() {
                return Collections.singleton(bl);
            }

            @Override
            @NotNull
            public List<Boolean> asList() {
                return Collections.singletonList(bl);
            }

            @Override
            @NotNull
            public boolean[] toArray() {
                return new boolean[]{bl};
            }

            @Override
            public int addToArray(@NotNull boolean[] blArray, int n) {
                blArray[n] = bl;
                return n + 1;
            }

            @Override
            @NotNull
            public Iterable<Integer> indexes() {
                return IntIndexable.SINGLE_0;
            }

            @Override
            @NotNull
            public IntIndexable intIndexes() {
                return IntIndexable.SINGLE_0;
            }
        };
    }

    @NotNull
    public static Base init(final int n, final boolean bl) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public boolean get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return bl;
            }

            @Override
            public int size() {
                return 0;
            }

            @Override
            @NotNull
            public BooleanIndexable frozen() {
                return this;
            }
        };
    }

    @NotNull
    public static Base viewByIndex(final int n, final @NotNull IntPredicate1 intPredicate1) {
        if (n == 0) {
            return EMPTY;
        }
        if (n < 0) {
            throw new IndexOutOfBoundsException("Indexables with negative size are impossible: " + n);
        }
        return new Base(){

            @Override
            public boolean get(int n2) {
                if (n2 < 0 || n2 >= n) {
                    throw new IndexOutOfBoundsException(String.format("Element %d requested from indexable with size %d!", n2, n));
                }
                return intPredicate1.test(n2);
            }

            @Override
            public int size() {
                return n;
            }
        };
    }

    @NotNull
    public static BooleanIndexable initByIndex(int n, @NotNull IntPredicate1 intPredicate1) {
        return BooleanIndexable.viewByIndex(n, intPredicate1).frozen();
    }

    @NotNull
    public static Base emptyIndexable() {
        return EMPTY;
    }

    @NotNull
    public static String toString(@NotNull BooleanIndexable booleanIndexable) {
        if (booleanIndexable.isEmpty()) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[').append(booleanIndexable.get(0));
        PrimitiveBooleanIterator primitiveBooleanIterator = booleanIndexable.tailSet(1).booleanIterator();
        while (primitiveBooleanIterator.hasNext()) {
            stringBuilder.append(',').append(primitiveBooleanIterator.nextBool());
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public static boolean equal(@NotNull BooleanIndexable booleanIndexable, @NotNull BooleanIndexable booleanIndexable2) {
        if (booleanIndexable == booleanIndexable2) {
            return true;
        }
        if (booleanIndexable.size() != booleanIndexable2.size()) {
            return false;
        }
        PrimitiveBooleanIterator primitiveBooleanIterator = booleanIndexable.booleanIterator();
        PrimitiveBooleanIterator primitiveBooleanIterator2 = booleanIndexable2.booleanIterator();
        while (primitiveBooleanIterator.hasNext() && primitiveBooleanIterator2.hasNext()) {
            if (primitiveBooleanIterator.nextBool() == primitiveBooleanIterator2.nextBool()) continue;
            return false;
        }
        return !primitiveBooleanIterator.hasNext() && !primitiveBooleanIterator2.hasNext();
    }

    public static boolean equal(@NotNull BooleanIndexable booleanIndexable, @Nullable Object object) {
        if (object instanceof BooleanIndexable) {
            return BooleanIndexable.equal(booleanIndexable, (BooleanIndexable)object);
        }
        return false;
    }

    public static int compare(@NotNull BooleanIndexable booleanIndexable, @NotNull BooleanIndexable booleanIndexable2) {
        PrimitiveBooleanIterator primitiveBooleanIterator = booleanIndexable.booleanIterator();
        PrimitiveBooleanIterator primitiveBooleanIterator2 = booleanIndexable2.booleanIterator();
        while (primitiveBooleanIterator.hasNext() && primitiveBooleanIterator2.hasNext()) {
            int n = Boolean.compare(primitiveBooleanIterator.nextBool(), primitiveBooleanIterator2.nextBool());
            if (n == 0) continue;
            return n;
        }
        if (primitiveBooleanIterator.hasNext()) {
            return 1;
        }
        if (primitiveBooleanIterator2.hasNext()) {
            return -1;
        }
        return 0;
    }

    public static int hash(@NotNull BooleanIndexable booleanIndexable) {
        int n = 1;
        PrimitiveBooleanIterator primitiveBooleanIterator = booleanIndexable.booleanIterator();
        while (primitiveBooleanIterator.hasNext()) {
            n = 31 * n + Boolean.hashCode(primitiveBooleanIterator.next());
        }
        return n;
    }

    @NotNull
    public static Base withCachedHash(final @NotNull BooleanIndexable booleanIndexable) {
        final int n = BooleanIndexable.hash(booleanIndexable);
        return new Base(){

            @Override
            public int size() {
                return booleanIndexable.size();
            }

            @Override
            public boolean get(int n2) {
                return booleanIndexable.get(n2);
            }

            @Override
            @NotNull
            public PrimitiveBooleanIterator booleanIterator() {
                return booleanIndexable.booleanIterator();
            }

            @Override
            @NotNull
            public PrimitiveBooleanIterator booleanIterator(int n3, int n2) {
                return booleanIndexable.booleanIterator(n3, n2);
            }

            @Override
            @NotNull
            public Iterator<Boolean> iterator() {
                return booleanIndexable.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Boolean> listIterator() {
                return booleanIndexable.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n3, int n2) {
                return booleanIndexable.subSet(n3, n2);
            }

            @Override
            public int addToArray(@NotNull boolean[] blArray, int n2) {
                return booleanIndexable.addToArray(blArray, n2);
            }

            @Override
            public int addToArray(@NotNull boolean[] blArray, int n4, int n2, int n3) {
                return booleanIndexable.addToArray(blArray, n4, n2, n3);
            }

            @Override
            public int hashCode() {
                return n;
            }

            @Override
            public boolean equals(Object object) {
                return BooleanIndexable.equal(booleanIndexable, object);
            }

            @Override
            public String toString() {
                return BooleanIndexable.toString(booleanIndexable);
            }
        };
    }

    default public int nextMatch(int n, @NotNull BooleanPredicate1 booleanPredicate1) {
        int n2 = this.size();
        for (int i = Pythonesque.mapLB(n, this); i < n2; ++i) {
            if (!booleanPredicate1.testBool(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int firstMatch(@NotNull BooleanPredicate1 booleanPredicate1) {
        return this.nextMatch(0, booleanPredicate1);
    }

    default public int previousMatch(int n, @NotNull BooleanPredicate1 booleanPredicate1) {
        for (int i = Pythonesque.mapUB(n, this); i >= 0; --i) {
            if (!booleanPredicate1.testBool(this.get(i))) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    default public int lastMatch(@NotNull BooleanPredicate1 booleanPredicate1) {
        return this.previousMatch(-1, booleanPredicate1);
    }

    @NotNull
    default public BooleanIndexable frozen() {
        return IndexableHelper.frozenFromArray(this.toArray());
    }

    default public void forEachBoolEntry(@NotNull EntryConsumer entryConsumer) {
        for (int i = 0; i < this.size(); ++i) {
            entryConsumer.accept(i, this.get(i));
        }
    }

    @NotNull
    default public Base asBase() {
        return new Base(){

            @Override
            public int size() {
                return BooleanIndexable.this.size();
            }

            @Override
            public boolean get(int n) {
                return BooleanIndexable.this.get(n);
            }

            @Override
            @NotNull
            public Base reverse() {
                return BooleanIndexable.this.reverse();
            }

            @Override
            @NotNull
            public PrimitiveBooleanIterator booleanIterator() {
                return BooleanIndexable.this.booleanIterator();
            }

            @Override
            @NotNull
            public PrimitiveBooleanIterator booleanIterator(int n, int n2) {
                return BooleanIndexable.this.booleanIterator(n, n2);
            }

            @Override
            @NotNull
            public Iterator<Boolean> iterator() {
                return BooleanIndexable.this.iterator();
            }

            @Override
            @NotNull
            public ListIterator<Boolean> listIterator() {
                return BooleanIndexable.this.listIterator();
            }

            @Override
            @NotNull
            public Base subSet(int n, int n2) {
                return BooleanIndexable.this.subSet(n, n2);
            }

            @Override
            @NotNull
            public boolean[] toArray() {
                return BooleanIndexable.this.toArray();
            }

            @Override
            public int addToArray(@NotNull boolean[] blArray, int n) {
                return BooleanIndexable.this.addToArray(blArray, n);
            }

            @Override
            public int addToArray(@NotNull boolean[] blArray, int n, int n2, int n3) {
                return BooleanIndexable.this.addToArray(blArray, n, n2, n3);
            }
        };
    }

    @FunctionalInterface
    public static interface EntryConsumer {
        public void accept(int var1, boolean var2);
    }

    public static abstract class Base
    implements BooleanIndexable,
    Comparable<BooleanIndexable> {
        @Override
        public int compareTo(@NotNull BooleanIndexable booleanIndexable) {
            Objects.requireNonNull(booleanIndexable);
            return BooleanIndexable.compare(this, booleanIndexable);
        }

        public int hashCode() {
            return BooleanIndexable.hash(this);
        }

        public boolean equals(Object object) {
            return BooleanIndexable.equal((BooleanIndexable)this, object);
        }

        public String toString() {
            return BooleanIndexable.toString(this);
        }

        @Override
        @NotNull
        public Base asBase() {
            return this;
        }
    }
}

