/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Countable;
import de.caff.generics.EmptyLoopError;
import de.caff.generics.Indexable;
import de.caff.generics.Types;
import de.caff.generics.function.Function3;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;

public class BasicLoop<T extends Item<T>>
implements Countable<T> {
    private T first;
    private int size;

    public BasicLoop() {
    }

    public <V> BasicLoop(@NotNull Iterable<V> iterable, @NotNull Function<? super V, Function3<T, BasicLoop<T>, T, T>> function) {
        this.addAll(iterable, function);
    }

    @SafeVarargs
    public <V> BasicLoop(@NotNull Function<? super V, Function3<T, BasicLoop<T>, T, T>> function, V ... VArray) {
        this.addAll(Indexable.viewArray(VArray), function);
    }

    @NotNull
    public T getFirstItem() {
        if (this.first == null) {
            throw new EmptyLoopError();
        }
        return this.first;
    }

    @Nullable
    public T getFirstItemOrNull() {
        return this.first;
    }

    @NotNull
    public T getLastItem() {
        return (T)((Item)this.getFirstItem()).previous;
    }

    @Nullable
    public T getLastItemOrNull() {
        return this.first == null ? null : (T)((Item)this.first).previous;
    }

    public void rotate(int n) {
        if (this.size < 2) {
            return;
        }
        if ((n %= this.size) < -this.size / 2) {
            n += this.size;
        } else if (n > this.size / 2) {
            n -= this.size;
        }
        assert (this.first != null);
        if (n == 0) {
            return;
        }
        if (n < 0) {
            while (n++ < 0) {
                this.first = ((Item)this.first).previous;
            }
        } else {
            while (n-- > 0) {
                this.first = ((Item)this.first).next;
            }
        }
    }

    public boolean rotateForwardUntil(@NotNull Predicate<? super T> predicate) {
        return this.rotateUntil(predicate, Item::getNext);
    }

    public boolean rotateBackwardUntil(@NotNull Predicate<? super T> predicate) {
        return this.rotateUntil(predicate, Item::getPrevious);
    }

    private boolean rotateUntil(@NotNull Predicate<? super T> predicate, @NotNull UnaryOperator<T> unaryOperator) {
        if (this.first == null) {
            return false;
        }
        int n = 0;
        while (n++ < this.size) {
            if (predicate.test(this.first)) {
                return true;
            }
            this.first = (Item)unaryOperator.apply(this.first);
        }
        return false;
    }

    @Nullable
    public T findFirst(@NotNull Predicate<? super T> predicate) {
        if (this.first == null) {
            return null;
        }
        return ((Item)this.first).findNext(predicate);
    }

    @Nullable
    public T findLast(@NotNull Predicate<? super T> predicate) {
        if (this.first == null) {
            return null;
        }
        return ((Item)this.first).findNext(predicate);
    }

    @NotNull
    public T add(@NotNull Function3<T, BasicLoop<T>, T, T> function3) {
        if (this.first == null) {
            this.first = (Item)function3.apply(this, null, null);
            return this.first;
        }
        return ((Item)this.first).insertBefore(function3);
    }

    public <V> void addAll(@NotNull Iterable<V> iterable, @NotNull Function<? super V, Function3<T, BasicLoop<T>, T, T>> function) {
        iterable.forEach(object -> this.add((Function3)function.apply((Object)object)));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.first == null;
    }

    public void clear() {
        this.first = null;
        this.size = 0;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.first == null ? Types.emptyIterator() : new ItemIterator<T>(this.first);
    }

    @NotNull
    public Countable<T> closedItemView() {
        if (this.isEmpty()) {
            return this;
        }
        return Countable.combined(this, Countable.singleton(this.first));
    }

    public void removeSuccessiveDuplicates(@NotNull BiPredicate<? super T, ? super T> biPredicate) {
        if (this.size < 2) {
            return;
        }
        while (((Item)this.first).getPrevious() != this.first && biPredicate.test(this.first, ((Item)this.first).getPrevious())) {
            ((Item)((Item)this.first).getPrevious()).remove();
        }
        Object v = ((Item)this.first).getNext();
        while (v != this.first) {
            Object v2 = ((Item)v).getNext();
            if (biPredicate.test(((Item)v).getPrevious(), v)) {
                ((Item)v).remove();
            }
            v = v2;
        }
    }

    public void removeSuccessiveDuplicates() {
        this.removeSuccessiveDuplicates(Objects::deepEquals);
    }

    public String toString() {
        return this.toString(" ");
    }

    @NotNull
    public String toString(@NotNull String string) {
        if (this.isEmpty()) {
            return "\u21bb";
        }
        StringBuilder stringBuilder = new StringBuilder("\u2924 ");
        boolean bl = true;
        for (Item item : this) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(string).append("\u2192 ");
            }
            stringBuilder.append(item);
        }
        stringBuilder.append(string).append("\u2926");
        return stringBuilder.toString();
    }

    @NotNull
    public String toMultiLineString() {
        return this.toString("\n");
    }

    private static class ItemIterator<I extends Item<I>>
    implements Iterator<I> {
        @NotNull
        private final I last;
        @Nullable
        private I next;

        ItemIterator(@NotNull I i) {
            this.last = i;
            this.next = i;
        }

        ItemIterator(@NotNull I i, @NotNull I i2) {
            this.last = ((Item)i2).getNext();
            this.next = i;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public I next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            I i = this.next;
            this.next = ((Item)this.next).next;
            if (this.next == this.last) {
                this.next = null;
            }
            return i;
        }
    }

    public static abstract class Item<V extends Item<V>> {
        @Nullable
        BasicLoop<V> loop;
        @NotNull
        V previous;
        @NotNull
        V next;

        protected Item(@NotNull BasicLoop<V> basicLoop, @Nullable V v, @Nullable V v2) {
            this.loop = basicLoop;
            if (v != null) {
                assert (v2 != null);
                this.previous = v;
                this.next = v2;
                assert (((Item)v).loop == basicLoop);
                assert (((Item)v2).loop == basicLoop);
                ((Item)v).next = this;
                ((Item)v2).previous = this;
            } else {
                assert (v2 == null);
                assert (((BasicLoop)basicLoop).size == 0);
                this.previous = this;
                this.next = this;
            }
            ++((BasicLoop)basicLoop).size;
        }

        protected Item(@NotNull BasicLoop<V> basicLoop) {
            this(basicLoop, null, null);
        }

        @NotNull
        public V getPrevious() {
            return this.previous;
        }

        @NotNull
        public V getNext() {
            return this.next;
        }

        public V advanced(int n) {
            if (this.loop != null) {
                n %= ((BasicLoop)this.loop).size;
            }
            if (n == 0) {
                return (V)this;
            }
            Item<V> item = this;
            if (n < 0) {
                while (++n <= 0) {
                    item = item.previous;
                }
            } else {
                while (--n >= 0) {
                    item = item.next;
                }
            }
            return (V)item;
        }

        public int stepsTo(@NotNull V v) {
            if (v == this) {
                return 0;
            }
            if (this.loop == null) {
                throw new IllegalStateException("Trying to find the steps to an item from an item outside of loops!");
            }
            if (((Item)v).loop != this.loop) {
                throw new IllegalArgumentException("Trying to find the steps to an item in another loop!");
            }
            int n = 1;
            V v2 = this.next;
            while (v2 != this) {
                if (v2 == v) {
                    return n;
                }
                ++n;
                v2 = ((Item)v2).next;
            }
            throw new IllegalStateException("No match in loop!");
        }

        public int minStepsTo(@NotNull V v) {
            int n = this.stepsTo(v);
            assert (this.loop != null);
            return n > ((BasicLoop)this.loop).size / 2 ? n - ((BasicLoop)this.loop).size : n;
        }

        @Nullable
        public BasicLoop<V> getLoop() {
            return this.loop;
        }

        public boolean isValid() {
            return this.loop != null;
        }

        @NotNull
        public V insertBefore(Function3<? extends V, BasicLoop<V>, V, V> function3) {
            if (this.loop == null) {
                throw new IllegalStateException("Cannot insert before a removed item!");
            }
            return (V)((Item)function3.apply(this.loop, this.previous, this));
        }

        @NotNull
        public V insertAfter(Function3<? extends V, BasicLoop<V>, V, V> function3) {
            if (this.loop == null) {
                throw new IllegalStateException("Cannot insert before a removed item!");
            }
            return (V)((Item)function3.apply(this.loop, this, this.next));
        }

        public void swapPlaces(@NotNull V v) {
            if (v == this) {
                return;
            }
            BasicLoop<V> basicLoop = this.loop;
            BasicLoop<V> basicLoop2 = ((Item)v).loop;
            V v2 = this.previous;
            V v3 = this.next;
            V v4 = ((Item)v).previous;
            V v5 = ((Item)v).next;
            if (basicLoop == null) {
                if (basicLoop2 == null) {
                    return;
                }
                if (((BasicLoop)basicLoop2).size == 1) {
                    ((BasicLoop)basicLoop2).first = this;
                    this.next = this;
                    this.previous = this.next;
                } else {
                    ((Item)v5).previous = this;
                    ((Item)v4).next = ((Item)v5).previous;
                    this.previous = v4;
                    this.next = v5;
                    if (((BasicLoop)basicLoop2).first == v) {
                        ((BasicLoop)basicLoop2).first = this;
                    }
                }
                this.loop = basicLoop2;
                ((Item)v).loop = null;
            } else if (basicLoop2 == null) {
                if (((BasicLoop)basicLoop).size == 1) {
                    ((BasicLoop)basicLoop).first = v;
                    ((Item)v).next = v;
                    ((Item)v).previous = ((Item)v).next;
                } else {
                    ((Item)v3).previous = v;
                    ((Item)v2).next = ((Item)v3).previous;
                    ((Item)v).previous = v2;
                    ((Item)v).next = v3;
                    if (((BasicLoop)basicLoop).first == this) {
                        ((BasicLoop)basicLoop).first = v;
                    }
                }
                ((Item)v).loop = basicLoop;
                this.loop = null;
            } else if (basicLoop == basicLoop2) {
                if (v2 == v) {
                    assert (v5 == this);
                    if (((BasicLoop)basicLoop).size == 2) {
                        basicLoop.rotate(1);
                        return;
                    }
                    ((Item)v3).previous = v;
                    ((Item)v).next = v3;
                    ((Item)v).previous = this;
                    this.next = v;
                    ((Item)v4).next = this;
                    this.previous = v4;
                } else if (v3 == v) {
                    assert (v4 == this);
                    if (((BasicLoop)basicLoop).size == 2) {
                        basicLoop.rotate(1);
                        return;
                    }
                    ((Item)v2).next = v;
                    ((Item)v).previous = v2;
                    ((Item)v).next = this;
                    this.previous = v;
                    ((Item)v5).previous = this;
                    this.next = v5;
                } else {
                    ((Item)v2).next = v;
                    ((Item)v).previous = v2;
                    ((Item)v3).previous = v;
                    ((Item)v).next = v3;
                    ((Item)v4).next = this;
                    this.previous = v4;
                    ((Item)v5).previous = this;
                    this.next = v5;
                }
                if (((BasicLoop)basicLoop).first == this) {
                    ((BasicLoop)basicLoop).first = v;
                } else if (((BasicLoop)basicLoop2).first == v) {
                    ((BasicLoop)basicLoop2).first = this;
                }
            } else {
                ((Item)v2).next = v;
                ((Item)v).previous = v2;
                ((Item)v3).previous = v;
                ((Item)v).next = v3;
                ((Item)v).loop = basicLoop;
                ((Item)v4).next = this;
                this.previous = v4;
                ((Item)v5).previous = this;
                this.next = v5;
                this.loop = basicLoop2;
                if (((BasicLoop)basicLoop).first == this) {
                    ((BasicLoop)basicLoop).first = v;
                }
                if (((BasicLoop)basicLoop2).first == v) {
                    ((BasicLoop)basicLoop2).first = this;
                }
            }
        }

        public V exchangeWith(@NotNull Function3<? extends V, BasicLoop<V>, V, V> function3) {
            Item item = (Item)function3.apply(this.loop, this, this.next);
            this.remove();
            return (V)item;
        }

        public void remove() {
            if (this.loop == null) {
                throw new IllegalStateException("Must not remove an item more than once!");
            }
            --((BasicLoop)this.loop).size;
            assert (((BasicLoop)this.loop).size >= 0);
            ((Item)this.previous).next = this.next;
            ((Item)this.next).previous = this.previous;
            if (((BasicLoop)this.loop).first == this) {
                if (((BasicLoop)this.loop).size == 0) {
                    ((BasicLoop)this.loop).first = null;
                } else {
                    ((BasicLoop)this.loop).first = this.next;
                }
            }
            this.loop = null;
        }

        @Nullable
        public V findNext(@NotNull Predicate<? super V> predicate) {
            if (predicate.test(this)) {
                return (V)this;
            }
            V v = this.next;
            while (v != this) {
                if (predicate.test(v)) {
                    return v;
                }
                v = ((Item)v).next;
            }
            return null;
        }

        @Nullable
        public V findPrevious(@NotNull Predicate<? super V> predicate) {
            if (predicate.test(this)) {
                return (V)this;
            }
            V v = this.previous;
            while (v != this) {
                if (predicate.test(v)) {
                    return v;
                }
                v = ((Item)v).next;
            }
            return null;
        }

        @NotNull
        Iterator<V> iteratorTo(@NotNull V v) {
            if (this.loop == null) {
                throw new IllegalStateException("Cannot iterate because item is outside loop!");
            }
            if (this.loop != ((Item)v).loop) {
                throw new IllegalArgumentException("Cannot iterate to an item in another loop!");
            }
            if (v == this) {
                return this.loop.closedItemView().iterator();
            }
            return new ItemIterator<Item>(this, (Item)((Item)v).next);
        }
    }
}

