/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayIterator<T>
implements Iterator<T> {
    @NotNull
    private final T[] array;
    private int run;
    private final int end;

    @SafeVarargs
    public ArrayIterator(T ... TArray) {
        this(TArray, 0, TArray.length);
    }

    public ArrayIterator(@NotNull T[] TArray, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("start has to be non-negative, but is " + n);
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("length has to be non-negative, but is " + n2);
        }
        if (n > TArray.length - n2) {
            throw new IllegalArgumentException(String.format("Cannot iterate to %d+%d=%d when array has only %d elements!", n, n2, (long)n + (long)n2, TArray.length));
        }
        this.array = TArray;
        this.run = n;
        this.end = n + n2;
    }

    @Override
    public boolean hasNext() {
        return this.run < this.end;
    }

    @Override
    public T next() {
        if (this.run >= this.end) {
            throw new NoSuchElementException("Iterating over the end!");
        }
        return this.array[this.run++];
    }
}

