/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.ActiveListListener;
import de.caff.generics.SynchronizedCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ActiveList<T>
extends AbstractList<T> {
    @NotNull
    private final List<T> wrapped;
    @NotNull
    private final Collection<ActiveListListener<? super T>> listeners = new SynchronizedCollection(new LinkedList());

    public ActiveList(@NotNull List<T> list) {
        this.wrapped = list;
    }

    @NotNull
    public static <S> ActiveList<S> wrap(@NotNull List<S> list) {
        return new ActiveList<S>(list);
    }

    public void addActiveListListener(@NotNull ActiveListListener<? super T> activeListListener) {
        this.listeners.add(activeListListener);
    }

    public void removeActiveListListener(@NotNull ActiveListListener<? super T> activeListListener) {
        this.listeners.remove(activeListListener);
    }

    private void fireAdded(int n, T t) {
        for (ActiveListListener<T> activeListListener : this.listeners) {
            activeListListener.itemAdded(n, t);
        }
    }

    private void fireRemoved(int n, T t) {
        for (ActiveListListener<T> activeListListener : this.listeners) {
            activeListListener.itemRemoved(n, t);
        }
    }

    private void fireExchanged(int n, T t, T t2) {
        for (ActiveListListener<T> activeListListener : this.listeners) {
            activeListListener.itemExchanged(n, t, t2);
        }
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.wrapped.contains(object);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.wrapped.toArray();
    }

    @Override
    @NotNull
    public <T1> T1[] toArray(@NotNull T1[] T1Array) {
        return this.wrapped.toArray(T1Array);
    }

    private boolean doRemove(int n, T t) {
        if (this.wrapped.remove(t)) {
            this.fireRemoved(n, t);
            return true;
        }
        return false;
    }

    @Override
    public boolean add(T t) {
        int n = this.size();
        if (this.wrapped.add(t)) {
            this.fireAdded(n, t);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.indexOf(object);
        if (n < 0) {
            return false;
        }
        return this.doRemove(n, object);
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        return this.wrapped.containsAll(collection);
    }

    @Override
    public void clear() {
        if (this.wrapped.isEmpty()) {
            return;
        }
        ArrayList<T> arrayList = new ArrayList<T>(this.wrapped);
        ListIterator listIterator = arrayList.listIterator(arrayList.size());
        while (listIterator.hasPrevious()) {
            int n = listIterator.previousIndex();
            Object e = listIterator.previous();
            this.doRemove(n, e);
        }
    }

    @Override
    public T get(int n) {
        return this.wrapped.get(n);
    }

    @Override
    public T set(int n, T t) {
        T t2 = this.wrapped.set(n, t);
        this.fireExchanged(n, t2, t);
        return t2;
    }

    @Override
    public void add(int n, T t) {
        this.wrapped.add(n, t);
        this.fireAdded(n, t);
    }

    @Override
    public T remove(int n) {
        T t = this.wrapped.remove(n);
        this.fireRemoved(n, t);
        return t;
    }

    @Override
    public int indexOf(Object object) {
        return this.wrapped.indexOf(object);
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.wrapped.lastIndexOf(object);
    }
}

