/*
 * Decompiled with CFR 0.152.
 */
package de.caff.generics;

import de.caff.annotation.NotNull;
import de.caff.generics.CountingSet;
import de.caff.generics.util.Counter;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Supplier;

class AbstractBasicCountingSet<T>
implements CountingSet<T> {
    @NotNull
    protected final Supplier<Counter> creator;
    @NotNull
    protected final Map<T, Counter> map;

    public AbstractBasicCountingSet(@NotNull Map<T, Counter> map, @NotNull Supplier<Counter> supplier) {
        this.creator = supplier;
        this.map = map;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.map.keySet().toArray();
    }

    @Override
    @NotNull
    public <U> U[] toArray(@NotNull U[] UArray) {
        return this.map.keySet().toArray(UArray);
    }

    @Override
    public boolean add(T t) {
        boolean bl;
        Counter counter = this.map.get(t);
        boolean bl2 = bl = counter == null;
        if (bl) {
            counter = this.creator.get();
            this.map.put(t, counter);
        }
        counter.add1();
        return bl;
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("removal not allowed!");
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> collection) {
        return this.map.keySet().containsAll(collection);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> collection) {
        boolean bl = false;
        for (T t : collection) {
            if (!this.add(t)) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> collection) {
        throw new UnsupportedOperationException("removal not allowed!");
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> collection) {
        throw new UnsupportedOperationException("removal not allowed!");
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public int getCount(T t) {
        Counter counter = this.map.get(t);
        return counter != null ? counter.getValue() : 0;
    }
}

