/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.xml;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Types;
import de.caff.generics.function.FragileFunction1;
import de.caff.util.ModuleVersion;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

@Deprecated
public class XmlTool {
    public static final String RELEASE_DATE = ModuleVersion.getReleaseDate();
    private static final String NOT_MASK = "Attribute value '%s' of attribute %s of element %s is %s!";

    private XmlTool() {
    }

    @NotNull
    public static String getValue(@NotNull Element element, @NotNull String string) throws SAXException {
        Attr attr = element.getAttributeNode(string);
        if (attr == null) {
            throw new SAXException(String.format("Required attribute %s is missing in %s!", string, element.getTagName()));
        }
        return attr.getValue();
    }

    @Nullable
    public static String getOptionalValue(@NotNull Element element, @NotNull String string) {
        Attr attr = element.getAttributeNode(string);
        return attr == null ? null : attr.getValue();
    }

    public static <T> T getValue(@NotNull Element element, @NotNull String string, @NotNull Function<String, ? extends T> function) throws SAXException {
        try {
            return function.apply(XmlTool.getValue(element, string));
        }
        catch (Throwable throwable) {
            throw new SAXException(String.format("Extractor failed for attribute %s in element %s!", string, element));
        }
    }

    public static <T, E extends Exception> T getValueF(@NotNull Element element, @NotNull String string, @NotNull FragileFunction1<? extends T, E, String> fragileFunction1) throws SAXException {
        try {
            return (T)fragileFunction1.apply((Object)XmlTool.getValue(element, string));
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            throw new SAXException(String.format("Extractor failed for attribute %s in element %s!", string, element), exception);
        }
        catch (Throwable throwable) {
            throw new SAXException(String.format("Extractor failed for attribute %s in element %s!", string, element));
        }
    }

    @Nullable
    public static <T> T getOptionalValue(@NotNull Element element, @NotNull String string, @NotNull Function<String, ? extends T> function) {
        String string2 = XmlTool.getOptionalValue(element, string);
        return string2 != null ? (T)function.apply(string2) : null;
    }

    @Nullable
    public static <T, E extends Exception> T getOptionalValueF(@NotNull Element element, @NotNull String string, @NotNull FragileFunction1<? extends T, E, String> fragileFunction1) throws E {
        String string2 = XmlTool.getOptionalValue(element, string);
        return (T)(string2 != null ? fragileFunction1.apply((Object)string2) : null);
    }

    @NotNull
    public static String getValue(@NotNull Element element, @NotNull String string, @NotNull String string2) {
        Attr attr = element.getAttributeNode(string);
        if (attr == null) {
            return string2;
        }
        return attr.getValue();
    }

    public static int getIntValue(@NotNull Element element, @NotNull String string) throws SAXException {
        String string2 = XmlTool.getValue(element, string);
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException(String.format(NOT_MASK, string2, string, element.getTagName(), "not an integer"), numberFormatException);
        }
    }

    public static double getDoubleValue(@NotNull Element element, @NotNull String string) throws SAXException {
        String string2 = XmlTool.getValue(element, string);
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException(String.format(NOT_MASK, string2, string, element.getTagName(), "not a double"), numberFormatException);
        }
    }

    @NotNull
    public static <E extends Enum<E>> E getEnumValue(@NotNull Element element, @NotNull String string, @NotNull Class<E> clazz) throws SAXException {
        String string2 = XmlTool.getValue(element, string);
        try {
            return Enum.valueOf(clazz, string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SAXException(String.format(NOT_MASK, string2, string, element.getTagName(), "no known enum value of type " + clazz), illegalArgumentException);
        }
    }

    @NotNull
    public static String getValue(@NotNull String string, @NotNull Attributes attributes, @NotNull String string2) throws SAXException {
        String string3 = attributes.getValue(string2);
        if (string3 == null) {
            throw new SAXException(String.format("Required attribute %s is missing in %s!", string2, string));
        }
        return string3;
    }

    @NotNull
    public static String getValue(@NotNull Attributes attributes, @NotNull String string, @NotNull String string2) {
        return (String)Types.notNull((Object)attributes.getValue(string), (Object)string2);
    }

    public static int getIntValue(@NotNull String string, @NotNull Attributes attributes, @NotNull String string2) throws SAXException {
        String string3 = XmlTool.getValue(string, attributes, string2);
        try {
            return Integer.parseInt(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException(String.format(NOT_MASK, string3, string2, string, "not an integer"), numberFormatException);
        }
    }

    public static double getDoubleValue(@NotNull String string, @NotNull Attributes attributes, @NotNull String string2) throws SAXException {
        String string3 = XmlTool.getValue(string, attributes, string2);
        try {
            return Double.parseDouble(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXException(String.format(NOT_MASK, string3, string2, string, "not a double"), numberFormatException);
        }
    }

    @NotNull
    public static <E extends Enum<E>> E getEnumValue(@NotNull String string, @NotNull Attributes attributes, @NotNull String string2, @NotNull Class<E> clazz) throws SAXException {
        String string3 = XmlTool.getValue(string, attributes, string2);
        try {
            return Enum.valueOf(clazz, string3);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SAXException(String.format(NOT_MASK, string3, string2, string, "no known enum value of type " + clazz), illegalArgumentException);
        }
    }

    public static <T> T getValue(@NotNull String string, @NotNull Attributes attributes, @NotNull String string2, @NotNull Function<String, ? extends T> function) throws SAXException {
        try {
            return function.apply(XmlTool.getValue(string, attributes, string2));
        }
        catch (Throwable throwable) {
            throw new SAXException(String.format("Extractor failed for attribute %s in element <%s>!", string2, string));
        }
    }

    public static <T, E extends Exception> T getValueF(@NotNull String string, @NotNull Attributes attributes, @NotNull String string2, @NotNull FragileFunction1<? extends T, E, String> fragileFunction1) throws SAXException {
        try {
            return (T)fragileFunction1.apply((Object)XmlTool.getValue(string, attributes, string2));
        }
        catch (SAXException sAXException) {
            throw sAXException;
        }
        catch (Exception exception) {
            throw new SAXException(String.format("Extractor failed for attribute %s in element %s!", string2, string), exception);
        }
        catch (Throwable throwable) {
            throw new SAXException(String.format("Extractor failed for attribute %s in element %s!", string2, string));
        }
    }

    @Nullable
    public static <T> T getOptionalValue(@NotNull Attributes attributes, @NotNull String string, @NotNull Function<String, ? extends T> function) {
        String string2 = attributes.getValue(string);
        return string2 != null ? (T)function.apply(string2) : null;
    }

    @Nullable
    public static <T, E extends Exception> T getOptionalValueF(@NotNull Attributes attributes, @NotNull String string, @NotNull FragileFunction1<? extends T, E, String> fragileFunction1) throws E {
        String string2 = attributes.getValue(string);
        return (T)(string2 != null ? fragileFunction1.apply((Object)string2) : null);
    }

    @NotNull
    public static Element getSingleChild(@NotNull Element element, @NotNull String string) throws SAXException {
        NodeList nodeList = element.getElementsByTagName(string);
        switch (nodeList.getLength()) {
            case 0: {
                throw new SAXException(String.format("Expected subelement %s is missing in %s!", string, element.getTagName()));
            }
            case 1: {
                return (Element)nodeList.item(0);
            }
        }
        throw new SAXException(String.format("Subelement %s of element %s may only appear once!", string, element.getTagName()));
    }

    @Nullable
    public static Element getOptionalSingleChild(@NotNull Element element, @NotNull String string) throws SAXException {
        NodeList nodeList = element.getElementsByTagName(string);
        switch (nodeList.getLength()) {
            case 0: {
                return null;
            }
            case 1: {
                return (Element)nodeList.item(0);
            }
        }
        throw new SAXException(String.format("Subelement %s of element %s may only appear once!", string, element.getTagName()));
    }

    @NotNull
    public static String getContent(@NotNull Element element, boolean bl) throws SAXException {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        String string = null;
        block4: for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            switch (node.getNodeType()) {
                case 2: {
                    continue block4;
                }
                case 3: {
                    if (string != null) continue block4;
                    string = ((Text)node).getWholeText();
                    continue block4;
                }
                default: {
                    throw new SAXException(String.format("Unecpected sub node type %d for text element %s!", node.getNodeType(), element.getTagName()));
                }
            }
        }
        if (string == null) {
            if (bl) {
                throw new SAXException(String.format("Empty element not allowed for text element %s!", element.getTagName()));
            }
            string = "";
        }
        return string;
    }

    @NotNull
    public static List<Element> getChildElements(@NotNull Element element, @NotNull String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        int n = nodeList.getLength();
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<Element> arrayList = new ArrayList<Element>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add((Element)nodeList.item(i));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @NotNull
    public static Document loadFromFile(@NotNull String string) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(string);
        document.getDocumentElement().normalize();
        return document;
    }
}

