/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.xml;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Types;
import de.caff.util.Base64;
import de.caff.util.xml.StringCollector;
import java.util.Locale;
import java.util.Stack;

@Deprecated
public class SimpleXmlWriter {
    public static final String DEFAULT_ENCODING = "utf-8";
    private static final String[] HEX = new String[256];
    @NotNull
    private final Stack<String> openElements = new Stack();
    @NotNull
    protected final StringCollector collector;
    protected final boolean autoWrap;
    @Nullable
    protected final String indentation;
    @NotNull
    protected final Locale locale;

    public SimpleXmlWriter(@NotNull StringCollector stringCollector) {
        this(stringCollector, -1);
    }

    public SimpleXmlWriter(@NotNull Locale locale, @NotNull StringCollector stringCollector) {
        this(locale, stringCollector, -1);
    }

    public SimpleXmlWriter(@NotNull StringCollector stringCollector, @Nullable String string) {
        this(stringCollector, string, -1);
    }

    public SimpleXmlWriter(@NotNull Locale locale, @NotNull StringCollector stringCollector, @Nullable String string) {
        this(locale, stringCollector, string, -1);
    }

    public SimpleXmlWriter(@NotNull StringCollector stringCollector, int n) {
        this(stringCollector, SimpleXmlWriter.getDefaultPreamble(), n);
    }

    public SimpleXmlWriter(@NotNull Locale locale, @NotNull StringCollector stringCollector, int n) {
        this(locale, stringCollector, SimpleXmlWriter.getDefaultPreamble(), n);
    }

    public SimpleXmlWriter(@NotNull StringCollector stringCollector, @Nullable String string, int n) {
        this(Locale.getDefault(), stringCollector, string, n);
    }

    public SimpleXmlWriter(@NotNull Locale locale, @NotNull StringCollector stringCollector, @Nullable String string, int n) {
        this.collector = stringCollector;
        this.locale = locale;
        this.autoWrap = n >= 0;
        String string2 = this.indentation = n > 0 ? Types.spaces((int)n) : null;
        if (string != null) {
            this.add(string);
        }
    }

    public boolean isAutoWrap() {
        return this.autoWrap;
    }

    @NotNull
    public String getIndentation() {
        return Types.notNull((String)this.indentation);
    }

    @NotNull
    public Locale getLocale() {
        return this.locale;
    }

    @NotNull
    public static String getDefaultPreamble() {
        return SimpleXmlWriter.getPreamble(DEFAULT_ENCODING);
    }

    @NotNull
    public static String getPreamble(@NotNull String string) {
        return String.format("<?xml version=\"1.0\" encoding=\"%s\"?>", string);
    }

    private void insertAutoWrap(int n) {
        if (!this.autoWrap) {
            return;
        }
        switch (this.collector.getLastLetter()) {
            case '>': {
                this.nl();
            }
            case '\n': {
                if (n <= 0 || this.indentation == null) break;
                for (int i = 0; i < n; ++i) {
                    this.add(this.indentation);
                }
                break;
            }
        }
    }

    @NotNull
    public SimpleXmlWriter open(@NotNull String string, Object ... objectArray) {
        this.openElements.push(string);
        return this.writeElement(true, string, objectArray);
    }

    @NotNull
    public SimpleXmlWriter close() {
        this.insertAutoWrap(this.openElements.size() - 1);
        this.add("</").quote(this.openElements.pop()).add(">");
        return this;
    }

    @NotNull
    public SimpleXmlWriter comment(@NotNull String string) {
        this.insertAutoWrap(this.openElements.size());
        this.add("<!-- ").add(string).add("-->");
        return this;
    }

    @NotNull
    public SimpleXmlWriter expand(@NotNull byte[] byArray) {
        for (byte by : byArray) {
            this.add(HEX[by & 0xFF]);
        }
        return this;
    }

    @NotNull
    public static String expand(@NotNull byte[] byArray, int n) {
        StringBuilder stringBuilder;
        if (n > 0) {
            stringBuilder = new StringBuilder(2 * byArray.length + byArray.length / n);
            for (int i = 0; i < byArray.length; ++i) {
                if (i % n == 0 && i > 0) {
                    stringBuilder.append("\n");
                }
                stringBuilder.append(HEX[byArray[i] & 0xFF]);
            }
        } else {
            stringBuilder = new StringBuilder(2 * byArray.length);
            for (byte by : byArray) {
                stringBuilder.append(HEX[by & 0xFF]);
            }
        }
        return stringBuilder.toString();
    }

    @NotNull
    public SimpleXmlWriter expandBase64(@NotNull byte[] byArray) {
        this.add(Base64.encodeBytes(byArray));
        return this;
    }

    @NotNull
    public SimpleXmlWriter element(@NotNull String string, Object ... objectArray) {
        this.writeElement(false, string, objectArray);
        return this;
    }

    @NotNull
    public SimpleXmlWriter text(@NotNull Object object) {
        return this.quote(object);
    }

    @NotNull
    public SimpleXmlWriter textf(@NotNull String string, Object ... objectArray) {
        return this.text(String.format(this.locale, string, objectArray));
    }

    @NotNull
    public SimpleXmlWriter nl() {
        return this.add("\n");
    }

    @NotNull
    public SimpleXmlWriter cdata(@NotNull String string) {
        return this.add("<![CDATA[").add(string).add("]]>");
    }

    public void finish() {
        while (!this.openElements.isEmpty()) {
            this.close();
        }
    }

    @NotNull
    private SimpleXmlWriter writeElement(boolean bl, @NotNull String string, @NotNull Object[] objectArray) {
        if (objectArray.length % 2 == 1) {
            throw new IllegalArgumentException("Need an even number of attributes");
        }
        this.insertAutoWrap(bl ? this.openElements.size() - 1 : this.openElements.size());
        this.add("<").quote(string);
        for (int i = 0; i < objectArray.length; i += 2) {
            this.add(" ").quote(objectArray[i]).add("=\"").quote(objectArray[i + 1]).add("\"");
        }
        return this.add(bl ? ">" : "/>");
    }

    @NotNull
    private SimpleXmlWriter add(@NotNull String string) {
        this.collector.add(string);
        return this;
    }

    @NotNull
    private SimpleXmlWriter quote(@Nullable Object object) {
        String string = object == null ? "null" : object.toString();
        int n = string.length();
        block6: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    this.collector.add("&lt;");
                    continue block6;
                }
                case '>': {
                    this.collector.add("&gt;");
                    continue block6;
                }
                case '\"': {
                    this.collector.add("&quot;");
                    continue block6;
                }
                case '&': {
                    this.collector.add("&amp;");
                    continue block6;
                }
                default: {
                    this.collector.add(c);
                }
            }
        }
        return this;
    }

    static {
        for (int i = 255; i >= 0; --i) {
            SimpleXmlWriter.HEX[i] = String.format("%02X", i);
        }
    }
}

