/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.templ;

import de.caff.annotation.NotNull;
import de.caff.generics.CharPair;
import de.caff.generics.Countable;
import de.caff.generics.Dict;
import de.caff.generics.Indexable;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;

public class Template {
    private static final Indexable<CharPair> COMBI_DELIMITERS = Indexable.viewArray((Object[])new CharPair[]{new CharPair("<>"), new CharPair("()"), new CharPair("[]"), new CharPair("{}")});
    private static final Map<Character, Character> DELIMITER_MAPPING = new HashMap<Character, Character>();
    static final String PLACEHOLDER_PREFIX = "%{";
    static final String PLACEHOLDER_SUFFIX = "}";
    static final String FALLBACK_SEPARATOR = "|";
    private static final Pattern VALID_NAME_PATTERN;
    @NotNull
    private final List<TextItem> textItems;
    @NotNull
    private final Countable<String> varNames;

    private Template(@NotNull List<TextItem> list) {
        this.textItems = list;
        HashSet hashSet = new HashSet();
        list.forEach(textItem -> textItem.registerName(hashSet::add));
        this.varNames = Countable.viewCollection(hashSet);
    }

    @NotNull
    public Countable<String> getPlaceholders() {
        return this.varNames;
    }

    @NotNull
    public static Template from(@NotNull String string) throws ParseException {
        return new Template(Template.parse(string));
    }

    @NotNull
    public String apply(@NotNull Dict<String, String> dict) {
        this.varNames.forEach(string -> {
            if (!dict.hasKey(string)) {
                throw new IllegalArgumentException(String.format("variableMapping does not provide a mapping for %s%s%s!", PLACEHOLDER_PREFIX, string, PLACEHOLDER_SUFFIX));
            }
        });
        StringBuilder stringBuilder = new StringBuilder();
        this.textItems.forEach(textItem -> stringBuilder.append(textItem.getText(dict)));
        return stringBuilder.toString();
    }

    @NotNull
    public String apply(@NotNull Map<String, String> map) {
        return this.apply((Dict<String, String>)Dict.viewMap(map));
    }

    @NotNull
    public String apply(@NotNull String string, @NotNull Object object, Object ... objectArray) {
        if (objectArray.length % 2 == 1) {
            throw new IllegalArgumentException("moreNameValuePairs has to have an even size!");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string, object.toString());
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!(objectArray[i] instanceof String)) {
                throw new IllegalArgumentException("The keys in moreNameValuePairs have to be Strings!");
            }
            hashMap.put(objectArray[i].toString(), Objects.toString(Objects.requireNonNull(objectArray[i + 1])));
        }
        return this.apply(hashMap);
    }

    public static void checkName(@NotNull String string) {
        if (!VALID_NAME_PATTERN.matcher(string).matches()) {
            throw new IllegalArgumentException(String.format("Not a valid name: \"%s\"!", string));
        }
    }

    @NotNull
    private static List<TextItem> parse(@NotNull String string) throws ParseException {
        LinkedList<TextItem> linkedList = new LinkedList<TextItem>();
        int n = 0;
        while (n < string.length()) {
            String string2;
            int n2;
            int n3 = string.indexOf(PLACEHOLDER_PREFIX, n);
            if (n3 < 0) {
                linkedList.add(new Text(string.substring(n)));
                break;
            }
            int n4 = string.indexOf(PLACEHOLDER_SUFFIX, n3 + PLACEHOLDER_PREFIX.length());
            if (n4 < 0) {
                throw new ParseException(String.format("Couldn't find substitution end marker for substitution starting at %s!", Template.toPosition(string, n3)), n3);
            }
            if (n != n3) {
                linkedList.add(new Text(string.substring(n, n3)));
            }
            if ((n2 = (string2 = string.substring(n3 + PLACEHOLDER_PREFIX.length(), n4)).indexOf(FALLBACK_SEPARATOR)) <= 0) {
                linkedList.add(new PlaceHolder(string2));
                n = n4 + PLACEHOLDER_SUFFIX.length();
                continue;
            }
            if (n2 >= string2.length() - 2) {
                throw new ParseException(String.format("Invalid placeholder fallback at %s, need start and end marker!", Template.toPosition(string, n + 2 + n2)), n + 2 + n2);
            }
            char c = string2.charAt(n2 + 1);
            String string3 = DELIMITER_MAPPING.getOrDefault(Character.valueOf(c), Character.valueOf(c)) + PLACEHOLDER_SUFFIX;
            int n5 = string.indexOf(string3, n + PLACEHOLDER_SUFFIX.length() + n2 + 2);
            if (n5 < 0) {
                throw new ParseException(String.format("Invalid placeholder fallback starting at %s, did not find end marker \"%s\"!", Template.toPosition(string, n + PLACEHOLDER_SUFFIX.length() + n2 + 2), string3), n + PLACEHOLDER_SUFFIX.length() + n2 + 2);
            }
            linkedList.add(new OptionalPlaceHolder(string.substring(n3 + PLACEHOLDER_PREFIX.length(), n3 + PLACEHOLDER_PREFIX.length() + n2), string.substring(n3 + PLACEHOLDER_PREFIX.length() + n2 + 2, n5)));
            n = n5 + PLACEHOLDER_PREFIX.length();
        }
        return linkedList;
    }

    @NotNull
    private static String toPosition(@NotNull String string, int n) {
        String[] stringArray = string.substring(0, n).split("\n");
        return String.format("%d:%d", stringArray.length + 1, stringArray[stringArray.length - 1].length() + 1);
    }

    static {
        COMBI_DELIMITERS.forEach(charPair -> {
            DELIMITER_MAPPING.put(Character.valueOf(charPair.first), Character.valueOf(charPair.second));
            DELIMITER_MAPPING.put(Character.valueOf(charPair.second), Character.valueOf(charPair.first));
        });
        VALID_NAME_PATTERN = Pattern.compile("[-0-9A-Za-z_+.!:]+");
    }

    private static class OptionalPlaceHolder
    implements TextItem {
        @NotNull
        private final String name;
        @NotNull
        private final Template fallback;

        OptionalPlaceHolder(@NotNull String string, @NotNull String string2) throws ParseException {
            Template.checkName(string);
            this.name = string;
            this.fallback = Template.from(string2);
        }

        @Override
        @NotNull
        public String getText(@NotNull Dict<String, String> dict) {
            return this.name.isEmpty() ? this.fallback.apply(dict) : (String)dict.getOr((Object)this.name, string -> this.fallback.apply(dict));
        }

        @Override
        public void registerName(@NotNull Consumer<String> consumer) {
        }

        @NotNull
        public String toString() {
            return Template.PLACEHOLDER_PREFIX + this.name + Template.FALLBACK_SEPARATOR + this.fallback + Template.PLACEHOLDER_SUFFIX;
        }
    }

    private static class PlaceHolder
    implements TextItem {
        @NotNull
        private final String name;

        PlaceHolder(@NotNull String string) {
            Template.checkName(string);
            this.name = string;
        }

        @Override
        @NotNull
        public String getText(@NotNull Dict<String, String> dict) {
            return (String)dict.getNonNull((Object)this.name);
        }

        @Override
        public void registerName(@NotNull Consumer<String> consumer) {
            consumer.accept(this.name);
        }

        @NotNull
        public String toString() {
            return Template.PLACEHOLDER_PREFIX + this.name + Template.PLACEHOLDER_SUFFIX;
        }
    }

    private static class Text
    implements TextItem {
        @NotNull
        private final String text;

        Text(@NotNull String string) {
            this.text = string;
        }

        @Override
        @NotNull
        public String getText(@NotNull Dict<String, String> dict) {
            return this.text;
        }

        @Override
        public void registerName(@NotNull Consumer<String> consumer) {
        }

        @NotNull
        public String toString() {
            return this.text;
        }
    }

    private static interface TextItem {
        @NotNull
        public String getText(@NotNull Dict<String, String> var1);

        public void registerName(@NotNull Consumer<String> var1);
    }
}

