/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.startup;

import com.sun.management.OperatingSystemMXBean;
import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.Types;
import de.caff.io.InputStreamPipe;
import de.caff.util.Utility;
import de.caff.util.debug.Debug;
import de.caff.util.debug.SimpleOutputtingDebugListener;
import java.io.File;
import java.io.FilenameFilter;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Objects;
import java.util.regex.Pattern;

public final class Restarter {
    public static final String PROPERTY_RESTARTED = "de.caff.util.startup.Restarted";
    public static final String PROPERTY_DONT_RESTART = "no.restart";
    public static final String PROPERTY_JAVA_HOME = "java.home";
    public static final String PROPERTY_JAVA_CLASSPATH = "java.class.path";
    public static final String PROPERTY_JAVA_VM_NAME = "java.vm.name";
    public static final long MAX_32BIT_SIZE = Utility.getLongParameter("restart.max.32bit", 1400000000L);
    public static final double DEFAULT_MEMORY_PART;
    private static final boolean DEBUG;
    private static final String[] SYSTEM_PREFIXES;
    private static final Pattern PATTERN_64BIT;
    static final String PROPERTY_FORMAT = "-D%s=%s";

    private Restarter() {
    }

    public static boolean possiblyRestart(@NotNull Class<?> clazz, String ... stringArray) {
        return Restarter.possiblyRestart(clazz.getName(), DEFAULT_MEMORY_PART, stringArray);
    }

    public static boolean possiblyRestart(@NotNull Class<?> clazz, double d, String ... stringArray) {
        return Restarter.possiblyRestart(clazz.getName(), d, stringArray);
    }

    public static boolean possiblyRestart(@NotNull String string, String ... stringArray) {
        return Restarter.possiblyRestart(string, DEFAULT_MEMORY_PART, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean possiblyRestart(@NotNull String string, double d, String ... stringArray) {
        String string2;
        LinkedList<String> linkedList;
        long l;
        SimpleOutputtingDebugListener simpleOutputtingDebugListener;
        block23: {
            boolean bl;
            block24: {
                block21: {
                    boolean bl2;
                    block22: {
                        long l2;
                        long l3;
                        block19: {
                            boolean bl3;
                            block20: {
                                block17: {
                                    boolean bl4;
                                    block18: {
                                        block15: {
                                            boolean bl5;
                                            block16: {
                                                simpleOutputtingDebugListener = DEBUG ? new SimpleOutputtingDebugListener(System.out) : null;
                                                if (simpleOutputtingDebugListener != null) {
                                                    Debug.addCookedMessageDebugListener(simpleOutputtingDebugListener);
                                                    Debug.setMask(127L);
                                                }
                                                if (!Utility.getBooleanParameter(PROPERTY_DONT_RESTART, false)) break block15;
                                                Debug.warn("Property %0 was set, not restarting.", PROPERTY_DONT_RESTART);
                                                bl5 = false;
                                                if (simpleOutputtingDebugListener == null) break block16;
                                                Debug.removeCookedMessageDebugListener(simpleOutputtingDebugListener);
                                            }
                                            return bl5;
                                        }
                                        if (!Utility.getBooleanParameter(PROPERTY_RESTARTED, false)) break block17;
                                        Debug.message("Property %0 was set, application was already restarted.", PROPERTY_RESTARTED);
                                        bl4 = true;
                                        if (simpleOutputtingDebugListener == null) break block18;
                                        Debug.removeCookedMessageDebugListener(simpleOutputtingDebugListener);
                                    }
                                    return bl4;
                                }
                                Runtime runtime = Runtime.getRuntime();
                                l3 = runtime.maxMemory();
                                l2 = Restarter.getPhysicalMemorySize();
                                if (l2 > 0L) break block19;
                                bl3 = false;
                                if (simpleOutputtingDebugListener == null) break block20;
                                Debug.removeCookedMessageDebugListener(simpleOutputtingDebugListener);
                            }
                            return bl3;
                        }
                        l = (long)(d * (double)l2);
                        if (!Restarter.is64BitJVM()) {
                            l = Math.min(l, MAX_32BIT_SIZE);
                        }
                        Debug.message("Trying to require " + l + " bytes...");
                        if (l > l3) break block21;
                        bl2 = true;
                        if (simpleOutputtingDebugListener == null) break block22;
                        Debug.removeCookedMessageDebugListener(simpleOutputtingDebugListener);
                    }
                    return bl2;
                }
                linkedList = new LinkedList<String>();
                string2 = Restarter.getJavaCommand();
                if (string2 != null) break block23;
                bl = false;
                if (simpleOutputtingDebugListener == null) break block24;
                Debug.removeCookedMessageDebugListener(simpleOutputtingDebugListener);
            }
            return bl;
        }
        try {
            try {
                linkedList.add(string2);
                linkedList.add(String.format("-mx%d", l));
                linkedList.add("-classpath");
                linkedList.add(System.getProperty(PROPERTY_JAVA_CLASSPATH));
                Restarter.addSystemProperties(linkedList);
                linkedList.add(String.format(PROPERTY_FORMAT, PROPERTY_RESTARTED, "true"));
                linkedList.add(string);
                linkedList.addAll(Types.asList((Object[])stringArray));
                Debug.message("Command line: %0", Types.join((String)" ", linkedList));
                ProcessBuilder processBuilder = new ProcessBuilder(linkedList);
                Process process = processBuilder.start();
                InputStreamPipe.startOn(process.getInputStream(), System.out);
                InputStreamPipe.startOn(process.getErrorStream(), System.err);
                int n = process.waitFor();
                if (n == 0) {
                    System.exit(n);
                } else {
                    Debug.warn("Original process exited with status %0", n);
                }
            }
            catch (Throwable throwable) {
                Debug.error(throwable);
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (simpleOutputtingDebugListener != null) {
                Debug.removeCookedMessageDebugListener(simpleOutputtingDebugListener);
            }
        }
    }

    public static void addSystemProperties(@NotNull Collection<String> collection) {
        block0: for (String string : System.getProperties().stringPropertyNames()) {
            for (String string2 : SYSTEM_PREFIXES) {
                if (string.startsWith(string2)) continue block0;
            }
            collection.add(String.format(PROPERTY_FORMAT, string, System.getProperty(string)));
        }
    }

    public static long getPhysicalMemorySize() {
        try {
            OperatingSystemMXBean operatingSystemMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            return operatingSystemMXBean.getTotalPhysicalMemorySize();
        }
        catch (ClassCastException classCastException) {
            Debug.error(classCastException);
            return 0L;
        }
    }

    @Nullable
    public static String getJavaCommand() {
        File file2;
        String string2 = System.getProperty(PROPERTY_JAVA_HOME);
        if (string2 == null) {
            return null;
        }
        String string3 = string2 + File.separatorChar + "bin";
        String string4 = string3 + File.separatorChar + "java";
        if (Utility.areWeOnWindows()) {
            string4 = string4 + ".exe";
        }
        if ((file2 = new File(string4)).exists() && file2.canExecute()) {
            return string4;
        }
        File file3 = new File(string3);
        if (!file3.exists() || !file3.isDirectory()) {
            return null;
        }
        FilenameFilter filenameFilter = (file, string) -> string.startsWith("java.") && string.lastIndexOf(46) == 4;
        for (File file4 : Objects.requireNonNull(file3.listFiles(filenameFilter))) {
            if (!file4.canExecute()) continue;
            return file4.getPath();
        }
        return null;
    }

    public static boolean is64BitJVM() {
        String string = System.getProperty(PROPERTY_JAVA_VM_NAME);
        return string != null && PATTERN_64BIT.matcher(string.toLowerCase()).find();
    }

    public static void main(String[] stringArray) {
        Debug.installCookedOutput();
        Debug.setMask(126L);
        System.out.println("args: " + Arrays.toString(stringArray));
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.maxMemory();
        System.out.println("max mem: " + l);
        Restarter.possiblyRestart(Restarter.class, 0.95, stringArray);
        System.out.println("Running on ... and exit");
        System.exit(0);
    }

    static {
        double d = Utility.getDoubleParameter("restart.mem.part", 0.75);
        if (d <= 0.0 || d > 1.0) {
            d = 0.75;
        }
        DEFAULT_MEMORY_PART = d;
        DEBUG = Utility.getBooleanParameter("debug.restart", false);
        SYSTEM_PREFIXES = new String[]{"file.", "java.", "line.separator", "os.", "path.separator", "sun.", "user."};
        PATTERN_64BIT = Pattern.compile("64.?bit");
    }
}

