/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.settings.AbstractBasicChangeableItem;
import de.caff.util.settings.PreferenceProperty;
import java.awt.Component;
import java.awt.Dimension;
import java.util.prefs.Preferences;

public class SizePreferenceProperty
extends AbstractBasicChangeableItem
implements PreferenceProperty {
    private static final String EXT_WIDTH = "-WIDTH";
    private static final String EXT_HEIGHT = "-HEIGHT";
    private static final long serialVersionUID = -6294165270594094306L;
    private Dimension dimension;

    public SizePreferenceProperty(String string) {
        super(string);
    }

    @Override
    public void readFrom(@NotNull Preferences preferences) {
        String string = this.getBasicName();
        int n = preferences.getInt(string + EXT_WIDTH, -1);
        int n2 = preferences.getInt(string + EXT_HEIGHT, -1);
        if (n >= 0 && n2 >= 0) {
            this.setSize(new Dimension(n, n2));
        } else {
            this.setSize((Dimension)null);
        }
    }

    @Override
    public void storeTo(@NotNull Preferences preferences) {
        String string = this.getBasicName();
        if (this.dimension == null) {
            preferences.remove(string + EXT_WIDTH);
            preferences.remove(string + EXT_HEIGHT);
        } else {
            preferences.putInt(string + EXT_WIDTH, this.dimension.width);
            preferences.putInt(string + EXT_HEIGHT, this.dimension.height);
        }
    }

    public boolean setComponentSize(@NotNull Component component) {
        if (this.dimension != null) {
            component.setSize(this.dimension.width, this.dimension.height);
            return true;
        }
        return false;
    }

    public void storeComponentSize(@NotNull Preferences preferences, @NotNull Component component) {
        this.dimension = component.getSize();
        this.storeTo(preferences);
    }

    public void setSize(@Nullable Dimension dimension) {
        if (dimension == null) {
            if (this.dimension != null) {
                Dimension dimension2 = this.dimension;
                this.dimension = null;
                this.fireValueChange(this.getBasicName(), dimension2, dimension);
            }
        } else if (!dimension.equals(this.dimension)) {
            Dimension dimension3 = this.dimension;
            this.dimension = new Dimension(dimension);
            this.fireValueChange(this.getBasicName(), dimension3, dimension);
        }
    }

    public void setSize(@NotNull Component component) {
        this.setSize(component.getSize());
    }
}

