/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.util.settings.AbstractBasicChangeableItem;
import de.caff.util.settings.Property;

public class SimpleShortProperty
extends AbstractBasicChangeableItem
implements Property<Short> {
    private static final long serialVersionUID = -1678345547647882885L;
    private short value;

    public SimpleShortProperty(@NotNull String string) {
        this(string, 0);
    }

    public SimpleShortProperty(@NotNull String string, int n) {
        this(string, (short)n);
    }

    public SimpleShortProperty(@NotNull String string, short s) {
        super(string);
        this.value = s;
    }

    @Override
    @NotNull
    public Short getValue() {
        return this.value;
    }

    @Override
    public void setValue(Short s) {
        if (s == null) {
            throw new IllegalArgumentException("value must not be null!");
        }
        this.setValue(s.byteValue());
    }

    @Override
    public void setValue(short s) {
        if (s != this.value) {
            short s2 = this.value;
            this.value = s;
            this.fireValueChange(this.getPropertyName(), s2, s);
        }
    }

    @Override
    public void setValue(int n) {
        this.setValue((short)n);
    }
}

