/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.generics.UniformMatcher;
import de.caff.generics.matcher.Match;
import de.caff.util.settings.AbstractBasicChangeableItem;
import de.caff.util.settings.Property;

public class SimpleNullableProperty<T>
extends AbstractBasicChangeableItem
implements Property<T> {
    private static final long serialVersionUID = -6245653244996622537L;
    @Nullable
    private T value;
    @NotNull
    private UniformMatcher<? super T> matcher;

    public SimpleNullableProperty(@NotNull String string) {
        this(string, null, Match.DEFAULT_MATCHER);
    }

    public SimpleNullableProperty(@NotNull String string, @Nullable T t) {
        this(string, t, Match.DEFAULT_MATCHER);
    }

    public SimpleNullableProperty(@NotNull String string, @NotNull UniformMatcher<? super T> uniformMatcher) {
        this(string, null, uniformMatcher);
    }

    public SimpleNullableProperty(@NotNull String string, @Nullable T t, @NotNull UniformMatcher<? super T> uniformMatcher) {
        super(string);
        this.value = t;
        this.matcher = uniformMatcher;
    }

    @Override
    @Nullable
    public T getValue() {
        return this.value;
    }

    @Override
    public void setValue(@Nullable T t) {
        if (!this.matcher.areEqual(t, this.value)) {
            T t2 = this.value;
            this.value = t;
            this.fireValueChange(this.getPropertyName(), t2, t);
        }
    }
}

