/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.util.settings.AbstractBasicChangeableItem;
import de.caff.util.settings.Property;

public class SimpleIntegerProperty
extends AbstractBasicChangeableItem
implements Property<Integer> {
    private static final long serialVersionUID = -6963509097934062799L;
    private int value;

    public SimpleIntegerProperty(@NotNull String string) {
        this(string, 0);
    }

    public SimpleIntegerProperty(@NotNull String string, int n) {
        super(string);
        this.value = n;
    }

    @Override
    @NotNull
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setValue(Integer n) {
        if (n == null) {
            throw new IllegalArgumentException("value must not be null!");
        }
        this.setValue((int)n);
    }

    @Override
    public void setValue(int n) {
        if (n != this.value) {
            int n2 = this.value;
            this.value = n;
            this.fireValueChange(this.getPropertyName(), n2, n);
        }
    }
}

