/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.util.settings.AbstractBasicChangeableItem;
import de.caff.util.settings.Property;

public class SimpleFloatProperty
extends AbstractBasicChangeableItem
implements Property<Float> {
    private static final long serialVersionUID = -1782754644783033700L;
    private float value;

    public SimpleFloatProperty(@NotNull String string) {
        this(string, 0.0f);
    }

    public SimpleFloatProperty(@NotNull String string, float f) {
        super(string);
        this.value = f;
    }

    @Override
    @NotNull
    public Float getValue() {
        return Float.valueOf(this.value);
    }

    @Override
    public void setValue(Float f) {
        if (f == null) {
            throw new IllegalArgumentException("value must not be null!");
        }
        this.setValue(f.floatValue());
    }

    @Override
    public void setValue(float f) {
        if (f != this.value) {
            float f2 = this.value;
            this.value = f;
            this.fireValueChange(this.getPropertyName(), Float.valueOf(f2), Float.valueOf(f));
        }
    }
}

