/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.util.settings.AbstractBasicChangeableItem;
import de.caff.util.settings.Property;

public class SimpleDoubleProperty
extends AbstractBasicChangeableItem
implements Property<Double> {
    private static final long serialVersionUID = -1782754644783033700L;
    private double value;

    public SimpleDoubleProperty(@NotNull String string) {
        this(string, 0.0);
    }

    public SimpleDoubleProperty(@NotNull String string, double d) {
        super(string);
        this.value = d;
    }

    @Override
    @NotNull
    public Double getValue() {
        return this.value;
    }

    @Override
    public void setValue(Double d) {
        if (d == null) {
            throw new IllegalArgumentException("value must not be null!");
        }
        this.setValue((double)d);
    }

    @Override
    public void setValue(double d) {
        if (d != this.value) {
            double d2 = this.value;
            this.value = d;
            this.fireValueChange(this.getPropertyName(), d2, d);
        }
    }
}

