/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.annotation.Nullable;
import de.caff.util.settings.AbstractBasicChangeableItem;
import de.caff.util.settings.DirectoryPreferenceProperty;
import java.io.File;
import java.util.prefs.Preferences;

public class SimpleDirectoryPreferenceProperty
extends AbstractBasicChangeableItem
implements DirectoryPreferenceProperty {
    private static final long serialVersionUID = 4626333074555535769L;
    @Nullable
    private File value;

    public SimpleDirectoryPreferenceProperty(@NotNull String string) {
        super(string);
    }

    public SimpleDirectoryPreferenceProperty(@NotNull String string, @Nullable File file) {
        super(string);
        this.value = file;
    }

    @Override
    public File getDirectory() {
        return this.value;
    }

    @Override
    public void setDirectory(File file) {
        if (file != null ? !file.equals(this.value) : this.value != null) {
            File file2 = this.value;
            this.value = file;
            this.fireValueChange(this.getBasicName(), file2, file);
        }
    }

    @Override
    public void readFrom(@NotNull Preferences preferences) {
        String string = preferences.get(this.getBasicName(), null);
        if (string != null) {
            this.setDirectory(new File(string));
        }
    }

    @Override
    public void storeTo(@NotNull Preferences preferences) {
        if (this.value == null) {
            preferences.remove(this.getBasicName());
        } else {
            preferences.put(this.getBasicName(), this.value.getPath());
        }
    }
}

