/*
 * Decompiled with CFR 0.152.
 */
package de.caff.util.settings;

import de.caff.annotation.NotNull;
import de.caff.util.settings.AbstractBasicChangeableItem;
import de.caff.util.settings.Property;

public class SimpleCharProperty
extends AbstractBasicChangeableItem
implements Property<Character> {
    private static final long serialVersionUID = -1678345547647882885L;
    private char value;

    public SimpleCharProperty(@NotNull String string) {
        this(string, 0);
    }

    public SimpleCharProperty(@NotNull String string, int n) {
        this(string, (char)n);
    }

    public SimpleCharProperty(@NotNull String string, char c) {
        super(string);
        this.value = c;
    }

    @Override
    @NotNull
    public Character getValue() {
        return Character.valueOf(this.value);
    }

    @Override
    public void setValue(Character c) {
        if (c == null) {
            throw new IllegalArgumentException("value must not be null!");
        }
        this.setValue(c.charValue());
    }

    @Override
    public void setValue(char c) {
        if (c != this.value) {
            char c2 = this.value;
            this.value = c;
            this.fireValueChange(this.getPropertyName(), c2, c);
        }
    }
}

